/* --------------------------------------------------------------------------
 * Copyright 1992-1994 by Forschungszentrum Informatik (FZI)
 *
 * You can use and distribute this software under the terms of the licence
 * you should have received along with this program.
 * If not or if you want additional information, write to
 * Forschungszentrum Informatik, "OBST", Haid-und-Neu-Strasse 10-14,
 * D-76131 Karlsruhe, Germany.
 *
 * The license covers the source file msh.y and those parts of msh.y that are
 * copied into a file generated from msh.y.
 * --------------------------------------------------------------------------
 */
%token name_tok
%token number_tok

%token abstract_tok
%token class_tok
%token commit_tok
%token comp_tok
%token create_tok
%token create_par_tok
%token definite_tok
%token endversion_tok
%token enum_tok
%token exit_tok
%token extern_tok
%token friend_tok
%token generate_tok
%token help_tok
%token import_tok
%token init_tok
%token insert_tok
%token instantiation_tok
%token literal_tok
%token local_tok
%token method_tok
%token nname_tok
%token operator_tok
%token param_tok
%token period_tok
%token print_tok
%token private_tok
%token protected_tok
%token prot_gen_tok
%token public_tok
%token quit_tok
%token recursive_tok
%token ref_tok
%token reset_tok
%token result_tok
%token remove_tok
%token schema_tok
%token scope_tok
%token set_tok
%token size_tok
%token static_tok
%token subclass_tok
%token super_tok
%token type_tok
%token typedef_tok
%token union_tok
%token update_tok
%token wait_tok
%token with_tok
%token with_extern_tok

%token l_abr_tok
%token r_abr_tok
%token l_br_tok
%token r_br_tok
%token l_brc_tok
%token r_brc_tok
%token l_par_tok
%token r_par_tok

%token ampersand_tok
%token ampersand_assign_tok
%token and_tok
%token assign_tok
%token bar_tok
%token bar_assign_tok
%token circumflex_tok
%token circumflex_assign_tok
%token colon_tok
%token comma_tok
%token equal_tok
%token exclam_tok
%token greater_equal_tok
%token less_equal_tok
%token minus_tok
%token minus_assign_tok
%token not_equal_tok
%token or_tok
%token percent_tok
%token percent_assign_tok
%token plus_tok
%token plus_assign_tok
%token rshift_assign_tok
%token lshift_assign_tok
%token slash_tok
%token slash_assign_tok
%token star_tok
%token star_assign_tok
%token semicolon_tok

%type <td>	type_name
%type <td>	type_param
%type <mk>	scope_param
%type <mk>	scope_modifier
%type <md>	method_name_param
%type <i>	int_param
%type <i>	number_tok
%type <str>	name_param
%type <str>	opt_name_param
%type <str>	name
%type <exp>	expression
%type <exp>	init_expression
%type <exp>	expression_param
%type <s>	name_tok
%type <b>	opt_recursive
%type <td_l>	type_name_list
%type <td_l>	act_gen_par_list
%type <t>	type_kind
%type <b>	set_or_reset
%type <smdl>	schema_param
%type <cd>	comp_param
%type <b_poi>	comp_attribute
%type <b_poi>	method_attribute

%{

#define OBST_IMP_STRINGOP
#define OBST_IMP_MALLOC
#include "obst_stdinc.h"
#include "_obst_config.h"
#include "obst_progstd.h"

#include "msh.h"		// includes msh_err.h
#include "mta.h"

typedef union {
	  sos_Bool				b;
	  sos_Bool *				b_poi;
	  sos_Int				i;
	  sos_Cstring				s;
	  sos_Comp_descr			cd;
	  sos_Schema_module			smdl;
          sos_Import_List			imp;
          sos_String				str;
          sos_String_List			str_l;
          sos_Enum_type				etd;
          sos_Class_type			ctd;
          sos_Gen_param				gp;
          sos_Gen_param_List			gp_l;
          sos_Param				par;
          sos_Param_List			par_l;
	  sos_Method_kind			mk;
          sos_Method_List			md_l;
          sos_Method				md;
          sos_Union_type			utd;
	  sos_Type				t;
          sos_Typedef_type			ttd;
          sos_Extern_type			xtd;
	  sos_Type_descr			td;
	  sos_Type_descr_List			td_l;
	  sos_Type_List				tp_l;
	  sos_Super_class_List			sc_l;
	  sos_Super_class			sc;
          sos_Expr				exp;
          sos_Int_expr				ie;
          sos_Identifier			id;
          sos_Expr_List				exp_l;
        } _YYSTYPE;

#define YYSTYPE _YYSTYPE

LOCAL sos_Schema_module	msh_schema;
LOCAL sos_Class_type	msh_class;
LOCAL sos_Comp_descr	msh_cd;
LOCAL sos_Method	msh_method;
LOCAL sos_Param		msh_param;
LOCAL sos_Expr		msh_init_expr;
LOCAL sos_Int		msh_integer;
LOCAL sos_String	msh_name;
LOCAL sos_Container	msh_cnt;
LOCAL sos_Type_descr	msh_result_type;
LOCAL sos_Method_kind	msh_scope;
LOCAL sos_Method_kind	msh_set_scope;
LOCAL sos_Method_kind	msh_get_scope;
LOCAL sos_Bool		msh_is_static;
LOCAL sos_Bool		msh_is_local;
LOCAL sos_Bool		msh_is_abstract;
LOCAL sos_Bool		msh_is_definite;
LOCAL sos_Bool		msh_is_reference;

#include "msh_lex.h"

LOCAL inline void yyerror (err_msg s)
{  msh_error (err_USE, s);
}
LOCAL inline void yyecho ()
{  if (msh_echo)
      ECHO;
}
%}

%%

command_sequence
   : 
   | command semicolon_tok command_sequence
   ;

command
   : commit_tok
     {
	mta_commit();
#ifdef OBST_HAVE_PROT
	sos_ModifHistory::end_work();
#endif
     }
   | reset_tok { mta_reset(); }
   | exit_tok  { exit (0);    }
   | quit_tok  { exit (0);    }
   | help_command
   | schema_command
   | endversion_tok
     {
#ifdef OBST_HAVE_PROT
	sos_ModifHistory::modif_history().end_version();
#endif
     }
   | wait_tok { msh_wait_key(); }
   | error
   ;

help_command
   : help_tok 			    { msh_help(); }
   | help_tok period_tok help_topic
   ;

help_topic
   : schema_tok  { help_schema();  }
   | type_tok    { help_type();    }
   | enum_tok    { help_enum();    }
   | typedef_tok { help_typedef(); }
   | extern_tok  { help_extern();  }
   | class_tok   { help_class();   }
   | method_tok  { help_method();  }
   | comp_tok    { help_comp();    }
   ;

schema_command
   : schema_with_name_command
   | schema_without_name_command
   ;

schema_without_name_command
   : schema_tok period_tok schema_without_name_suffix
   ;

schema_without_name_suffix
   : print_tok
     {
	msh_list_schemas();
     }
   | create_tok name_param
     {
	sos_Schema_module::create_schema ($2, FALSE);
     }
   | remove_tok l_par_tok name opt_recursive r_par_tok
     {
	msh_schema = msh_sd [$3];
	msh_schema.remove ($4);
     }
   ;

opt_recursive
   : 			     { $$ = FALSE; }
   | comma_tok recursive_tok { $$ = TRUE;  }
   ;

schema_with_name_command
   : schema_tok schema_param period_tok 
     {
        msh_schema = $2;
        msh_cnt = msh_schema.container();
     }
     schema_with_name_suffix
   ;

schema_with_name_suffix
   : nname_tok period_tok set_tok name_param
     {
	 msh_schema.modify_name ($4);
     }
   | with_extern_tok period_tok set_or_reset
     {
	msh_schema.modify_with_extern($3);
     }
   | generate_tok opt_name_param
     {
	msh_schema.generate ($2); 
     }
   | import_command
   | print_tok
     {
	mta_schema_declaration (cout, msh_schema);
     }
   | type_command
   | prot_gen_tok period_tok set_or_reset
     {
#ifdef OBST_HAVE_PROT
	sos_ModifHistory::set_gen_prot (msh_schema, $3);
#endif
     }
   ;

import_command
   : import_tok period_tok import_suffix
   ;

import_suffix
   : insert_tok schema_param { msh_schema.insert_import ($2); }
   | remove_tok schema_param { msh_schema.remove_import ($2); }
   | update_tok schema_param { msh_schema.update_import ($2); }
   | update_tok		     { msh_schema.update_imports();   }
   ;

type_command
   : command_valid_for_all_types
   | enum_command
   | union_command
   | class_command
   | extern_command
   | typedef_command
   ;

command_valid_for_all_types
   : type_kind period_tok create_tok opt_name_param
     {
	msh_schema.create_type ($1, $4);
     }
   | type_kind period_tok remove_tok name_param
     {
	sos_Type_descr td = msh_schema.lookup_type ($4);
	td.remove();
     }
   ;

set_name_command_suffix
   : nname_tok period_tok set_tok name_param
     {
        msh_result_type.modify_name(sos_String::clone($4, msh_cnt));
     }
   ;

print_type_command_suffix
   : print_tok
     {
        sos_String_List sl = mta_get_declaration(msh_result_type);
        agg_iterate (sl, sos_String s)
           cout << s << "\n";
        agg_iterate_end (sl, s)
        MTA_DESTROY_LIST (sl);
     }
   ;

type_kind
   : enum_tok    { $$ = sos_Enum_type_type;    }
   | union_tok   { $$ = sos_Union_type_type;   }
   | class_tok   { $$ = sos_Class_type_type;   }
   | extern_tok  { $$ = sos_Extern_type_type;  }
   | typedef_tok { $$ = sos_Typedef_type_type; }
   ;

enum_command
   : enum_tok name_param period_tok literal_tok period_tok insert_tok name_param
     {
	sos_Enum_type et = sos_Enum_type::make(msh_schema.lookup_type ($2));
	et.insert_literal ($7);
     }
   | enum_tok name_param period_tok literal_tok period_tok remove_tok name_param
     {
	sos_Enum_type et = sos_Enum_type::make (msh_schema.lookup_type ($2));
	et.remove_literal ($7);
     }
   | enum_tok name_param period_tok
     {
	msh_result_type = msh_schema.lookup_type($2);
     }
     print_type_command_suffix
   | enum_tok name_param period_tok
     {
        msh_result_type = msh_schema.lookup_type($2);
     }
     set_name_command_suffix
   ;

union_command
   : union_tok name_param period_tok insert_tok type_param
     {
	sos_Union_type ut = sos_Union_type::make(msh_schema.lookup_type ($2));
	ut.insert_type ($5);
     }
   | union_tok name_param period_tok remove_tok type_param
     {
	sos_Union_type ut = sos_Union_type::make(msh_schema.lookup_type ($2));
	ut.remove_type ($5);
     }
   | union_tok name_param period_tok
     {
	msh_result_type = msh_schema.lookup_type($2);
     }
     print_type_command_suffix
   | union_tok name_param period_tok
     {
	msh_result_type = msh_schema.lookup_type($2);
     }
     set_name_command_suffix
   ;

class_command
   : class_tok name_param period_tok 
     {
	msh_class = sos_Class_type::make (msh_schema.lookup_type ($2));
     }
     class_command_suffix
   | class_tok name_param period_tok
     {
	msh_result_type = msh_schema.lookup_type($2);
     }
     print_type_command_suffix
   | class_tok name_param period_tok
     {
	msh_result_type = msh_schema.lookup_type($2);
     }
     set_name_command_suffix
   ;

class_command_suffix
   : subclass_tok period_tok print_tok
     {
	msh_list_subclasses (msh_class);
     }
   | friend_tok period_tok remove_tok type_param
     {
	msh_class.insert_friend (sos_Class_type::make ($4));
     }
   | friend_tok period_tok insert_tok type_param
     {
	msh_class.remove_friend (sos_Class_type::make ($4));
     }
   | superclass_command
   | component_command
   | method_command
   | instantiation_command
   | create_par_command
   ;

create_par_command
   : create_par_tok period_tok insert_tok l_par_tok name
     {
	// set defaults for create parameter insertion
	msh_result_type = sos_Type_descr::make(void_type);
	msh_init_expr   = sos_Expr::make (NO_OBJECT);
	msh_integer	= 1;
     }
     param_create_par_list r_par_tok
     {
	msh_class.insert_create_param ($5, msh_result_type, msh_init_expr,
				       msh_integer);
     }
   | create_par_tok period_tok remove_tok name_param
     {
	msh_class.remove_create_param ($4);
     }
   | create_par_tok int_param period_tok set_tok l_par_tok name
     {
	// set defaults for create parameter modification
	sos_Param p     = msh_class.get_create_params().get_nth($2);
	msh_result_type = p.get_type();
	msh_init_expr   = p.get_default_expr();
     }
     param_create_par_list r_par_tok
     {
	msh_class.modify_create_param ($2, $6, msh_result_type, msh_init_expr);
     }
   ;

param_create_par_list
   :
   | comma_tok param_create_par param_create_par_list
   ;

param_create_par
   : type_name	     { msh_result_type = $1; }
   | init_expression { msh_init_expr   = $1; }
   | number_tok	     { msh_integer     = $1; }
   ;

superclass_command
   : super_tok period_tok insert_tok type_param
     {
	msh_class.insert_superclass ($4);
     }
   | super_tok period_tok remove_tok type_param
     {
	msh_class.remove_superclass ($4);
     }
   | super_tok type_param period_tok create_par_tok int_param period_tok set_tok
     expression_param
     {
	msh_class.modify_superclass_create_param ($2, $5, $8);
     }
   ;

component_command
   : comp_tok 
     {
	msh_init_expr   = sos_Expr::make (NO_OBJECT);
	msh_result_type = sos_Type_descr::make(void_type);
	msh_get_scope   =
	msh_set_scope   = sos_PRIVATE;
	msh_is_static   =
	msh_is_local    =
	msh_is_abstract =
	msh_is_definite = FALSE;
     }
     comp_command_suffix
   ;

comp_command_suffix
   : period_tok create_tok l_par_tok name comp_create_parameter_list
     r_par_tok
     {
	sos_Comp_descr cd = msh_class.create_component();
	cd.modify ($4, msh_result_type, msh_get_scope, msh_set_scope,
		   msh_is_local, msh_is_definite, msh_is_static, msh_init_expr);
     }
   | period_tok remove_tok comp_param
     {
	$3.remove();
     }
   | comp_param
     {
	msh_cd = $1;
	msh_name        = msh_cd.get_name();
	msh_init_expr   = msh_cd.get_init_expr();
	msh_result_type = msh_cd.get_get_method().get_result_type();
	msh_get_scope   = msh_cd.get_get_method().get_kind();
	msh_set_scope   = msh_cd.get_set_method().get_kind();
	msh_is_static   = FALSE;
	msh_is_local    = msh_cd.get_is_local();
	msh_is_abstract = msh_cd.get_get_method().get_is_abstract();
	msh_is_definite = msh_cd.get_get_method().get_is_definite();
     }
     period_tok comp_modif_command
     {
	msh_cd.modify (msh_name, msh_result_type, msh_get_scope, msh_set_scope,
		       msh_is_local, msh_is_definite, msh_is_static,
		       msh_init_expr);
     }
   ;

comp_param
   : name_param
     {
        sos_Comp_descr_List comps = msh_class.get_components();
        agg_iterate (comps, sos_Comp_descr cd)
        {  if (    cd.get_name().equal ($1)
	       AND cd.get_get_method().get_defined_in().operator==(msh_class))
	   {  $$ = cd;
	      break;
	   }
        }
        agg_iterate_end (comps, cd)
     }
   ;

comp_modif_command
   : comp_attribute period_tok set_or_reset       { *$1		    = $3; }
   | nname_tok period_tok set_tok name_param      { msh_name        = $4; }
   | result_tok period_tok set_tok type_param     { msh_result_type = $4; }
   | init_tok period_tok set_tok expression_param { msh_init_expr   = $4; }
   | scope_tok period_tok set_tok l_par_tok scope_modifier 
     {
	msh_get_scope =
	msh_set_scope = $5;
     }
     r_par_tok
   | scope_tok period_tok set_tok l_par_tok scope_modifier comma_tok
     scope_modifier set_tok 
     {
	msh_get_scope = $5;
	msh_set_scope = $7;
     }
     r_par_tok
   ;

comp_attribute
   : method_attribute
   | local_tok    { msh_is_local    = TRUE; $$ = &msh_is_local;    }
   ;

method_attribute
   : static_tok   { msh_is_static   = TRUE; $$ = &msh_is_static;   }
   | abstract_tok { msh_is_abstract = TRUE; $$ = &msh_is_abstract; }
   | definite_tok { msh_is_definite = TRUE; $$ = &msh_is_definite; }
   ;

scope_modifier
   : public_tok    { $$ = sos_PUBLIC;    }
   | protected_tok { $$ = sos_PROTECTED; }
   | private_tok   { $$ = sos_PRIVATE;   }
   ;

scope_param
   : l_par_tok scope_modifier r_par_tok { $$ = $2; }
   ;

comp_create_parameter_list
   :
   | comma_tok comp_create_parameter comp_create_parameter_list
   ;

comp_create_parameter
   : type_name		    { msh_result_type = $1; }
   | init_expression	    { msh_init_expr   = $1; }
   | scope_modifier	    { msh_get_scope   =
			      msh_set_scope   = $1; }
   | scope_modifier set_tok { msh_set_scope   = $1; }
   | comp_attribute
   ;

method_command
   : method_tok period_tok create_tok
     {
	msh_scope       = sos_PRIVATE;
	msh_is_abstract =
	msh_is_definite =
	msh_is_static   = FALSE;
	msh_result_type = sos_Type_descr::make (void_type);
     }
     method_create_parameter_list
     {
	msh_method = msh_class.create_method();
	msh_method.modify (msh_result_type, msh_name, msh_scope,
			   msh_is_static, msh_is_abstract, msh_is_definite);
     }
   | method_tok period_tok remove_tok method_name_param
     {
	$4.remove();
     }
   | method_tok method_name_param
     {
	msh_method      = $2;
	msh_result_type = msh_method.get_result_type();
	msh_name        = msh_method.get_name();
	msh_is_static   = msh_method.get_is_static();
	msh_is_definite = msh_method.get_is_definite();
	msh_is_abstract = msh_method.get_is_abstract();
	msh_scope       = msh_method.get_kind();
     }
     period_tok method_command_with_name_suffix
   ;

method_command_with_name_suffix
   : method_attribute period_tok set_or_reset
     {
	*$1 = $3;
	msh_method.modify (msh_result_type, msh_name, msh_scope,
			   msh_is_static, msh_is_abstract, msh_is_definite);
     }
   | scope_tok period_tok set_tok scope_param
     {
	msh_method.modify (msh_result_type, msh_name, $4,
			   msh_is_static, msh_is_abstract, msh_is_definite);
     }
   | result_tok period_tok set_tok type_param
     {
	msh_result_type = $4;
	msh_method.modify (msh_result_type, msh_name, msh_scope,
			   msh_is_static, msh_is_abstract, msh_is_definite);
     }
   | nname_tok period_tok set_tok name_param
     {
	msh_method.modify (msh_result_type, $4, msh_scope,
			   msh_is_static, msh_is_abstract, msh_is_definite);
     }
   | param_tok method_param_modif_command
   ;

method_param_modif_command
   : period_tok create_tok 
     {
	msh_result_type = sos_Type_descr::make (void_type);
	msh_integer     = 1;
	msh_init_expr   = sos_Expr::make (NO_OBJECT);
     }
     l_par_tok name param_create_par_list r_par_tok
     {
	msh_method.insert_param (msh_integer, msh_result_type);
	msh_method.modify_param (msh_integer, msh_result_type,
				 $5, FALSE, msh_init_expr);
     }
   | period_tok remove_tok int_param
     {
	msh_method.remove_param ($3);
     }
   | int_param period_tok
     {
	msh_param	 = msh_method.get_params().get_nth ($1);
	msh_result_type  = msh_param.get_type();
	msh_init_expr    = msh_param.get_default_expr();
	msh_is_reference = msh_param.get_is_ref();
	msh_name	 = msh_param.get_name();
     }
     method_param_modif_command_suffix
     {
	msh_method.modify_param ($1, msh_result_type,
				 msh_name, msh_is_reference, msh_init_expr);
     }
   ;

method_param_modif_command_suffix
   : type_tok  period_tok set_tok type_param       { msh_result_type  = $4; }
   | ref_tok   period_tok set_or_reset             { msh_is_reference = $3; }
   | nname_tok period_tok set_tok name_param       { msh_name         = $4; }
   | init_tok  period_tok set_tok expression_param { msh_init_expr    = $4; }
   ;

method_name_param
   : l_par_tok name r_par_tok
     {
	$$ = msh_lookup_method(msh_class, $2);
     }
   | l_par_tok name comma_tok number_tok r_par_tok
     {
        $$ = msh_lookup_method(msh_class, $2, $4);
     }
   ;

method_create_parameter_list
   : l_par_tok name { msh_name = $2; } method_create_parameters r_par_tok
   ;

method_create_parameters
   :
   | comma_tok method_create_parameter method_create_parameters
   ;

method_create_parameter
   : type_name      { msh_result_type = $1; }
   | scope_modifier { msh_scope       = $1; }
   | method_attribute
   ;

instantiation_command
   : instantiation_tok period_tok create_tok
     l_par_tok name comma_tok act_gen_par_list r_par_tok
   ;

act_gen_par_list
   : l_abr_tok type_name_list r_abr_tok { $$ = $2; }
   ;

extern_command
   : extern_tok name_param period_tok size_tok period_tok set_tok int_param
     {
	sos_Extern_type et = sos_Extern_type::make(msh_schema.lookup_type($2));
	et.modify_size ($7);
     }
   | extern_tok name_param period_tok
     {
	msh_result_type = msh_schema.lookup_type($2);
     }
     print_type_command_suffix
   | extern_tok name_param period_tok
     {
	msh_result_type = msh_schema.lookup_type($2);
     }
     set_name_command_suffix
   ;

typedef_command
   : typedef_tok name_param period_tok type_tok period_tok set_tok type_param
     {
	sos_Typedef_type td= sos_Typedef_type::make(msh_schema.lookup_type($2));
	td.modify ($7);
     }
   | typedef_tok name_param period_tok
     {
	msh_result_type = msh_schema.lookup_type($2);
     }
     print_type_command_suffix
   | typedef_tok name_param period_tok
     {
	msh_result_type = msh_schema.lookup_type($2);
     }
     set_name_command_suffix
   ;

int_param
   : l_par_tok number_tok r_par_tok { $$ = $2; }
   ;

schema_param
   : name_param { $$ = msh_sd [$1]; }
   ;

name
   : name_tok   { $$ = sos_String::create (TEMP_CONTAINER, $1); }
   ;

name_param
   : l_par_tok name_tok r_par_tok
     {
        $$ = sos_String::create (TEMP_CONTAINER, $2);
     }
   ;

opt_name_param
   :		{ $$ = sos_String::make(NO_OBJECT); }
   | name_param
   ;

expression
   : number_tok { $$ = sos_Int_expr::create  (TEMP_CONTAINER, $1); }
   | name	{ $$ = sos_Identifier::create(TEMP_CONTAINER, $1); }
   ;

set_or_reset
   : set_tok   { $$ = TRUE;  }
   | reset_tok { $$ = FALSE; }
   ;

init_expression
   : assign_tok expression { $$ = $2;			     }
   | assign_tok		   { $$ = sos_Expr::make(NO_OBJECT); }
   ;

expression_param
   : l_par_tok expression r_par_tok { $$ = $2; }
   ;

type_param
   : l_par_tok type_name  r_par_tok { $$ = $2; }
   ;

type_name
   : name
     {
	$$ = msh_schema.lookup_type ($1);
	if (INVALID ($$))
	   msh_error (err_USE, err_MSH_TYPE_NOT_FOUND, $1);
     }
   | name act_gen_par_list
     {
	sos_Type_descr td = msh_schema.lookup_type ($1);
	sos_Class_type ct = sos_Class_type::make (td);
	$$ = ct.lookup_or_create_instantiation (msh_schema, $2, TRUE);
     }
   ;

type_name_list
   : {
	$$ = sos_Type_descr_List::create (TEMP_CONTAINER);
     }
   | type_name_list comma_tok type_name
     {
        $1.append($3);
        $$ = $1;
     }
   ;

%%
