/* --------------------------------------------------------------------------
 * Copyright 1992-1994 by Forschungszentrum Informatik (FZI)
 *
 * You can use and distribute this software under the terms of the licence
 * you should have received along with this program.
 * If not or if you want additional information, write to
 * Forschungszentrum Informatik, "OBST Projekt", Haid-und-Neu-Strasse 10-14,
 * D-76131 Karlsruhe, Germany.
 * --------------------------------------------------------------------------
 */
/* OBST LIBRARY MODULE */

#include "mta.h"
#define OBST_IMP_FORMATTED_IO
#define OBST_IMP_STRINGOP
#define OBST_IMP_ERROR        
#define OBST_IMP_FILE   
#include "obst_stdinc.h"

EXPORT sos_Generic_instantiation mta_get_instantiation
                                        (sos_Class_type      gencl,
                                         sos_Class_type      instcl,
                                         sos_Type_descr_List agpl)
{  T_PROC ("mta_get_instantiation")
   TT (mta_L, T_ENTER);
 
   static sos_Object_sos_Object_Mapping_Hash gil_table
             = sos_Object_sos_Object_Mapping_Hash::create (TEMP_CONTAINER);
 
   sos_Generic_instantiation gi;
   sos_Bool do_create = TRUE;
 
   sos_Object_List gil = sos_Object_List::make (gil_table[(sos_Object)instcl]);
 
   if (INVALID(gil))
      gil_table.insert (instcl, gil= sos_Object_List::create(TEMP_CONTAINER));
   else
      agg_iterate (gil, sos_Object giobj)
         gi = sos_Generic_instantiation::make (giobj);
         sos_Type_descr_List gipl = gi.get_act_gen_params();
 
         if (gipl == agpl OR gipl.equal (agpl)) // '==' accounts for NO_OBJECT
         {  do_create = FALSE;
            break;
         }
      agg_iterate_end (gil, obj);
 
   if (do_create)
   {  gi = sos_Generic_instantiation::create (gencl.container());
      gi.set_gen_class (gencl);
      gi.set_instantiation (instcl);
      gi.set_act_gen_params (agpl);
      gil.insert (1, gi);
   }
   TT (mta_L, T_LEAVE);
   return gi;
}
 
EXPORT sos_String mta_instantiation_name (sos_String          gen_class_name,
                                          sos_Type_descr_List act_params,
                                          sos_Bool            make_tp /*=TRUE*/)
{
   /* if make_tp is set (the default), then make_type() is applied to
      the type description, even if it is a typedef type. Otherwise
      for typedef types the defined name is taken into the instantiation
      name. This is useful for generating the second name for a generic
      instantiation, in which typedef names are kept. For an example see
      comments in cfe_create_inst_class_type.
      Note, that the string is created in the TEMP_CONTAINER. It must be
      destroyed after use. */

   T_PROC ("mta_instantiation_name")
   TT (mta_M, T_ENTER);

   smg_String s;

   agg_iterate (act_params, sos_Type_descr td)
   {  if (make_tp || !td.has_type (sos_Typedef_type_type))
         s += td.make_type().get_name();
      else
         s += sos_Typedef_type::make(td).get_name();
      s += "_";
   }
   agg_iterate_end (act_params, td);
   s += gen_class_name;

   TT (mta_M, T_LEAVE);
   return s.make_String (TEMP_CONTAINER);
}
