/* --------------------------------------------------------------------------
 * Copyright 1992 by Forschungszentrum Informatik (FZI)
 *
 * You can use and distribute this software under the terms of the license
 * version 1 you should have received along with this software.
 * If not or if you want additional information, write to
 * Forschungszentrum Informatik, "STONE", Haid-und-Neu-Strasse 10-14,
 * D-76131 Karlsruhe, Germany.
 * --------------------------------------------------------------------------
 */
// OBST root container initialization facility (init)

#define OBST_IMP_FILE
#include "obst_stdinc.h"

#include "_obst_config.h"
#include "obst.h"
#include "obst_progstd.h"
#include "smg.h"
#include "dir_use.h"
// new for transactions
#include "sync_use.h"
#include "sync_decl.h"

#ifdef PROFILE
extern "C" void monitor(...);
#endif

EXPORT int init_main (int argc, char *argv[])
{
   sos_Directory dir;

   int fd;
   smg_String cnt_name = smg_String (obst_getenv(ENVVAR_CONTAINER)) + "/" + 1;
       
   fd = ::open(cnt_name.make_Cstring (SMG_BORROW),O_RDWR | O_CREAT | O_EXCL,0664);

        ::close(fd);

#ifndef LOCKD_CORRECT
     cnt_name += ".lck";
     fd = ::open(cnt_name.make_Cstring (SMG_BORROW),O_RDWR | O_CREAT | O_EXCL,0664); 
        ::close(fd);
#endif /* LOCKD_CORRECT */

   sos_String name = sos_String::create (TEMP_CONTAINER, "root");
   ROOT_CONTAINER.open (WRITING, WAITING);
   dir = sos_Object_Directory::create (ROOT_CONTAINER, name);
   ROOT_CONTAINER.close() ;

#ifdef PROFILE
   monitor (0);
#endif

   return 0;
}
