#line 1 "./src/dir/dir.C"
/* --------------------------------------------------------------------------
 * Copyright 1992-1993 by Forschungszentrum Informatik (FZI)
 *
 * You can use and distribute this software under the terms of the license
 * version 1 you should have received along with this software.
 * If not or if you want additional information, write to
 * Forschungszentrum Informatik, "STONE", Haid-und-Neu-Strasse 10-14,
 * D-76131 Karlsruhe, Germany.
 * --------------------------------------------------------------------------
 */
/* OBST LIBRARY MODULE */

// tracing conventions: see trc_dir.h

#define  OBST_IMP_STDCONST
#include "obst_stdinc.h"

#include "obst_progstd.h"
#include "_obst_config.h"
#include "obst.h"
#include "smg.h"
#include "trc_dir.h"
#include "dir_err.h"
#include "dir_obst.h"

// *************************************************************************
void _sos_Object_Directory::local_initialize (OBST_PARDECL(sos_Object_Directory) dir)
// *************************************************************************
{  T_PROC ("sos_Object_Directory::local_initialize")
   TT (dir_M, T_ENTER);

   if (VALID (dir.get_name()))
      dir.set_name (sos_String::copy (dir.get_name(), dir.container()));

   TT (dir_M, T_LEAVE);
}

// *************************************************************************
void _sos_Object_Directory::local_finalize (OBST_PARDECL(sos_Object_Directory) dir)
// *************************************************************************
{  T_PROC ("sos_Object_Directory::local_finalize")
   TT (dir_M, T_ENTER);

   if (VALID (dir.get_name()))
      dir.get_name().destroy();
   agg_iterate_association (dir, sos_String name, sos_Object elem)
      name.destroy();
   agg_iterate_association_end (dir, name, elem);

   TT (dir_M, T_LEAVE);
}


// *************************************************************************
sos_Object_Directory _sos_Object_Directory::root()
// *************************************************************************
{  T_PROC ("sos_Object_Directory::root")
   TT (dir_H, T_ENTER);

   sos_Bool open = (sos_Bool) ((ROOT_CONTAINER.status() == READABLE) OR
		               (ROOT_CONTAINER.status() == WRITEABLE));

   if (NOT open) ROOT_CONTAINER.open (READING, WAITING);

   sos_Object_Directory d =
      sos_Object_Directory::make (ROOT_CONTAINER.root_object());

   if (NOT open) ROOT_CONTAINER.close ();

   TT (dir_H, T_LEAVE);

   return d;
}

// *************************************************************************
sos_Object _sos_Object_Directory::lookup (OBST_PARDECL(sos_String) path)
// *************************************************************************
{  T_PROC ("sos_Object_Directory::lookup")
   TT (dir_H, T_ENTER);

   sos_Object  result = _sos_Object_Directory::root();
   smg_String  s0     = path;
   char        *s     = s0.make_Cstring (SMG_BORROW);
   char        *buf   = new char[s0.length()];
   sos_String  key    = sos_String::create (TEMP_CONTAINER);

   sos_Object_Directory dir;

   do
   {  if (*s == '/'  AND  result.is_some (sos_Object_Directory_type))
	 dir = sos_Object_Directory::make (result);
      else
      {  result = NO_OBJECT;
	 break;
      }
      if (! *(++s))
	 break;
      
      char *nptr = buf;
      while ((*nptr = *s) AND *nptr != '/')
      {  nptr ++;   s ++;
      }
      *nptr = '\0';

      if (*buf)
      {  key.assign_Cstring (buf);
	 result = dir [key];
      }
   }
   while (VALID (result) AND *s);

   delete buf;
   key.destroy();

   TT (dir_H, T_LEAVE);
   return result;
}

// *************************************************************************
void _sos_Object_Directory::insert (const sos_Typed_id&_OBSThis,OBST_PARDECL(sos_String) so,OBST_PARDECL( sos_Object) o)
// *************************************************************************
const{  T_PROC ("sos_Object_Directory::insert")
   TT (dir_H, T_ENTER);

   sos_String name;
   if (is_key (_OBSThis,so))
   {  sos_Cursor c = open_cursor (_OBSThis,TEMP_CONTAINER);
      move_cursor (_OBSThis,c, so);
      name = sos_String::make (get_key (_OBSThis,c));
      close_cursor (_OBSThis,c);
   }
   else
      name = sos_String::copy (so, _OBSThis.container());
   _sos_Object_sos_Object_Mapping::insert (_OBSThis,name, o);
   TT (dir_H, T_LEAVE);
}


// *************************************************************************
void _sos_Object_Directory::remove (const sos_Typed_id&_OBSThis,OBST_PARDECL(sos_String) so)
// *************************************************************************
const{  T_PROC ("sos_Object_Directory::remove")
   TT (dir_H, T_ENTER);

   sos_Cursor c = open_cursor (_OBSThis);
   sos_Bool found = move_cursor (_OBSThis,c, so);
   err_assert (found,"Directory::remove:name not found");

   sos_Object name = get_key (_OBSThis,c);
   _sos_Object_sos_Object_Mapping::remove (_OBSThis,so);
   name.destroy();
   close_cursor (_OBSThis,c);

   TT (dir_H, T_LEAVE);
}

static sos_Object_Directory *wd;

// *************************************************************************
void _sos_Object_Directory::set_wd (OBST_PARDECL(sos_String) path)
// *************************************************************************
{  T_PROC ("sos_Object_Directory::set_wd")
   TT (dir_H, T_ENTER);

   sos_Object d = _sos_Object_Directory::lookup (path);
   
   if (INVALID (d)  OR  NOT d.isa (sos_Object_Directory_type))
   {  sos_Cstring pname = path.make_Cstring ();
      err_raise (err_SYS, err_DIR_NO_DIR, pname);
      delete pname;
   }
   else
   {  wd = new sos_Object_Directory;
     *wd = sos_Object_Directory::make (d);
   }

   TT (dir_H, T_LEAVE);
}

// *************************************************************************
void _sos_Object_Directory::set_wd_from_env ()
// *************************************************************************
{  T_PROC ("sos_Object_Directory::set_wd_from_env")
   TT (dir_H, T_ENTER);

   char* e;
   if (e = obst_getenv (ENVVAR_DIR))
   {  sos_String s = _sos_String::create (TEMP_CONTAINER, e);
      _sos_Object_Directory::set_wd (s);
      s.destroy();
   }
   else
      err_raise (err_SYS, err_DIR_NO_DIR, NULL, FALSE);

   TT (dir_H, T_LEAVE);
}

// *************************************************************************
sos_Object_Directory _sos_Object_Directory::get_wd ()
// *************************************************************************
{  T_PROC ("sos_Object_Directory::get_wd")
   TT (dir_H, T_ENTER);

   sos_Object_Directory result;

   if (wd)
      result = *wd;
   else
   {  err_raise (err_SYS, err_DIR_NO_WD, NULL, FALSE);;
      result = sos_Object_Directory::make (NO_OBJECT);
   }

   TT (dir_H, T_LEAVE);
   return result;
}
