/* --------------------------------------------------------------------------
 * Copyright 1992-1994 by Forschungszentrum Informatik (FZI)
 *
 * You can use and distribute this software under the terms of the license
 * version 1 you should have received along with this software.
 * If not or if you want additional information, write to
 * Forschungszentrum Informatik, "STONE", Haid-und-Neu-Strasse 10-14,
 * D-76131 Karlsruhe, Germany.
 * --------------------------------------------------------------------------
 */
// **************************************************************************
// Module demo                   ??/??/89                        Joerg Wienke
//
// **************************************************************************
// Simple non-graphic tool to inspect the meta-database (small test program)
// **************************************************************************

#define OBST_IMP_STREAM
#define OBST_IMP_FORMATTED_IO
#include "obst_stdinc.h"

#include "obst_progstd.h"
#include "obst.h"
#include "smg.h"
#include "obst_err.h"
#include "mta_use.h"


// *******
LOCAL smg_String type_kind (sos_Type_descr type)
{
  if (type.has_type (sos_Union_type_type))
     return "Union    ";
  if (type.has_type (sos_Typedef_type_type))
     return "Typedef  ";
  if (type.has_type (sos_Extern_type_type))
     return "Extern   ";
  if (type.has_type (sos_Class_type_type))
     return "Class    ";
  if (type.has_type (sos_Enum_type_type))
     return "Enum     ";
  return    "         ";
}

// *******
LOCAL void get_meth (sos_Method_List ml)
{
   agg_iterate (ml, sos_Method m)
   {  cout << "   ";
      if (m.get_is_static() == TRUE)
	 cout << "static ";
      cout << m.get_result_type().make_type().get_name() << " " 
	   << m.get_name() << " ";
      
      sos_Param_List pl = m.get_params ();
      cout << "(";
      sos_Bool is_first = TRUE;
      if (VALID (pl))
         agg_iterate (pl, sos_Param p)
            if (is_first)
	       is_first = FALSE;
	    else
	       cout << ", ";
   
	    cout << p.get_type().make_type().get_name(); 
         agg_iterate_end (pl, p);
      cout << ");\n";
   }
   agg_iterate_end (ml, m);
}

// *******
LOCAL void type_menu (int& choice, sos_Schema_module& sm, sos_String& str)
{  sos_Type_table type_table = sm.get_type_table();
   sos_Type_descr type       = type_table [str];

   cout << "\f";

   if (type.has_type (sos_Class_type_type))
   {
      cout << "class " << str;

      sos_Class_type ct = sos_Class_type::make(type);

   // print generic parameters
   // ========================

      sos_Gen_param_List gpl;
      gpl = ct.get_formal_gen_params ();

      if (VALID (gpl))
      {  cout << "<";
	 sos_Bool is_first = TRUE;
	 agg_iterate (gpl, sos_Gen_param gp)
	    if (is_first)
	       is_first = FALSE;
	    else
	       cout << ", ";

	    cout << gp.get_name ();
	 agg_iterate_end (gpl, gp);
	 cout << "> ";
      }

   // print parameters
   // ================

      sos_Param_List pl;
      pl = ct.get_create_params ();

      if (VALID (pl))
      {  cout << "(";
	 sos_Bool is_first = TRUE;
	 agg_iterate (pl, sos_Param p)
	    if (is_first)
	       is_first = FALSE;
	    else
	       cout << ", ";

	    cout << p.get_type().make_type().get_name() << " " << p.get_name();
	 agg_iterate_end (pl, p);
	 cout << ") ";
      }

   // print super_classes
   // ===================

      sos_Super_class_List scl = ct.get_super_classes ();
    
      sos_Bool is_first = TRUE;
      agg_iterate (scl, sos_Super_class sc)
         if (is_first)
	 {  is_first=FALSE;
	    cout << ": ";
	 }
	 else
	    cout << ", ";

	 cout << sc.make_type().get_name();
      agg_iterate_end (scl, tn);

   // ===========================

      cout << "\n{\n";

      get_meth (ct.get_local_methods());

      cout << "}\n";

   }

   else if (type.has_type (sos_Union_type_type))
   {
      sos_Type_List lt = sos_Union_type::make(type).get_united();

      cout << "union " << str << "\n{\n";
      
      agg_iterate (lt, sos_Type t)
         cout << "   " << t.get_name() << ";\n";
      agg_iterate_end (lt, t);
      cout << "}\n";
   }

   else if (type.has_type (sos_Typedef_type_type))
   {
      cout << "typedef " << "<"
	   << sos_Typedef_type::make(type).get_named_type().get_name()
           << ">" << " " << str << "\n";
   }

   else if (type.has_type (sos_Extern_type_type))
   {
      cout << "\n\n       no further information \n";
   }

   else if (type.has_type (sos_Enum_type_type))
   {
      sos_String_List sl = sos_Enum_type::make(type).get_literals();

      cout << "       enum " << str << " {";
    
      sos_Bool is_first = TRUE;
      agg_iterate (sl, sos_String s)
         if (is_first)
	    is_first = FALSE;
	 else
	    cout << ", ";
	 cout << s;
      agg_iterate_end (sl, s);
      cout << "};";
   }

   cout << "\n\n       (0) RETURN\n";
   cout << "\n\n       CHOICE: ";
   cin  >> choice;

   if (choice == 0)
      return;
}

// *******
LOCAL void schema_menu (int& choice, sos_Schema_module& sm, sos_String& str)
{  const int  a_size = 100;
   sos_String a[100];

   cout << "\f";

   sos_Type_table tt = sm.get_type_table ();

   int i = 1;
   agg_iterate_association (tt, sos_String name, sos_Type_descr tp)
      char is [10];
      a[i] = name;
      sprintf (is, "(%d) ", i);
      char _is [12];   // neccesary for ATT
      sprintf (_is, "%11s", is);
      cout << _is
	   << type_kind (tp) << name << "\n";

      err_assert (i++ < a_size, "schema_menu - table overflow");
   agg_iterate_association_end (tt, name, tp);

   cout << "\n       (0) RETURN\n";
   cout << "\n       CHOICE: ";
   cin  >> choice;

   if (choice != 0)
      str = a[choice];
}

// *******
LOCAL void schema_dir_menu (int&			 choice, 
			    sos_Schema_module_Directory& sd,
			    sos_Schema_module&		 sm)
{  const int  a_size = 10000;
   sos_String a[a_size];

   cout << "\f";    // clear screen

   int i = 1;
   agg_iterate_association(sd, sos_String name, sos_Schema_module mdl)
      a[i] = name;
      sos_Cstring sname = name.make_Cstring ();
      char _sname[1000];   // neccesary for ATT 
      sprintf (_sname, "%6s", sname);
      cout << "\n          (" << i << ") " << _sname;
      delete sname;

   // imports
      
      sos_Import_List imports = mdl.get_imports();

      cout << "   imports: ";
      agg_iterate (imports, sos_Import imported)
	 cout << imported.get_module().get_name() << " ("
	      << sos_Enum_type::make(sos_Import_mode_type).
				get_literals().get_nth (1+imported.get_mode())
	      << ")  ";
      agg_iterate_end (imports, imported);
      cout << "\n";

      err_assert (i++ < a_size, "schema_dir_menu - table overflow");
   agg_iterate_association_end (sd, name, mdl);

   cout << "\n\n          (0) QUIT\n";
   cout << "\n\n          CHOICE: ";
   cin  >> choice;

   if (choice != 0)
      sm = sd [ a[choice] ];
}

// *******
EXPORT int demo_main (int, char *[])
{  
   sos_Schema_module_Directory sd = sos_Schema_module::schema_dir();
   sos_Schema_module	       sm;
   sos_String	     	       str;

   for (int choice1 = 1;  choice1; )
   {  schema_dir_menu (choice1, sd, sm);

      for (int choice2 = 1;  choice2 && choice1; )
      {  schema_menu (choice2, sm, str);

	 for (int choice3 = 1;  choice3 && choice2; )
	    type_menu (choice3, sm, str);
      }
   }
   return 0;
}
