/* --------------------------------------------------------------------------
 * Copyright 1992-1994 by Forschungszentrum Informatik (FZI)
 *
 * You can use and distribute this software under the terms of the license
 * you should have received along with this program.
 * If not or if you want additional information, write to
 * Forschungszentrum Informatik, "STONE", Haid-und-Neu-Strasse 10-14,
 * D-76131 Karlsruhe, Germany.
 * --------------------------------------------------------------------------
 */
// **************************************************************************
// Module cfe_main                                           Juergen Uhl (ju)
//
// **************************************************************************
//
// tracing conventions: see trc_cfe.h

#define OBST_IMP_STDCONST
#define OBST_IMP_STREAM
#define OBST_IMP_FILE
#include "obst_stdinc.h"

#include "cfe.h"

#ifdef PROFILE
extern "C" void monitor(...);
#endif

// ---------- global variables ----------------------------------------------

EXPORT sos_Schema_module   cfe_schema;
EXPORT sos_Type_table      cfe_type_tab;
EXPORT sos_Forward_table   cfe_forward_tab;
EXPORT sos_Type_descr_List cfe_types;
EXPORT sos_Container	   cfe_cnt;
EXPORT sos_Class_type      ERROR_TYPE;
EXPORT sos_Bool		   cfe_echo_flag = FALSE;


// --------------------------------------------------------------------------

EXPORT void cfe_compile()
{
   T_PROC ("cfe_compile")
   TT (cfe_H, T_ENTER);

   /* ERROR_TYPE is the result of cfe_lookup_generic_instantiation in case
      of an incorrect instantiation. Since cfe doesn't abort execution, this
      class must be pretty initialized. In addition to this class a further
      class is needed, representing the generic class, of which ERROR_TYPE
      is an instantiation. */

   sos_Class_type error_gen_class = sos_Class_type::create(TEMP_CONTAINER);

   error_gen_class.set_formal_gen_params (
	           sos_Gen_param_List::create (TEMP_CONTAINER));
   error_gen_class.set_actual_gen_params (sos_Type_descr_List::make(NO_OBJECT));
   ERROR_TYPE = sos_Class_type::create (TEMP_CONTAINER);
   ERROR_TYPE.set_name (sos_String::create (TEMP_CONTAINER, "__error"));
   error_gen_class.set_name (ERROR_TYPE.get_name());
   ERROR_TYPE.set_create_params (sos_Param_List::make(NO_OBJECT));
   ERROR_TYPE.set_super_classes (sos_Super_class_List::create (
						     TEMP_CONTAINER, TRUE));
   ERROR_TYPE.set_super_closure (sos_Super_class_List::create (TEMP_CONTAINER,
		FALSE));
   mta_set_super_closure (ERROR_TYPE);
   ERROR_TYPE.set_friends (sos_Type_List::make (NO_OBJECT));
   ERROR_TYPE.set_local_methods (sos_Method_List::create (TEMP_CONTAINER));
   ERROR_TYPE.set_methods (sos_Method_table::create (TEMP_CONTAINER));
   ERROR_TYPE.set_components (sos_Comp_descr_List::create (TEMP_CONTAINER));
   ERROR_TYPE.set_root_class (error_gen_class);
   ERROR_TYPE.set_formal_gen_params (sos_Gen_param_List::make(NO_OBJECT));
   ERROR_TYPE.set_actual_gen_params (sos_Type_descr_List::create(TEMP_CONTAINER));

   cfe_yyparse();

   TT (cfe_H, T_LEAVE);
}


EXPORT void cfe_init (sos_String name)
{
   T_PROC ("cfe_init")
   TT (cfe_H, T_ENTER);

   // not yet implemented:
   // open imported schemas (transitively) for reading
   // open depending schemas (transitively) for writing

   cfe_forward_tab = sos_String_sos_Class_type_List_Mapping::create (
                                                TEMP_CONTAINER, FALSE, TRUE);

   cfe_types = cfe_schema.get_types();
   cfe_type_tab = cfe_schema.get_type_table();

   TT (cfe_H, T_LEAVE);
}

EXPORT void cfe_finalize()
{
   T_PROC ("cfe_finalize");
   TT (cfe_H, T_ENTER);

   if (err_occurred (err_SYS) + err_occurred (err_USE) != 0)
      cfe_schema.remove(/* force deletion */ TRUE);

#ifdef OBST_HAVE_PROT
   // allow future generation of protocol info for the compiled schema
   sos_ModifHistory::set_gen_prot(cfe_schema, TRUE);
#endif

   mta_commit();
   sos_Container_set open_cnts = sos_Container_set::open_containers(OPEN);
   cnt_iterate (open_cnts, sos_Container c)
      c.close();
   cnt_iterate_end (open_cnts, c)

   TT (cfe_H, T_LEAVE);
}


EXPORT void cfe_check_schema ()
{
   T_PROC ("cfe_check_schema");
   TT (cfe_H, T_ENTER);

   agg_iterate_association (cfe_forward_tab, sos_String name,
			    sos_Class_type_List ctl)
   {  agg_iterate (ctl, sos_Class_type ct)
      {
	 if INVALID(ct.get_methods())
	    cfe_error (err_USE, err_CFE_NOT_DECLARED, ct.get_name());
      }
      agg_iterate_end (ctl, ct);
   }
   agg_iterate_association_end (cfe_forward_tab, name, ctl);

   TT (cfe_H, T_LEAVE);
}


EXPORT void cfe_error (err_class ec, err_msg s, char* where /* = 0 */)
{
   T_PROC ("cfe_error");
   TT (cfe_H, T_ENTER);

   smg_String line_msg = smg_String ("line ") + cfe_yylineno;

   if (where)
      line_msg += smg_String(": ") + where;
   
   err_raise (ec, s, line_msg.make_Cstring (SMG_BORROW));

   TT (cfe_H, T_LEAVE);
}


EXPORT void cfe_error (err_class ec, err_msg s, sos_String where)
{  sos_Cstring w = where.make_Cstring();
   cfe_error (ec, s, w);
   delete w;
}


EXPORT void cfe_import_module (sos_String name)

// Check existence of a schema module named 'name' and append it
// at the module list of the current schema cfe_schema

{  T_PROC ("cfe_import_module")
   TT (cfe_H, T_ENTER);

   sos_Schema_module sm = sos_Schema_module::lookup (name);
   if INVALID(sm)
      cfe_error (err_USE, err_CFE_INVALID_IMPORT, name);
   else
      cfe_schema.insert_import (sm);

   TT (cfe_H, T_LEAVE);
}


EXPORT int cfe_main (int argc, char *argv[])
{  T_FILE ("cfe.out");
   T_REDEF(NULL);

   char* infile = NULL;
   int   status = 0;

#define print_version() \
   cout << "OBST version:" << obst_version << "\n"

   if (argc == 2 AND streql (argv[1], "-v"))
      print_version();
   else
   {  for (int i = 1;  i < argc;  ++ i)
      {  if (streql (argv[i], "-E"))
	    cfe_echo_flag = TRUE;
	 else if (streql (argv[i], "-v"))
	    print_version();
	 else if (i == argc-1)
	    infile = argv[argc-1];
	 else
	    status = 1;
      }
      if (status OR !infile)
      {  err_raise (err_USE, err_CFE_USAGE, NULL, FALSE);
	 status = 1;
      }
      else
      {  cfe_yyin = fopen (infile, "r");
	 if (cfe_yyin == 0)
	 {  err_raise (err_USE, err_CFE_NO_FILE, argv[argc-1], FALSE);
	    status = 1;
	 }
	 else
	 {  cfe_compile ();

	    if (err_occurred (err_SYS) + err_occurred (err_USE) != 0)
	       status = -1;
	 }
      }
   }
#ifdef PROFILE
   monitor (0);
#endif

   T_EXIT ();
   return status;
}
