#ifndef _CFE_H
#define _CFE_H 1
/* --------------------------------------------------------------------------
 * Copyright 1992-1993 by Forschungszentrum Informatik (FZI)
 *
 * You can use and distribute this software under the terms of the license
 * version 1 you should have received along with this software.
 * If not or if you want additional information, write to
 * Forschungszentrum Informatik, "STONE", Haid-und-Neu-Strasse 10-14,
 * D-76131 Karlsruhe, Germany.
 * --------------------------------------------------------------------------
 */
#define OBST_IMP_FILE
#define OBST_IMP_FORMATTED_IO
#include "obst_stdinc.h"
#include "obst.h"
#include "obst_progstd.h"
#include "smg.h"
#include "cfe_err.h"
#include "trc_cfe.h"
#include "mta_use.h"
#include "mta.h"

//#define CFE_DEBUG

/* Compile a sequence of schema modules:
   - check for syntactic and semantic correctness
   - enter each module sos_Into a container
   This job is done by the function `cfe_compile'. The remaining functions
   perform auxiliary operations for the semantic analysis; they are called
   from the yacc parser (see cfe_yacc.s).
*/

// compilation state
extern sos_Schema_module    	cfe_schema;
extern sos_Type_table    	cfe_type_tab;
extern sos_Forward_table	cfe_forward_tab;
extern sos_Type_descr_List	cfe_types;
extern sos_Container    	cfe_cnt;
extern sos_Class_type		cfe_ct;
extern sos_Class_type		ERROR_TYPE;

// ********************* module cfe_yacc.c *****************************

extern FILE     *cfe_yyin;
extern int      cfe_yyparse();
extern int      cfe_yylineno;
extern sos_Bool cfe_echo_flag;

// ********************* module cfe_main.c *****************************

// schema compiler
extern void cfe_compile ();

// schema handling
extern void cfe_init (sos_String name);
extern void cfe_import_module (sos_String);
extern void cfe_complete_imports (sos_Import_List);
extern void cfe_check_schema ();
extern void cfe_finalize ();

// error handling
extern void cfe_error (err_class, err_msg, char* = 0);
extern void cfe_error (err_class, err_msg, sos_String);

// ******************** module cfe_method.c ****************************

// method handling
extern void cfe_init_methods (sos_Class_type);
extern void cfe_complete_methods (sos_Class_type);
extern void cfe_append_comp_methods (sos_Class_type, sos_Type_descr,
				     sos_String, sos_Expr,
	     			     sos_Method_kind, sos_Method_kind,
	     			     sos_Bool, sos_Bool, sos_Bool, sos_Int&);
extern void cfe_complete_components (sos_Class_type);
extern void cfe_build_methodtable (sos_Class_type);

#ifdef CFE_DEBUG
extern void cfe_print_local_methods (sos_Class_type);
extern void cfe_print_method (sos_Class_type, sos_Method);
#endif

// ******************** module cfe_super.c *****************************

// superclass handling
extern void cfe_check_super_classes (sos_Class_type, sos_Super_class_List);
extern void cfe_check_no_form_gen_param (sos_Type_descr);

// ******************** module cfe_generic.c ***************************

// handling of generic types
extern sos_Type_descr cfe_lookup_generic_instantiation(sos_String,
					  	       sos_Type_descr_List,
				     	  	       sos_Import_mode,
				     	  	       sos_Type_descr_List);
extern void           cfe_check_generic_instantiations (sos_Type_descr_List);
extern sos_Gen_param  cfe_lookup_gen_params (sos_String, sos_Gen_param_List);
extern void           cfe_set_generic_stuff(sos_Class_type,sos_Gen_param_List);
extern void           cfe_create_universal_inst (sos_Class_type);
extern void           cfe_complete_forward_insts();
extern sos_Bool       cfe_contains_formal_gen_params (sos_Type_descr_List);
extern sos_Class_type cfe_create_inst_class_type (sos_String,
					  	  sos_Type_descr_List,
						  sos_Bool,
				     	  	  sos_Type_descr_List);

// ******************** module cfe_type.c ******************************

// other type handling
extern void           cfe_set_offsets_and_size (sos_Class_type, sos_Int);
extern sos_Type_descr cfe_lookup_type_name (sos_Class_type, sos_String,
					    sos_Import_mode);
extern void           cfe_check_type (sos_String);
extern sos_Class_type cfe_make_class_type (sos_String, sos_Type_table,
					   sos_Type_descr_List);
extern void           cfe_check_no_generic (sos_Type_descr);
extern sos_Int        cfe_enum_size (sos_Int);
extern sos_Type_descr cfe_create_and_enter_forward (sos_String,
						    sos_Type_descr_List);
extern void 	      cfe_enter_object_as_sc (sos_Class_type,
					      sos_Super_class_List);
extern sos_Generic_instantiation
		      cfe_get_instantiation (sos_Class_type, sos_Class_type,
					     sos_Type_descr_List);

#ifdef CFE_DEBUG
extern void cfe_print_typedescr (sos_Type_descr);
#endif

#endif
