/* --------------------------------------------------------------------------
 * Copyright 1992-1994 by Forschungszentrum Informatik (FZI)
 *
 * You can use and distribute this software under the terms of the license
 * version 1 you should have received along with this software.
 * If not or if you want additional information, write to
 * Forschungszentrum Informatik, "STONE", Haid-und-Neu-Strasse 10-14,
 * D-76131 Karlsruhe, Germany.
 * --------------------------------------------------------------------------
 */
// **************************************************************************
// Module sil_main                                           Juergen Uhl (ju)
//
// **************************************************************************
// OBST schema implementation linker (sil)
// **************************************************************************

#define OBST_IMP_STDCONST
#define OBST_IMP_STRINGOP
#define OBST_IMP_STREAM
#define OBST_IMP_PROCEXEC
#include "obst_stdinc.h"

#include "obst_progstd.h"
#include "smg.h"
#include "obst.h"
#include "trc_cci.h"
#include "cci_err.h"
#include "cci_use.h"
#include "cci_incrload.h"


LOCAL void print_deps_in_dir (sos_Directory dir, sos_String context, char* txt)
{  T_PROC ("sil - print_deps_in_dir")
   TT (cci_M, T_ENTER);

   if (VALID (dir))
   {  if (INVALID (context))
      {  agg_iterate_association (dir, sos_String cntxt, sos_Object _sl)
	 if (VALID (_sl))
	 {  sos_String_List sl = sos_String_List::make (_sl);
	    agg_iterate (sl, sos_String s)
	       cout << "[" << cntxt << ":" << txt << "] " << s << "\n";
	    agg_iterate_end (sl, s)
	 }
	 agg_iterate_association_end (dir, cntxt, _sl)
      }
      else
      {  sos_String_List sl = sos_String_List::make (dir[context]);
	 if (VALID (sl))
	 {  agg_iterate (sl, sos_String s)
	       cout << "[" << context << ":" << txt << "] " << s << "\n";
	    agg_iterate_end (sl, s)
	 }
      }
   }
   TT (cci_M, T_LEAVE);
}

LOCAL void print_deps (cci_Schema_impl impl, sos_String context)
{  T_PROC ("sil - print_deps")
   TT (cci_M, T_ENTER);

   sos_String_List sl = impl.get_schemas();
   if (VALID (sl))
   {  agg_iterate (sl, sos_String s)
	 cout << "[schema] " << s << ".obst\n";
      agg_iterate_end (sl, s)
   }
   print_deps_in_dir (impl.get_object_files(), context, "obj");
   print_deps_in_dir (impl.get_libraries(),    context, "lib");

   TT (cci_M, T_LEAVE);
}

// ----------------------------------------------------------------------------

#define is_opt(s,min)	(arglen>(min) && streqln(argv[i],s,arglen))
#define EXIT(status)	T_EXIT(); return (status)


EXPORT int sil_main (int argc, char *argv[])
{  T_FILE ("sil.out");
   T_REDEF(NULL);

   if (argc < 2)
   {  err_raise (err_USE, err_SIL_USAGE, NULL, FALSE);
      EXIT (1);
   }
   cci_incr_ld.final_init();

   sos_String        str = sos_String::create (TEMP_CONTAINER, argv[1]);
   sos_Schema_module sm  = sos_Schema_module::lookup (str);

   if (INVALID (sm))
   {  err_raise (err_USE, err_SIL_NO_SCHEMA, argv[1], FALSE);
      EXIT (1);
   }

   sos_Container sct = sm.container();
   sct.open (WRITING, WAITING);

   cci_Schema_impl impl    = cci_Schema_impl::make_impl (sm);
   sos_String      context = cci_incr_ld.ld_context;

   cci_Dependency  kind    = cci_NONE;

   for (int i = 2;  i < argc;  i++)
   {  int arglen = strlen(argv[i]);

      if (is_opt ("-remove", 1))
      {  impl.remove_deps (kind, context);
      }
      else if (is_opt ("-REMOVE", 1))
      {  impl.remove_deps (kind, sos_String::make(NO_OBJECT));
      }
      else if (is_opt ("-objects", 1) || is_opt ("-append", 1))
      {  kind = cci_OBJECT;
      }
      else if (is_opt ("-libraries", 1))
      {  kind = cci_LIB;
      }
      else if (is_opt ("-schemas", 1))
      {  kind = cci_SCHEMA;
      }
      else if (is_opt ("-context", 1))
      {  if (++i >= argc)
	 {  err_raise (err_USE, err_SIL_USAGE, argv[i], FALSE);
	    EXIT (1);
	 }
	 context = sos_String::create (TEMP_CONTAINER, argv[i]);
      }
      else if (is_opt ("-print", 1))
      {  print_deps (impl, context);
      }
      else if (is_opt ("-PRINT", 1))
      {  print_deps (impl, sos_String::make(NO_OBJECT));
      }
      else if (is_opt ("-test", 1))
      {  err_block 
            impl.load();
            cout << "...done\n";
         err_exception
            cout << err_last_origin() << ": " << err_last_raised() << "\n";
	    EXIT (1);
         err_block_end
      }
      else
      {  err_raise (err_USE, err_SIL_USAGE, argv[i], FALSE);
	 EXIT (1);
      }
      if (kind != cci_NONE)
      {			      // allow '-l*' as library specifications
         while (++i < argc
		&& (*argv[i] != '-'  ||  kind == cci_LIB && argv[i][1] == 'l'))
	 {  str.assign_Cstring (argv[i]);
	    impl.add_dep (kind, str, context);
	 }
	 -- i;
      }
   }
   sct.close ();

   EXIT (0);
}
