#line 1 "./src/agg/Bag.C"
/* --------------------------------------------------------------------------
 * Copyright 1992-1993 by Forschungszentrum Informatik (FZI)
 *
 * You can use and distribute this software under the terms of the license
 * version 1 you should have received along with this software.
 * If not or if you want additional information, write to
 * Forschungszentrum Informatik, "STONE", Haid-und-Neu-Strasse 10-14,
 * D-76131 Karlsruhe, Germany.
 * --------------------------------------------------------------------------
 */
/* OBST LIBRARY MODULE */

#include "agg.h"
  
// **************************************************************************
// Module Bag                       03/07/89           Bernhard Schiefer (bs)
//                                                    modified:   9/8/90 (ja)
//                                                              24/10/91 (bs)
//                                                              24/10/92 (ja)
// **************************************************************************
// implements methods of classes: Bag
// **************************************************************************

/*
Ein Bag ist eine Erweiterung von Set, eingetragene Objekte koennen auch in 
mehrfachen Exemplaren eingetragen werden.
Die Implementierung setzt auf einem Mapping auf, und zwar wird eine Abbildung
von einem Objekt auf eine Zahl benutzt. Die Zahl gibt die Anzahl an, wieviel 
Exemplare dieses Objekts im Bag sind. Die Moeglichkeit im Schema ein 
Object_sos_Int_Mapping zu benutzen wurde verworfen, stattdessen wird das
ordinaere Mapping benutzt, wobei ein Entity als Zahl sos_Interpretiert wird.
Der Container liegt nutzlos auf der Platte.
*/

// **************************************************************************
void _sos_Object_Bag::change_impl_type (const sos_Typed_id&_OBSThis,agg_Impl impl)
// **************************************************************************
const{   get_m(_OBSThis).change_impl_type (impl);
} // ** Bag::change_impl_type ***
 

// **************************************************************************
void _sos_Object_Bag::change_list_cursor (const sos_Typed_id&_OBSThis,sos_Bool list_cursor)
// **************************************************************************
const{   get_m(_OBSThis).change_list_cursor (list_cursor);
    set_list_cursor (_OBSThis,list_cursor);
} // ** Bag::change_list_cursor ***

// **************************************************************************
void _sos_Object_Bag::search_succ_pred (const sos_Typed_id&_OBSThis,OBST_PARDECL(sos_Bag_node) bn,  Index steps, 
				       sos_Object& o, sos_Int& no, sos_Int& max)
// **************************************************************************
// suche ausgehend von dem Element in bag_node steps Schritte nach vorne
// bzw. hinten. Liefere in o,no,max die neue Position. Ist die 
// Position nicht gueltig, so ist o = my_no_object
const{
   sos_Object_sos_Int_Mapping m = get_m(_OBSThis);
   sos_Cursor tmp_cur = m.open_cursor();

   max = bn.get_tag_max();
   no = bn.get_tag_no();
   o = m.get_key (bn.get_map_cursor());

   m.move_cursor (tmp_cur, o);

   for ( ; VALID(o) AND steps != 0; )
   {  if (steps > 0)
      {  // Muss ich aufs naechste Element gehen ?
         if (no+steps > max)
         {  // Ja
            if (m.to_succ (tmp_cur))
            {  o = m.get_key (tmp_cur);
               steps -= (max-no+1);
               no = 1;
               max =  m.get_info (tmp_cur);
            }
            else
               o = NO_OBJECT; 
         }
         else
         {  // Nein
            no += steps;
            steps = 0;
         }
      }
      else
      {  // muss ich aufs fruehere Element gehen ?
         if (steps+no < 1)
         {  // Ja
            if (m.to_pred (tmp_cur))
            {  o = m.get_key (tmp_cur);
               steps += no;
               max = m.get_info (tmp_cur);
               no = max;
            }
            else
               o = NO_OBJECT; 
            // Im Augenblick steht der Zeiger auf der letzten 
            // Auspraegung des Objects
         }
         else
         {  // Nein
            no += steps;
            steps = 0;
         }
      }
   } // for
} // sos_Object_Bag::search_succ_pred


// **************************************************************************
void _sos_Object_Bag::write_current (const sos_Typed_id&_OBSThis,OBST_PARDECL(sos_Cursor) c,OBST_PARDECL(
                                    sos_Object) o,
                                    sos_Int    no,
                                    sos_Int    max)
// **************************************************************************
// schreibe in den Cursor die Position auf dem sos_Object o,
// der Exemplarnummer no und der Exemplaranzahl max.
const{
   sos_Bag_node bn = sos_Bag_node::make (c.get_current());

   get_m(_OBSThis).move_cursor (bn.get_map_cursor(), o);
   bn.set_tag_no (no);
   bn.set_tag_max (max);
} // sos_Object_Bag::write_current

// **************************************************************************
sos_Int _sos_Object_Bag::get_no_of_elements (const sos_Typed_id&_OBSThis,OBST_PARDECL(sos_Object_sos_Int_Mapping) m,OBST_PARDECL(
                                            sos_Object)                 o)
// **************************************************************************
// liefert die Anzahl der Vorkommen, die im Mapping m vom Objekt o sind
const{
   if (m.is_key (o))
      return m[o];
   else
      return 0;
} // ** sos_Object_Bag::get_no_of_element

// **************************************************************************
sos_Int _sos_Object_Bag::set_no_of_elements (const sos_Typed_id&_OBSThis,OBST_PARDECL(sos_Object_sos_Int_Mapping) m,OBST_PARDECL(
                                            sos_Object) o,
                                            sos_Int old_no,
                                            sos_Int new_no)
// **************************************************************************
// Setzt die Anzahl der Vorkommen von o von vormals old_no auf new_no
// Es wird die Anzahl zurueckgeliefert, die dazukam
const{
   if ((new_no == 0) AND (old_no >0))
   {  m.remove (o);
      return -old_no;
   }
   else
      // Hier ist new_no>0 oder old_no==0
      if ((new_no > 0) AND (old_no != new_no))
      {  m.insert (o, new_no);
         return new_no - old_no;
      }
      else 
      // Hier ist old_no==new_no => nichts
         return 0;
} //  ** sos_Object_Bag::set_no_of_elements


// **************************************************************************
void _sos_Object_Bag::local_initialize (OBST_PARDECL(sos_Object_Bag) bag)
// **************************************************************************
{  T_PROC ("sos_Object_Bag::local_initialize");
   TT (agg_H, T_ENTER);

   bag.set_cardinality (0);
   bag.set_m (sos_Object_sos_Int_Mapping::create
		  (bag.container(),
		   bag.get_list_cursor(),
		   bag.get_based_on_equal(),
		   FALSE,
		   bag.get_impl_type()));

   TT (agg_H, T_LEAVE);
} // ** local_initialize **

// **************************************************************************
void _sos_Object_Bag::local_finalize (OBST_PARDECL(sos_Object_Bag) bag)
// **************************************************************************
{  T_PROC ("sos_Object_Bag::local_finalize");
   TT (agg_H, T_ENTER);

   bag.get_m().destroy();

   TT (agg_H, T_LEAVE);
} // ** local_finalize **

// **************************************************************************
sos_Int _sos_Object_Bag::entity_occurs (const sos_Typed_id&_OBSThis,OBST_PARDECL(sos_Cursor) c)
// **************************************************************************
const{  T_PROC ("sos_Object_Bag::entity_occurs");
   TT (agg_H, T_ENTER);

   sos_Cursor map_cursor = 
      sos_Bag_node::make(c.get_current()).get_map_cursor();
   sos_Int no_of_entries = get_m(_OBSThis).get_info (map_cursor);

   TT (agg_H, T_LEAVE);
   return no_of_entries;
} // ** sos_Object_Bag::entity_occurs (sos_Cursor)

// **************************************************************************
sos_Bool _sos_Object_Bag::to_diff_succ (const sos_Typed_id&_OBSThis,OBST_PARDECL(sos_Cursor) c, Index steps)
// **************************************************************************
const{  T_PROC ("sos_Object_Bag::to_diff_succ");
   TT (agg_H, T_ENTER);

   sos_Object_sos_Int_Mapping m = get_m(_OBSThis);
   err_assert (c.defined_for (sos_Object_Bag::make(_OBSThis,this)), "sos_Object_Bag:to_diff_succ");
   err_assert (is_valid (_OBSThis,c),"sos_Object_Bag:to_diff_succ");   
      
   sos_Bag_node bn = sos_Bag_node::make (c.get_current());
   sos_Cursor map_cursor = bn.get_map_cursor();
   sos_Bool valid = m.to_succ (map_cursor, steps);
   if (valid)
   {  bn.set_tag_no(1);
      bn.set_tag_max (m.get_info (map_cursor));
   }
   
   TT (agg_H, T_LEAVE);
   return valid;
} // ** sos_Object_Bag::to_diff_succ **

// **************************************************************************
sos_Bool _sos_Object_Bag::to_diff_pred (const sos_Typed_id&_OBSThis,OBST_PARDECL(sos_Cursor) c, Index steps)
// **************************************************************************
const{  T_PROC ("sos_Object_Bag::to_diff_pred");
   TT (agg_H, T_ENTER);

   sos_Object_sos_Int_Mapping m = get_m(_OBSThis);
   err_assert (c.defined_for (sos_Object_Bag::make(_OBSThis,this)), "sos_Object_Bag:to_diff_pred");
   err_assert (is_valid (_OBSThis,c),"sos_Object_Bag:to_diff_pred");   
      
   sos_Bag_node bn = sos_Bag_node::make (c.get_current());
   sos_Cursor map_cursor = bn.get_map_cursor();

   sos_Bool valid = m.to_pred (map_cursor, steps);
   if (valid)
   {  sos_Int max = m.get_info (map_cursor);
      bn.set_tag_no (max);
      bn.set_tag_max (m.get_info (map_cursor));
   }

   TT (agg_H, T_LEAVE);
   return valid;
} // ** sos_Object_Bag::to_diff_pred **

// **************************************************************************
void _sos_Object_Bag::eliminate (const sos_Typed_id&_OBSThis,OBST_PARDECL(sos_Object) o)
// **************************************************************************
// loescht alle Vorkommen von o
const{
   T_PROC ("sos_Object_Bag::eliminate");
   TT (agg_H, T_ENTER);

   sos_Object_sos_Int_Mapping m = get_m(_OBSThis);
   sos_Int no_of_entries = 0;

   if (m.is_key (o))
   {  no_of_entries = m[o];
      m.remove (o);
      set_cardinality (_OBSThis,get_cardinality(_OBSThis) - no_of_entries);
   }

   TT (agg_H, T_LEAVE);
} // ** sos_Object_Bag::eliminate **

// **************************************************************************
sos_Int _sos_Object_Bag::occurrences (const sos_Typed_id&_OBSThis,OBST_PARDECL(sos_Object) o)
// **************************************************************************
const{ 
   T_PROC ("sos_Object_Bag::occurrences");
   TT (agg_H, T_ENTER);

   sos_Object_sos_Int_Mapping m = get_m(_OBSThis);
   sos_Int no_of_entries = 0;

   if (m.is_key (o))
      no_of_entries = m[o];

   TT (agg_H, T_LEAVE);
   return no_of_entries;
} // ** sos_Object_Bag::occurrences (sos_Object)

// **************************************************************************
sos_Int _sos_Object_Bag::insert (const sos_Typed_id&_OBSThis,OBST_PARDECL(sos_Object) o)
// **************************************************************************
// fuege das Objekt o in das Bag ein, es wird die Anzahl der danach (!) im
// Bag vorhandenen Exemplare geliefert.
const{
   T_PROC ("sos_Object_Bag::insert");
   TT (agg_H, T_ENTER);

   sos_Object_sos_Int_Mapping m = get_m(_OBSThis);
   sos_Int no_of_entries = 1;

   // hole die Abbildung von o, um herauszufinden, wieviel Objekte o
   // schon vorhanden sind

   // Der Offset wird sos_Interpretiert als die Anzahl der Objekte o, die schon
   // vorhanden sind.
   if (m.is_key (o))
      no_of_entries = m[o]+1;

   m.insert (o, no_of_entries); // ueberschreibe altes o

   set_cardinality (_OBSThis,get_cardinality(_OBSThis)+1);
   TT (agg_H, T_LEAVE);
   return no_of_entries;
} // ** sos_Object_Bag::insert **

// **************************************************************************
sos_Int _sos_Object_Bag::remove (const sos_Typed_id&_OBSThis,OBST_PARDECL(sos_Object) o)
// **************************************************************************
// loesche ein Objekt o, es wird die Anzahl der Objekte, die 
// vorher (!) im bag waren, zurueckgeliefert
const{
   T_PROC ("sos_Object_Bag::remove");
   TT (agg_H, T_ENTER);

   sos_Object_sos_Int_Mapping m = get_m(_OBSThis);
   sos_Int no_of_entries = 0;

   if (m.is_key (o))
   {  no_of_entries = m[o];
      if (no_of_entries == 1)
	 m.remove (o);
      else
         m.insert (o, no_of_entries-1); 

      set_cardinality (_OBSThis,get_cardinality(_OBSThis) - 1);
   }

   TT (agg_H, T_LEAVE);
   return no_of_entries;
} // ** remove **


// **************************************************************************
void _sos_Object_Bag::__plus_assign (const sos_Typed_id&_OBSThis,OBST_PARDECL(sos_Object_Bag) abag)
// **************************************************************************
// Nach A += B wurden alle Elemente in B zu A aufaddiert
const{
   T_PROC ("sos_Object_Bag::operator+=");
   TT (agg_H, T_ENTER);

   sos_Object_sos_Int_Mapping this_m = get_m(_OBSThis);
   sos_Object_sos_Int_Mapping abag_m = abag.get_m();
   sos_Cursor cur = abag_m.open_cursor ();
   for (;abag_m.is_valid (cur);)
   {
      sos_Object o = abag_m.get_key (cur);
      if (abag_m.is_valid (cur) == TRUE)
         abag_m.to_succ (cur);
      sos_Int this_entries = get_no_of_elements (_OBSThis,this_m, o);
      sos_Int abag_entries = get_no_of_elements (_OBSThis,abag_m, o);
      sos_Int add=set_no_of_elements (_OBSThis,this_m, o, 
				       this_entries, this_entries+abag_entries);
      set_cardinality (_OBSThis,get_cardinality(_OBSThis)+add);
   } // for
   abag_m.close_cursor (cur);
   TT (agg_H, T_LEAVE);
} // ** _sos_Object_Bag:;operator+= **

// **************************************************************************
void _sos_Object_Bag::__minus_assign (const sos_Typed_id&_OBSThis,OBST_PARDECL(sos_Object_Bag) abag)
// **************************************************************************
// Nach A -= B wurden aus A alle Elemente, die in B sind, entfernt
const{  T_PROC ("sos_Object_BAsos_Object_Bag::operator-=");
   TT (agg_H, T_ENTER);

   sos_Object_sos_Int_Mapping this_m = get_m(_OBSThis);
   sos_Object_sos_Int_Mapping abag_m = abag.get_m();

   sos_Cursor cur = abag_m.open_cursor();

   for (;(abag_m.is_valid (cur));)
   {  sos_Object o = abag_m.get_key (cur);
      if (abag_m.is_valid (cur))
         abag_m.to_succ (cur);

      // Wie oft gibt`s das Element ?
      sos_Int this_entries = get_no_of_elements (_OBSThis,this_m, o);
      sos_Int abag_entries = get_no_of_elements (_OBSThis,abag_m, o);
      sos_Int new_entries = this_entries-abag_entries;
      if (new_entries < 0)
         new_entries = 0;
      
      sos_Int add = set_no_of_elements (_OBSThis,this_m, o, this_entries, new_entries);
 
      set_cardinality (_OBSThis,get_cardinality(_OBSThis)+add);
   } // for
   abag_m.close_cursor (cur);
   TT (agg_H, T_LEAVE);
} // ** _sos_Object_Bag:;operator-= **

// **************************************************************************
void _sos_Object_Bag::__times_assign (const sos_Typed_id&_OBSThis,OBST_PARDECL(sos_Object_Bag) abag)
// **************************************************************************
// Liefert die Schnittmenge von A und B,
// Also entferne aus self alle Elemente, die nicht in abag sind
const{  
   T_PROC ("sos_Object_Bag::operator*=");
   TT (agg_H, T_ENTER);

 
   sos_Object_sos_Int_Mapping abag_m = abag.get_m();
   sos_Object_sos_Int_Mapping this_m = get_m(_OBSThis);
   sos_Cursor cur = this_m.open_cursor();
   sos_Bool cur_valid = this_m.is_valid (cur); 
   sos_Int length = get_cardinality(_OBSThis);
   for (;(cur_valid);)
   {  sos_Object o = this_m.get_key (cur);
      // erhoehe gleich den Cursor, da das sos_Object in set_no_of_element 
      // eventuel geloescht wird. Wuerde dann to_succ aufgerufen, 
      // gaebe es den altbekannten SEGV
      if (cur_valid)
         cur_valid = this_m.to_succ (cur);

      // Wieviel Auspraegungen von diesem Element gibt es ?
      sos_Int this_entries = get_no_of_elements (_OBSThis,this_m, o);
      sos_Int abag_entries = get_no_of_elements (_OBSThis,abag_m, o);
      // Die neue Anzahl ist das Minimum der beiden
      sos_Int new_entries = this_entries;
      if (this_entries > abag_entries )
         new_entries = abag_entries;

      sos_Int add = set_no_of_elements (_OBSThis,this_m, o, this_entries, new_entries);
      
      length += add;
   } // for 
   set_cardinality (_OBSThis,length);
   this_m.close_cursor (cur);
   TT (agg_H, T_LEAVE);
} // ** sos_Object_Bag::operator*= **

// **************************************************************************
sos_Bool _sos_Object_Bag::__less (const sos_Typed_id&_OBSThis,OBST_PARDECL(sos_Object_Bag) abag)
// **************************************************************************
// Liefert TRUE zurueck, wenn jedes Element aus this auch in abag ist
// und abag mindestens ein Element mehr enthaelt
const{ 
   T_PROC ("sos_Object_Bag::operator<");
   TT (agg_H, T_ENTER);

   sos_Object_sos_Int_Mapping abag_m = abag.get_m();
   sos_Object_sos_Int_Mapping this_m = get_m(_OBSThis);

   // pruefe zuerst, ob die Anzahl der Elemente schon ein Ergebnis liefert
   if (get_cardinality(_OBSThis) >= abag.get_cardinality())
   {
      TT (agg_H, T_LEAVE);
      return FALSE;
   }
   
   // So, ab hier sind in abag mehr Elemente als in this

   sos_Cursor cur = this_m.open_cursor();
   for (;this_m.is_valid (cur);this_m.to_succ (cur))
   {  sos_Object o = this_m.get_key (cur);
      sos_Int this_entries = get_no_of_elements (_OBSThis,this_m, o);
      sos_Int abag_entries = get_no_of_elements (_OBSThis,abag_m, o);
      if (this_entries > abag_entries)
      {
         this_m.close_cursor (cur);
         TT (agg_H, T_LEAVE);
         return FALSE;
      }
   } // for
   this_m.close_cursor (cur);

   // Hier angekommen, ist this < abag
   TT (agg_H, T_LEAVE);
   return TRUE;
} // ** sos_Object_Bag::operator< **

// **************************************************************************
sos_Bool _sos_Object_Bag::__less_equal (const sos_Typed_id&_OBSThis,OBST_PARDECL(sos_Object_Bag) abag)
// **************************************************************************
// Liefert TRUE zurueck, wenn jedes Element aus this auch in abag ist
const{ 
   T_PROC ("sos_Object_Bag::operator<=");
   TT (agg_H, T_ENTER);

   sos_Object_sos_Int_Mapping abag_m = abag.get_m();
   sos_Object_sos_Int_Mapping this_m = get_m(_OBSThis);

   // pruefe zuerst, ob die Anzahl der Elemente schon ein Ergebnis liefert
   if (get_cardinality(_OBSThis) > abag.get_cardinality())
   {  TT (agg_H, T_LEAVE);
      return FALSE;
   }

   // So, ab hier sind in abag mindestens soviele Elemente wie in this
   sos_Cursor cur = this_m.open_cursor();
   for (;this_m.is_valid (cur);this_m.to_succ (cur))
   {  sos_Object o = this_m.get_key (cur);
      sos_Int this_entries = get_no_of_elements (_OBSThis,this_m, o);
      sos_Int abag_entries = get_no_of_elements (_OBSThis,abag_m, o);
      if (this_entries > abag_entries)
      {  this_m.close_cursor (cur);
         TT (agg_H, T_LEAVE);
         return FALSE;
      }
   } // for
   this_m.close_cursor (cur);
   TT (agg_H, T_LEAVE);
   return TRUE;
} // ** sos_Object_Bag::operator<= **

// **************************************************************************
sos_Bool _sos_Object_Bag::__greater (const sos_Typed_id&_OBSThis,OBST_PARDECL(sos_Object_Bag) abag)
const{ return sos_Bool (abag < sos_Object_Bag::make(_OBSThis,this)); }
// **************************************************************************

// **************************************************************************
sos_Bool _sos_Object_Bag::__greater_equal (const sos_Typed_id&_OBSThis,OBST_PARDECL(sos_Object_Bag) abag)
const{ return sos_Bool (abag <= sos_Object_Bag::make(_OBSThis,this)); }
// **************************************************************************

// **************************************************************************
void _sos_Object_Bag::max_union (const sos_Typed_id&_OBSThis,OBST_PARDECL(sos_Object_Bag) b)
// **************************************************************************
const{  T_PROC ("sos_Object_Bag::max_union");
   TT(agg_H, T_ENTER);

   sos_Object_sos_Int_Mapping this_m = get_m(_OBSThis);
   sos_Object_sos_Int_Mapping b_m    = b.get_m();
   sos_Cursor cur     = b_m.open_cursor ();
   for (;b_m.is_valid (cur);)
   {  sos_Object o;
      o = b_m.get_key (cur);
      b_m.to_succ (cur);
      sos_Int this_entries = get_no_of_elements (_OBSThis,this_m, o);
      sos_Int b_entries = get_no_of_elements (_OBSThis,b_m, o);
      if (this_entries < b_entries)
      {  sos_Int add = set_no_of_elements (_OBSThis,this_m, o, this_entries, b_entries);
         set_cardinality (_OBSThis,get_cardinality(_OBSThis)+add);
      }
   } // for
   b_m.close_cursor (cur);
   TT (agg_H, T_LEAVE);
} // ** sos_Object_Bag::max_union **

// **************************************************************************
void _sos_Object_Bag::local_assign (OBST_PARDECL(sos_Object_Bag) x,OBST_PARDECL( sos_Object) o)
// **************************************************************************
{  T_PROC ("sos_Object_Bag::local_assign");
   TT(agg_H, T_ENTER);

   sos_Object_Bag y = sos_Object_Bag::make (o);
   x.get_m().assign (y.get_m());

   x.set_cardinality (y.get_cardinality());
   TT(agg_H, T_LEAVE);
} // sos_Object_Bag::local_assign

// **************************************************************************
sos_Bool _sos_Object_Bag::local_equal (OBST_PARDECL(sos_Object_Bag) x,OBST_PARDECL( sos_Object) o,
				      sos_Eq_kind)
// **************************************************************************
{  T_PROC ("sos_Object_Bag::local_equal");
   TT(agg_H, T_ENTER);
   
   sos_Bool result;

   sos_Object_Bag y = sos_Object_Bag::make (o);
   sos_Object_sos_Int_Mapping x_m = x.get_m();
   sos_Object_sos_Int_Mapping y_m = y.get_m();
   if (x.get_cardinality() != y.get_cardinality())
      result = FALSE;
   else
   {  result = TRUE;
      agg_iterate_association (x_m, sos_Object key, sos_Int x_entries)
      {  if (x_entries != y.get_no_of_elements (y_m, key))
	 {  result = FALSE;
	    break;
	 }  
      }
      agg_iterate_association_end (x_m, key, x_entries);
   }
   TT(agg_H, T_LEAVE;TB(result));
   return result;
} // sos_Object_Bag::local_equal

// **************************************************************************
sos_Int _sos_Object_Bag::local_hash_value (OBST_PARDECL(sos_Object_Bag))
// **************************************************************************
{  T_PROC ("sos_Object_Bag::local_hash_value");
   TT(agg_H, T_ENTER);
   
   sos_Int result = 0;

   TT(agg_H, T_LEAVE;TI(result));

   return result;
} // sos_Object_Bag::local_hash_value

// **************************************************************************
sos_Bool _sos_Object_Bag::is_element (const sos_Typed_id&_OBSThis,OBST_PARDECL(sos_Object) o)
// **************************************************************************
const{  T_PROC ("sos_Object_Bag::is_element");
   TT (agg_H, T_ENTER);

   sos_Bool result = get_m(_OBSThis).is_key (o);

   TT (agg_H, T_LEAVE);
   return result;
} // ** sos_Object_Bag::is_element (sos_Object)

// **************************************************************************
sos_Object _sos_Object_Bag::get (const sos_Typed_id&_OBSThis,OBST_PARDECL(sos_Cursor) c)
// **************************************************************************
const{  T_PROC ("sos_Object_Bag::get");
   TT (agg_H, T_ENTER);

   err_assert (c.defined_for (sos_Object_Bag::make(_OBSThis,this)), "sos_Object_Bag:get");
   err_assert (is_valid (_OBSThis,c),"sos_Object_Bag:get");   

   sos_Bag_node bn = sos_Bag_node::make (c.get_current());
   sos_Object o = get_m(_OBSThis).get_key (bn.get_map_cursor());
    
   TT (agg_H, T_LEAVE);
   return o;
} // ** sos_Object_Bag::get **

// **************************************************************************
void _sos_Object_Bag::remove_at (const sos_Typed_id&_OBSThis,OBST_PARDECL(sos_Cursor) c)
// **************************************************************************
const{  T_PROC ("sos_Object_Bag::remove_at");
   TT(agg_H, T_ENTER);

   err_assert (c.defined_for (sos_Object_Bag::make(_OBSThis,this)), "sos_Object_Bag:remove_at");
   err_assert (is_valid (_OBSThis,c),"sos_Object_Bag:remove_at");   

   sos_Object entity = get (_OBSThis,c);
   if (get_list_cursor(_OBSThis))
      to_succ (_OBSThis,c,1);
   remove (_OBSThis,entity);

   TT(agg_H, T_LEAVE);
} // sos_Object_Bag::remove_at

// **************************************************************************
sos_Int _sos_Object_Bag::card (const sos_Typed_id&_OBSThis)
// **************************************************************************
const{
   T_PROC ("sos_Object_Bag::card");
   TT (agg_H, T_ENTER);

   sos_Int crd = get_cardinality(_OBSThis);

   TT (agg_H, T_LEAVE; TI(crd));
   return crd;
} // ** card **

// **************************************************************************
void _sos_Object_Bag::clear(const sos_Typed_id&_OBSThis)
// **************************************************************************
const{  T_PROC ("sos_Object_Bag::clear");
   TT (agg_H, T_ENTER);
   
   get_m(_OBSThis).clear();
   set_cardinality(_OBSThis,0);

   TT (agg_H, T_LEAVE);
} // ** clear

// **************************************************************************
sos_Cursor _sos_Object_Bag::open_cursor (const sos_Typed_id&_OBSThis,sos_Container Cursor_ct)
// **************************************************************************
const{
   sos_Object_sos_Int_Mapping m = get_m(_OBSThis);
   sos_Cursor c = sos_Cursor::create(Cursor_ct, sos_Object_Bag::make(_OBSThis,this));
   sos_Cursor map_cursor = m.open_cursor (Cursor_ct);
   sos_Bag_node bn = sos_Bag_node::create
		       (Cursor_ct, map_cursor, get_list_cursor(_OBSThis));
   c.set_current (bn);

   if (m.to_first (map_cursor))
   {  bn.set_tag_no(1);
      bn.set_tag_max (m.get_info (map_cursor));
   }

   return c;
} // sos_Object_Bag::open_cursor

// **************************************************************************
void _sos_Object_Bag::close_cursor (const sos_Typed_id&_OBSThis,OBST_PARDECL(sos_Cursor) c)
// **************************************************************************
const{  
   sos_Bag_node bn = sos_Bag_node::make (c.get_current());
   get_m(_OBSThis).close_cursor (bn.get_map_cursor());
   c.get_current().destroy();
   c.destroy();
} // sos_Object_Bag::close_cursor

// **************************************************************************
sos_Cursor _sos_Object_Bag::duplicate (const sos_Typed_id&_OBSThis,OBST_PARDECL(sos_Cursor) c, 
				      sos_Container cnt /*= TEMP_CONTAINER */)
// **************************************************************************
const{  
   sos_Object_sos_Int_Mapping m = get_m(_OBSThis);
   sos_Bag_node  bn        = sos_Bag_node::make (c.get_current());
   sos_Cursor map_cursor   = bn.get_map_cursor();

   sos_Cursor dup_map_cursor = m.duplicate (map_cursor, cnt);
   sos_Cursor dup_c        = sos_Cursor::create(cnt, sos_Object_Bag::make(_OBSThis,this));
   sos_Bag_node dup_bn     = 
      sos_Bag_node::create(cnt, dup_map_cursor, get_list_cursor(_OBSThis));

   dup_c.set_current (dup_bn);
   dup_bn.set_tag_no (bn.get_tag_no());
   dup_bn.set_tag_max (bn.get_tag_max());
   return dup_c;
} // sos_Object_Bag::duplicate

// **************************************************************************
sos_Bool _sos_Object_Bag::is_valid (const sos_Typed_id&_OBSThis,OBST_PARDECL(sos_Cursor) c)
// ************************************************************************** 
const{  sos_Cursor map_cursor = 
      sos_Bag_node::make (c.get_current()).get_map_cursor();
   sos_Bool valid =get_m(_OBSThis).is_valid (map_cursor);
   return valid;
} // ** is_valid **

// **************************************************************************
sos_Bool _sos_Object_Bag::to_first (const sos_Typed_id&_OBSThis,OBST_PARDECL(sos_Cursor) c)
// **************************************************************************
const{  sos_Object_sos_Int_Mapping m = get_m(_OBSThis);
   sos_Bag_node  bn        = sos_Bag_node::make (c.get_current());
   sos_Cursor map_cursor = bn.get_map_cursor();

   m.to_first (map_cursor);
   if (m.is_valid (map_cursor))
   { bn.set_tag_no(1);
     bn.set_tag_max (m.get_info (map_cursor));
   }

   return m.is_valid (map_cursor);
} // sos_Object_Bag::to_first

// **************************************************************************
sos_Bool _sos_Object_Bag::to_last (const sos_Typed_id&_OBSThis,OBST_PARDECL(sos_Cursor) c)
// **************************************************************************
const{  sos_Object_sos_Int_Mapping m = get_m(_OBSThis);
   sos_Bag_node  bn = sos_Bag_node::make (c.get_current());
   sos_Cursor map_cursor = bn.get_map_cursor();

   m.to_last (map_cursor);
   if (m.is_valid (map_cursor))
   {   sos_Int no = m.get_info (map_cursor);
       bn.set_tag_no (no);
       bn.set_tag_max (no);
   }

   return m.is_valid (map_cursor);
} // sos_Object_Bag::to_last

// **************************************************************************
sos_Bool _sos_Object_Bag::to_succ (const sos_Typed_id&_OBSThis,OBST_PARDECL(sos_Cursor) c, Index steps)
// **************************************************************************
const{  T_PROC ("sos_Object_Bag::to_succ");
   TT (agg_H, T_ENTER);

   err_assert (c.defined_for (sos_Object_Bag::make(_OBSThis,this)), "sos_Object_Bag:to_succ");
   err_assert (is_valid (_OBSThis,c),"sos_Object_Bag:to_succ");   
      
   sos_Bag_node bn = sos_Bag_node::make (c.get_current());

   sos_Object   o;
   sos_Int      no, max;

   search_succ_pred (_OBSThis,bn, steps, o, no, max);
   write_current (_OBSThis,c, o, no, max);

   TT (agg_H, T_LEAVE);
   return is_valid (_OBSThis,c);
} // ** sos_Object_Bag::to_succ **

// **************************************************************************
sos_Bool _sos_Object_Bag::to_pred (const sos_Typed_id&_OBSThis,OBST_PARDECL(sos_Cursor) c, Index steps)
// **************************************************************************
const{  T_PROC ("sos_Object_Bag::to_pred");
   TT (agg_H, T_ENTER);

   err_assert (c.defined_for (sos_Object_Bag::make(_OBSThis,this)), "sos_Object_Bag:to_pred");
   err_assert (is_valid (_OBSThis,c),"sos_Object_Bag:to_pred");   
      
   sos_Bag_node bn = sos_Bag_node::make (c.get_current());

   sos_Object   o;
   sos_Int      no, max;

   search_succ_pred (_OBSThis,bn,-steps, o, no, max);
   write_current (_OBSThis,c, o, no, max);
   
   TT (agg_H, T_LEAVE);
   return is_valid (_OBSThis,c);
} // ** sos_Object_Bag::to_pred **
