#ifndef _MSH_H
#define _MSH_H 1
/* --------------------------------------------------------------------------
 * Copyright 1993-1994 by Forschungszentrum Informatik (FZI)
 *
 * You can use and distribute this software under the terms of the licence
 * you should have received along with this program.
 * If not or if you want additional information, write to
 * Forschungszentrum Informatik, "OBST", Haid-und-Neu-Strasse 10-14,
 * D-76131 Karlsruhe, Germany.
 * --------------------------------------------------------------------------
 */

#include "mta.h"      	     // Some evolution methods are functions
#include "msh_err.h"	     // e.g. mta_commit, mta_reset

// -------------------------- msh_main.C ------------------------------------
extern sos_Bool			   msh_echo;
extern sos_Schema_module_Directory msh_sd;

extern void 	  msh_list_subclasses (const sos_Class_type &ct);
extern void 	  msh_list_schemas();
extern void 	  help_schema();
extern void 	  help_type();
extern void 	  help_class();
extern void 	  help_comp();
extern void 	  help_method();
extern void 	  help_method();
extern void 	  help_enum();
extern void 	  help_union();
extern void 	  help_typedef();
extern void 	  help_extern();
extern void 	  msh_help();
extern void 	  msh_prompt();
extern void 	  msh_error (err_class ec, err_msg s, char* where = 0);
extern void	  msh_error (err_class ec, err_msg s, const sos_String&);
extern sos_Method msh_lookup_method (const sos_Class_type& ct,
				     const sos_String& name,
				     sos_Int num_par = -1);
extern void 	  msh_wait_key();

// -------------------------- msh_yacc.C ------------------------------------
extern int msh_yyparse();
extern int msh_yylineno;

#endif /* _MSH_H */
