#ifndef knl_USE_H
#define knl_USE_H 1
#include "obst_config.h"
enum sos_Bool { FALSE,TRUE };
enum sos_Eq_kind { EQ_STRONG,EQ_WEAK };
enum sos_Comp_result { CMP_LESS,CMP_EQUAL,CMP_GREATER };
enum sos_Sync_mode { TESTING,WAITING };
enum sos_Open_result { LOCKED,OPENED,UNACCESSIBLE,DEADLOCK };
enum sos_Access_mode { READING,CHECKOUT,WRITING };
enum sos_Container_status { READABLE,CHECKEDOUT,WRITEABLE,DESTROYED,UNAVAILABLE };
enum sos_Container_mod_status { NOT_MODIFIABLE,MODIFIABLE,OPEN };
enum sos_Existing_status { NOT_EXISTING,PERHAPS_EXISTING };
class sos_Object;
class sos_Ordered_object;
class sos_Scalar_object;
class sos_String;
class sos_Named;
class sos_Type;
#include "knl_ext.h"
extern sos_Id*_knl__tp_;
extern sos_Type*_knl_tp_;
#define _void_type _knl__tp_[0]
#define void_type _knl_tp_[0]
sos_Object make_sos_Int_object(const sos_Int);
sos_Int make_sos_Int(const sos_Object&);
#define _sos_Int_type _knl__tp_[1]
#define sos_Int_type _knl_tp_[1]
sos_Object make_sos_Float_object(OBST_FLOATMAKEDECL(sos_Float));
sos_Float make_sos_Float(const sos_Object&);
#define _sos_Float_type _knl__tp_[2]
#define sos_Float_type _knl_tp_[2]
sos_Object make_sos_Char_object(const sos_Char);
sos_Char make_sos_Char(const sos_Object&);
#define _sos_Char_type _knl__tp_[3]
#define sos_Char_type _knl_tp_[3]
sos_Object make_sos_Cstring_object(const sos_Cstring);
sos_Cstring make_sos_Cstring(const sos_Object&);
#define _sos_Cstring_type _knl__tp_[4]
#define sos_Cstring_type _knl_tp_[4]
sos_Object make_sos_Pointer_object(const sos_Pointer);
sos_Pointer make_sos_Pointer(const sos_Object&);
#define _sos_Pointer_type _knl__tp_[5]
#define sos_Pointer_type _knl_tp_[5]
sos_Object make_sos_CppFctPtr_object(const sos_CppFctPtr);
sos_CppFctPtr make_sos_CppFctPtr(const sos_Object&);
#define _sos_CppFctPtr_type _knl__tp_[6]
#define sos_CppFctPtr_type _knl_tp_[6]
sos_Object make_sos_Id_object(const sos_Id);
sos_Id make_sos_Id(const sos_Object&);
#define _sos_Id_type _knl__tp_[7]
#define sos_Id_type _knl_tp_[7]
inline void bcopy_from_sos_Bool(void*e,void*c)
{*(sos_Char*)c=(sos_Char)*(sos_Bool*)e;}
inline void bcopy_to_sos_Bool(void*e,void*c)
{*(sos_Bool*)e=(sos_Bool)*(sos_Char*)c;}
sos_Object make_sos_Bool_object(const sos_Bool);
sos_Bool make_sos_Bool(const sos_Object&);
#define _sos_Bool_type _knl__tp_[8]
#define sos_Bool_type _knl_tp_[8]
inline void bcopy_from_sos_Eq_kind(void*e,void*c)
{*(sos_Char*)c=(sos_Char)*(sos_Eq_kind*)e;}
inline void bcopy_to_sos_Eq_kind(void*e,void*c)
{*(sos_Eq_kind*)e=(sos_Eq_kind)*(sos_Char*)c;}
sos_Object make_sos_Eq_kind_object(const sos_Eq_kind);
sos_Eq_kind make_sos_Eq_kind(const sos_Object&);
#define _sos_Eq_kind_type _knl__tp_[9]
#define sos_Eq_kind_type _knl_tp_[9]
inline void bcopy_from_sos_Comp_result(void*e,void*c)
{*(sos_Char*)c=(sos_Char)*(sos_Comp_result*)e;}
inline void bcopy_to_sos_Comp_result(void*e,void*c)
{*(sos_Comp_result*)e=(sos_Comp_result)*(sos_Char*)c;}
sos_Object make_sos_Comp_result_object(const sos_Comp_result);
sos_Comp_result make_sos_Comp_result(const sos_Object&);
#define _sos_Comp_result_type _knl__tp_[10]
#define sos_Comp_result_type _knl_tp_[10]
sos_Object make_sos_Container_object(const sos_Container);
sos_Container make_sos_Container(const sos_Object&);
#define _sos_Container_type _knl__tp_[11]
#define sos_Container_type _knl_tp_[11]
sos_Object make_sos_Offset_object(const sos_Offset);
sos_Offset make_sos_Offset(const sos_Object&);
#define _sos_Offset_type _knl__tp_[12]
#define sos_Offset_type _knl_tp_[12]
inline void bcopy_from_sos_Sync_mode(void*e,void*c)
{*(sos_Char*)c=(sos_Char)*(sos_Sync_mode*)e;}
inline void bcopy_to_sos_Sync_mode(void*e,void*c)
{*(sos_Sync_mode*)e=(sos_Sync_mode)*(sos_Char*)c;}
sos_Object make_sos_Sync_mode_object(const sos_Sync_mode);
sos_Sync_mode make_sos_Sync_mode(const sos_Object&);
#define _sos_Sync_mode_type _knl__tp_[13]
#define sos_Sync_mode_type _knl_tp_[13]
inline void bcopy_from_sos_Open_result(void*e,void*c)
{*(sos_Char*)c=(sos_Char)*(sos_Open_result*)e;}
inline void bcopy_to_sos_Open_result(void*e,void*c)
{*(sos_Open_result*)e=(sos_Open_result)*(sos_Char*)c;}
sos_Object make_sos_Open_result_object(const sos_Open_result);
sos_Open_result make_sos_Open_result(const sos_Object&);
#define _sos_Open_result_type _knl__tp_[14]
#define sos_Open_result_type _knl_tp_[14]
inline void bcopy_from_sos_Access_mode(void*e,void*c)
{*(sos_Char*)c=(sos_Char)*(sos_Access_mode*)e;}
inline void bcopy_to_sos_Access_mode(void*e,void*c)
{*(sos_Access_mode*)e=(sos_Access_mode)*(sos_Char*)c;}
sos_Object make_sos_Access_mode_object(const sos_Access_mode);
sos_Access_mode make_sos_Access_mode(const sos_Object&);
#define _sos_Access_mode_type _knl__tp_[15]
#define sos_Access_mode_type _knl_tp_[15]
inline void bcopy_from_sos_Container_status(void*e,void*c)
{*(sos_Char*)c=(sos_Char)*(sos_Container_status*)e;}
inline void bcopy_to_sos_Container_status(void*e,void*c)
{*(sos_Container_status*)e=(sos_Container_status)*(sos_Char*)c;}
sos_Object make_sos_Container_status_object(const sos_Container_status);
sos_Container_status make_sos_Container_status(const sos_Object&);
#define _sos_Container_status_type _knl__tp_[16]
#define sos_Container_status_type _knl_tp_[16]
inline void bcopy_from_sos_Container_mod_status(void*e,void*c)
{*(sos_Char*)c=(sos_Char)*(sos_Container_mod_status*)e;}
inline void bcopy_to_sos_Container_mod_status(void*e,void*c)
{*(sos_Container_mod_status*)e=(sos_Container_mod_status)*(sos_Char*)c;}
sos_Object make_sos_Container_mod_status_object(const sos_Container_mod_status);
sos_Container_mod_status make_sos_Container_mod_status(const sos_Object&);
#define _sos_Container_mod_status_type _knl__tp_[17]
#define sos_Container_mod_status_type _knl_tp_[17]
inline void bcopy_from_sos_Existing_status(void*e,void*c)
{*(sos_Char*)c=(sos_Char)*(sos_Existing_status*)e;}
inline void bcopy_to_sos_Existing_status(void*e,void*c)
{*(sos_Existing_status*)e=(sos_Existing_status)*(sos_Char*)c;}
sos_Object make_sos_Existing_status_object(const sos_Existing_status);
sos_Existing_status make_sos_Existing_status(const sos_Object&);
#define _sos_Existing_status_type _knl__tp_[18]
#define sos_Existing_status_type _knl_tp_[18]
class sos_Object: public obst_Root_class 
{  friend class _sos_Object;
   const class _sos_Object*_impl;
public :
   static sos_Object make(const sos_Typed_id&);
   static sos_Object make(const sos_Typed_id&_OBSThis,const _sos_Object *_y){
         sos_Object _x;_x._self=_OBSThis;_x._impl=_y;return _x;
   }
   static sos_Object make(const obst_Root_class&);
private:
   sos_Id get_type_id(OBST_NO_ARGS)const;
   void set_type_id(sos_Id)const;
public:
   static sos_Object clone(OBST_PARDECL(sos_Object),sos_Container);
   void destroy(OBST_NO_ARGS)const;
   void assign(OBST_PARDECL(sos_Object))const;
   sos_Bool equal(OBST_PARDECL(sos_Object),sos_Eq_kind =EQ_STRONG)const;
   sos_Int hash_value(OBST_NO_ARGS)const;
   sos_Type type(OBST_NO_ARGS)const;
   sos_Bool has_type(OBST_PARDECL(sos_Type))const;
   sos_Bool isa(OBST_PARDECL(sos_Type))const;
   sos_Bool is_some(OBST_PARDECL(sos_Type))const;
   sos_Bool is_value(OBST_NO_ARGS)const;
   sos_Int size(OBST_NO_ARGS)const;
   sos_Bool like(OBST_PARDECL(sos_Object))const;
protected:
   static void local_assign(OBST_PARDECL(sos_Object),OBST_PARDECL(sos_Object));
   static sos_Bool local_equal(OBST_PARDECL(sos_Object),OBST_PARDECL(sos_Object),sos_Eq_kind);
   static sos_Int local_hash_value(OBST_PARDECL(sos_Object));
};
OBST_TMPDEF(extern,sos_Object,_sos_Object_tmp)
#define _sos_Object_type _knl__tp_[19]
#define sos_Object_type _knl_tp_[19]
class sos_Ordered_object: public obst_Root_class 
{  friend class _sos_Ordered_object;
   const class _sos_Ordered_object*_impl;
public :
   operator sos_Object(OBST_NO_ARGS) const;
   static sos_Ordered_object make(const sos_Typed_id&);
   static sos_Ordered_object make(const sos_Typed_id&_OBSThis,const _sos_Ordered_object *_y){
         sos_Ordered_object _x;_x._self=_OBSThis;_x._impl=_y;return _x;
   }
   static sos_Ordered_object make(const obst_Root_class&);
   sos_Bool like(OBST_PARDECL(sos_Object))const;
   static sos_Ordered_object clone(OBST_PARDECL(sos_Ordered_object),sos_Container);
   void destroy(OBST_NO_ARGS)const;
   void assign(OBST_PARDECL(sos_Object))const;
   sos_Bool equal(OBST_PARDECL(sos_Object),sos_Eq_kind =EQ_STRONG)const;
   sos_Int hash_value(OBST_NO_ARGS)const;
   sos_Comp_result compare(OBST_PARDECL(sos_Ordered_object))const;
   sos_Bool operator<(OBST_PARDECL(sos_Ordered_object))const;
   sos_Bool operator<=(OBST_PARDECL(sos_Ordered_object))const;
   sos_Bool operator>(OBST_PARDECL(sos_Ordered_object))const;
   sos_Bool operator>=(OBST_PARDECL(sos_Ordered_object))const;
   sos_Type type(OBST_NO_ARGS)const;
   sos_Bool has_type(OBST_PARDECL(sos_Type))const;
   sos_Bool isa(OBST_PARDECL(sos_Type))const;
   sos_Bool is_some(OBST_PARDECL(sos_Type))const;
   sos_Bool is_value(OBST_NO_ARGS)const;
   sos_Int size(OBST_NO_ARGS)const;
};
OBST_TMPDEF(extern,sos_Ordered_object,_sos_Ordered_object_tmp)
#define _sos_Ordered_object_type _knl__tp_[20]
#define sos_Ordered_object_type _knl_tp_[20]
class sos_Scalar_object: public obst_Root_class 
{  friend class _sos_Scalar_object;
   const class _sos_Scalar_object*_impl;
public :
   operator sos_Object(OBST_NO_ARGS) const;
   static sos_Scalar_object make(const sos_Typed_id&);
   static sos_Scalar_object make(const sos_Typed_id&_OBSThis,const _sos_Scalar_object *_y){
         sos_Scalar_object _x;_x._self=_OBSThis;_x._impl=_y;return _x;
   }
   static sos_Scalar_object make(const obst_Root_class&);
   sos_Bool like(OBST_PARDECL(sos_Object))const;
   static sos_Scalar_object clone(OBST_PARDECL(sos_Scalar_object),sos_Container);
   void destroy(OBST_NO_ARGS)const;
   void assign(OBST_PARDECL(sos_Object))const;
   sos_Bool equal(OBST_PARDECL(sos_Object),sos_Eq_kind =EQ_STRONG)const;
   sos_Int hash_value(OBST_NO_ARGS)const;
protected:
   static void local_initialize(OBST_PARDECL(sos_Scalar_object));
   static void local_finalize(OBST_PARDECL(sos_Scalar_object));
   static void total_assign(OBST_PARDECL(sos_Scalar_object),OBST_PARDECL(sos_Object));
   static sos_Bool total_equal(OBST_PARDECL(sos_Scalar_object),OBST_PARDECL(sos_Object),sos_Eq_kind);
   static sos_Int total_hash_value(OBST_PARDECL(sos_Scalar_object));
public:
   sos_Type type(OBST_NO_ARGS)const;
   sos_Bool has_type(OBST_PARDECL(sos_Type))const;
   sos_Bool isa(OBST_PARDECL(sos_Type))const;
   sos_Bool is_some(OBST_PARDECL(sos_Type))const;
   sos_Bool is_value(OBST_NO_ARGS)const;
   sos_Int size(OBST_NO_ARGS)const;
};
OBST_TMPDEF(extern,sos_Scalar_object,_sos_Scalar_object_tmp)
#define _sos_Scalar_object_type _knl__tp_[21]
#define sos_Scalar_object_type _knl_tp_[21]
class sos_String: public obst_Root_class 
{  friend class _sos_String;
   const class _sos_String*_impl;
public :
   operator sos_Object(OBST_NO_ARGS) const;
   operator sos_Ordered_object(OBST_NO_ARGS) const;
   static sos_String make(const sos_Typed_id&);
   static sos_String make(const sos_Typed_id&_OBSThis,const _sos_String *_y){
         sos_String _x;_x._self=_OBSThis;_x._impl=_y;return _x;
   }
   static sos_String make(const obst_Root_class&);
   static sos_String clone(OBST_PARDECL(sos_String),sos_Container);
   void destroy(OBST_NO_ARGS)const;
   sos_Int hash_value(OBST_NO_ARGS)const;
   sos_Int get_length(OBST_NO_ARGS)const;
private:
   void set_length(sos_Int)const;
public:
   sos_Cstring make_Cstring(OBST_NO_ARGS)const;
   sos_Cstring _make_Cstring(OBST_NO_ARGS)const;
   void operator+=(OBST_PARDECL(sos_String))const;
   sos_Comp_result compare(OBST_PARDECL(sos_Ordered_object))const;
protected:
   static void local_assign(OBST_PARDECL(sos_String),OBST_PARDECL(sos_Object));
   static sos_Bool local_equal(OBST_PARDECL(sos_String),OBST_PARDECL(sos_Object),sos_Eq_kind);
public:
   sos_Bool operator<(OBST_PARDECL(sos_Ordered_object))const;
   sos_Bool operator<=(OBST_PARDECL(sos_Ordered_object))const;
   sos_Bool operator>(OBST_PARDECL(sos_Ordered_object))const;
   sos_Bool operator>=(OBST_PARDECL(sos_Ordered_object))const;
   sos_Bool has_type(OBST_PARDECL(sos_Type))const;
   sos_Bool isa(OBST_PARDECL(sos_Type))const;
   static sos_String create(sos_Container);
   static sos_String create(sos_Container,sos_Cstring);
   static sos_String copy(OBST_PARDECL(sos_String),sos_Container);
   void assign(OBST_PARDECL(sos_Object))const;
   sos_Bool equal(OBST_PARDECL(sos_Object),sos_Eq_kind =EQ_STRONG)const;
   void assign_Cstring(sos_Cstring)const;
   sos_Int size(OBST_NO_ARGS)const;
protected:
   static void local_initialize(OBST_PARDECL(sos_String));
   static void local_finalize(OBST_PARDECL(sos_String));
   static sos_Int local_hash_value(OBST_PARDECL(sos_String));
private:
   sos_Offset get_address(OBST_NO_ARGS)const;
   void set_address(sos_Offset)const;
public:
   sos_Bool like(OBST_PARDECL(sos_Object))const;
   sos_Type type(OBST_NO_ARGS)const;
   sos_Bool is_some(OBST_PARDECL(sos_Type))const;
   sos_Bool is_value(OBST_NO_ARGS)const;
};
OBST_TMPDEF(extern,sos_String,_sos_String_tmp)
#define _sos_String_type _knl__tp_[22]
#define sos_String_type _knl_tp_[22]
class sos_Named: public obst_Root_class 
{  friend class _sos_Named;
   const class _sos_Named*_impl;
public :
   operator sos_Object(OBST_NO_ARGS) const;
   static sos_Named make(const sos_Typed_id&);
   static sos_Named make(const sos_Typed_id&_OBSThis,const _sos_Named *_y){
         sos_Named _x;_x._self=_OBSThis;_x._impl=_y;return _x;
   }
   static sos_Named make(const obst_Root_class&);
   sos_Bool like(OBST_PARDECL(sos_Object))const;
   static sos_Named clone(OBST_PARDECL(sos_Named),sos_Container);
   void destroy(OBST_NO_ARGS)const;
   void assign(OBST_PARDECL(sos_Object))const;
   sos_Bool equal(OBST_PARDECL(sos_Object),sos_Eq_kind =EQ_STRONG)const;
   sos_Int hash_value(OBST_NO_ARGS)const;
   sos_String get_name(OBST_NO_ARGS)const;
   sos_Type type(OBST_NO_ARGS)const;
   sos_Bool has_type(OBST_PARDECL(sos_Type))const;
   sos_Bool isa(OBST_PARDECL(sos_Type))const;
   sos_Bool is_some(OBST_PARDECL(sos_Type))const;
   sos_Bool is_value(OBST_NO_ARGS)const;
   sos_Int size(OBST_NO_ARGS)const;
};
OBST_TMPDEF(extern,sos_Named,_sos_Named_tmp)
#define _sos_Named_type _knl__tp_[23]
#define sos_Named_type _knl_tp_[23]
class sos_Type: public obst_Root_class 
{  friend class _sos_Type;
   const class _sos_Type*_impl;
public :
   operator sos_Object(OBST_NO_ARGS) const;
   operator sos_Named(OBST_NO_ARGS) const;
   static sos_Type make(const sos_Typed_id&);
   static sos_Type make(const sos_Typed_id&_OBSThis,const _sos_Type *_y){
         sos_Type _x;_x._self=_OBSThis;_x._impl=_y;return _x;
   }
   static sos_Type make(const obst_Root_class&);
   static sos_Type clone(OBST_PARDECL(sos_Type),sos_Container);
   void destroy(OBST_NO_ARGS)const;
   sos_Int hash_value(OBST_NO_ARGS)const;
   sos_String get_name(OBST_NO_ARGS)const;
   void set_name(OBST_PARDECL(sos_String))const;
   sos_Bool is_derived_from(OBST_PARDECL(sos_Type))const;
   sos_Bool is_derived_from_some(OBST_PARDECL(sos_Type))const;
   sos_Bool is_scalar(OBST_NO_ARGS)const;
   sos_Type root(OBST_NO_ARGS)const;
   sos_Bool has_type(OBST_PARDECL(sos_Type))const;
   sos_Bool isa(OBST_PARDECL(sos_Type))const;
protected:
   static void local_assign(OBST_PARDECL(sos_Type),OBST_PARDECL(sos_Object));
   static sos_Bool local_equal(OBST_PARDECL(sos_Type),OBST_PARDECL(sos_Object),sos_Eq_kind);
public:
   void assign(OBST_PARDECL(sos_Object))const;
   sos_Bool equal(OBST_PARDECL(sos_Object),sos_Eq_kind =EQ_STRONG)const;
   sos_Int get_object_size(OBST_NO_ARGS)const;
   void set_object_size(sos_Int)const;
   sos_Bool like(OBST_PARDECL(sos_Object))const;
   sos_Type type(OBST_NO_ARGS)const;
   sos_Bool is_some(OBST_PARDECL(sos_Type))const;
   sos_Bool is_value(OBST_NO_ARGS)const;
   sos_Int size(OBST_NO_ARGS)const;
protected:
   static sos_Int local_hash_value(OBST_PARDECL(sos_Type));
};
OBST_TMPDEF(extern,sos_Type,_sos_Type_tmp)
#define _sos_Type_type _knl__tp_[24]
#define sos_Type_type _knl_tp_[24]
extern "C" void _knl_init_obst(int);
#endif
