/* --------------------------------------------------------------------------
 * Copyright 1992-1993 by Forschungszentrum Informatik (FZI)
 *
 * You can use and distribute this software under the terms of the license
 * version 1 you should have received along with this software.
 * If not or if you want additional information, write to
 * Forschungszentrum Informatik, "STONE", Haid-und-Neu-Strasse 10-14,
 * D-76131 Karlsruhe, Germany.
 * --------------------------------------------------------------------------
 */

#include <stream.h>
#include "TextFile_obst.h"

void TextFile::set (sos_Cstring cs)
{  sos_String s = sos_String::create (self.container());
   s.assign_Cstring (cs);
   self.set_contents (s);
   self.set_size (s.get_length());
}

void TextFile::append (UnixFile f)
{  if (f.has_type (TextFile_type))
   {  TextFile tf = TextFile::make (f);
      self.get_contents() += tf.get_contents();
      self.UnixFile::append (f);
   }
   else
      cerr << "Error: invalid parameter type\n";   
}

void TextFile::append (UnixFile f, sos_String separator)
{  self.get_contents() += separator;
   self.append (f);
   self.set_size (self.get_size() + separator.get_length());
}

