/* --------------------------------------------------------------------------
 * Copyright 1992-1993 by Forschungszentrum Informatik (FZI)
 *
 * You can use and distribute this software under the terms of the license
 * version 1 you should have received along with this software.
 * If not or if you want additional information, write to
 * Forschungszentrum Informatik, "STONE", Haid-und-Neu-Strasse 10-14,
 * D-76131 Karlsruhe, Germany.
 * --------------------------------------------------------------------------
 */

#define OBST_IMP_STREAM
#include "obst_stdinc.h"

#include "obst.h"
#include "External_use.h"
#include "../include/string_utils.h"

int main (int argc, char* argv[])
{  obst_init (argc, argv);

   C c_obj      = C::create (TEMP_CONTAINER);
   sos_Double v = 1234.56;

   c_obj.set_val (v);

   cout << "Value stored in/read from a component (must be "
	<< v << "): " << c_obj.get_val() << "\n";
  
   sos_Cstring txt  = "1234.56";
   sos_Object  obj  = make_sos_Double_object_from_string (txt);

   cout << "Value converted from/to an sos_String (must be "
	<< txt << "): " << make_string_from_sos_Double_object (obj) << "\n";

   return 0;
}
