/* --------------------------------------------------------------------------
 * Copyright 1992-1993 by Forschungszentrum Informatik (FZI)
 *
 * You can use and distribute this software under the terms of the license
 * version 1 you should have received along with this software.
 * If not or if you want additional information, write to
 * Forschungszentrum Informatik, "STONE", Haid-und-Neu-Strasse 10-14,
 * D-76131 Karlsruhe, Germany.
 * --------------------------------------------------------------------------
 */

#define OBST_IMP_STREAM
#include "obst_stdinc.h"

#include "obst.h"
#include "dir_use.h"
#include "../UnixFile/UnixFile_use.h"

int main (int argc, char* argv[])
{  obst_init (argc, argv);

   sos_Container cnt       = sos_Container::create();
   sos_Directory root_dir  = sos_Directory::root();
   sos_String    file_name = sos_String::create (cnt);
  
   file_name.assign_Cstring ("pretty file");

   UnixFile f1 = UnixFile::create (cnt, file_name);

   f1.set_size (100);

   ROOT_CONTAINER.open (WRITING,WAITING);
   root_dir.insert (file_name, f1);
   sos_Container_set modified;
   modified += ROOT_CONTAINER;
   modified += cnt;
   modified.close();

   cout << "Unixfile created and inserted in root directory";
   cout << "...\n";
   return 0;
}
  
