;;; read-string and supporting routines.  Reads input from an area on the
;;; screen of a specified length, allowing editing.
;;;
;;; Note: These are translated from VAX BASIC, poorly, and are probably
;;;       very fragile.  (I think they originate in some turbo pascal code.)
;;;
(require "scm_dir:smgdef.scm")


(define (read-string vd			;virtual display
		     kbd		;keyboard
		     s			;default data
		     l			;max length of field
		     row		;row on vd where field is
		     col		;column on vd where field is
		     term		;list of terminators
		     )
  ;; This key and anything after it are automatically terminators.
  (define START_AUTO_TERM 256)

  (define (delete_ s p l sl)
    (do ((i p (+ i 1)))
	((>= i (- sl 1)))
      (string-set! s i (if (>= (+ i l) sl) #\ (string-ref s (+ i l)))))
    (string-set! s (- sl 1) #\ ))

  (define (insert_ ch s p sl)
    (do ((i sl (- i 1)))
	((= i p))
      (string-set! s i (string-ref s (- i 1))))
    (string-set! s p (integer->char ch)))

  (let* ((sl (string-length s))
	 (p sl)
	 (s (let ((x (make-string l #\ )))
	      (do ((i 0 (+ i 1)))
		  ((>= i sl))
		(string-set! x i (string-ref s i)))
	      x)))
    (smg$put_chars vd (string-append (substring s 0 sl)
				 (make-string (- l sl) #\_))
	       row col)
    (smg$set_cursor_abs vd row (+ col p))
    (let loop ((ch (vector-ref (smg$read_keystroke kbd) 1)))
      (cond
       ((and (>= ch SMG$K_TRM_SPACE) (<= ch SMG$K_TRM_TILDE))
	(if (< p l)
	    (begin (if (= sl l)
		       (begin (delete_ s (- sl 1) 1 sl) (set! sl (- sl 1))))
		   (insert_ ch s p sl)
		   (set! sl (+ sl 1))
		   (set! p (+ p 1))
		   (smg$put_chars vd (substring s (- p 1) sl) row (+ col p -1))
		   )
	    (smg$ring_bell vd 1))	    
	)
       ((or (= ch SMG$K_TRM_LEFT) (= ch SMG$K_TRM_CTRLB))
	(if (> p 0)
	    (set! p (- p 1))
	    (smg$ring_bell vd 1))
	)
       ((or (= ch SMG$K_TRM_RIGHT) (= ch SMG$K_TRM_CTRLF))
	(if (< p sl)
	    (set! p (+ p 1))
	    (smg$ring_bell vd 1))
	)
       ((= ch SMG$K_TRM_CTRLH)
	(set! p 0)
	)
       ((= ch SMG$K_TRM_CTRLE)
	(set! p sl)
	)
       ((= ch SMG$K_TRM_CTRLD)
	(if (< p sl)
	    (begin (delete_ s p 1 sl)
		   (set! sl (- sl 1))
		   (smg$put_chars vd (string-append (substring s p sl)
						    "_")
				  row (+ col p)))
	    (smg$ring_bell vd 1))
	)
       ((= ch SMG$K_TRM_DELETE)
	(if (> p 0)
	    (begin (delete_ s (- p 1) 1 sl)
		   (set! sl (- sl 1))
;		   (newline) (display "put-chars") (display p) (display " ")
;		   (display sl)
		   (set! p (- p 1))
		   (smg$put_chars vd (string-append (substring s p sl) "_")
				  row (+ col p)))
	    (smg$ring_bell vd 1))
	)
       ((= ch SMG$K_TRM_CTRLR)
	(smg$put_chars vd (string-append (substring s 0 sl)
					 (make-string (- l sl) #\_))
		       row col)
	)
       ((= ch SMG$K_TRM_CTRLU)
	(if (> p 0)
	    (begin
	      (delete_ s 0 p sl)
	      (set! sl (- sl p))
	      (set! p 0)
	      (smg$put_chars vd (string-append (substring s 0 sl)
					       (make-string (- l sl) #\_))
			     row col))
	    (smg$ring_bell vd 1))
	)
       ((= ch SMG$K_TRM_CTRLK)
	(if (< p sl)
	    (begin
	      (delete_ s p (- sl p) sl)
	      (set! sl (- sl (- sl p)))
	      (smg$put_chars vd (string-append (substring s 0 sl)
					       (make-string (- l sl) #\_))
			     row col)
	      )
	    (smg$ring_bell vd 1))
	)
       (else
	(if (not (or (> ch START_AUTO_TERM)
		     (member ch term)))
	    (smg$ring_bell vd 1)))
      )
      (smg$set_cursor_abs vd row (+ col p))
      (if (and (or (>= ch START_AUTO_TERM)
		   (member ch term))
	       (not (member ch (list SMG$K_TRM_LEFT SMG$K_TRM_RIGHT))))
	  (cons (substring s 0 sl) ch)	;return something
	  (loop (vector-ref (smg$read_keystroke kbd) 1))))))
