;;; jpiexample.scm -- examples of how to call lib$getjpi from SCM.
;;;
;;; Note that this uses Continuation Passing Style versions of the
;;; SMG functions.  (That's what loading defforcps.scm and vmslib.si do.)

(require "scm_dir:jpidef.scm")
(require "scm_dir:defforcps.scm")
(require "scm_dir:vmslib.si")
(require "scm_dir:menu.scm")



;;; Various support variables.

(define item-codes
  (list JPI$_ASTACT JPI$_ASTEN JPI$_PRI JPI$_OWNER
	JPI$_UIC JPI$_STS JPI$_STATE JPI$_MEM JPI$_GRP JPI$_PRIB JPI$_APTCNT
	JPI$_TMBU JPI$_GPGCNT JPI$_PPGCNT JPI$_ASTCNT JPI$_BIOCNT JPI$_BIOLM
	JPI$_BYTCNT JPI$_DIOCNT JPI$_DIOLM JPI$_FILCNT JPI$_TQCNT JPI$_EFWM
	JPI$_EFCS JPI$_EFCU JPI$_PID JPI$_BYTLM JPI$_PRCCNT JPI$_PRCNAM
	JPI$_TERMINAL JPI$_JOBPRCCNT JPI$_ENQCNT JPI$_ENQLM JPI$_SWPFILLOC
	JPI$_MODE JPI$_JOBTYPE JPI$_PROC_INDEX JPI$_MASTER_PID JPI$_RIGHTSLIST
	JPI$_CPU_ID JPI$_STS2 JPI$_NODENAME JPI$_NODE_CSID JPI$_NODE_VERSION
	JPI$_TT_PHYDEVNAM JPI$_TT_ACCPORNAM JPI$_LASTPCB JPI$_CURPRIV
	JPI$_WSAUTH JPI$_WSQUOTA JPI$_DFWSCNT JPI$_FREP0VA JPI$_FREP1VA
	JPI$_DFPFC JPI$_CPUTIM JPI$_PRCLM JPI$_ASTLM JPI$_PAGEFLTS JPI$_DIRIO
	JPI$_BUFIO JPI$_CPULIM JPI$_PGFLQUOTA JPI$_FILLM JPI$_TQLM JPI$_WSSIZE
	JPI$_AUTHPRIV JPI$_IMAGPRIV JPI$_PAGFILCNT JPI$_FREPTECNT
	JPI$_WSEXTENT JPI$_WSAUTHEXT JPI$_AUTHPRI JPI$_PAGFILLOC
	JPI$_IMAGECOUNT JPI$_PHDFLAGS JPI$_LASTPHD JPI$_VIRTPEAK JPI$_WSPEAK
	JPI$_USERNAME JPI$_ACCOUNT JPI$_PROCPRIV JPI$_VOLUMES JPI$_LOGINTIM
	JPI$_IMAGNAME JPI$_SITESPEC JPI$_MSGMASK JPI$_CLINAME JPI$_TABLENAME
	JPI$_CREPRC_FLAGS JPI$_UAF_FLAGS JPI$_MAXDETACH JPI$_MAXJOBS
	JPI$_SHRFILLM JPI$_LASTCTL JPI$_EXCVEC JPI$_FINALEXC JPI$_LASTADR
	JPI$_LASTPCBFLD JPI$_LASTPHDFLD))


(define item-codes-vector
  (list->vector item-codes))


(define item-names-vector
  (vector "JPI$_ASTACT" "JPI$_ASTEN" "JPI$_PRI" "JPI$_OWNER"
	  "JPI$_UIC" "JPI$_STS" "JPI$_STATE" "JPI$_MEM" "JPI$_GRP"
	  "JPI$_PRIB" "JPI$_APTCNT" "JPI$_TMBU" "JPI$_GPGCNT"
	  "JPI$_PPGCNT" "JPI$_ASTCNT" "JPI$_BIOCNT" "JPI$_BIOLM"
	  "JPI$_BYTCNT" "JPI$_DIOCNT" "JPI$_DIOLM" "JPI$_FILCNT"
	  "JPI$_TQCNT" "JPI$_EFWM" "JPI$_EFCS" "JPI$_EFCU" "JPI$_PID"
	  "JPI$_BYTLM" "JPI$_PRCCNT" "JPI$_PRCNAM" "JPI$_TERMINAL"
	  "JPI$_JOBPRCCNT" "JPI$_ENQCNT" "JPI$_ENQLM" "JPI$_SWPFILLOC"
	  "JPI$_MODE" "JPI$_JOBTYPE" "JPI$_PROC_INDEX"
	  "JPI$_MASTER_PID" "JPI$_RIGHTSLIST" "JPI$_CPU_ID"
	  "JPI$_STS2" "JPI$_NODENAME" "JPI$_NODE_CSID"
	  "JPI$_NODE_VERSION" "JPI$_TT_PHYDEVNAM" "JPI$_TT_ACCPORNAM"
	  "JPI$_LASTPCB" "JPI$_CURPRIV" "JPI$_WSAUTH" "JPI$_WSQUOTA"
	  "JPI$_DFWSCNT" "JPI$_FREP0VA" "JPI$_FREP1VA" "JPI$_DFPFC"
	  "JPI$_CPUTIM" "JPI$_PRCLM" "JPI$_ASTLM" "JPI$_PAGEFLTS"
	  "JPI$_DIRIO" "JPI$_BUFIO" "JPI$_CPULIM" "JPI$_PGFLQUOTA"
	  "JPI$_FILLM" "JPI$_TQLM" "JPI$_WSSIZE" "JPI$_AUTHPRIV"
	  "JPI$_IMAGPRIV" "JPI$_PAGFILCNT" "JPI$_FREPTECNT"
	  "JPI$_WSEXTENT" "JPI$_WSAUTHEXT" "JPI$_AUTHPRI"
	  "JPI$_PAGFILLOC" "JPI$_IMAGECOUNT" "JPI$_PHDFLAGS"
	  "JPI$_LASTPHD" "JPI$_VIRTPEAK" "JPI$_WSPEAK" "JPI$_USERNAME"
	  "JPI$_ACCOUNT" "JPI$_PROCPRIV" "JPI$_VOLUMES"
	  "JPI$_LOGINTIM" "JPI$_IMAGNAME" "JPI$_SITESPEC"
	  "JPI$_MSGMASK" "JPI$_CLINAME" "JPI$_TABLENAME"
	  "JPI$_CREPRC_FLAGS" "JPI$_UAF_FLAGS" "JPI$_MAXDETACH"
	  "JPI$_MAXJOBS" "JPI$_SHRFILLM" "JPI$_LASTCTL" "JPI$_EXCVEC"
	  "JPI$_FINALEXC" "JPI$_LASTADR" "JPI$_LASTPCBFLD"
	  "JPI$_LASTPHDFLD"))


;;; The examples.

;; Get the authpriv of PID.
(define (jpi-ex1 . pid)
  (lib$getjpi list JPI$_AUTHPRIV (if (null? pid) 0 (car pid))))


;; get all the info we can about PID.
(define (jpi-ex2 . pid)
  (for-each (lambda (item-code)
	      (newline)
	      (display item-code)
	      (display " -> ")
	      (lib$getjpi (lambda objs (display objs))
			  item-code (if (null? pid) 0 (car pid))))
	    item-codes)
  (newline))


;; Of course, this only works if you run it from a suitably priveleged process.
;; (Why does LIB$GETJPI not give you all processes the current process
;; has privs to access when wildcarding???  That's what SYS$GETJPI does,
;; isn't it?)
(define (jpi-ex3)
  (define (do-it stat pid value string length)
    (cond ((odd? stat)
	   (display string) (newline)
	   (lib$getjpi do-it jpi$_pid pid))
	  (else
	   (display "stat: ") (display stat) (newline)
	   'done)))
  (lib$getjpi do-it jpi$_pid -1))


(define (jpi-ex4)
  (letrec ((wrapper
	    (lambda (pid)
	      (lib$getjpi helper JPI$_PID pid)))
	   (helper
	    (lambda (stat pid value string length)
	      (if (odd? stat)
		  (cons string (wrapper pid))
		  '()))))
    (wrapper -1)))


(define (jpi-ex5)
  (let* ((pids-and-usernames (jpi-ex5-helper))
	 (pids (list->vector (map car pids-and-usernames)))
	 (choices (list->vector (map (lambda (obj)
				       (string-append (car obj)
						      " "
						      (cadr obj)))
				     pids-and-usernames))))
    (let ((pbd (vector-ref (smg$create_pasteboard) 1))
	  (kbd (vector-ref (smg$create_virtual_keyboard) 1))
	  (dpy (vector-ref (smg$create_virtual_display 21 78 SMG$M_BORDER) 1)))

      (smg$paste_virtual_display dpy pbd 2 2)
      (do ((result (menu choices pbd kbd 15 70 3 3 0 " Pids ")
		   (menu choices pbd kbd 15 70 3 3 result " Pids ")))
	  ((not result) #f)
	(smg$put_chars dpy
		       (string-append
			"username: "
			(lib$getjpi
			 (lambda (stat pid value string len) string)
			 JPI$_USERNAME
			 (string->number (vector-ref pids result) 16)))
		       1 1 SMG$M_ERASE_TO_EOL)
	(smg$put_chars dpy
		       (string-append
			"privs: "
			(lib$getjpi
			 (lambda (stat pid value string len) string)
			 JPI$_CURPRIV
			 (string->number (vector-ref pids result) 16)))
		       2 1 SMG$M_ERASE_TO_EOL)
	(smg$put_chars dpy "Press any key to continue." 20 1
		       SMG$M_ERASE_TO_EOL)
	(smg$read_keystroke kbd)
	(smg$erase_line dpy 20 1)
	(pid-to-info pbd kbd dpy (string->number (vector-ref pids result) 16))
	(smg$erase_display dpy))
      (smg$set_physical_cursor pbd 24 1)
      (smg$delete_pasteboard pbd 0)
      (smg$delete_virtual_keyboard kbd))))


(define (jpi-ex5-helper)
  (letrec ((wrapper
	    (lambda (pid)
	      (lib$getjpi helper JPI$_PID pid)))
	   (helper
	    (lambda (stat pid value string length)
	      (if (odd? stat)
		  (cons (list string
			      (lib$getjpi
			       (lambda (stat pid value string . rest)
				 string)
			       JPI$_USERNAME
			       (string->number string 16)))
			(wrapper pid))
		  '()))))
    (wrapper -1)))



(define (pid-to-info pbd kbd dpy . pid)
  (do ((item (menu item-names-vector pbd kbd 15 70 3 3 0 "Item Codes")
	     (menu item-names-vector pbd kbd 15 70 3 3 item "Item Codes")))
      ((not item) #f)
    (smg$put_chars dpy 
		   (lib$getjpi
		    (lambda (stat pid value string length)
		      (string-append "stat: " (number->string stat)
				     " pid: " (number->string pid)
				     " val: " (number->string
					       (vector-ref value 0))
				     " " (number->string (vector-ref value 1))
				     " str: " string))
		    (vector-ref item-codes-vector item)
		    (if (null? pid) 0 (car pid)))
		   3 1 SMG$M_ERASE_TO_EOL)
    (smg$put_chars dpy "Press any key to continue." 20 1
		   SMG$M_ERASE_TO_EOL)
    (smg$read_keystroke kbd)
    (smg$erase_line dpy 20 1)))
