/*
 * Epoch 4.0 display code - Abstract redisplay code.
 *
 * $Revision: 1.22 $
 * $Source: /import/kaplan/stable/distrib/epoch-4.0/src/RCS/dispepoch.c,v $
 * $Date: 91/09/27 10:58:14 $
 * $Author: love $
 */

/* #define CURSOR_DEBUG */

#ifndef LINT
static char rcsid[] = "$Author: love $ $Date: 91/09/27 10:58:14 $ $Source: /import/kaplan/stable/distrib/epoch-4.0/src/RCS/dispepoch.c,v $ $Revision: 1.22 $";
#endif

#include <signal.h>

#include "config.h"
#include <stdio.h>

#ifdef HAVE_TIMEVAL
#ifdef HPUX
#include <time.h>
#else
#include <sys/time.h>
#endif
#endif

#ifdef HAVE_TERMIO
#include <termio.h>
#ifdef TCOUTQ
#undef TIOCOUTQ
#define TIOCOUTQ TCOUTQ
#include <fcntl.h>
#endif /* TCOUTQ defined */
#else
#ifndef VMS
#include <sys/ioctl.h>
#endif /* not VMS */
#endif /* not HAVE_TERMIO */

/* Allow m- file to inhibit use of FIONREAD.  */
#ifdef BROKEN_FIONREAD
#undef FIONREAD
#endif

/* We are unable to use interrupts if FIONREAD is not available,
   so flush SIGIO so we won't try. */
#ifndef FIONREAD
#ifdef SIGIO
#undef SIGIO
#endif
#endif

#undef NULL

#include "termchar.h"
#include "termopts.h"
#include "cm.h"
#include "lisp.h"
#include "buffer.h"
#include "window.h"
#include "commands.h"

#include "dispepoch.h"		/* Epoch */
#include "screen.h"		/* Epoch */
#include "screenW.h"		/* Epoch */
#include "button.h"		/* Epoch */

#define max(a, b) ((a) > (b) ? (a) : (b))
#define min(a, b) ((a) < (b) ? (a) : (b))

#ifndef PENDING_OUTPUT_COUNT
/* Get number of chars of output now in the buffer of a stdio stream.
 * This ought to be built into stdio, but it isn't.
 * Some s- files overide this */
#ifdef __GNU_LIBRARY__
#define	PENDING_OUTPUT_COUNT(FILE) ((FILE)->__bp - (FILE)->__buf)
#else
#define PENDING_OUTPUT_COUNT(FILE) ((FILE)->_ptr - (FILE)->_base)
#endif
#endif /* No PENDING_OUTPUT_COUNT */

/* Nonzero means do not assume anything about current
   contents of actual terminal screen */

int screen_garbaged;

/* Nonzero means last display completed and cursor is really at
   WS->cursor_x, WS->cursor_y.  Zero means it was preempted. */

int display_completed;

int inverse_video;

int visible_bell;

int baud_rate;

/* nil or a symbol naming the window system
   under which emacs is running
   ('x is the only current possibility).  */

Lisp_Object Vwindow_system;

/* Version number of window system, or nil if no window system.  */

Lisp_Object Vwindow_system_version;

/* Nonzero means reading single-character input with prompt
   so put cursor on minibuffer after the prompt.  */

int cursor_in_echo_area;


/* Stdio stream being used for copy of all terminal output.  */

FILE *termscript;

/* Structure for info on cursor positioning */

struct cm Wcm;

int in_display;		/* 1 if in redisplay: can't handle SIGWINCH now.  */

/* This buffer records the history of display preemption.  */

struct preempt
{
  /* Number of keyboard characters read so far at preempt.  */
  int keyboard_char_count;
  /* Vertical position at which preemption occurred.  */
  int vpos;
};

#define N_PREEMPTIONS 50

/* Circular buffer recording recent display preemptions.  */
struct preempt preemptions[N_PREEMPTIONS];

/* Index of next element in preemptions.  */
int preemption_index;

/* Set these variables in the debugger to force a display preemption.  */
int debug_preemption_vpos = -1;
int debug_preemption_char_count = -1;

int display_completed;

extern int distinct_minibuffer;
extern int screen_changed;

extern struct X_font fake_font;

extern short text_width();

extern struct Root_Block *cur_root;
extern struct Root_Block *mini_root;
extern struct Root_Block *root;

extern struct redisplay_block display_list[300];
extern int list_ptr;

/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
/* Replot an Emacs window in its screen.  This will also fly for minibuffer
 * window.
 */
void
update_window(w)
     struct window *w;
{
  struct Root_Block *rb = XROOT(w->root);
  WS_DEF;
  struct line_header *l,*start,*end;
  struct char_block *cb,*endc;
  int i = 0;

  if (scroll_region_ok)
    {
      /* Running under X.  We want to find any lines which have been
       * marked "shifted"
       */
      for (i = 0; i <= list_ptr; i++)
	if (BLOCK_TYPE(i) == LINE &&
	    BLOCK_LINE(i)->shifted && !BLOCK_LINE(i)->changed) break;
      if (i < list_ptr)
	{
	  /* Found start, now find end of region */
	  start = BLOCK_LINE(i);
	  BLOCK_DONE(i) = 1;	/* Mark line as done */
	  for (; i <= list_ptr; i++)
	    {
	      if (BLOCK_TYPE(i) != LINE ||
		  BLOCK_LINE(i)->changed)
		break;
	      end = BLOCK_LINE(i);
	      BLOCK_DONE(i) = 1; /* Mark line as done */
	    }
	  shift_region(w,start,end);
	}
    }
  i = 0;

  while (i <= list_ptr)
    {
      if (!BLOCK_DONE(i))
	switch (BLOCK_TYPE(i))
	  {
	  case LINE:		/* A regular line */
	    l = BLOCK_LINE(i);
	    cb = BLOCK_LINE_START(i);
	    endc = BLOCK_LINE_END(i);
	    update_line(w,l,cb,endc);	
	    l->new = l->changed = l->shifted = 0; /* Line is up to date */
	    break;
	  case AREA:		/* Region to blank */
	    clear_window_end(w,BLOCK_AREA_TOP(i),BLOCK_AREA_BOTTOM(i));
	    break;
	  default:
	    break;
	  }
      i++;
    }
  list_ptr = -1;
  display_completed = 1;
  bzero(display_list,300*sizeof(struct redisplay_block));
}
/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
/* Clean up at end of redisplay for screen.
 */
update_cursor(rb)
     struct Root_Block *rb;
{
  WS_DEF;

  /* We haven't called update_end(), so InUpdate = 1, and move_cursor
   * will simply plot cursor in new position.
   */
  if (cursor_in_echo_area < 0)
    {
      /* Put cursor in */
      ws->new_cur_char = ws->new_cur_line->body;
      ws->cursor_x = 0;
      move_cursor(ws->new_cur_line,
		  ws->new_cur_char,
		  ws->cursor_y,
		  ws->cursor_x,
		  ws->new_cur_w,rb);
    }
  else if (cursor_in_echo_area)
    {
      /* Put cursor */
      ws->new_cur_char = ws->new_cur_line->end;
      ws->cursor_x = ws->new_cur_line->chars;
      move_cursor(ws->new_cur_line,
		  ws->new_cur_char,
		  ws->cursor_y,
		  ws->cursor_x,
		  ws->new_cur_w,rb);
    }
  else if (ws->new_cur_line != ws->cur_line ||
	   ws->new_cur_char != ws->cur_char)
    {
      move_cursor(ws->new_cur_line,
		  ws->new_cur_char,
		  ws->cursor_y,
		  ws->cursor_x,
		  ws->new_cur_w,rb);
    }
#ifdef CURSOR_DEBUG
  if (rb != mini_root)
    {
      fprintf(stderr,"Cursor at %d,%d (%c)\tPreviously at %d,%d (%c)\n",
	      ws->cursor_x,ws->cursor_y,ws->new_cur_char->ch,
	      ws->vis_xpos,ws->vis_ypos,ws->cur_char->ch);      
    }
#endif
  update_end();
}

/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
/* Handle forward and backward cursor movement on current line
 */
int 
output_forward_char(n)
     int n;
{
  register struct window *w = XWINDOW(selected_window);
  struct Root_Block *rb = XROOT(w->root);
  struct W_Screen *ws = XWSCREEN(rb->win);
  struct char_block *cb,*cb1;
  int i = ws->cursor_y;

  if ((n < 0 && ws->cur_char == ws->cur_line->body) ||
      (n > 0 && ws->cur_char == ws->cur_line->end) ||
      (ws->vis_xpos > ws->cur_line->chars) ||
      w->hscroll > 0)
    return 0;			/* Silently fail at window edges */
    
  /* Set new cursor position.  Moving cursor will set this equal to the
   * prev position.
   */
  ws->cursor_x += n;
  ws->new_cur_line = ws->cur_line;
  ws->new_cur_char = (n > 0) ? ws->cur_char->next : ws->cur_char->prev;
  ws->new_cur_w = w;

  XFASTINT(w->last_point_x) = ws->cursor_x;
  XFASTINT(w->last_point) = point;  

  move_cursor(ws->new_cur_line,ws->new_cur_char,
	      ws->cursor_y,ws->cursor_x,ws->new_cur_w,rb);
  
  if (inhibit_window_system)
    fflush(stdout);
  return 1;

}
/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
/* Handle insertion of a character at 'cur_line,cur_char'
 * Assume that redisplay() is atomic for each screen and won't be preempted.
 * If much is waiting (i.e. fast typing), caller (command_loop_1()) will call
 * something with remaining chars.
 */
int
output_for_insert(c)
     int c;
{
  register struct window *w = XWINDOW(selected_window);
  struct Root_Block *rb = XROOT(w->root);
  register struct W_Screen *ws = XWSCREEN(rb->win);
  register struct line_header *l = ws->cur_line;
  register struct char_block *new,*cb = ws->cur_char,*prev;
  register struct buffer *b = current_buffer;
  char a[1];			/* CRUDE */
  int pixright;
  Lisp_Object ob;
  struct X_font *font;

  if (
      /* Selected window is minibuffer & msg is displayed */
      (EQ(selected_window,minibuf_window) && echo_area_contents) ||
      (w->hscroll > 0) || 
      (cb == l->body) ||
      ws->cursor_y < 0 ||
      ws->cursor_y > window_char_height(w) ||
      !display_completed ||
      buffer_shared > 1      
      )
      return 0;			/* Silently fail in these cases */

  new = get_block();
  new->ch = a[0] = c;
  ob = get_button(current_buffer,point,0,0,0);
  new->style = ws->cursor_x > 0 ? cb->style :
    NULL(ob) ? 0 : XSTYLE(ob);

  if (!NULL(ob) && (XTYPE(XSTYLE(ob)->font) == Lisp_Raw_Data))
    font = XXFONT(new->style->font);
  else
    font = XXFONT(STYLE_FIELD(w,font,stylenorm));
  new->new = 1;			/* Flag -> this is new */
  new->width = text_width(font->x_font,a,1);
  new->xpos = cb->xpos;
  
  a[0] = '\\';
  pixright = XFASTINT(w->pixleft) + XFASTINT(w->pixwidth) -
    text_width(font->x_font,a,1);
    
  if ((l->lwidth + new->width) >= (pixright) ||
      font->ascent > l->ascent ||
      font->descent > l->descent)
    {
      /* Fail here if we are going to go over the edge of this window, or
       * the new character's font is a different height than the line's
       * ascent or descent.
       */
      l->changed = 1;
      free_blocks(new,new);
      return 0;
    }
  
  /* Link it into the line */
  new->prev = cb->prev;
  new->prev->next = new;

  new->next = cb;
  cb->prev = new;

  /* Adjust attributes for rest of line */
  prev = new;
  while (cb)
    {
      cb->xpos = prev->xpos + prev->width;
      prev = cb;
      cb = cb->next;
    }
  
  l->lwidth += new->width;
  l->chars++;
  
  if (inhibit_window_system)
    {
      fflush(stdout);
    }
  else
    {
      update_line(w,l,new,0);
      ws->cursor_x += 1;
      move_cursor(ws->new_cur_line,ws->new_cur_char,
		  ws->cursor_y,ws->cursor_x,ws->new_cur_w,rb);

#ifdef CURSOR_DEBUG      
      if (rb != mini_root)
	{
	  fprintf(stderr,"Cursor at %d,%d (%c)\tPreviously at %d,%d (%c)\n",
		  ws->cursor_x,ws->cursor_y,ws->new_cur_char->ch,
		  ws->vis_xpos,ws->vis_ypos,ws->cur_char->ch);
	}
#endif      
    }

  return 1;
}
/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
/* Change screen height and/or width.  Note that new height and width are
 * now in pixels.  ASCII behaviour should be unchanged.
 */
change_screen_size(height,width,pretend,rb)
     register int height,width,pretend;
     struct Root_Block *rb;
{
  WS_DEF;
  extern int gc_in_progress;
  
  if (in_display || gc_in_progress)
    {
      ws->size_change_pending = 1;
      ws->new_width = width;
      ws->new_height = height;
      return;
    }

  ws->size_change_pending  = 0;
  change_screen_size_1(height,width,pretend,rb);
}

change_screen_size_1(height,width,pretend,rb)
     register int height,width,pretend;
     struct Root_Block *rb;
{
  WS_DEF;

  if ((height == 0 || height == ws->pixh) &&
      (width == 0 || width == ws->pixw))
    {
      ws->size_change = 0;	/* Blow off */
      return 1;
    }

  RW_FIXUP(rb);

  if (height && height != ws->pixh)
    {
      if (height > MScreenLength) height = MScreenLength;
      ws->height = height / XFHEIGHT(XXFONT(XSTYLE(rb->stylenorm)->font));
      ws->pixh = height;
      if (distinct_minibuffer)
	set_window_height(rb->ewin,height,1);
      else
	{
	  /* Fudge around screen's minibuffer */
	  height -= XWINDOW(rb->minibuf_window)->pixheight;
	  XWINDOW(rb->minibuf_window)->pixtop = ws->in_border + height;
	  set_window_height(rb->ewin,height,1);
	}
    }
  if (width && width != ws->pixw)
    {
      if (width > MScreenWidth) width = MScreenWidth;
      ws->pixw = width;
      set_window_width(rb->ewin,width,1);
      if (!distinct_minibuffer)
	set_window_width(rb->minibuf_window,width,1);
      ws->width = width / XFWIDTH(XXFONT(XSTYLE(rb->stylenorm)->font));
    }
  rb->needs_update = Qt;
  screen_changed++;
  ws->size_change = 0;
  if (pretend > -1) redisplay_preserve_echo_area();
    
  return 1;
}
	

#ifdef SIGWINCH
window_change_signal ()
{
  int width, height;
  extern int errno;
  int old_errno = errno;

  get_screen_size (&width, &height);
  /* Record the new size, but don't reallocate the data structures now.
     Let that be done later outside of the signal handler.  */
  in_display++;
  change_screen_size (height, width, 0,cur_root);
  in_display--;
  signal (SIGWINCH, window_change_signal);

  errno = old_errno;
}
#endif /* SIGWINCH */
/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
/* Initialization done when Emacs fork is started, before doing stty.
 * Determine terminal type and set terminal_driver
 * Then invoke its decoding routine to set up variables
 * in the terminal package
 */
char *terminal_type;

init_display ()
{
  
  Lisp_Object style;  
#ifdef HAVE_X_WINDOWS
  extern Lisp_Object Vxterm;
  Vxterm = Qnil;
#endif
  
  Vwindow_system = Qnil;
  meta_key = 0;
  inverse_video = 0;
  cursor_in_echo_area = 0;
  terminal_type = (char *) 0;


  if (!inhibit_window_system)
    {
#ifdef HAVE_X_WINDOWS
      extern char *XD_display_name;
      char *disp = (char *) egetenv ("DISPLAY");

      /* Note KSH likes to provide an empty string as an envvar value.  */
      if (XD_display_name || (disp && *disp))
	{
#if OLD
	  distinct_minibuffer = 1; /* Default? */

	  distinct_minibuffer = 0;
#endif	  
	  x_term_init ();
	  Vxterm = Qt;
	  Vwindow_system = intern ("x");
	  Vwindow_system_version = make_number (11);
	  goto term_init_done;
	}
#endif /* HAVE_X_WINDOWS */
      ;
    }
  /* Record we aren't using a window system.  */
  inhibit_window_system = 1;
  distinct_minibuffer = 0;	/* Epoch */
  x_init_roots();		/* Set up root block appropriately */

  /* Look at the TERM variable */
  terminal_type = (char *) getenv ("TERM");
  if (!terminal_type)
    {
#ifdef VMS
      fprintf (stderr, "Please specify your terminal type.\n\
For types defined in VMS, use  set term /device=TYPE.\n\
For types not defined in VMS, use  define emacs_term \"TYPE\".\n\
\(The quotation marks are necessary since terminal types are lower case.)\n");
#else
      fprintf (stderr, "Please set the environment variable TERM; see tset(1).\n");
#endif
      exit (1);
    }
  term_init (terminal_type);
  /* Fake a 1 x 1 pixel font. */
  fake_font.x_font = 0;
  fake_font.ascent = 1;
  fake_font.descent = 0;
  fake_font.width = 1;
  /* fake an _ x _ pixel screen = char geometry */
  style = Fepoch_make_style();
  XSET(cur_root->stylenorm,Lisp_Style,style);
  XSET(XSTYLE(style)->font,Lisp_Raw_Data,&fake_font);

  cur_Wscreen->in_border = 1;
  cur_Wscreen->pixw = cur_Wscreen->width;
  cur_Wscreen->pixh = cur_Wscreen->height;
  /* Set hook for finding text widths */

 term_init_done:
  ;

/* if (distinct_minibuffer) */

#ifdef SIGWINCH
#ifndef CANNOT_DUMP
  if (initialized)
#endif /* CANNOT_DUMP */
    if (inhibit_window_system)
      signal (SIGWINCH, window_change_signal);
#endif /* SIGWINCH */
}

DEFUN ("open-termscript", Fopen_termscript, Sopen_termscript,
  1, 1, "FOpen termscript file: ",
  "Start writing all terminal output to FILE as well as the terminal.\n\
FILE = nil means just close any termscript file currently open.")
  (file) Lisp_Object file;
{
  if (termscript != 0) fclose (termscript);
  termscript = 0;

  if (! NULL (file))
    {
      file = Fexpand_file_name (file, Qnil);
      termscript = fopen (XSTRING (file)->data, "w");
      if (termscript == 0)
	report_file_error ("Opening termscript", Fcons (file, Qnil));
    }
  return Qnil;
}

DEFUN ("baud-rate", Fbaud_rate, Sbaud_rate, 0, 0, 0,
  "Return the output baud rate of the terminal.")
  ()
{
  Lisp_Object temp;
  XSET (temp, Lisp_Int, baud_rate);
  return temp;
}

DEFUN ("send-string-to-terminal", Fsend_string_to_terminal,
  Ssend_string_to_terminal, 1, 1, 0,
  "Send STRING to the terminal without alteration.\n\
Control characters in STRING will have terminal-dependent effects.")
  (str)
     Lisp_Object str;
{
  CHECK_STRING (str, 0);
  fwrite (XSTRING (str)->data, 1, XSTRING (str)->size, stdout);
  fflush (stdout);
  if (termscript)
    {
      fwrite (XSTRING (str)->data, 1, XSTRING (str)->size, termscript);
      fflush (termscript);
    }
  return Qnil;
}

void Ding ()
{
  if (noninteractive)
    putchar (07);
  else if (noninteractive)  /* Stop executing a keyboard macro. */
    error ("Keyboard macro terminated by a command ringing the bell");
  else
    ring_bell ();
  fflush (stdout);
}

DEFUN ("ding", Fding, Sding, 0, 1, 0,
  "Beep, or flash the screen.\n\
Terminates any keyboard macro currently executing unless an argument\n\
is given.")
  (arg)
  Lisp_Object arg;
{
  if (!NULL (arg))
    {
      bell ();
      fflush (stdout);
    }
  else
    bell ();
  return Qnil;
}

bell ()
{
  if (noninteractive)
    putchar (07);
  else if (!FROM_KBD)  /* Stop executing a keyboard macro. */
    error ("Keyboard macro terminated by a command ringing the bell");
  else
    ring_bell ();
  fflush (stdout);
}

DEFUN ("sleep-for", Fsleep_for, Ssleep_for, 1, 1, 0,
  "Pause, without updating display, for ARG seconds.")
  (n)
     Lisp_Object n;
{
  register int t;
#ifndef subprocesses
#ifdef HAVE_TIMEVAL
  struct timeval timeout, end_time, garbage1;
#endif /* HAVE_TIMEVAL */
#endif /* no subprocesses */

  CHECK_NUMBER (n, 0);
  t = XINT (n);
  if (t <= 0)
    return Qnil;

#ifdef subprocesses
  wait_reading_process_input (t, 0, 0);
#else /* No subprocesses */
  immediate_quit = 1;
  QUIT;

#ifdef VMS
  sys_sleep (t);
#else /* not VMS */
/* The reason this is done this way 
    (rather than defined (H_S) && defined (H_T))
   is because the VMS preprocessor doesn't grok `defined' */
#ifdef HAVE_SELECT
#ifdef HAVE_TIMEVAL
  gettimeofday (&end_time, &garbage1);
  end_time.tv_sec += t;

  while (1)
    {
      gettimeofday (&timeout, &garbage1);
      timeout.tv_sec = end_time.tv_sec - timeout.tv_sec;
      timeout.tv_usec = end_time.tv_usec - timeout.tv_usec;
      if (timeout.tv_usec < 0)
	timeout.tv_usec += 1000000,
      timeout.tv_sec--;
      if (timeout.tv_sec < 0)
	break;
      if (!select (1, 0, 0, 0, &timeout))
	break;
    }
#else /* not HAVE_TIMEVAL */
  /* Is it safe to quit out of `sleep'?  I'm afraid to trust it.  */
  sleep (t);
#endif /* HAVE_TIMEVAL */
#else /* not HAVE_SELECT */
  sleep (t);
#endif /* HAVE_SELECT */
#endif /* not VMS */
  
  immediate_quit = 0;
#endif /* no subprocesses */
  return Qnil;
}

DEFUN ("sit-for", Fsit_for, Ssit_for, 1, 2, 0,
  "Perform redisplay, then wait for ARG seconds or until input is available.\n\
Optional second arg non-nil means don't redisplay.\n\
Redisplay is preempted as always if input arrives, and does not happen\n\
if input is available before it starts.\n\
Value is t if waited the full time with no input arriving.")
  (n, nodisp)
     Lisp_Object n, nodisp;
{
#ifndef subprocesses
#ifdef HAVE_TIMEVAL
  struct timeval timeout;
#else
  int timeout_sec;
#endif
  int waitchannels;
#endif /* no subprocesses */

  CHECK_NUMBER (n, 0);

  Fepoch_dispatch_events();	/* Clear out event keys */

  if (detect_input_pending ())
    return Qnil;

  if (EQ (nodisp, Qnil))
    redisplay_preserve_echo_area ();
  if (XINT (n) > 0)
    {
#ifdef subprocesses
#ifdef SIGIO
      gobble_input ();
#endif				/* SIGIO */
      {
	long start_time = time(0);
	long wait_time = (long) XINT(n);
	extern int kbd_count;

	do
	  {
	    wait_reading_process_input (wait_time, 1, 1);
	    detect_input_pending();
	    Fepoch_dispatch_events();
	    wait_time -= time(0) - start_time;
	  }
	while (wait_time > 0 && kbd_count == 0);
      }
#else				/* no subprocesses */
      immediate_quit = 1;
      QUIT;

      waitchannels = 1;
#ifdef VMS
      input_wait_timeout (XINT (n));
#else				/* not VMS */
#ifndef HAVE_TIMEVAL
      timeout_sec = XINT (n);
      select (1, &waitchannels, 0, 0, &timeout_sec);
#else				/* HAVE_TIMEVAL */
      timeout.tv_sec = XINT (n);  
      timeout.tv_usec = 0;
      select (1, &waitchannels, 0, 0, &timeout);
#endif				/* HAVE_TIMEVAL */
#endif				/* not VMS */

      immediate_quit = 0;
#endif				/* no subprocesses */
    }
  return detect_input_pending () ? Qnil : Qt;
}  



syms_of_display ()
{
  defsubr (&Sopen_termscript);
  defsubr (&Sding);
  defsubr (&Ssit_for);
  defsubr (&Ssleep_for);
  defsubr (&Sbaud_rate);
  defsubr (&Ssend_string_to_terminal);

  DEFVAR_BOOL ("inverse-video", &inverse_video,
    "*Non-nil means use inverse-video.");
  DEFVAR_BOOL ("visible-bell", &visible_bell,
    "*Non-nil means try to flash the screen to represent a bell.");
  DEFVAR_BOOL ("no-redraw-on-reenter", &no_redraw_on_reenter,
    "*Non-nil means no need to redraw entire screen after suspending.\n\
It is up to you to set this variable to inform Emacs.");
  DEFVAR_LISP ("window-system", &Vwindow_system,
    "A symbol naming the window-system under which Emacs is running,\n\
\(such as `x'), or nil if emacs is running on an ordinary terminal.");
  DEFVAR_LISP ("window-system-version", &Vwindow_system_version,
    "Version number of the window system Emacs is running under.");
  DEFVAR_BOOL ("cursor-in-echo-area", &cursor_in_echo_area,
    "Non-nil means put cursor in minibuffer after any message displayed there.");

  /* Initialize `window-system', unless init_display already decided it.  */
#ifdef CANNOT_DUMP
  if (noninteractive)
#endif
    {
      Vwindow_system_version = Qnil;
      Vwindow_system = Qnil;
    }
}
