;;; Copyright (C) 1990  Christopher J. Love
;;;
;;; This file is for use with Epoch, a modified version of GNU Emacs.
;;; Requires Epoch 3.2 or later.
;;;
;;; This code is distributed in the hope that it will be useful,
;;; bute WITHOUT ANY WARRANTY. No author or distributor accepts
;;; responsibility to anyone for the consequences of using this code
;;; or for whether it serves any particular purpose or works at all,
;;; unless explicitly stated in a written agreement.
;;;
;;; Everyone is granted permission to copy, modify and redistribute
;;; this code, but only under the conditions described in the
;;; GNU Emacs General Public License, except the original author nor his
;;; agents are bound by the License in their use of this code.
;;; (These special rights for the author in no way restrict the rights of
;;;  others given in the License or this prologue)
;;; A copy of this license is supposed to have been given to you along
;;; with Epoch so you can know your rights and responsibilities. 
;;; It should be in a file named COPYING.  Among other things, the
;;; copyright notice and this notice must be preserved on all copies. 
;;;

;;
;; emenu.el - This is an example Epoch application using the menu package.
;;	      
;;	    
;;
(require 'menu)

;;
;; Global alist of menu options and their actions (s-expressions passed to
;; eval)
;;
(defvar menu::options nil
  "Alist of menu options and their elisp commands"
)

;;
;; Ctrl Mouse-right will call a popup menu
;;
(global-set-mouse mouse-right mouse-control-up 'menu::pop)
(global-set-mouse mouse-left mouse-control
  (function (lambda (marg)
      (epoch::ungrab-pointer)
      (menu::pop marg)
)))
;;
;; Mouse handler function for calling Epoch root menu
;;
(defun menu::pop (arg)
  (menu::popup epoch::root)
  (if (not (eq menu::selection 0))
    (eval (cdr (assoc menu::selection menu::options)))
  )
)
  
;;
;; ---------------------------------------------------------------------------
;; Install an Epoch root menu:
(defvar epoch::root nil
  "Root popup menu for Epoch"
)

(setq epoch::root
  (list "Main Menu"
    (list '() "Find File..."
      (list "Find File"
	(list 'ff1 "Find file")
	(list 'ff2 "Find file other screen")
      )
    )
    (list '() "Buffers..."
      (list "Buffer"
	(list 'bf1 "Switch to buffer")
	(list 'bf2 "Switch to buffer other screen")
      )
    )
    (list '() "Screens..."
      (list "Screens"
	(list 'sc3 "Iconify Screen")
	(list 'sc1 "Create Screen")
	(list 'sc2 "Delete Screen (Current)")
      )
    )
    (list '() "News..."
      (list "News"
	(list 'news1 "Read News (GNUS)")
	(list 'news2 "Post News (GNUS)")
      )
    )
    (list '() "Mail..."
      (list "Mail"
	(list 'mail1 "Read Mail (MH)")
	(list 'mail2 "Send Mail (MH)")
      )
    )
    (list 'exit "Exit Epoch")
  )
)

(setq menu::options
  (list
    '(ff1 call-interactively 'find-file)
    '(ff2 call-interactively 'find-file-other-screen)
    '(bf1 call-interactively 'switch-to-buffer)
    '(bf2 call-interactively 'find-buffer-other-screen)
    '(sc1 create-screen)
    '(sc3 iconify-screen)
    '(sc2 delete-screen)
    '(news1 gnus)
    '(news2 gnus-post-news)
    '(mail1 mh-set-up)
    '(mail2 mh-send)
    '(exit my-exit-from-emacs)
  )
)
