/*
   This file is part of TALER
   Copyright (C) 2025 Taler Systems SA

   TALER is free software; you can redistribute it and/or modify it under the
   terms of the GNU General Public License as published by the Free Software
   Foundation; either version 3, or (at your option) any later version.

   TALER is distributed in the hope that it will be useful, but WITHOUT ANY
   WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
   A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

   You should have received a copy of the GNU General Public License along with
   TALER; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */
/**
 * @file backenddb/pg_update_mfa_challenge.h
 * @brief implementation of the update_mfa_challenge function for Postgres
 * @author Christian Grothoff
 */
#ifndef PG_UPDATE_MFA_CHALLENGE_H
#define PG_UPDATE_MFA_CHALLENGE_H

#include <taler/taler_util.h>
#include <taler/taler_json_lib.h>
#include "taler_merchantdb_plugin.h"


/**
 * Update the state of an MFA challenge as we have now
 * retransmitted the challenge code.
 *
 * @param cls closure
 * @param challenge_id challenge ID to be solved
 * @param code new challenge code
 * @param retry_counter number of attempts that remain
 *             for solving the challenge
 * @param expiration_date when should the challenge expire
 * @param retransmission_date set to when a fresh challenge
 *             may be transmitted next
 * @return database result code
 */
enum GNUNET_DB_QueryStatus
TMH_PG_update_mfa_challenge (
  void *cls,
  uint64_t challenge_id,
  const char *code,
  uint32_t retry_counter,
  struct GNUNET_TIME_Absolute expiration_date,
  struct GNUNET_TIME_Absolute retransmission_date);


#endif
