/*
 This file is part of GNU Taler
 (C) 2025 Taler Systems S.A.

 GNU Taler is free software; you can redistribute it and/or modify it under the
 terms of the GNU Affero Public License as published by the Free Software
 Foundation; either version 3, or (at your option) any later version.

 GNU Taler is distributed in the hope that it will be useful, but WITHOUT ANY
 WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 A PARTICULAR PURPOSE.  See the GNU Affero Public License for more details.

 You should have received a copy of the GNU Affero Public License along with
 GNU Taler; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */

import { format } from "date-fns";
import {
  DoubleColumnFormDesign,
  InternationalizationAPI,
} from "../../index.browser.js";
import { TalerFormAttributes } from "@gnu-taler/taler-util";

/**
 * Design of the generic upload form.
 */
export function form_generic_upload(
  i18n: InternationalizationAPI,
  context: {
    REQUESTED_FILE_TITLE: string;
    REQUESTED_FILE_DESCRIPTION: string;
  },
): DoubleColumnFormDesign {
  const today = format(new Date(), "yyyy-MM-dd");

  return {
    type: "double-column",
    sections: [
      {
        title: i18n.str`Document upload (${context.REQUESTED_FILE_TITLE})`,
        description: i18n.str`${context.REQUESTED_FILE_DESCRIPTION}`,
        fields: [
          {
            id: TalerFormAttributes.FILE,
            label: i18n.str`File (PDF)`,
            type: "file",
            accept: "application/pdf",
            required: false,
          },
          {
            id: TalerFormAttributes.NOTE_TEXT,
            label: i18n.str`Free-form message`,
            type: "textArea",
            required: false,
          },
        ],
      },
    ],
  };
}
