/* A Bison parser, made by GNU Bison 3.7.5.  */

/* Bison implementation for Yacc-like parsers in C

   Copyright (C) 1984, 1989-1990, 2000-2015, 2018-2021 Free Software Foundation,
   Inc.

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.  */

/* As a special exception, you may create a larger work that contains
   part or all of the Bison parser skeleton and distribute that work
   under terms of your choice, so long as that work isn't itself a
   parser generator using the skeleton or a modified version thereof
   as a parser skeleton.  Alternatively, if you modify or redistribute
   the parser skeleton itself, you may (at your option) remove this
   special exception, which will cause the skeleton and the resulting
   Bison output files to be licensed under the GNU General Public
   License without this special exception.

   This special exception was added by the Free Software Foundation in
   version 2.2 of Bison.  */

/* C LALR(1) parser skeleton written by Richard Stallman, by
   simplifying the original so-called "semantic" parser.  */

/* DO NOT RELY ON FEATURES THAT ARE NOT DOCUMENTED in the manual,
   especially those whose name start with YY_ or yy_.  They are
   private implementation details that can be changed or removed.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output, and Bison version.  */
#define YYBISON 30705

/* Bison version string.  */
#define YYBISON_VERSION "3.7.5"

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 2

/* Push parsers.  */
#define YYPUSH 0

/* Pull parsers.  */
#define YYPULL 1

/* Substitute the type names.  */
#define YYSTYPE         PKL_TAB_STYPE
#define YYLTYPE         PKL_TAB_LTYPE
/* Substitute the variable and function names.  */
#define yyparse         pkl_tab_parse
#define yylex           pkl_tab_lex
#define yyerror         pkl_tab_error
#define yydebug         pkl_tab_debug
#define yynerrs         pkl_tab_nerrs

/* First part of user prologue.  */
#line 35 "pkl-tab.y"

#include <config.h>
#include <stdlib.h>
#include <stdio.h>
#include <xalloc.h>
#include <assert.h>
#include <string.h>
#include <gettext.h>
#define _(str) gettext (str)

#include "pk-utils.h"

#include "pkl.h"
#include "pkl-diag.h"
#include "pkl-ast.h"
#include "pkl-parser.h" /* For struct pkl_parser.  */

#include "pvm.h"

#define PKL_TAB_LTYPE pkl_ast_loc
#define YYDEBUG 1
#include "pkl-tab.h"
#include "pkl-lex.h"

#ifdef PKL_DEBUG
# include "pkl-gen.h"
#endif

#define scanner (pkl_parser->scanner)

/* YYLLOC_DEFAULT -> default code for computing locations.  */

#define PKL_AST_CHILDREN_STEP 12


/* Emit an error.  */

static void
pkl_tab_error (YYLTYPE *llocp,
               struct pkl_parser *pkl_parser,
               char const *err)
{
    pkl_error (pkl_parser->compiler, pkl_parser->ast, *llocp, "%s", err);
}

/* These are used in the defun_or_method rule.  */

#define IS_DEFUN 0
#define IS_METHOD 1

/* Register an argument in the compile-time environment.  This is used
   by function specifiers and try-catch statements.

   Return 0 if there was an error registering, 1 otherwise.  */

static int
pkl_register_arg (struct pkl_parser *parser, pkl_ast_node arg)
{
  pkl_ast_node arg_decl;
  pkl_ast_node arg_identifier = PKL_AST_FUNC_ARG_IDENTIFIER (arg);

  pkl_ast_node dummy
    = pkl_ast_make_integer (parser->ast, 0);
  PKL_AST_TYPE (dummy) = ASTREF (PKL_AST_FUNC_ARG_TYPE (arg));

  arg_decl = pkl_ast_make_decl (parser->ast,
                                PKL_AST_DECL_KIND_VAR,
                                arg_identifier,
                                dummy,
                                NULL /* source */);
  PKL_AST_LOC (arg_decl) = PKL_AST_LOC (arg);

  if (!pkl_env_register (parser->env,
                         PKL_ENV_NS_MAIN,
                         PKL_AST_IDENTIFIER_POINTER (arg_identifier),
                         arg_decl))
    {
      pkl_error (parser->compiler, parser->ast,PKL_AST_LOC (arg_identifier),
                 "duplicated argument name `%s' in function declaration",
                 PKL_AST_IDENTIFIER_POINTER (arg_identifier));
      /* Make sure to pop the function frame.  */
      parser->env = pkl_env_pop_frame (parser->env);
      return 0;
    }

  return 1;
}

/* Assert statement is a syntactic sugar that transforms to invocation
   of _pkl_assert function with appropriate arguments.

   This function accepts AST nodes corresponding to the condition and
   optional message of the assert statement, and also the location info
   of the statement.

   Returns NULL on failure, and expression statement AST node on success.  */

static pkl_ast_node
pkl_make_assertion (struct pkl_parser *parser, pkl_ast_node cond, pkl_ast_node msg,
                    struct pkl_ast_loc stmt_loc)
{
  pkl_ast_node vfunc, call, call_arg;
  /* _pkl_assert args */
  pkl_ast_node arg_cond, arg_msg, arg_fname, arg_line, arg_col;

  /* Make variable for `_pkl_assert` function */
  {
    const char *name = "_pkl_assert";
    pkl_ast_node vfunc_init;
    int back, over;

    vfunc_init = pkl_env_lookup (parser->env, PKL_ENV_NS_MAIN, name, &back, &over);
    if (!vfunc_init
        || (PKL_AST_DECL_KIND (vfunc_init) != PKL_AST_DECL_KIND_FUNC))
      {
        pkl_error (parser->compiler, parser->ast, stmt_loc, "undefined function '%s'",
                   name);
        return NULL;
      }
    vfunc = pkl_ast_make_var (parser->ast,
                              pkl_ast_make_identifier (parser->ast, name),
                              vfunc_init, back, over);
  }

  /* First argument of _pkl_assert: condition */
  arg_cond = pkl_ast_make_funcall_arg (parser->ast, cond, NULL);
  PKL_AST_LOC (arg_cond) = PKL_AST_LOC (cond);

  /* Second argument of _pkl_assert: user message */
  if (msg == NULL)
    {
      /* Use the source code of the condition as the user message.  */
      struct pkl_ast_loc exp_loc = PKL_AST_LOC (cond);
      char *loc_source = pkl_loc_to_source (parser, exp_loc, 80);
      char *escaped_loc_source = NULL;

      /* Escape backslash characters in loc_source, wince we are using
         it in a Poke string literal.  */
      {
        size_t escaped_size = 0, i, j;

        for (i = 0; i < strlen (loc_source); ++i)
          escaped_size += (loc_source[i] == '\\' ? 2 : 1);

        escaped_loc_source = malloc (escaped_size + 1);

        for (i = 0, j = 0; i < strlen (loc_source); ++i)
          {
            if (loc_source[i] == '\\')
              {
                escaped_loc_source[j++] = '\\';
                escaped_loc_source[j++] = '\\';
              }
            else
              escaped_loc_source[j++] = loc_source[i];
          }
        escaped_loc_source[j] = '\0';
      }

      msg = pkl_ast_make_string (parser->ast, escaped_loc_source);
      free (loc_source);
      free (escaped_loc_source);
      PKL_AST_TYPE (msg) = ASTREF (pkl_ast_make_string_type (parser->ast));
    }
  arg_msg = pkl_ast_make_funcall_arg (parser->ast, msg, NULL);
  arg_msg = ASTREF (arg_msg);
  PKL_AST_LOC (arg_msg) = PKL_AST_LOC (msg);

  /* Third argument of _pkl_assert: file name */
  {
    pkl_ast_node fname
        = pkl_ast_make_string (parser->ast,
                               parser->filename ? parser->filename : "<stdin>");

    PKL_AST_TYPE (fname) = ASTREF (pkl_ast_make_string_type (parser->ast));
    arg_fname = pkl_ast_make_funcall_arg (parser->ast, fname, NULL);
    arg_fname = ASTREF (arg_fname);
  }

  /* Fourth argument of _pkl_assert: line */
  {
    pkl_ast_node line = pkl_ast_make_integer (parser->ast, stmt_loc.first_line);

    PKL_AST_TYPE (line) = ASTREF (pkl_ast_make_integral_type (parser->ast, 64, 0));
    arg_line = pkl_ast_make_funcall_arg (parser->ast, line, NULL);
    arg_line = ASTREF (arg_line);
  }

  /* Fifth argument of _pkl_assert: column */
  {
    pkl_ast_node col = pkl_ast_make_integer (parser->ast, stmt_loc.first_column);

    PKL_AST_TYPE (col) = ASTREF (pkl_ast_make_integral_type (parser->ast, 64, 0));
    arg_col = pkl_ast_make_funcall_arg (parser->ast, col, NULL);
    arg_col = ASTREF (arg_col);
  }

  call_arg = pkl_ast_chainon (arg_line, arg_col);
  call_arg = pkl_ast_chainon (arg_fname, call_arg);
  call_arg = pkl_ast_chainon (arg_msg, call_arg);
  call_arg = pkl_ast_chainon (arg_cond, call_arg);
  call = pkl_ast_make_funcall (parser->ast, vfunc, call_arg);
  return pkl_ast_make_exp_stmt (parser->ast, call);
}

#if 0
/* Register a list of arguments in the compile-time environment.  This
   is used by function specifiers and try-catch statements.

   Return 0 if there was an error registering, 1 otherwise.  */

static int
pkl_register_args (struct pkl_parser *parser, pkl_ast_node arg_list)
{
  pkl_ast_node arg;

  for (arg = arg_list; arg; arg = PKL_AST_CHAIN (arg))
    {
      pkl_ast_node arg_decl;
      pkl_ast_node arg_identifier = PKL_AST_FUNC_ARG_IDENTIFIER (arg);

      pkl_ast_node dummy
        = pkl_ast_make_integer (parser->ast, 0);
      PKL_AST_TYPE (dummy) = ASTREF (PKL_AST_FUNC_ARG_TYPE (arg));

      arg_decl = pkl_ast_make_decl (parser->ast,
                                    PKL_AST_DECL_KIND_VAR,
                                    arg_identifier,
                                    dummy,
                                    NULL /* source */);
      PKL_AST_LOC (arg_decl) = PKL_AST_LOC (arg);

      if (!pkl_env_register (parser->env,
                             PKL_ENV_NS_MAIN,
                             PKL_AST_IDENTIFIER_POINTER (arg_identifier),
                             arg_decl))
        {
          pkl_error (parser->compiler, parser->ast, PKL_AST_LOC (arg_identifier),
                     "duplicated argument name `%s' in function declaration",
                     PKL_AST_IDENTIFIER_POINTER (arg_identifier));
          /* Make sure to pop the function frame.  */
          parser->env = pkl_env_pop_frame (parser->env);
          return 0;
        }
    }

  return 1;
}
#endif

/* Register N dummy entries in the compilation environment.  */

static void
pkl_register_dummies (struct pkl_parser *parser, int n)
{
  int i;
  for (i = 0; i < n; ++i)
    {
      char *name;
      pkl_ast_node id;
      pkl_ast_node decl;
      int r;

      asprintf (&name, "@*UNUSABLE_OFF_%d*@", i);
      id = pkl_ast_make_identifier (parser->ast, name);
      decl = pkl_ast_make_decl (parser->ast,
                                PKL_AST_DECL_KIND_VAR,
                                id, NULL /* initial */,
                                NULL /* source */);

      r = pkl_env_register (parser->env, PKL_ENV_NS_MAIN, name, decl);
      assert (r);
    }
}

/* Load a module, given its name.
   If the module file cannot be read, return 1.
   If there is a parse error loading the module, return 2.
   Otherwise, return 0.  */

static int
load_module (struct pkl_parser *parser,
             const char *module, pkl_ast_node *node,
             int filename_p, char **filename)
{
  char *module_filename = NULL;
  pkl_ast ast;
  FILE *fp;

  module_filename = pkl_resolve_module (parser->compiler,
                                        module,
                                        filename_p);
  if (module_filename == NULL)
    /* No file found.  */
    return 1;

  fp = fopen (module_filename, "rb");
  if (!fp)
    {
      free (module_filename);
      return 1;
    }

  /* Parse the file, using the given environment.  The declarations
     found in the parsed file are appended to that environment, so
     nothing extra should be done about that.  */
  if (pkl_parse_file (parser->compiler, &parser->env, &ast, fp,
                      module_filename)
      != 0)
    {
      fclose (fp);
      free (module_filename);
      return 2;
    }

  /* Add the module to the compiler's list of loaded modules.  */
  pkl_add_module (parser->compiler, module_filename);

  /* However, the AST nodes shall be appended explicitly, which is
     achieved by returning them to the caller in the NODE
     argument.  */
  *node = PKL_AST_PROGRAM_ELEMS (ast->ast);

  /* Dirty hack is dirty, but it works.  */
  PKL_AST_PROGRAM_ELEMS (ast->ast) = NULL;
  pkl_ast_free (ast);

  /* Set the `filename' output argument if needed.  */
  if (filename)
    *filename = strdup (module_filename);

  fclose (fp);
  free (module_filename);
  return 0;
}


#line 416 "pkl-tab.c"

# ifndef YY_CAST
#  ifdef __cplusplus
#   define YY_CAST(Type, Val) static_cast<Type> (Val)
#   define YY_REINTERPRET_CAST(Type, Val) reinterpret_cast<Type> (Val)
#  else
#   define YY_CAST(Type, Val) ((Type) (Val))
#   define YY_REINTERPRET_CAST(Type, Val) ((Type) (Val))
#  endif
# endif
# ifndef YY_NULLPTR
#  if defined __cplusplus
#   if 201103L <= __cplusplus
#    define YY_NULLPTR nullptr
#   else
#    define YY_NULLPTR 0
#   endif
#  else
#   define YY_NULLPTR ((void*)0)
#  endif
# endif

#include "pkl-tab.h"
/* Symbol kind.  */
enum yysymbol_kind_t
{
  YYSYMBOL_YYEMPTY = -2,
  YYSYMBOL_YYEOF = 0,                      /* "end of file"  */
  YYSYMBOL_YYerror = 1,                    /* error  */
  YYSYMBOL_YYUNDEF = 2,                    /* "invalid token"  */
  YYSYMBOL_INTEGER = 3,                    /* "integer literal"  */
  YYSYMBOL_LEXER_EXCEPTION = 4,            /* LEXER_EXCEPTION  */
  YYSYMBOL_CHAR = 5,                       /* "character literal"  */
  YYSYMBOL_STR = 6,                        /* "string"  */
  YYSYMBOL_IDENTIFIER = 7,                 /* "identifier"  */
  YYSYMBOL_TYPENAME = 8,                   /* "type name"  */
  YYSYMBOL_UNIT = 9,                       /* "offset unit"  */
  YYSYMBOL_OFFSET = 10,                    /* "offset"  */
  YYSYMBOL_ASM = 11,                       /* "keyword `asm'"  */
  YYSYMBOL_ENUM = 12,                      /* "keyword `enum'"  */
  YYSYMBOL_PINNED = 13,                    /* "keyword `pinned'"  */
  YYSYMBOL_STRUCT = 14,                    /* "keyword `struct'"  */
  YYSYMBOL_UNION = 15,                     /* "keyword `union'"  */
  YYSYMBOL_CONST = 16,                     /* "keyword `const'"  */
  YYSYMBOL_CONTINUE = 17,                  /* "keyword `continue'"  */
  YYSYMBOL_ELSE = 18,                      /* "keyword `else'"  */
  YYSYMBOL_IF = 19,                        /* "keyword `if'"  */
  YYSYMBOL_WHILE = 20,                     /* "keyword `while'"  */
  YYSYMBOL_UNTIL = 21,                     /* "keyword `until'"  */
  YYSYMBOL_FOR = 22,                       /* "keyword `for'"  */
  YYSYMBOL_IN = 23,                        /* "keyword `in'"  */
  YYSYMBOL_WHERE = 24,                     /* "keyword `where'"  */
  YYSYMBOL_SIZEOF = 25,                    /* "keyword `sizeof'"  */
  YYSYMBOL_TYPEOF = 26,                    /* "keyword `typeof'"  */
  YYSYMBOL_ASSERT = 27,                    /* "keyword `assert'"  */
  YYSYMBOL_APUSH = 28,                     /* "keyword `apush'"  */
  YYSYMBOL_APOP = 29,                      /* "keyword `apop'"  */
  YYSYMBOL_ERR = 30,                       /* "token"  */
  YYSYMBOL_ALIEN = 31,                     /* ALIEN  */
  YYSYMBOL_INTCONSTR = 32,                 /* "int type constructor"  */
  YYSYMBOL_UINTCONSTR = 33,                /* "uint type constructor"  */
  YYSYMBOL_OFFSETCONSTR = 34,              /* "offset type constructor"  */
  YYSYMBOL_DEFUN = 35,                     /* "keyword `fun'"  */
  YYSYMBOL_DEFSET = 36,                    /* "keyword `defset'"  */
  YYSYMBOL_DEFTYPE = 37,                   /* "keyword `type'"  */
  YYSYMBOL_DEFVAR = 38,                    /* "keyword `var'"  */
  YYSYMBOL_DEFUNIT = 39,                   /* "keyword `unit'"  */
  YYSYMBOL_METHOD = 40,                    /* "keyword `method'"  */
  YYSYMBOL_RETURN = 41,                    /* "keyword `return'"  */
  YYSYMBOL_BREAK = 42,                     /* "keyword `break'"  */
  YYSYMBOL_STRING = 43,                    /* "string type specifier"  */
  YYSYMBOL_TRY = 44,                       /* "keyword `try'"  */
  YYSYMBOL_CATCH = 45,                     /* "keyword `catch'"  */
  YYSYMBOL_RAISE = 46,                     /* "keyword `raise'"  */
  YYSYMBOL_VOID = 47,                      /* "void type specifier"  */
  YYSYMBOL_ANY = 48,                       /* "any type specifier"  */
  YYSYMBOL_PRINT = 49,                     /* "keyword `print'"  */
  YYSYMBOL_PRINTF = 50,                    /* "keyword `printf'"  */
  YYSYMBOL_LOAD = 51,                      /* "keyword `load'"  */
  YYSYMBOL_LAMBDA = 52,                    /* "keyword `lambda'"  */
  YYSYMBOL_FORMAT = 53,                    /* "keyword `format'"  */
  YYSYMBOL_COMPUTED = 54,                  /* "keyword `computed'"  */
  YYSYMBOL_IMMUTABLE = 55,                 /* IMMUTABLE  */
  YYSYMBOL_BUILTIN_TERM_GET_COLOR = 56,    /* BUILTIN_TERM_GET_COLOR  */
  YYSYMBOL_BUILTIN_TERM_SET_COLOR = 57,    /* BUILTIN_TERM_SET_COLOR  */
  YYSYMBOL_BUILTIN_TERM_GET_BGCOLOR = 58,  /* BUILTIN_TERM_GET_BGCOLOR  */
  YYSYMBOL_BUILTIN_TERM_SET_BGCOLOR = 59,  /* BUILTIN_TERM_SET_BGCOLOR  */
  YYSYMBOL_POWA = 60,                      /* "power-and-assign operator"  */
  YYSYMBOL_MULA = 61,                      /* "multiply-and-assign operator"  */
  YYSYMBOL_DIVA = 62,                      /* "divide-and-assing operator"  */
  YYSYMBOL_MODA = 63,                      /* "modulus-and-assign operator"  */
  YYSYMBOL_ADDA = 64,                      /* "add-and-assing operator"  */
  YYSYMBOL_SUBA = 65,                      /* "subtract-and-assign operator"  */
  YYSYMBOL_SLA = 66,                       /* "shift-left-and-assign operator"  */
  YYSYMBOL_SRA = 67,                       /* "shift-right-and-assign operator"  */
  YYSYMBOL_BANDA = 68,                     /* "bit-and-and-assign operator"  */
  YYSYMBOL_XORA = 69,                      /* "bit-xor-and-assign operator"  */
  YYSYMBOL_IORA = 70,                      /* "bit-or-and-assign operator"  */
  YYSYMBOL_RANGEA = 71,                    /* "range separator"  */
  YYSYMBOL_OR = 72,                        /* "logical or operator"  */
  YYSYMBOL_AND = 73,                       /* "logical and operator"  */
  YYSYMBOL_IMPL = 74,                      /* "logical implication operator"  */
  YYSYMBOL_75_bit_wise_or_operator_ = 75,  /* "bit-wise or operator"  */
  YYSYMBOL_76_bit_wise_xor_operator_ = 76, /* "bit-wise xor operator"  */
  YYSYMBOL_77_bit_wise_and_operator_ = 77, /* "bit-wise and operator"  */
  YYSYMBOL_EQ = 78,                        /* "equality operator"  */
  YYSYMBOL_NE = 79,                        /* "inequality operator"  */
  YYSYMBOL_LE = 80,                        /* "less-or-equal operator"  */
  YYSYMBOL_GE = 81,                        /* "bigger-or-equal-than operator"  */
  YYSYMBOL_82_less_than_operator_ = 82,    /* "less-than operator"  */
  YYSYMBOL_83_bigger_than_operator_ = 83,  /* "bigger-than operator"  */
  YYSYMBOL_SL = 84,                        /* "left shift operator"  */
  YYSYMBOL_SR = 85,                        /* "right shift operator"  */
  YYSYMBOL_86_addition_operator_ = 86,     /* "addition operator"  */
  YYSYMBOL_87_subtraction_operator_ = 87,  /* "subtraction operator"  */
  YYSYMBOL_88_multiplication_operator_ = 88, /* "multiplication operator"  */
  YYSYMBOL_89_division_operator_ = 89,     /* "division operator"  */
  YYSYMBOL_CEILDIV = 90,                   /* "ceiling division operator"  */
  YYSYMBOL_91_modulus_operator_ = 91,      /* "modulus operator"  */
  YYSYMBOL_POW = 92,                       /* "power operator"  */
  YYSYMBOL_BCONC = 93,                     /* "bit-concatenation operator"  */
  YYSYMBOL_94_map_operator_ = 94,          /* "map operator"  */
  YYSYMBOL_NSMAP = 95,                     /* "non-strict map operator"  */
  YYSYMBOL_INC = 96,                       /* "increment operator"  */
  YYSYMBOL_DEC = 97,                       /* "decrement operator"  */
  YYSYMBOL_AS = 98,                        /* "cast operator"  */
  YYSYMBOL_ISA = 99,                       /* "type identification operator"  */
  YYSYMBOL_100_dot_operator_ = 100,        /* "dot operator"  */
  YYSYMBOL_ATTR = 101,                     /* "attribute"  */
  YYSYMBOL_UNMAP = 102,                    /* "unmap operator"  */
  YYSYMBOL_REMAP = 103,                    /* "remap operator"  */
  YYSYMBOL_EXCOND = 104,                   /* "conditional on exception operator"  */
  YYSYMBOL_BIG = 105,                      /* "keyword `big'"  */
  YYSYMBOL_LITTLE = 106,                   /* "keyword `little'"  */
  YYSYMBOL_SIGNED = 107,                   /* "keyword `signed'"  */
  YYSYMBOL_UNSIGNED = 108,                 /* "keyword `unsigned'"  */
  YYSYMBOL_THREEDOTS = 109,                /* "varargs indicator"  */
  YYSYMBOL_THEN = 110,                     /* THEN  */
  YYSYMBOL_111_ = 111,                     /* '?'  */
  YYSYMBOL_112_ = 112,                     /* ':'  */
  YYSYMBOL_UNARY = 113,                    /* UNARY  */
  YYSYMBOL_HYPERUNARY = 114,               /* HYPERUNARY  */
  YYSYMBOL_START_EXP = 115,                /* START_EXP  */
  YYSYMBOL_START_DECL = 116,               /* START_DECL  */
  YYSYMBOL_START_STMT = 117,               /* START_STMT  */
  YYSYMBOL_START_PROGRAM = 118,            /* START_PROGRAM  */
  YYSYMBOL_119_ = 119,                     /* ','  */
  YYSYMBOL_120_ = 120,                     /* ';'  */
  YYSYMBOL_121_ = 121,                     /* '('  */
  YYSYMBOL_122_ = 122,                     /* ')'  */
  YYSYMBOL_123_ = 123,                     /* '~'  */
  YYSYMBOL_124_ = 124,                     /* '!'  */
  YYSYMBOL_125_ = 125,                     /* ".>"  */
  YYSYMBOL_126_ = 126,                     /* '['  */
  YYSYMBOL_127_ = 127,                     /* ']'  */
  YYSYMBOL_128_ = 128,                     /* '{'  */
  YYSYMBOL_129_ = 129,                     /* '}'  */
  YYSYMBOL_130_ = 130,                     /* '='  */
  YYSYMBOL_YYACCEPT = 131,                 /* $accept  */
  YYSYMBOL_pushlevel = 132,                /* pushlevel  */
  YYSYMBOL_start = 133,                    /* start  */
  YYSYMBOL_program = 134,                  /* program  */
  YYSYMBOL_program_elem_list = 135,        /* program_elem_list  */
  YYSYMBOL_program_elem = 136,             /* program_elem  */
  YYSYMBOL_load = 137,                     /* load  */
  YYSYMBOL_integer = 138,                  /* integer  */
  YYSYMBOL_identifier = 139,               /* identifier  */
  YYSYMBOL_expression_list = 140,          /* expression_list  */
  YYSYMBOL_expression_opt = 141,           /* expression_opt  */
  YYSYMBOL_expression = 142,               /* expression  */
  YYSYMBOL_bconc = 143,                    /* bconc  */
  YYSYMBOL_mapop = 144,                    /* mapop  */
  YYSYMBOL_map = 145,                      /* map  */
  YYSYMBOL_unary_operator = 146,           /* unary_operator  */
  YYSYMBOL_primary = 147,                  /* primary  */
  YYSYMBOL_148_1 = 148,                    /* $@1  */
  YYSYMBOL_funcall = 149,                  /* funcall  */
  YYSYMBOL_funcall_arg_list = 150,         /* funcall_arg_list  */
  YYSYMBOL_funcall_arg = 151,              /* funcall_arg  */
  YYSYMBOL_format_arg_list = 152,          /* format_arg_list  */
  YYSYMBOL_format_arg = 153,               /* format_arg  */
  YYSYMBOL_opt_comma = 154,                /* opt_comma  */
  YYSYMBOL_struct_field_list = 155,        /* struct_field_list  */
  YYSYMBOL_struct_field = 156,             /* struct_field  */
  YYSYMBOL_array = 157,                    /* array  */
  YYSYMBOL_array_initializer_list = 158,   /* array_initializer_list  */
  YYSYMBOL_array_initializer = 159,        /* array_initializer  */
  YYSYMBOL_pushlevel_args = 160,           /* pushlevel_args  */
  YYSYMBOL_function_specifier = 161,       /* function_specifier  */
  YYSYMBOL_function_arg_list = 162,        /* function_arg_list  */
  YYSYMBOL_function_arg = 163,             /* function_arg  */
  YYSYMBOL_function_arg_initial = 164,     /* function_arg_initial  */
  YYSYMBOL_type_specifier = 165,           /* type_specifier  */
  YYSYMBOL_typename = 166,                 /* typename  */
  YYSYMBOL_string_type_specifier = 167,    /* string_type_specifier  */
  YYSYMBOL_simple_type_specifier = 168,    /* simple_type_specifier  */
  YYSYMBOL_cons_type_specifier = 169,      /* cons_type_specifier  */
  YYSYMBOL_integral_type_specifier = 170,  /* integral_type_specifier  */
  YYSYMBOL_integral_type_sign = 171,       /* integral_type_sign  */
  YYSYMBOL_offset_type_specifier = 172,    /* offset_type_specifier  */
  YYSYMBOL_array_type_specifier = 173,     /* array_type_specifier  */
  YYSYMBOL_function_type_specifier = 174,  /* function_type_specifier  */
  YYSYMBOL_function_type_arg_list = 175,   /* function_type_arg_list  */
  YYSYMBOL_function_type_arg = 176,        /* function_type_arg  */
  YYSYMBOL_struct_type_specifier = 177,    /* struct_type_specifier  */
  YYSYMBOL_178_2 = 178,                    /* $@2  */
  YYSYMBOL_struct_or_union = 179,          /* struct_or_union  */
  YYSYMBOL_struct_type_pinned = 180,       /* struct_type_pinned  */
  YYSYMBOL_integral_struct = 181,          /* integral_struct  */
  YYSYMBOL_struct_type_elem_list = 182,    /* struct_type_elem_list  */
  YYSYMBOL_endianness = 183,               /* endianness  */
  YYSYMBOL_struct_type_computed_field = 184, /* struct_type_computed_field  */
  YYSYMBOL_struct_type_field = 185,        /* struct_type_field  */
  YYSYMBOL_186_3 = 186,                    /* $@3  */
  YYSYMBOL_struct_type_field_identifier = 187, /* struct_type_field_identifier  */
  YYSYMBOL_struct_type_field_label = 188,  /* struct_type_field_label  */
  YYSYMBOL_struct_type_field_constraint_and_init = 189, /* struct_type_field_constraint_and_init  */
  YYSYMBOL_struct_type_field_optcond_pre = 190, /* struct_type_field_optcond_pre  */
  YYSYMBOL_struct_type_field_optcond_post = 191, /* struct_type_field_optcond_post  */
  YYSYMBOL_simple_declaration = 192,       /* simple_declaration  */
  YYSYMBOL_declaration = 193,              /* declaration  */
  YYSYMBOL_194_4 = 194,                    /* @4  */
  YYSYMBOL_defun_or_method = 195,          /* defun_or_method  */
  YYSYMBOL_defvar_list = 196,              /* defvar_list  */
  YYSYMBOL_defvar = 197,                   /* defvar  */
  YYSYMBOL_deftype_list = 198,             /* deftype_list  */
  YYSYMBOL_deftype = 199,                  /* deftype  */
  YYSYMBOL_defunit_list = 200,             /* defunit_list  */
  YYSYMBOL_defunit = 201,                  /* defunit  */
  YYSYMBOL_comp_stmt = 202,                /* comp_stmt  */
  YYSYMBOL_builtin = 203,                  /* builtin  */
  YYSYMBOL_stmt_decl_list = 204,           /* stmt_decl_list  */
  YYSYMBOL_ass_exp_op = 205,               /* ass_exp_op  */
  YYSYMBOL_simple_stmt_list = 206,         /* simple_stmt_list  */
  YYSYMBOL_simple_stmt = 207,              /* simple_stmt  */
  YYSYMBOL_stmt = 208,                     /* stmt  */
  YYSYMBOL_209_5 = 209,                    /* @5  */
  YYSYMBOL_210_6 = 210,                    /* @6  */
  YYSYMBOL_funcall_stmt = 211,             /* funcall_stmt  */
  YYSYMBOL_funcall_stmt_arg_list = 212,    /* funcall_stmt_arg_list  */
  YYSYMBOL_funcall_stmt_arg = 213          /* funcall_stmt_arg  */
};
typedef enum yysymbol_kind_t yysymbol_kind_t;




#ifdef short
# undef short
#endif

/* On compilers that do not define __PTRDIFF_MAX__ etc., make sure
   <limits.h> and (if available) <stdint.h> are included
   so that the code can choose integer types of a good width.  */

#ifndef __PTRDIFF_MAX__
# include <limits.h> /* INFRINGES ON USER NAME SPACE */
# if defined __STDC_VERSION__ && 199901 <= __STDC_VERSION__
#  include <stdint.h> /* INFRINGES ON USER NAME SPACE */
#  define YY_STDINT_H
# endif
#endif

/* Narrow types that promote to a signed type and that can represent a
   signed or unsigned integer of at least N bits.  In tables they can
   save space and decrease cache pressure.  Promoting to a signed type
   helps avoid bugs in integer arithmetic.  */

#ifdef __INT_LEAST8_MAX__
typedef __INT_LEAST8_TYPE__ yytype_int8;
#elif defined YY_STDINT_H
typedef int_least8_t yytype_int8;
#else
typedef signed char yytype_int8;
#endif

#ifdef __INT_LEAST16_MAX__
typedef __INT_LEAST16_TYPE__ yytype_int16;
#elif defined YY_STDINT_H
typedef int_least16_t yytype_int16;
#else
typedef short yytype_int16;
#endif

/* Work around bug in HP-UX 11.23, which defines these macros
   incorrectly for preprocessor constants.  This workaround can likely
   be removed in 2023, as HPE has promised support for HP-UX 11.23
   (aka HP-UX 11i v2) only through the end of 2022; see Table 2 of
   <https://h20195.www2.hpe.com/V2/getpdf.aspx/4AA4-7673ENW.pdf>.  */
#ifdef __hpux
# undef UINT_LEAST8_MAX
# undef UINT_LEAST16_MAX
# define UINT_LEAST8_MAX 255
# define UINT_LEAST16_MAX 65535
#endif

#if defined __UINT_LEAST8_MAX__ && __UINT_LEAST8_MAX__ <= __INT_MAX__
typedef __UINT_LEAST8_TYPE__ yytype_uint8;
#elif (!defined __UINT_LEAST8_MAX__ && defined YY_STDINT_H \
       && UINT_LEAST8_MAX <= INT_MAX)
typedef uint_least8_t yytype_uint8;
#elif !defined __UINT_LEAST8_MAX__ && UCHAR_MAX <= INT_MAX
typedef unsigned char yytype_uint8;
#else
typedef short yytype_uint8;
#endif

#if defined __UINT_LEAST16_MAX__ && __UINT_LEAST16_MAX__ <= __INT_MAX__
typedef __UINT_LEAST16_TYPE__ yytype_uint16;
#elif (!defined __UINT_LEAST16_MAX__ && defined YY_STDINT_H \
       && UINT_LEAST16_MAX <= INT_MAX)
typedef uint_least16_t yytype_uint16;
#elif !defined __UINT_LEAST16_MAX__ && USHRT_MAX <= INT_MAX
typedef unsigned short yytype_uint16;
#else
typedef int yytype_uint16;
#endif

#ifndef YYPTRDIFF_T
# if defined __PTRDIFF_TYPE__ && defined __PTRDIFF_MAX__
#  define YYPTRDIFF_T __PTRDIFF_TYPE__
#  define YYPTRDIFF_MAXIMUM __PTRDIFF_MAX__
# elif defined PTRDIFF_MAX
#  ifndef ptrdiff_t
#   include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  endif
#  define YYPTRDIFF_T ptrdiff_t
#  define YYPTRDIFF_MAXIMUM PTRDIFF_MAX
# else
#  define YYPTRDIFF_T long
#  define YYPTRDIFF_MAXIMUM LONG_MAX
# endif
#endif

#ifndef YYSIZE_T
# ifdef __SIZE_TYPE__
#  define YYSIZE_T __SIZE_TYPE__
# elif defined size_t
#  define YYSIZE_T size_t
# elif defined __STDC_VERSION__ && 199901 <= __STDC_VERSION__
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# else
#  define YYSIZE_T unsigned
# endif
#endif

#define YYSIZE_MAXIMUM                                  \
  YY_CAST (YYPTRDIFF_T,                                 \
           (YYPTRDIFF_MAXIMUM < YY_CAST (YYSIZE_T, -1)  \
            ? YYPTRDIFF_MAXIMUM                         \
            : YY_CAST (YYSIZE_T, -1)))

#define YYSIZEOF(X) YY_CAST (YYPTRDIFF_T, sizeof (X))


/* Stored state numbers (used for stacks). */
typedef yytype_int16 yy_state_t;

/* State numbers in computations.  */
typedef int yy_state_fast_t;

#ifndef YY_
# if defined YYENABLE_NLS && YYENABLE_NLS
#  if ENABLE_NLS
#   include <libintl.h> /* INFRINGES ON USER NAME SPACE */
#   define YY_(Msgid) dgettext ("bison-runtime", Msgid)
#  endif
# endif
# ifndef YY_
#  define YY_(Msgid) Msgid
# endif
#endif

#ifndef N_
# define N_(Msgid) Msgid
#endif


#ifndef YY_ATTRIBUTE_PURE
# if defined __GNUC__ && 2 < __GNUC__ + (96 <= __GNUC_MINOR__)
#  define YY_ATTRIBUTE_PURE __attribute__ ((__pure__))
# else
#  define YY_ATTRIBUTE_PURE
# endif
#endif

#ifndef YY_ATTRIBUTE_UNUSED
# if defined __GNUC__ && 2 < __GNUC__ + (7 <= __GNUC_MINOR__)
#  define YY_ATTRIBUTE_UNUSED __attribute__ ((__unused__))
# else
#  define YY_ATTRIBUTE_UNUSED
# endif
#endif

/* Suppress unused-variable warnings by "using" E.  */
#if ! defined lint || defined __GNUC__
# define YY_USE(E) ((void) (E))
#else
# define YY_USE(E) /* empty */
#endif

#if defined __GNUC__ && ! defined __ICC && 407 <= __GNUC__ * 100 + __GNUC_MINOR__
/* Suppress an incorrect diagnostic about yylval being uninitialized.  */
# define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN                            \
    _Pragma ("GCC diagnostic push")                                     \
    _Pragma ("GCC diagnostic ignored \"-Wuninitialized\"")              \
    _Pragma ("GCC diagnostic ignored \"-Wmaybe-uninitialized\"")
# define YY_IGNORE_MAYBE_UNINITIALIZED_END      \
    _Pragma ("GCC diagnostic pop")
#else
# define YY_INITIAL_VALUE(Value) Value
#endif
#ifndef YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_END
#endif
#ifndef YY_INITIAL_VALUE
# define YY_INITIAL_VALUE(Value) /* Nothing. */
#endif

#if defined __cplusplus && defined __GNUC__ && ! defined __ICC && 6 <= __GNUC__
# define YY_IGNORE_USELESS_CAST_BEGIN                          \
    _Pragma ("GCC diagnostic push")                            \
    _Pragma ("GCC diagnostic ignored \"-Wuseless-cast\"")
# define YY_IGNORE_USELESS_CAST_END            \
    _Pragma ("GCC diagnostic pop")
#endif
#ifndef YY_IGNORE_USELESS_CAST_BEGIN
# define YY_IGNORE_USELESS_CAST_BEGIN
# define YY_IGNORE_USELESS_CAST_END
#endif


#define YY_ASSERT(E) ((void) (0 && (E)))

#if 1

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's 'empty if-body' warning.  */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
#  ifndef YYSTACK_ALLOC_MAXIMUM
    /* The OS might guarantee only one guard page at the bottom of the stack,
       and a page size can be as small as 4096 bytes.  So we cannot safely
       invoke alloca (N) if N exceeds 4096.  Use a slightly smaller number
       to allow for a few compiler-allocated temporary stack slots.  */
#   define YYSTACK_ALLOC_MAXIMUM 4032 /* reasonable circa 2006 */
#  endif
# else
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
#  ifndef YYSTACK_ALLOC_MAXIMUM
#   define YYSTACK_ALLOC_MAXIMUM YYSIZE_MAXIMUM
#  endif
#  if (defined __cplusplus && ! defined EXIT_SUCCESS \
       && ! ((defined YYMALLOC || defined malloc) \
             && (defined YYFREE || defined free)))
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   ifndef EXIT_SUCCESS
#    define EXIT_SUCCESS 0
#   endif
#  endif
#  ifndef YYMALLOC
#   define YYMALLOC malloc
#   if ! defined malloc && ! defined EXIT_SUCCESS
void *malloc (YYSIZE_T); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
#  ifndef YYFREE
#   define YYFREE free
#   if ! defined free && ! defined EXIT_SUCCESS
void free (void *); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
# endif
# define YYCOPY_NEEDED 1
#endif /* 1 */

#if (! defined yyoverflow \
     && (! defined __cplusplus \
         || (defined PKL_TAB_LTYPE_IS_TRIVIAL && PKL_TAB_LTYPE_IS_TRIVIAL \
             && defined PKL_TAB_STYPE_IS_TRIVIAL && PKL_TAB_STYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  yy_state_t yyss_alloc;
  YYSTYPE yyvs_alloc;
  YYLTYPE yyls_alloc;
};

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (YYSIZEOF (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (YYSIZEOF (yy_state_t) + YYSIZEOF (YYSTYPE) \
             + YYSIZEOF (YYLTYPE)) \
      + 2 * YYSTACK_GAP_MAXIMUM)

# define YYCOPY_NEEDED 1

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack_alloc, Stack)                           \
    do                                                                  \
      {                                                                 \
        YYPTRDIFF_T yynewbytes;                                         \
        YYCOPY (&yyptr->Stack_alloc, Stack, yysize);                    \
        Stack = &yyptr->Stack_alloc;                                    \
        yynewbytes = yystacksize * YYSIZEOF (*Stack) + YYSTACK_GAP_MAXIMUM; \
        yyptr += yynewbytes / YYSIZEOF (*yyptr);                        \
      }                                                                 \
    while (0)

#endif

#if defined YYCOPY_NEEDED && YYCOPY_NEEDED
/* Copy COUNT objects from SRC to DST.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined __GNUC__ && 1 < __GNUC__
#   define YYCOPY(Dst, Src, Count) \
      __builtin_memcpy (Dst, Src, YY_CAST (YYSIZE_T, (Count)) * sizeof (*(Src)))
#  else
#   define YYCOPY(Dst, Src, Count)              \
      do                                        \
        {                                       \
          YYPTRDIFF_T yyi;                      \
          for (yyi = 0; yyi < (Count); yyi++)   \
            (Dst)[yyi] = (Src)[yyi];            \
        }                                       \
      while (0)
#  endif
# endif
#endif /* !YYCOPY_NEEDED */

/* YYFINAL -- State number of the termination state.  */
#define YYFINAL  93
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   5253

/* YYNTOKENS -- Number of terminals.  */
#define YYNTOKENS  131
/* YYNNTS -- Number of nonterminals.  */
#define YYNNTS  83
/* YYNRULES -- Number of rules.  */
#define YYNRULES  285
/* YYNSTATES -- Number of states.  */
#define YYNSTATES  535

/* YYMAXUTOK -- Last valid token kind.  */
#define YYMAXUTOK   360


/* YYTRANSLATE(TOKEN-NUM) -- Symbol number corresponding to TOKEN-NUM
   as returned by yylex, with out-of-bounds checking.  */
#define YYTRANSLATE(YYX)                                \
  (0 <= (YYX) && (YYX) <= YYMAXUTOK                     \
   ? YY_CAST (yysymbol_kind_t, yytranslate[YYX])        \
   : YYSYMBOL_YYUNDEF)

/* YYTRANSLATE[TOKEN-NUM] -- Symbol number corresponding to TOKEN-NUM
   as returned by yylex.  */
static const yytype_uint8 yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,   124,     2,     2,     2,    91,    77,     2,
     121,   122,    88,    86,   119,    87,   100,    89,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,   112,   120,
      82,   130,    83,   111,    94,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,   126,     2,   127,    76,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,   128,    75,   129,   123,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    69,    70,    71,    72,    73,    74,
      78,    79,    80,    81,    84,    85,    90,    92,    93,    95,
      96,    97,    98,    99,   101,   102,   103,   104,   105,   106,
     107,   108,   109,   110,   113,   114,   115,   116,   117,   118,
     125
};

#if PKL_TAB_DEBUG
  /* YYRLINE[YYN] -- Source line where rule number YYN was defined.  */
static const yytype_int16 yyrline[] =
{
       0,   599,   599,   614,   620,   627,   633,   639,   645,   655,
     661,   667,   676,   680,   684,   685,   695,   696,   701,   702,
     706,   740,   780,   781,   796,   797,   805,   807,   808,   815,
     816,   820,   821,   827,   834,   841,   847,   853,   859,   865,
     870,   875,   881,   887,   893,   899,   905,   911,   917,   923,
     929,   935,   941,   947,   953,   959,   965,   971,   976,   981,
     987,   993,   999,  1014,  1019,  1034,  1040,  1046,  1047,  1051,
    1060,  1061,  1065,  1071,  1080,  1081,  1082,  1083,  1084,  1085,
    1089,  1118,  1124,  1130,  1136,  1144,  1145,  1151,  1157,  1162,
    1168,  1174,  1180,  1186,  1192,  1193,  1198,  1197,  1209,  1214,
    1219,  1231,  1237,  1243,  1248,  1253,  1258,  1264,  1270,  1284,
    1307,  1316,  1318,  1319,  1326,  1335,  1337,  1338,  1349,  1357,
    1358,  1362,  1364,  1365,  1372,  1379,  1390,  1401,  1402,  1409,
    1415,  1428,  1454,  1464,  1477,  1478,  1485,  1495,  1521,  1522,
    1530,  1531,  1532,  1536,  1551,  1559,  1564,  1569,  1570,  1571,
    1572,  1573,  1577,  1578,  1579,  1583,  1594,  1595,  1599,  1630,
    1641,  1647,  1655,  1662,  1672,  1673,  1680,  1686,  1693,  1712,
    1732,  1730,  1792,  1793,  1797,  1798,  1802,  1803,  1807,  1808,
    1809,  1810,  1812,  1814,  1819,  1820,  1821,  1825,  1842,  1840,
    1967,  1968,  1972,  1976,  1984,  1990,  1997,  2004,  2012,  2020,
    2030,  2034,  2042,  2046,  2058,  2059,  2060,  2065,  2064,  2118,
    2122,  2123,  2127,  2128,  2133,  2155,  2156,  2161,  2185,  2186,
    2191,  2230,  2238,  2246,  2257,  2258,  2259,  2260,  2264,  2265,
    2267,  2268,  2273,  2274,  2275,  2276,  2277,  2278,  2279,  2280,
    2281,  2282,  2283,  2287,  2288,  2289,  2294,  2300,  2311,  2317,
    2323,  2329,  2342,  2349,  2356,  2362,  2368,  2374,  2383,  2384,
    2389,  2393,  2399,  2405,  2416,  2431,  2444,  2443,  2492,  2491,
    2539,  2545,  2551,  2557,  2563,  2577,  2591,  2609,  2621,  2627,
    2633,  2639,  2655,  2664,  2665,  2672
};
#endif

/** Accessing symbol of state STATE.  */
#define YY_ACCESSING_SYMBOL(State) YY_CAST (yysymbol_kind_t, yystos[State])

#if 1
/* The user-facing name of the symbol whose (internal) number is
   YYSYMBOL.  No bounds checking.  */
static const char *yysymbol_name (yysymbol_kind_t yysymbol) YY_ATTRIBUTE_UNUSED;

static const char *
yysymbol_name (yysymbol_kind_t yysymbol)
{
  static const char *const yy_sname[] =
  {
  N_("end of file"), N_("error"), N_("invalid token"),
  N_("integer literal"), "LEXER_EXCEPTION", N_("character literal"),
  N_("string"), N_("identifier"), N_("type name"), N_("offset unit"),
  N_("offset"), N_("keyword `asm'"), N_("keyword `enum'"),
  N_("keyword `pinned'"), N_("keyword `struct'"), N_("keyword `union'"),
  N_("keyword `const'"), N_("keyword `continue'"), N_("keyword `else'"),
  N_("keyword `if'"), N_("keyword `while'"), N_("keyword `until'"),
  N_("keyword `for'"), N_("keyword `in'"), N_("keyword `where'"),
  N_("keyword `sizeof'"), N_("keyword `typeof'"), N_("keyword `assert'"),
  N_("keyword `apush'"), N_("keyword `apop'"), N_("token"), "ALIEN",
  N_("int type constructor"), N_("uint type constructor"),
  N_("offset type constructor"), N_("keyword `fun'"),
  N_("keyword `defset'"), N_("keyword `type'"), N_("keyword `var'"),
  N_("keyword `unit'"), N_("keyword `method'"), N_("keyword `return'"),
  N_("keyword `break'"), N_("string type specifier"), N_("keyword `try'"),
  N_("keyword `catch'"), N_("keyword `raise'"), N_("void type specifier"),
  N_("any type specifier"), N_("keyword `print'"), N_("keyword `printf'"),
  N_("keyword `load'"), N_("keyword `lambda'"), N_("keyword `format'"),
  N_("keyword `computed'"), "IMMUTABLE", "BUILTIN_TERM_GET_COLOR",
  "BUILTIN_TERM_SET_COLOR", "BUILTIN_TERM_GET_BGCOLOR",
  "BUILTIN_TERM_SET_BGCOLOR", N_("power-and-assign operator"),
  N_("multiply-and-assign operator"), N_("divide-and-assing operator"),
  N_("modulus-and-assign operator"), N_("add-and-assing operator"),
  N_("subtract-and-assign operator"), N_("shift-left-and-assign operator"),
  N_("shift-right-and-assign operator"), N_("bit-and-and-assign operator"),
  N_("bit-xor-and-assign operator"), N_("bit-or-and-assign operator"),
  N_("range separator"), N_("logical or operator"),
  N_("logical and operator"), N_("logical implication operator"),
  N_("bit-wise or operator"), N_("bit-wise xor operator"),
  N_("bit-wise and operator"), N_("equality operator"),
  N_("inequality operator"), N_("less-or-equal operator"),
  N_("bigger-or-equal-than operator"), N_("less-than operator"),
  N_("bigger-than operator"), N_("left shift operator"),
  N_("right shift operator"), N_("addition operator"),
  N_("subtraction operator"), N_("multiplication operator"),
  N_("division operator"), N_("ceiling division operator"),
  N_("modulus operator"), N_("power operator"),
  N_("bit-concatenation operator"), N_("map operator"),
  N_("non-strict map operator"), N_("increment operator"),
  N_("decrement operator"), N_("cast operator"),
  N_("type identification operator"), N_("dot operator"), N_("attribute"),
  N_("unmap operator"), N_("remap operator"),
  N_("conditional on exception operator"), N_("keyword `big'"),
  N_("keyword `little'"), N_("keyword `signed'"), N_("keyword `unsigned'"),
  N_("varargs indicator"), "THEN", "'?'", "':'", "UNARY", "HYPERUNARY",
  "START_EXP", "START_DECL", "START_STMT", "START_PROGRAM", "','", "';'",
  "'('", "')'", "'~'", "'!'", ".>", "'['", "']'", "'{'", "'}'", "'='",
  "$accept", "pushlevel", "start", "program", "program_elem_list",
  "program_elem", "load", "integer", "identifier", "expression_list",
  "expression_opt", "expression", "bconc", "mapop", "map",
  "unary_operator", "primary", "$@1", "funcall", "funcall_arg_list",
  "funcall_arg", "format_arg_list", "format_arg", "opt_comma",
  "struct_field_list", "struct_field", "array", "array_initializer_list",
  "array_initializer", "pushlevel_args", "function_specifier",
  "function_arg_list", "function_arg", "function_arg_initial",
  "type_specifier", "typename", "string_type_specifier",
  "simple_type_specifier", "cons_type_specifier",
  "integral_type_specifier", "integral_type_sign", "offset_type_specifier",
  "array_type_specifier", "function_type_specifier",
  "function_type_arg_list", "function_type_arg", "struct_type_specifier",
  "$@2", "struct_or_union", "struct_type_pinned", "integral_struct",
  "struct_type_elem_list", "endianness", "struct_type_computed_field",
  "struct_type_field", "$@3", "struct_type_field_identifier",
  "struct_type_field_label", "struct_type_field_constraint_and_init",
  "struct_type_field_optcond_pre", "struct_type_field_optcond_post",
  "simple_declaration", "declaration", "@4", "defun_or_method",
  "defvar_list", "defvar", "deftype_list", "deftype", "defunit_list",
  "defunit", "comp_stmt", "builtin", "stmt_decl_list", "ass_exp_op",
  "simple_stmt_list", "simple_stmt", "stmt", "@5", "@6", "funcall_stmt",
  "funcall_stmt_arg_list", "funcall_stmt_arg", YY_NULLPTR
  };
  /* YYTRANSLATABLE[SYMBOL-NUM] -- Whether YY_SNAME[SYMBOL-NUM] is
     internationalizable.  */
  static yytype_int8 yytranslatable[] =
  {
       1,     1,     1,     1,     0,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     0,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     0,     0,     0,     0,     0,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0
  };
  return (yysymbol < YYNTOKENS && yytranslatable[yysymbol]
          ? _(yy_sname[yysymbol])
          : yy_sname[yysymbol]);
}
#endif

#ifdef YYPRINT
/* YYTOKNUM[NUM] -- (External) token number corresponding to the
   (internal) symbol number NUM (which must be that of a token).  */
static const yytype_int16 yytoknum[] =
{
       0,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   124,    94,    38,   330,   331,
     332,   333,    60,    62,   334,   335,    43,    45,    42,    47,
     336,    37,   337,   338,    64,   339,   340,   341,   342,   343,
      46,   344,   345,   346,   347,   348,   349,   350,   351,   352,
     353,    63,    58,   354,   355,   356,   357,   358,   359,    44,
      59,    40,    41,   126,    33,   360,    91,    93,   123,   125,
      61
};
#endif

#define YYPACT_NINF (-428)

#define yypact_value_is_default(Yyn) \
  ((Yyn) == YYPACT_NINF)

#define YYTABLE_NINF (-269)

#define yytable_value_is_error(Yyn) \
  ((Yyn) == YYTABLE_NINF)

  /* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
     STATE-NUM.  */
static const yytype_int16 yypact[] =
{
     106,  2829,   168,  1737,   819,    23,  -428,  -428,  -428,  -428,
    -428,  -428,  -428,  -428,   379,   -90,    -9,    25,    29,  -428,
    -428,   379,  -428,  -428,  -428,  -428,    33,  -428,  -428,  2829,
    2829,  -428,  -428,  2829,  -428,  -428,  2421,   -41,  -428,  4839,
    -428,  -428,  2829,    44,  -428,  -428,   -26,    43,   -75,    51,
    -428,    52,  -428,    72,   -71,  -428,    68,    68,    68,  -428,
      80,    94,    68,    26,    98,   120,   126,   141,   143,  2545,
     107,  1845,  2557,  2829,    -5,   227,  -428,   166,  5098,   145,
     153,  2964,   -71,   172,   178,  -428,   168,  -428,   927,  -428,
    -428,  -428,  -428,  -428,  -428,  -428,   -82,  -428,   379,  2829,
    2829,  2829,   -18,   182,   279,   208,   208,  3649,   284,   188,
     174,  5098,   193,  -428,  -428,  -428,  -428,  -428,  1035,  -428,
    -428,  2829,  2829,  2829,  2829,  2829,  2829,  2829,  2829,  2829,
    2829,  2829,  2829,  2829,  2829,  2829,  2829,  2829,  2829,  2829,
    2829,  2829,  2829,  2829,  -428,  -428,   379,   379,   194,  2829,
    2829,  -428,   218,    68,  2137,    68,  2681,  1209,  -428,  -428,
    1480,  2829,  2149,   237,  2829,  -428,  -428,   192,   205,  -428,
     195,   211,  -428,   202,   223,  -428,  -428,  -428,  -428,  2829,
    -428,  2829,  2829,    -3,  2829,  -428,  4499,  -428,     5,  -428,
    4584,  4669,  2273,   331,   232,   233,  -428,  2829,  2829,  -428,
    -428,  -428,  -428,  -428,  -428,  -428,  -428,  -428,  -428,  -428,
     348,  2829,  2829,   249,  -428,  -428,  -428,  -428,  -428,   244,
     -16,  3734,   155,  4887,  3819,   191,  -428,  -428,   -60,  2285,
    -428,  -428,  2829,  1377,   236,  -428,  -428,  1143,  -428,   800,
    3527,  1992,  5098,   908,  1012,  1596,  1193,  1193,  1357,  1357,
    1357,  1357,  1630,  1630,   698,   698,   282,   282,   282,   282,
     293,   230,   241,   241,  2829,  1193,  4972,  -428,  5098,    54,
    -428,  -428,  1546,  2969,   238,   -88,   239,  5098,   252,  -428,
    -428,  3054,  5013,   263,  5098,  -428,  1193,   212,    68,  2829,
      68,  2829,    68,   265,  3479,  3904,  3989,   349,  2693,   321,
     637,  -428,  2829,    -8,  -428,  -428,  5098,    69,  -428,  2285,
    -428,  -428,  5098,  5098,  2829,  5098,  5098,  -428,  2829,  -428,
    -428,  -428,  2829,  -428,   310,   319,   246,  -428,    90,  3139,
    -428,  -428,  -428,  -428,  -428,  4074,  2829,  2829,  -428,  -428,
    3224,  2829,  1612,  -428,  2829,  1311,   274,  -428,  2829,  2817,
     285,    49,   391,  -428,   241,  -428,  -428,  -428,  5098,  -428,
    5098,  -428,   182,  2013,  -428,  1845,  1845,  2829,   288,  5098,
     294,  2829,  -428,  4754,  2829,  -428,  -428,  2829,  -428,   129,
    5098,  3564,  4159,  -428,  -428,   306,   296,   297,    17,  -428,
    -428,   289,  -428,  5142,  -428,  -428,  3309,  -428,  3394,  5098,
    -428,  -428,  5098,  5098,  -428,  -428,   379,   -89,   298,   302,
    -428,   242,  -428,   -28,   407,  -428,  5098,  1911,  2693,  4244,
    -428,  5098,   246,  5098,  -428,  2149,  -428,  -428,  -428,   379,
     246,   299,  -428,  2829,  -428,  -428,   241,  -428,   379,     6,
    -428,  -428,   379,  2149,  2829,  -428,  1845,   406,   312,   139,
    -428,   311,  -428,  -428,   313,   151,   -47,  -428,  2829,  -428,
    5098,   241,  -428,   241,   308,   165,  -428,   315,   410,  2409,
    1845,  1911,  -428,  -428,  -428,  5098,   309,  -428,  1845,  2829,
    -428,  -428,   177,  -428,  -428,  -428,     8,  -428,  4329,  1845,
     323,   212,   147,  -428,  -428,   163,  -428,  1845,  -428,  2829,
      68,  -428,  -428,  -428,  -428,  -428,  -428,   212,  -428,  4414,
     327,    68,  -428,  -428,  -428,  -428,   -42,  2829,  2829,  2829,
     351,  5098,  2884,  5057,  2829,   429,  2829,  2829,  5098,  2829,
     329,  5098,  5098,  5098,  -428
};

  /* YYDEFACT[STATE-NUM] -- Default reduction number in state STATE-NUM.
     Performed when YYTABLE does not specify something else to do.  Zero
     means the default is an error.  */
static const yytype_int16 yydefact[] =
{
       0,     2,     0,     2,     2,     0,    22,    23,    82,    83,
      80,   143,    62,    63,     0,     0,     0,     0,     0,   156,
     157,     0,   144,   146,   145,    96,     0,    75,    74,     2,
       2,    78,    79,     2,    76,    77,     2,     0,    81,     3,
      67,    68,     2,    31,    94,    85,   147,   151,     0,     0,
     148,     0,   149,   150,     0,   210,     0,     0,     0,   211,
       0,     5,     0,     0,     0,     0,     0,     0,     0,     2,
       0,     2,     2,     2,     0,     0,   259,     9,   250,    67,
      68,    31,   258,     0,     7,   254,     0,    11,     2,    14,
      19,    16,    18,     1,   147,   151,     0,   150,     0,     2,
       2,     2,     0,     0,     0,    65,    66,     0,    31,     0,
       0,   129,   119,   127,   224,   225,   226,   227,     2,   223,
      64,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,   101,   102,     0,     0,    33,     2,
       2,     4,    32,     0,     2,     0,     2,     2,    70,    71,
       2,     2,     2,     0,     2,    25,    24,     0,   205,   215,
       0,   204,   212,     0,   206,   218,   209,     6,   207,     2,
     271,     2,     2,     2,     2,   272,     0,   270,     0,   278,
       0,     0,     2,     0,     0,     0,    10,     2,     2,   232,
     233,   234,   235,   236,   237,   238,   239,   240,   242,   241,
       0,     2,     2,   282,   283,   260,     8,    17,    15,     0,
       0,     0,     0,     0,     0,     0,   131,    97,     0,     2,
      84,    95,     2,     2,     0,   221,   230,     2,   228,    56,
      54,    53,    55,    50,    51,    52,    44,    45,    48,    49,
      46,    47,    42,    43,    35,    36,    37,    38,    39,    41,
      40,    69,    57,    58,     2,    61,     0,    87,   114,     0,
     112,    86,     2,     0,    80,   143,     0,   124,   119,   122,
     160,     0,    72,   119,    27,   155,    60,     2,     0,     2,
       0,     2,     0,     0,     0,     0,     0,     0,     2,     0,
       0,   273,     2,     2,   279,   280,   118,     0,   116,     2,
      21,    20,   248,   249,     2,   246,   247,   284,     2,   105,
     103,   104,     2,   107,     0,     0,     0,   131,     0,     0,
     128,   126,   222,   231,   229,     0,     2,     2,   110,    91,
       0,     2,     2,    88,     2,     2,     0,   161,     2,     2,
       0,     0,   174,   217,   140,   142,   141,   216,   214,   213,
     220,   219,     0,     2,   255,     2,     2,     2,     0,    30,
       0,     2,   252,     0,     2,     2,   274,     2,   281,     0,
     285,     0,     0,   159,   158,     0,     0,   134,     0,     2,
     100,     0,    34,    59,   113,    92,     0,    93,     0,   125,
     123,   109,    73,    28,   108,   168,     0,   166,     0,   164,
     175,     0,   208,     0,   261,   263,     2,     2,     2,     0,
     277,     2,     0,   117,   251,     2,    98,   106,   137,     0,
       0,   138,   133,     2,    89,    90,   163,   167,     0,     0,
     172,   173,   176,     2,     2,   256,     2,   266,     0,     0,
     244,     0,   253,   275,     0,     0,     0,   135,     2,   136,
     130,   162,   165,   177,     0,     0,   262,     0,     0,     2,
       2,     2,     2,    99,     2,   139,   170,   257,     2,     2,
     245,   265,     0,   276,   132,   169,   200,   267,     0,     2,
       0,     2,   200,   179,   178,   184,   180,     2,   264,     2,
       0,   171,   183,   182,   181,   186,   185,     2,   269,     0,
       0,   190,   201,   187,   191,   188,   194,     2,     2,     2,
     192,   199,   195,   196,     2,   202,     2,     2,   193,     2,
       0,   198,   197,   203,   189
};

  /* YYPGOTO[NTERM-NUM].  */
static const yytype_int16 yypgoto[] =
{
    -428,  -173,  -428,  -428,  -428,   365,   451,   -48,   -50,  -358,
      37,    -1,   148,  -428,   164,  -428,    86,  -428,  -428,  -428,
     119,  -216,  -428,  -174,  -428,   113,  -428,  -428,   226,   133,
     100,    34,    45,  -428,  -427,   253,   325,   251,  -428,  -428,
    -428,  -428,   343,  -428,    27,  -428,  -428,  -428,  -428,  -428,
    -428,  -428,  -428,   -27,   -24,  -428,  -428,  -428,  -428,  -428,
    -428,   170,     0,  -428,  -428,  -428,   180,  -428,   187,  -428,
     184,    74,  -428,  -428,  -428,     9,  -408,   108,  -428,  -428,
     444,  -428,   266
};

  /* YYDEFGOTO[NTERM-NUM].  */
static const yytype_int16 yydefgoto[] =
{
       0,    37,     5,    87,    88,    89,    90,    38,   385,   283,
     368,    78,    40,   161,    41,    42,    43,   103,    44,   269,
     270,   307,   308,   234,   278,   279,    45,   112,   113,   326,
     227,   386,   387,   459,   353,    46,    47,    48,    49,    50,
      51,    52,    53,   355,   408,   409,   356,   486,   442,   411,
     464,   492,   507,   493,   494,   516,   515,   525,   520,   495,
     530,    60,    91,   293,    62,   171,   172,   168,   169,   174,
     175,    54,   119,   237,   212,   449,    83,    92,   467,   468,
      85,   213,   214
};

  /* YYTABLE[YYPACT[STATE-NUM]] -- What to do in state STATE-NUM.  If
     positive, shift that token.  If negative, reduce the rule whose
     number is the opposite.  If YYTABLE_NINF, syntax error.  */
static const yytype_int16 yytable[] =
{
      39,   192,    61,   163,   297,   413,   167,   170,   173,   450,
     299,   374,   178,   328,    11,   114,   115,   116,   117,   158,
     159,   -24,   437,    93,   165,   166,   302,   490,   105,   106,
     219,    98,   107,   164,    11,   111,   517,   160,    19,    20,
      21,   152,   -24,    55,   160,    56,    57,    58,    59,    22,
     303,   160,   327,    23,    24,     6,     7,    11,    19,    20,
      21,   480,   491,   450,   500,   474,   160,   455,   186,    22,
     518,   190,   191,    23,    24,   165,   166,    82,    82,   160,
     511,    19,    20,    21,   443,   465,   217,   118,   519,    81,
      81,   444,    22,   379,   445,  -152,    23,    24,   221,   223,
     224,   225,   157,   267,   346,   271,   319,   276,   160,   350,
     160,    84,    99,   375,   352,   405,   193,   298,   236,   108,
     239,   240,   241,   242,   243,   244,   245,   246,   247,   248,
     249,   250,   251,   252,   253,   254,   255,   256,   257,   258,
     259,   260,   261,   160,   153,    82,   100,   179,   265,   266,
     101,    79,    79,   268,   104,   273,   277,    81,   405,   281,
     282,   284,    82,   286,  -154,   154,   490,    80,    80,   155,
     156,   406,   162,   337,    81,   325,   338,   324,   294,   188,
     295,   296,    55,   300,    56,    57,    58,    59,   377,   378,
      11,   306,    82,  -153,     6,     7,   312,   313,   165,   166,
     176,   491,   422,    55,    81,    56,    57,    58,    59,   377,
     315,   316,   390,   177,    19,    20,    21,  -269,   180,    79,
      11,     1,     2,     3,     4,    22,   238,   187,   306,    23,
      24,   329,   111,   194,   195,    80,    79,   333,   167,   120,
     170,   181,   173,   447,    19,    20,    21,   182,   377,   158,
     159,   424,    80,   165,   275,    22,   440,   441,   469,    23,
      24,   470,   183,   335,   184,    96,    79,    94,   505,   506,
     444,   340,   102,   473,    94,   197,   501,   321,    19,    20,
      21,   160,    80,   198,   444,   229,   196,   477,   358,    22,
     360,   120,   215,    23,    24,   276,   469,   369,   216,   489,
     232,   373,   120,   226,  -269,  -269,   146,   147,   306,   148,
     231,    82,   233,   380,    96,   264,    94,   381,   352,   148,
     285,   382,   287,    81,   288,   289,   144,   145,   146,   147,
     290,   148,   291,   351,   352,   393,   268,   309,   431,    95,
     396,   398,   292,   399,   277,   334,    95,   402,   403,   220,
     222,    94,   310,   311,   228,   314,    94,    97,    56,    57,
      58,   210,   284,   331,    97,   318,   416,   160,   -25,   344,
     419,   345,   367,   421,   142,   143,   423,   376,   144,   145,
     146,   147,   349,   148,   153,    79,   143,    11,    95,   144,
     145,   146,   147,   383,   148,   362,   210,   262,   263,    94,
      94,    80,   384,   401,   410,   154,    97,   404,   417,   155,
     156,    19,    20,    21,   418,   428,   430,   369,   429,   433,
     438,   439,    22,    95,   284,   446,    23,    24,    95,   458,
    -268,   471,   460,   193,   479,   472,   476,   478,   485,    82,
      82,    97,   284,   403,   499,   524,    97,   513,   529,   534,
     510,    81,    81,   218,    77,   451,   394,   475,   400,   330,
     389,   514,   412,   432,   457,   502,   462,   454,   503,   370,
     359,    95,    95,   414,   415,   357,   361,   109,   488,   317,
     482,     0,     0,     0,     0,     0,   496,     0,     0,    97,
      97,     0,   504,     0,     0,   453,     0,     0,   509,     0,
       0,     0,     0,    81,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    79,    79,     0,   521,   522,   523,     0,
      82,     0,     0,   528,     0,   531,   532,     0,   533,    80,
      80,     0,    81,     0,     0,     0,     0,     0,   354,     0,
      94,     0,     0,     0,    82,     0,   483,     0,   484,     0,
       0,     0,    82,     0,   466,    81,    81,    81,     0,     0,
       0,     0,     0,    82,    81,    79,     0,     0,     0,     0,
       0,    82,     0,     0,     0,    81,     0,   388,   481,    94,
       0,    80,     0,    81,     0,     0,   487,     0,     0,     0,
       0,     0,     0,     0,    79,     0,     0,   498,     0,     0,
       0,     0,   407,     0,    94,   508,     0,     0,     0,     0,
      80,     0,    95,   228,     0,    94,     0,    79,    79,    79,
       0,     0,     0,     0,     0,     0,    79,     0,     0,     0,
      97,     0,     0,    80,    80,    80,     0,    79,     0,     0,
       0,     0,    80,     0,     0,    79,   120,     0,     0,     0,
       0,    95,     0,    80,     0,     0,     0,   436,     0,    94,
     121,    80,     0,     0,     0,     0,     0,     0,     0,    97,
       0,     0,     0,   388,     0,    94,    95,     0,     0,     0,
     456,   388,    94,    94,     0,     0,     0,    95,     0,   461,
     407,    94,    94,   463,    97,    94,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    97,     0,   120,     0,   122,
     123,   124,   125,   126,   127,   128,   129,   130,   131,   132,
     133,   134,   135,   136,   137,   138,   139,   140,   141,   142,
     143,    95,     0,   144,   145,   146,   147,     0,   148,     0,
       0,   149,   354,     0,    94,     0,     0,    95,   150,    97,
       0,     0,     0,     0,    95,    95,   371,     0,   354,   372,
      94,     0,     0,    95,    95,    97,     0,    95,     0,     0,
       0,     0,    97,    97,     0,     0,     0,     0,     0,     0,
       0,    97,    97,     0,     0,    97,   138,   139,   140,   141,
     142,   143,     0,     0,   144,   145,   146,   147,     0,   148,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   120,
       0,     0,     0,     0,     0,     0,    95,     0,     0,   -12,
       0,     0,     6,     7,     8,     9,    10,    11,    12,    13,
      63,     0,    95,     0,    97,     0,    64,     0,    65,    66,
       0,    67,     0,     0,    15,    16,    68,    17,    18,     0,
      97,    19,    20,    21,    55,     0,    56,    57,    58,    59,
      69,    70,    22,    71,     0,    72,    23,    24,    73,    74,
      75,    25,    26,     0,    86,   125,   126,   127,   128,   129,
     130,   131,   132,   133,   134,   135,   136,   137,   138,   139,
     140,   141,   142,   143,     0,     0,   144,   145,   146,   147,
       0,   148,     0,     0,   149,    27,    28,     0,     0,     0,
       0,     0,     0,     0,     0,    29,    30,   120,     0,     0,
       0,    31,    32,     0,     0,     0,     0,   -13,     0,     0,
       6,     7,     8,     9,    10,    11,    12,    13,    63,    76,
      33,     0,    34,    35,    64,    36,    65,    66,     0,    67,
       0,     0,    15,    16,    68,    17,    18,     0,     0,    19,
      20,    21,    55,     0,    56,    57,    58,    59,    69,    70,
      22,    71,     0,    72,    23,    24,    73,    74,    75,    25,
      26,     0,    86,     0,   126,   127,   128,   129,   130,   131,
     132,   133,   134,   135,   136,   137,   138,   139,   140,   141,
     142,   143,     0,     0,   144,   145,   146,   147,     0,   148,
       0,     0,   149,    27,    28,     0,     0,     0,     0,     0,
       0,   120,     0,    29,    30,     0,     0,     0,     0,    31,
      32,     0,     0,     0,     0,     0,     0,     0,     6,     7,
       8,     9,    10,    11,    12,    13,    63,    76,    33,     0,
      34,    35,    64,    36,    65,    66,     0,    67,     0,     0,
      15,    16,    68,    17,    18,     0,     0,    19,    20,    21,
      55,     0,    56,    57,    58,    59,    69,    70,    22,    71,
       0,    72,    23,    24,    73,    74,     0,    25,    26,   127,
     128,   129,   130,   131,   132,   133,   134,   135,   136,   137,
     138,   139,   140,   141,   142,   143,     0,     0,   144,   145,
     146,   147,     0,   148,     0,     0,   149,     0,     0,     0,
       0,    27,    28,     0,     0,     0,     0,     0,     0,     0,
       0,    29,    30,     0,     0,     0,     0,    31,    32,     0,
       0,     0,     0,     0,     0,     0,     6,     7,     8,     9,
      10,    11,    12,    13,    63,    76,    33,     0,    34,    35,
      64,    36,    65,    66,   235,    67,     0,     0,    15,    16,
      68,    17,    18,     0,     0,    19,    20,    21,    55,     0,
      56,    57,    58,    59,    69,    70,    22,    71,     0,    72,
      23,    24,    73,    74,     0,    25,    26,     0,     0,     0,
       0,     0,   120,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     6,     7,     8,     9,   274,   275,    12,    13,
      14,     0,     0,     0,     0,     0,     0,     0,     0,    27,
      28,     0,     0,     0,    15,    16,     0,    17,    18,    29,
      30,    19,    20,    21,     0,    31,    32,     0,     0,     0,
       0,     0,    22,     0,     0,     0,    23,    24,     0,     0,
       0,    25,    26,    76,    33,     0,    34,    35,     0,    36,
       0,     0,   332,   130,   131,   132,   133,   134,   135,   136,
     137,   138,   139,   140,   141,   142,   143,     0,     0,   144,
     145,   146,   147,     0,   148,    27,    28,     0,     0,     0,
       0,     0,     0,     0,     0,    29,    30,     0,     0,     0,
       0,    31,    32,     0,     6,     7,     8,     9,   274,   275,
      12,    13,    14,     0,     0,     0,     0,     0,  -121,     0,
      33,     0,    34,    35,     0,    36,    15,    16,  -121,    17,
      18,     0,     0,    19,    20,    21,     0,     0,     0,     0,
       0,     0,     0,     0,    22,     0,     0,     0,    23,    24,
       0,     0,     0,    25,    26,     0,   120,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       6,     7,     8,     9,    10,    11,    12,    13,    14,     0,
       0,     0,     0,     0,     0,     0,     0,    27,    28,     0,
       0,     0,    15,    16,     0,    17,    18,    29,    30,    19,
      20,    21,     0,    31,    32,     0,     0,     0,     0,     0,
      22,     0,     0,     0,    23,    24,     0,     0,     0,    25,
      26,     0,    33,     0,    34,    35,     0,    36,     0,     0,
    -120,   134,   135,   136,   137,   138,   139,   140,   141,   142,
     143,     0,     0,   144,   145,   146,   147,     0,   148,     0,
       0,     0,     0,    27,    28,     0,     0,     0,     0,     0,
       0,     0,     0,    29,    30,     0,     0,   110,     0,    31,
      32,     0,     0,     6,     7,     8,     9,    10,    11,    12,
      13,    14,     0,     0,     0,     0,     0,     0,    33,     0,
      34,    35,     0,    36,  -120,    15,    16,     0,    17,    18,
       0,     0,    19,    20,    21,     0,     0,     0,     0,     0,
       0,     0,     0,    22,     0,     0,     0,    23,    24,     0,
       0,     0,    25,    26,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     6,
       7,     8,     9,    10,    11,    12,    13,    14,     0,     0,
       0,     0,     0,     0,     0,     0,    27,    28,     0,     0,
       0,    15,    16,     0,    17,    18,    29,    30,    19,    20,
      21,     0,    31,    32,     0,     0,     0,     0,     0,    22,
       0,     0,     0,    23,    24,     0,     0,     0,    25,    26,
       0,    33,     0,    34,    35,   120,    36,   280,     0,     0,
       0,     0,     0,     0,     0,     6,     7,     8,     9,    10,
      11,    12,    13,    14,     0,     0,     0,     0,     0,     0,
       0,     0,    27,    28,     0,     0,     0,    15,    16,   120,
      17,    18,    29,    30,    19,    20,    21,     0,    31,    32,
       0,     0,     0,     0,     0,    22,     0,     0,     0,    23,
      24,     0,     0,     0,    25,    26,     0,    33,     0,    34,
      35,     0,    36,   339,   128,   129,   130,   131,   132,   133,
     134,   135,   136,   137,   138,   139,   140,   141,   142,   143,
       0,     0,   144,   145,   146,   147,     0,   148,    27,    28,
     149,     0,     0,     0,     0,     0,     0,     0,    29,    30,
       0,     0,     0,     0,    31,    32,   136,   137,   138,   139,
     140,   141,   142,   143,     0,     0,   144,   145,   146,   147,
       0,   148,     0,    33,     0,    34,    35,     0,    36,   397,
       6,     7,     8,     9,    10,    11,    12,    13,    63,     0,
       0,     0,     0,     0,    64,     0,    65,    66,     0,    67,
       0,     0,    15,    16,    68,    17,    18,     0,     0,    19,
      20,    21,     0,     0,     0,     0,     0,     0,    69,    70,
      22,    71,     0,    72,    23,    24,    73,    74,    75,    25,
      26,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    27,    28,     0,     0,     0,     0,     0,
       0,     0,     0,    29,    30,     0,     0,     0,     0,    31,
      32,     0,     0,     0,     0,     0,     0,     0,     6,     7,
       8,     9,    10,    11,    12,    13,    63,    76,    33,     0,
      34,    35,    64,    36,    65,    66,     0,    67,     0,     0,
      15,    16,    68,    17,    18,     0,     0,    19,    20,    21,
       0,     0,     0,     0,     0,     0,    69,    70,    22,    71,
       0,    72,    23,    24,    73,    74,     0,    25,    26,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     6,     7,     8,     9,    10,    11,
      12,    13,    63,     0,     0,     0,     0,     0,     0,     0,
       0,    27,    28,     0,     0,     0,    15,    16,    68,    17,
      18,    29,    30,    19,    20,    21,     0,    31,    32,     0,
       0,     0,     0,     0,    22,     0,     0,     0,    23,    24,
       0,   448,     0,    25,    26,    76,    33,     0,    34,    35,
       0,    36,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    27,    28,     0,
       0,   120,     0,     0,     0,     0,     0,    29,    30,     0,
       0,     0,     0,    31,    32,   121,     6,     7,     8,     9,
      10,    11,    12,    13,    14,     0,     0,     0,     0,     0,
    -243,     0,    33,  -243,    34,    35,     0,    36,    15,    16,
       0,    17,    18,     0,     0,    19,    20,    21,     0,     0,
       0,     0,     0,     0,     0,     0,    22,     0,     0,     0,
      23,    24,     0,     0,     0,    25,    26,   125,   126,   127,
     128,   129,   130,   131,   132,   133,   134,   135,   136,   137,
     138,   139,   140,   141,   142,   143,     0,     0,   144,   145,
     146,   147,     0,   148,     0,     0,   149,     0,     0,    27,
      28,     0,     0,     0,     0,     0,     0,     0,     0,    29,
      30,     0,     0,     0,     0,    31,    32,     0,     0,     0,
       0,     0,     0,     0,     0,   -26,     0,     0,     0,     0,
       0,     0,   -26,     0,    33,   -26,    34,    35,     0,    36,
       6,     7,     8,     9,    10,    11,    12,    13,    14,     0,
       0,     0,     6,     7,     8,     9,    10,    11,    12,    13,
      14,     0,    15,    16,     0,    17,    18,     0,     0,    19,
      20,    21,     0,     0,    15,    16,     0,    17,    18,     0,
      22,    19,    20,    21,    23,    24,     0,     0,     0,    25,
      26,     0,    22,     0,     0,     0,    23,    24,     0,     0,
       0,    25,    26,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    27,    28,     0,     0,     0,     0,     0,
       0,     0,     0,    29,    30,    27,    28,     0,     0,    31,
      32,     0,     0,     0,     0,    29,    30,     0,     0,     0,
       0,    31,    32,     0,     0,     0,  -111,     0,    33,  -111,
      34,    35,     0,    36,     0,     0,     0,     0,   -26,     0,
      33,   -26,    34,    35,     0,    36,     6,     7,     8,     9,
      10,    11,    12,    13,    14,     0,     0,     0,     6,     7,
       8,     9,    10,    11,    12,    13,    14,     0,    15,    16,
       0,    17,    18,     0,     0,    19,    20,    21,     0,     0,
      15,    16,     0,    17,    18,     0,    22,    19,    20,    21,
      23,    24,     0,     0,     0,    25,    26,     0,    22,     0,
       0,     0,    23,    24,     0,     0,     0,    25,    26,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    27,
      28,     0,     0,     0,     0,     0,     0,     0,     0,    29,
      30,    27,    28,     0,     0,    31,    32,     0,     0,     0,
       0,    29,    30,     0,     0,     0,     0,    31,    32,     0,
       0,     0,  -115,  -115,    33,     0,    34,    35,     0,    36,
       0,     0,     0,     0,  -115,     0,    33,  -115,    34,    35,
       0,    36,     6,     7,     8,     9,    10,    11,    12,    13,
      63,     0,     0,     0,     6,     7,     8,     9,    10,    11,
      12,    13,    14,     0,    15,    16,    68,    17,    18,     0,
       0,    19,    20,    21,     0,     0,    15,    16,     0,    17,
      18,     0,    22,    19,    20,    21,    23,    24,     0,   448,
       0,    25,    26,     0,    22,     0,     0,     0,    23,    24,
       0,     0,     0,    25,    26,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    27,    28,     0,     0,     0,
       0,     0,     0,     0,     0,    29,    30,    27,    28,     0,
       0,    31,    32,     0,     0,     0,     0,    29,    30,     0,
       0,   110,     0,    31,    32,     0,     0,     0,     0,     0,
      33,     0,    34,    35,     0,    36,     0,     0,     0,     0,
       0,     0,    33,     0,    34,    35,     0,    36,     6,     7,
       8,     9,    10,    11,    12,    13,    14,     0,     0,     0,
       6,     7,     8,     9,    10,    11,    12,    13,    14,     0,
      15,    16,     0,    17,    18,     0,     0,    19,    20,    21,
       0,     0,    15,    16,     0,    17,    18,     0,    22,    19,
      20,    21,    23,    24,     0,     0,     0,    25,    26,     0,
      22,     0,     0,     0,    23,    24,     0,     0,     0,    25,
      26,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    27,    28,     0,     0,     0,     0,     0,     0,     0,
       0,    29,    30,    27,    28,     0,     0,    31,    32,     0,
       0,     0,     0,    29,    30,     0,     0,     0,     0,    31,
      32,     0,     0,     0,     0,   185,    33,     0,    34,    35,
       0,    36,     0,     0,     0,     0,     0,   189,    33,     0,
      34,    35,     0,    36,     6,     7,     8,     9,    10,    11,
      12,    13,    14,     0,     0,     0,     6,     7,     8,     9,
      10,    11,    12,    13,    14,     0,    15,    16,     0,    17,
      18,     0,     0,    19,    20,    21,     0,     0,    15,    16,
       0,    17,    18,     0,    22,    19,    20,    21,    23,    24,
       0,     0,     0,    25,    26,     0,    22,     0,     0,     0,
      23,    24,     0,     0,     0,    25,    26,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    27,    28,     0,
       0,     0,     0,     0,     0,     0,     0,    29,    30,    27,
      28,     0,     0,    31,    32,     0,     0,     0,     0,    29,
      30,     0,     0,   272,     0,    31,    32,     0,     0,     0,
       0,     0,    33,     0,    34,    35,     0,    36,     0,     0,
       0,     0,     0,   -29,    33,     0,    34,    35,     0,    36,
       6,     7,     8,     9,    10,    11,    12,    13,    14,     0,
       0,     0,     6,     7,     8,     9,    10,    11,    12,    13,
      14,     0,    15,    16,     0,    17,    18,     0,     0,    19,
      20,    21,     0,     0,    15,    16,     0,    17,    18,     0,
      22,    19,    20,    21,    23,    24,     0,     0,     0,    25,
      26,     0,    22,     0,     0,     0,    23,    24,     0,     0,
       0,    25,    26,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   120,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    27,    28,     0,     0,   121,     0,     0,
       0,     0,     0,    29,    30,    27,    28,     0,     0,    31,
      32,     0,     0,     0,     0,    29,    30,     0,     0,     0,
       0,    31,    32,     0,     0,     0,     0,     0,    33,  -120,
      34,    35,     0,    36,     0,     0,     0,     0,     0,     0,
      33,     0,    34,    35,     0,    36,   122,   123,   124,   125,
     126,   127,   128,   129,   130,   131,   132,   133,   134,   135,
     136,   137,   138,   139,   140,   141,   142,   143,   120,     0,
     144,   145,   146,   147,     0,   148,     0,     0,   149,     0,
       0,     0,   121,     0,     0,   150,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   526,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   199,   200,   201,   202,   203,   204,
     205,   206,   207,   208,   209,     0,     0,     0,     0,     0,
     341,   122,   123,   124,   125,   126,   127,   128,   129,   130,
     131,   132,   133,   134,   135,   136,   137,   138,   139,   140,
     141,   142,   143,   120,   153,   144,   145,   146,   147,     0,
     148,     0,     0,   149,     0,     0,   210,   121,     0,     0,
     150,   342,     0,     0,     0,   154,     0,     0,     0,   155,
     156,     0,     0,     0,   211,     0,   343,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   122,   123,   124,   125,
     126,   127,   128,   129,   130,   131,   132,   133,   134,   135,
     136,   137,   138,   139,   140,   141,   142,   143,   120,     0,
     144,   145,   146,   147,     0,   148,     0,     0,   149,     0,
       0,     0,   121,     0,     0,   150,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   347,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   122,   123,   124,   125,   126,   127,   128,   129,   130,
     131,   132,   133,   134,   135,   136,   137,   138,   139,   140,
     141,   142,   143,   120,     0,   144,   145,   146,   147,     0,
     148,     0,     0,   149,     0,     0,     0,   121,     0,     0,
     150,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   391,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   122,   123,   124,   125,
     126,   127,   128,   129,   130,   131,   132,   133,   134,   135,
     136,   137,   138,   139,   140,   141,   142,   143,   120,     0,
     144,   145,   146,   147,     0,   148,     0,     0,   149,     0,
       0,     0,   121,     0,     0,   150,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   395,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   122,   123,   124,   125,   126,   127,   128,   129,   130,
     131,   132,   133,   134,   135,   136,   137,   138,   139,   140,
     141,   142,   143,   120,     0,   144,   145,   146,   147,     0,
     148,     0,     0,   149,     0,     0,     0,   121,     0,     0,
     150,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   434,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   122,   123,   124,   125,
     126,   127,   128,   129,   130,   131,   132,   133,   134,   135,
     136,   137,   138,   139,   140,   141,   142,   143,   120,     0,
     144,   145,   146,   147,     0,   148,     0,     0,   149,     0,
       0,     0,   121,     0,     0,   150,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   435,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   120,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     121,   122,   123,   124,   125,   126,   127,   128,   129,   130,
     131,   132,   133,   134,   135,   136,   137,   138,   139,   140,
     141,   142,   143,   120,     0,   144,   145,   146,   147,     0,
     148,     0,     0,   149,     0,     0,     0,   121,     0,     0,
     150,   363,     0,     0,     0,     0,     0,     0,     0,     0,
     123,   364,   125,   126,   127,   128,   129,   130,   131,   132,
     133,   134,   135,   136,   137,   138,   139,   140,   141,   142,
     143,     0,     0,   144,   145,   146,   147,     0,   148,     0,
       0,   149,     0,     0,     0,     0,   122,   123,   124,   125,
     126,   127,   128,   129,   130,   131,   132,   133,   134,   135,
     136,   137,   138,   139,   140,   141,   142,   143,   120,     0,
     144,   145,   146,   147,     0,   148,     0,     0,   149,     0,
       0,     0,   121,     0,     0,   150,   425,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   426,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   122,   123,   124,   125,   126,   127,   128,   129,   130,
     131,   132,   133,   134,   135,   136,   137,   138,   139,   140,
     141,   142,   143,   120,     0,   144,   145,   146,   147,     0,
     148,     0,     0,   149,     0,     0,     0,   121,     0,     0,
     150,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   230,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   122,   123,   124,   125,
     126,   127,   128,   129,   130,   131,   132,   133,   134,   135,
     136,   137,   138,   139,   140,   141,   142,   143,   120,     0,
     144,   145,   146,   147,     0,   148,     0,     0,   149,     0,
       0,     0,   121,     0,     0,   150,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   320,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   122,   123,   124,   125,   126,   127,   128,   129,   130,
     131,   132,   133,   134,   135,   136,   137,   138,   139,   140,
     141,   142,   143,   120,     0,   144,   145,   146,   147,     0,
     148,     0,     0,   149,     0,     0,     0,   121,     0,     0,
     150,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   323,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   122,   123,   124,   125,
     126,   127,   128,   129,   130,   131,   132,   133,   134,   135,
     136,   137,   138,   139,   140,   141,   142,   143,   120,     0,
     144,   145,   146,   147,     0,   148,     0,     0,   149,     0,
       0,     0,   121,     0,     0,   150,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   365,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   122,   123,   124,   125,   126,   127,   128,   129,   130,
     131,   132,   133,   134,   135,   136,   137,   138,   139,   140,
     141,   142,   143,   120,     0,   144,   145,   146,   147,     0,
     148,     0,     0,   149,     0,     0,     0,   121,     0,     0,
     150,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   366,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   122,   123,   124,   125,
     126,   127,   128,   129,   130,   131,   132,   133,   134,   135,
     136,   137,   138,   139,   140,   141,   142,   143,   120,     0,
     144,   145,   146,   147,     0,   148,     0,     0,   149,     0,
       0,     0,   121,     0,     0,   150,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   392,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   122,   123,   124,   125,   126,   127,   128,   129,   130,
     131,   132,   133,   134,   135,   136,   137,   138,   139,   140,
     141,   142,   143,   120,     0,   144,   145,   146,   147,     0,
     148,     0,     0,   149,     0,     0,     0,   121,     0,     0,
     150,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   427,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   122,   123,   124,   125,
     126,   127,   128,   129,   130,   131,   132,   133,   134,   135,
     136,   137,   138,   139,   140,   141,   142,   143,   120,     0,
     144,   145,   146,   147,     0,   148,     0,     0,   149,     0,
       0,     0,   121,     0,     0,   150,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   452,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   122,   123,   124,   125,   126,   127,   128,   129,   130,
     131,   132,   133,   134,   135,   136,   137,   138,   139,   140,
     141,   142,   143,   120,     0,   144,   145,   146,   147,     0,
     148,     0,     0,   149,     0,     0,     0,   121,     0,     0,
     150,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   497,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   122,   123,   124,   125,
     126,   127,   128,   129,   130,   131,   132,   133,   134,   135,
     136,   137,   138,   139,   140,   141,   142,   143,   120,     0,
     144,   145,   146,   147,     0,   148,     0,     0,   149,     0,
       0,     0,   121,     0,     0,   150,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   512,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   122,   123,   124,   125,   126,   127,   128,   129,   130,
     131,   132,   133,   134,   135,   136,   137,   138,   139,   140,
     141,   142,   143,   120,     0,   144,   145,   146,   147,     0,
     148,     0,     0,   149,     0,     0,     0,   121,     0,     0,
     150,     0,     0,     0,     0,     0,     0,     0,     0,   301,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   122,   123,   124,   125,
     126,   127,   128,   129,   130,   131,   132,   133,   134,   135,
     136,   137,   138,   139,   140,   141,   142,   143,   120,     0,
     144,   145,   146,   147,     0,   148,     0,     0,   149,     0,
       0,     0,   121,     0,     0,   150,     0,     0,     0,     0,
       0,     0,     0,     0,   304,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   122,   123,   124,   125,   126,   127,   128,   129,   130,
     131,   132,   133,   134,   135,   136,   137,   138,   139,   140,
     141,   142,   143,   120,     0,   144,   145,   146,   147,     0,
     148,     0,     0,   149,     0,     0,     0,   121,     0,     0,
     150,     0,     0,     0,     0,     0,     0,     0,     0,   305,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   122,   123,   124,   125,
     126,   127,   128,   129,   130,   131,   132,   133,   134,   135,
     136,   137,   138,   139,   140,   141,   142,   143,   120,     0,
     144,   145,   146,   147,     0,   148,     0,     0,   149,     0,
       0,     0,   121,     0,     0,   150,     0,     0,     0,     0,
       0,     0,     0,     0,   420,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   120,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     121,   122,   123,   124,   125,   126,   127,   128,   129,   130,
     131,   132,   133,   134,   135,   136,   137,   138,   139,   140,
     141,   142,   143,     0,     0,   144,   145,   146,   147,     0,
     148,     0,     0,   149,     0,     0,     0,     0,     0,     0,
     150,     0,     0,     0,     0,     0,     0,     0,   151,   122,
     123,   124,   125,   126,   127,   128,   129,   130,   131,   132,
     133,   134,   135,   136,   137,   138,   139,   140,   141,   142,
     143,   120,     0,   144,   145,   146,   147,     0,   148,     0,
       0,   149,     0,     0,     0,   121,     0,     0,   150,     0,
       0,     0,     0,     0,     0,     0,   322,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   120,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   121,     0,     0,     0,
       0,     0,     0,     0,   122,   123,   124,   125,   126,   127,
     128,   129,   130,   131,   132,   133,   134,   135,   136,   137,
     138,   139,   140,   141,   142,   143,   120,     0,   144,   145,
     146,   147,     0,   148,     0,     0,   149,     0,     0,     0,
     121,     0,     0,   150,   336,   122,   123,   124,   125,   126,
     127,   128,   129,   130,   131,   132,   133,   134,   135,   136,
     137,   138,   139,   140,   141,   142,   143,   120,     0,   144,
     145,   146,   147,     0,   148,     0,     0,   149,     0,     0,
       0,   121,     0,     0,   150,   348,     0,     0,     0,   122,
     123,   124,   125,   126,   127,   128,   129,   130,   131,   132,
     133,   134,   135,   136,   137,   138,   139,   140,   141,   142,
     143,   120,     0,   144,   145,   146,   147,     0,   148,     0,
       0,   149,     0,     0,     0,   121,     0,     0,   150,   527,
     122,   123,   124,   125,   126,   127,   128,   129,   130,   131,
     132,   133,   134,   135,   136,   137,   138,   139,   140,   141,
     142,   143,     0,     0,   144,   145,   146,   147,     0,   148,
       0,     0,   149,     0,     0,     0,     0,     0,     0,   150,
       0,     0,     0,     0,   122,   123,     0,   125,   126,   127,
     128,   129,   130,   131,   132,   133,   134,   135,   136,   137,
     138,   139,   140,   141,   142,   143,     0,     0,   144,   145,
     146,   147,     0,   148,     0,     0,   149,     0,     0,     0,
       0,     0,     0,   150
};

static const yytype_int16 yycheck[] =
{
       1,     6,     2,    51,     7,   363,    56,    57,    58,   417,
     183,    19,    62,   229,     8,    56,    57,    58,    59,    94,
      95,   109,   111,     0,     7,     8,    21,    19,    29,    30,
     112,   121,    33,   104,     8,    36,    78,   126,    32,    33,
      34,    42,   130,    35,   126,    37,    38,    39,    40,    43,
      45,   126,   112,    47,    48,     3,     4,     8,    32,    33,
      34,   469,    54,   471,   491,   112,   126,   425,    69,    43,
     112,    72,    73,    47,    48,     7,     8,     3,     4,   126,
     507,    32,    33,    34,   112,   443,    86,   128,   130,     3,
       4,   119,    43,   309,   122,   121,    47,    48,    99,   100,
     101,   119,   128,   153,   278,   155,   122,   157,   126,   283,
     126,     3,   121,   121,   287,   109,   121,   120,   118,    33,
     121,   122,   123,   124,   125,   126,   127,   128,   129,   130,
     131,   132,   133,   134,   135,   136,   137,   138,   139,   140,
     141,   142,   143,   126,   100,    71,   121,   121,   149,   150,
     121,     3,     4,   154,   121,   156,   157,    71,   109,   160,
     161,   162,    88,   164,   121,   121,    19,     3,     4,   125,
     126,   122,   121,   119,    88,   225,   122,   225,   179,    71,
     181,   182,    35,   184,    37,    38,    39,    40,   119,   120,
       8,   192,   118,   121,     3,     4,   197,   198,     7,     8,
     120,    54,   375,    35,   118,    37,    38,    39,    40,   119,
     211,   212,   122,   119,    32,    33,    34,     9,   120,    71,
       8,   115,   116,   117,   118,    43,   118,   120,   229,    47,
      48,   232,   233,     6,     7,    71,    88,   237,   288,     9,
     290,   121,   292,   416,    32,    33,    34,   121,   119,    94,
      95,   122,    88,     7,     8,    43,    14,    15,   119,    47,
      48,   122,   121,   264,   121,    14,   118,    14,   105,   106,
     119,   272,    21,   122,    21,   130,   129,   122,    32,    33,
      34,   126,   118,   130,   119,     6,   120,   122,   289,    43,
     291,     9,   120,    47,    48,   345,   119,   298,   120,   122,
     126,   302,     9,   121,    96,    97,    98,    99,   309,   101,
     122,   237,   119,   314,    63,   121,    63,   318,   491,   101,
      83,   322,   130,   237,   119,   130,    96,    97,    98,    99,
     119,   101,   130,   121,   507,   336,   337,     6,   388,    14,
     341,   342,   119,   344,   345,   237,    21,   348,   349,    98,
      99,    98,   120,   120,   103,     7,   103,    14,    37,    38,
      39,   112,   363,   127,    21,   121,   367,   126,   130,   130,
     371,   119,    23,   374,    92,    93,   377,   303,    96,    97,
      98,    99,   119,   101,   100,   237,    93,     8,    63,    96,
      97,    98,    99,    83,   101,   130,   112,   146,   147,   146,
     147,   237,    83,   129,    13,   121,    63,   122,   120,   125,
     126,    32,    33,    34,   120,   109,   119,   418,   122,   130,
     122,   119,    43,    98,   425,    18,    47,    48,   103,   130,
      24,   120,   433,   121,    24,   122,   128,   122,   129,   365,
     366,    98,   443,   444,   121,    94,   103,   120,    19,   120,
     500,   365,   366,    88,     3,   418,   337,   458,   345,   233,
     327,   511,   362,   389,   430,   492,   439,   422,   492,   299,
     290,   146,   147,   365,   366,   288,   292,    33,   479,   213,
     471,    -1,    -1,    -1,    -1,    -1,   486,    -1,    -1,   146,
     147,    -1,   492,    -1,    -1,   421,    -1,    -1,   499,    -1,
      -1,    -1,    -1,   417,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   365,   366,    -1,   517,   518,   519,    -1,
     446,    -1,    -1,   524,    -1,   526,   527,    -1,   529,   365,
     366,    -1,   446,    -1,    -1,    -1,    -1,    -1,   287,    -1,
     287,    -1,    -1,    -1,   470,    -1,   472,    -1,   474,    -1,
      -1,    -1,   478,    -1,   446,   469,   470,   471,    -1,    -1,
      -1,    -1,    -1,   489,   478,   417,    -1,    -1,    -1,    -1,
      -1,   497,    -1,    -1,    -1,   489,    -1,   326,   470,   326,
      -1,   417,    -1,   497,    -1,    -1,   478,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   446,    -1,    -1,   489,    -1,    -1,
      -1,    -1,   351,    -1,   351,   497,    -1,    -1,    -1,    -1,
     446,    -1,   287,   362,    -1,   362,    -1,   469,   470,   471,
      -1,    -1,    -1,    -1,    -1,    -1,   478,    -1,    -1,    -1,
     287,    -1,    -1,   469,   470,   471,    -1,   489,    -1,    -1,
      -1,    -1,   478,    -1,    -1,   497,     9,    -1,    -1,    -1,
      -1,   326,    -1,   489,    -1,    -1,    -1,   406,    -1,   406,
      23,   497,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   326,
      -1,    -1,    -1,   422,    -1,   422,   351,    -1,    -1,    -1,
     429,   430,   429,   430,    -1,    -1,    -1,   362,    -1,   438,
     439,   438,   439,   442,   351,   442,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   362,    -1,     9,    -1,    72,
      73,    74,    75,    76,    77,    78,    79,    80,    81,    82,
      83,    84,    85,    86,    87,    88,    89,    90,    91,    92,
      93,   406,    -1,    96,    97,    98,    99,    -1,   101,    -1,
      -1,   104,   491,    -1,   491,    -1,    -1,   422,   111,   406,
      -1,    -1,    -1,    -1,   429,   430,   119,    -1,   507,   122,
     507,    -1,    -1,   438,   439,   422,    -1,   442,    -1,    -1,
      -1,    -1,   429,   430,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   438,   439,    -1,    -1,   442,    88,    89,    90,    91,
      92,    93,    -1,    -1,    96,    97,    98,    99,    -1,   101,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,     9,
      -1,    -1,    -1,    -1,    -1,    -1,   491,    -1,    -1,     0,
      -1,    -1,     3,     4,     5,     6,     7,     8,     9,    10,
      11,    -1,   507,    -1,   491,    -1,    17,    -1,    19,    20,
      -1,    22,    -1,    -1,    25,    26,    27,    28,    29,    -1,
     507,    32,    33,    34,    35,    -1,    37,    38,    39,    40,
      41,    42,    43,    44,    -1,    46,    47,    48,    49,    50,
      51,    52,    53,    -1,    55,    75,    76,    77,    78,    79,
      80,    81,    82,    83,    84,    85,    86,    87,    88,    89,
      90,    91,    92,    93,    -1,    -1,    96,    97,    98,    99,
      -1,   101,    -1,    -1,   104,    86,    87,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    96,    97,     9,    -1,    -1,
      -1,   102,   103,    -1,    -1,    -1,    -1,     0,    -1,    -1,
       3,     4,     5,     6,     7,     8,     9,    10,    11,   120,
     121,    -1,   123,   124,    17,   126,    19,    20,    -1,    22,
      -1,    -1,    25,    26,    27,    28,    29,    -1,    -1,    32,
      33,    34,    35,    -1,    37,    38,    39,    40,    41,    42,
      43,    44,    -1,    46,    47,    48,    49,    50,    51,    52,
      53,    -1,    55,    -1,    76,    77,    78,    79,    80,    81,
      82,    83,    84,    85,    86,    87,    88,    89,    90,    91,
      92,    93,    -1,    -1,    96,    97,    98,    99,    -1,   101,
      -1,    -1,   104,    86,    87,    -1,    -1,    -1,    -1,    -1,
      -1,     9,    -1,    96,    97,    -1,    -1,    -1,    -1,   102,
     103,    -1,    -1,    -1,    -1,    -1,    -1,    -1,     3,     4,
       5,     6,     7,     8,     9,    10,    11,   120,   121,    -1,
     123,   124,    17,   126,    19,    20,    -1,    22,    -1,    -1,
      25,    26,    27,    28,    29,    -1,    -1,    32,    33,    34,
      35,    -1,    37,    38,    39,    40,    41,    42,    43,    44,
      -1,    46,    47,    48,    49,    50,    -1,    52,    53,    77,
      78,    79,    80,    81,    82,    83,    84,    85,    86,    87,
      88,    89,    90,    91,    92,    93,    -1,    -1,    96,    97,
      98,    99,    -1,   101,    -1,    -1,   104,    -1,    -1,    -1,
      -1,    86,    87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    96,    97,    -1,    -1,    -1,    -1,   102,   103,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,     3,     4,     5,     6,
       7,     8,     9,    10,    11,   120,   121,    -1,   123,   124,
      17,   126,    19,    20,   129,    22,    -1,    -1,    25,    26,
      27,    28,    29,    -1,    -1,    32,    33,    34,    35,    -1,
      37,    38,    39,    40,    41,    42,    43,    44,    -1,    46,
      47,    48,    49,    50,    -1,    52,    53,    -1,    -1,    -1,
      -1,    -1,     9,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,     3,     4,     5,     6,     7,     8,     9,    10,
      11,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    86,
      87,    -1,    -1,    -1,    25,    26,    -1,    28,    29,    96,
      97,    32,    33,    34,    -1,   102,   103,    -1,    -1,    -1,
      -1,    -1,    43,    -1,    -1,    -1,    47,    48,    -1,    -1,
      -1,    52,    53,   120,   121,    -1,   123,   124,    -1,   126,
      -1,    -1,   129,    80,    81,    82,    83,    84,    85,    86,
      87,    88,    89,    90,    91,    92,    93,    -1,    -1,    96,
      97,    98,    99,    -1,   101,    86,    87,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    96,    97,    -1,    -1,    -1,
      -1,   102,   103,    -1,     3,     4,     5,     6,     7,     8,
       9,    10,    11,    -1,    -1,    -1,    -1,    -1,   119,    -1,
     121,    -1,   123,   124,    -1,   126,    25,    26,   129,    28,
      29,    -1,    -1,    32,    33,    34,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    43,    -1,    -1,    -1,    47,    48,
      -1,    -1,    -1,    52,    53,    -1,     9,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
       3,     4,     5,     6,     7,     8,     9,    10,    11,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    86,    87,    -1,
      -1,    -1,    25,    26,    -1,    28,    29,    96,    97,    32,
      33,    34,    -1,   102,   103,    -1,    -1,    -1,    -1,    -1,
      43,    -1,    -1,    -1,    47,    48,    -1,    -1,    -1,    52,
      53,    -1,   121,    -1,   123,   124,    -1,   126,    -1,    -1,
     129,    84,    85,    86,    87,    88,    89,    90,    91,    92,
      93,    -1,    -1,    96,    97,    98,    99,    -1,   101,    -1,
      -1,    -1,    -1,    86,    87,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    96,    97,    -1,    -1,   100,    -1,   102,
     103,    -1,    -1,     3,     4,     5,     6,     7,     8,     9,
      10,    11,    -1,    -1,    -1,    -1,    -1,    -1,   121,    -1,
     123,   124,    -1,   126,   127,    25,    26,    -1,    28,    29,
      -1,    -1,    32,    33,    34,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    43,    -1,    -1,    -1,    47,    48,    -1,
      -1,    -1,    52,    53,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,     3,
       4,     5,     6,     7,     8,     9,    10,    11,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    86,    87,    -1,    -1,
      -1,    25,    26,    -1,    28,    29,    96,    97,    32,    33,
      34,    -1,   102,   103,    -1,    -1,    -1,    -1,    -1,    43,
      -1,    -1,    -1,    47,    48,    -1,    -1,    -1,    52,    53,
      -1,   121,    -1,   123,   124,     9,   126,   127,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,     3,     4,     5,     6,     7,
       8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    86,    87,    -1,    -1,    -1,    25,    26,     9,
      28,    29,    96,    97,    32,    33,    34,    -1,   102,   103,
      -1,    -1,    -1,    -1,    -1,    43,    -1,    -1,    -1,    47,
      48,    -1,    -1,    -1,    52,    53,    -1,   121,    -1,   123,
     124,    -1,   126,   127,    78,    79,    80,    81,    82,    83,
      84,    85,    86,    87,    88,    89,    90,    91,    92,    93,
      -1,    -1,    96,    97,    98,    99,    -1,   101,    86,    87,
     104,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    96,    97,
      -1,    -1,    -1,    -1,   102,   103,    86,    87,    88,    89,
      90,    91,    92,    93,    -1,    -1,    96,    97,    98,    99,
      -1,   101,    -1,   121,    -1,   123,   124,    -1,   126,   127,
       3,     4,     5,     6,     7,     8,     9,    10,    11,    -1,
      -1,    -1,    -1,    -1,    17,    -1,    19,    20,    -1,    22,
      -1,    -1,    25,    26,    27,    28,    29,    -1,    -1,    32,
      33,    34,    -1,    -1,    -1,    -1,    -1,    -1,    41,    42,
      43,    44,    -1,    46,    47,    48,    49,    50,    51,    52,
      53,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    86,    87,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    96,    97,    -1,    -1,    -1,    -1,   102,
     103,    -1,    -1,    -1,    -1,    -1,    -1,    -1,     3,     4,
       5,     6,     7,     8,     9,    10,    11,   120,   121,    -1,
     123,   124,    17,   126,    19,    20,    -1,    22,    -1,    -1,
      25,    26,    27,    28,    29,    -1,    -1,    32,    33,    34,
      -1,    -1,    -1,    -1,    -1,    -1,    41,    42,    43,    44,
      -1,    46,    47,    48,    49,    50,    -1,    52,    53,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,     3,     4,     5,     6,     7,     8,
       9,    10,    11,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    86,    87,    -1,    -1,    -1,    25,    26,    27,    28,
      29,    96,    97,    32,    33,    34,    -1,   102,   103,    -1,
      -1,    -1,    -1,    -1,    43,    -1,    -1,    -1,    47,    48,
      -1,    50,    -1,    52,    53,   120,   121,    -1,   123,   124,
      -1,   126,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    86,    87,    -1,
      -1,     9,    -1,    -1,    -1,    -1,    -1,    96,    97,    -1,
      -1,    -1,    -1,   102,   103,    23,     3,     4,     5,     6,
       7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,
     119,    -1,   121,   122,   123,   124,    -1,   126,    25,    26,
      -1,    28,    29,    -1,    -1,    32,    33,    34,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    43,    -1,    -1,    -1,
      47,    48,    -1,    -1,    -1,    52,    53,    75,    76,    77,
      78,    79,    80,    81,    82,    83,    84,    85,    86,    87,
      88,    89,    90,    91,    92,    93,    -1,    -1,    96,    97,
      98,    99,    -1,   101,    -1,    -1,   104,    -1,    -1,    86,
      87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    96,
      97,    -1,    -1,    -1,    -1,   102,   103,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   112,    -1,    -1,    -1,    -1,
      -1,    -1,   119,    -1,   121,   122,   123,   124,    -1,   126,
       3,     4,     5,     6,     7,     8,     9,    10,    11,    -1,
      -1,    -1,     3,     4,     5,     6,     7,     8,     9,    10,
      11,    -1,    25,    26,    -1,    28,    29,    -1,    -1,    32,
      33,    34,    -1,    -1,    25,    26,    -1,    28,    29,    -1,
      43,    32,    33,    34,    47,    48,    -1,    -1,    -1,    52,
      53,    -1,    43,    -1,    -1,    -1,    47,    48,    -1,    -1,
      -1,    52,    53,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    86,    87,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    96,    97,    86,    87,    -1,    -1,   102,
     103,    -1,    -1,    -1,    -1,    96,    97,    -1,    -1,    -1,
      -1,   102,   103,    -1,    -1,    -1,   119,    -1,   121,   122,
     123,   124,    -1,   126,    -1,    -1,    -1,    -1,   119,    -1,
     121,   122,   123,   124,    -1,   126,     3,     4,     5,     6,
       7,     8,     9,    10,    11,    -1,    -1,    -1,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    -1,    25,    26,
      -1,    28,    29,    -1,    -1,    32,    33,    34,    -1,    -1,
      25,    26,    -1,    28,    29,    -1,    43,    32,    33,    34,
      47,    48,    -1,    -1,    -1,    52,    53,    -1,    43,    -1,
      -1,    -1,    47,    48,    -1,    -1,    -1,    52,    53,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    86,
      87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    96,
      97,    86,    87,    -1,    -1,   102,   103,    -1,    -1,    -1,
      -1,    96,    97,    -1,    -1,    -1,    -1,   102,   103,    -1,
      -1,    -1,   119,   120,   121,    -1,   123,   124,    -1,   126,
      -1,    -1,    -1,    -1,   119,    -1,   121,   122,   123,   124,
      -1,   126,     3,     4,     5,     6,     7,     8,     9,    10,
      11,    -1,    -1,    -1,     3,     4,     5,     6,     7,     8,
       9,    10,    11,    -1,    25,    26,    27,    28,    29,    -1,
      -1,    32,    33,    34,    -1,    -1,    25,    26,    -1,    28,
      29,    -1,    43,    32,    33,    34,    47,    48,    -1,    50,
      -1,    52,    53,    -1,    43,    -1,    -1,    -1,    47,    48,
      -1,    -1,    -1,    52,    53,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    86,    87,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    96,    97,    86,    87,    -1,
      -1,   102,   103,    -1,    -1,    -1,    -1,    96,    97,    -1,
      -1,   100,    -1,   102,   103,    -1,    -1,    -1,    -1,    -1,
     121,    -1,   123,   124,    -1,   126,    -1,    -1,    -1,    -1,
      -1,    -1,   121,    -1,   123,   124,    -1,   126,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    -1,    -1,    -1,
       3,     4,     5,     6,     7,     8,     9,    10,    11,    -1,
      25,    26,    -1,    28,    29,    -1,    -1,    32,    33,    34,
      -1,    -1,    25,    26,    -1,    28,    29,    -1,    43,    32,
      33,    34,    47,    48,    -1,    -1,    -1,    52,    53,    -1,
      43,    -1,    -1,    -1,    47,    48,    -1,    -1,    -1,    52,
      53,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    86,    87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    96,    97,    86,    87,    -1,    -1,   102,   103,    -1,
      -1,    -1,    -1,    96,    97,    -1,    -1,    -1,    -1,   102,
     103,    -1,    -1,    -1,    -1,   120,   121,    -1,   123,   124,
      -1,   126,    -1,    -1,    -1,    -1,    -1,   120,   121,    -1,
     123,   124,    -1,   126,     3,     4,     5,     6,     7,     8,
       9,    10,    11,    -1,    -1,    -1,     3,     4,     5,     6,
       7,     8,     9,    10,    11,    -1,    25,    26,    -1,    28,
      29,    -1,    -1,    32,    33,    34,    -1,    -1,    25,    26,
      -1,    28,    29,    -1,    43,    32,    33,    34,    47,    48,
      -1,    -1,    -1,    52,    53,    -1,    43,    -1,    -1,    -1,
      47,    48,    -1,    -1,    -1,    52,    53,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    86,    87,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    96,    97,    86,
      87,    -1,    -1,   102,   103,    -1,    -1,    -1,    -1,    96,
      97,    -1,    -1,   112,    -1,   102,   103,    -1,    -1,    -1,
      -1,    -1,   121,    -1,   123,   124,    -1,   126,    -1,    -1,
      -1,    -1,    -1,   120,   121,    -1,   123,   124,    -1,   126,
       3,     4,     5,     6,     7,     8,     9,    10,    11,    -1,
      -1,    -1,     3,     4,     5,     6,     7,     8,     9,    10,
      11,    -1,    25,    26,    -1,    28,    29,    -1,    -1,    32,
      33,    34,    -1,    -1,    25,    26,    -1,    28,    29,    -1,
      43,    32,    33,    34,    47,    48,    -1,    -1,    -1,    52,
      53,    -1,    43,    -1,    -1,    -1,    47,    48,    -1,    -1,
      -1,    52,    53,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,     9,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    86,    87,    -1,    -1,    23,    -1,    -1,
      -1,    -1,    -1,    96,    97,    86,    87,    -1,    -1,   102,
     103,    -1,    -1,    -1,    -1,    96,    97,    -1,    -1,    -1,
      -1,   102,   103,    -1,    -1,    -1,    -1,    -1,   121,   122,
     123,   124,    -1,   126,    -1,    -1,    -1,    -1,    -1,    -1,
     121,    -1,   123,   124,    -1,   126,    72,    73,    74,    75,
      76,    77,    78,    79,    80,    81,    82,    83,    84,    85,
      86,    87,    88,    89,    90,    91,    92,    93,     9,    -1,
      96,    97,    98,    99,    -1,   101,    -1,    -1,   104,    -1,
      -1,    -1,    23,    -1,    -1,   111,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   130,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    60,    61,    62,    63,    64,    65,
      66,    67,    68,    69,    70,    -1,    -1,    -1,    -1,    -1,
      71,    72,    73,    74,    75,    76,    77,    78,    79,    80,
      81,    82,    83,    84,    85,    86,    87,    88,    89,    90,
      91,    92,    93,     9,   100,    96,    97,    98,    99,    -1,
     101,    -1,    -1,   104,    -1,    -1,   112,    23,    -1,    -1,
     111,   112,    -1,    -1,    -1,   121,    -1,    -1,    -1,   125,
     126,    -1,    -1,    -1,   130,    -1,   127,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    72,    73,    74,    75,
      76,    77,    78,    79,    80,    81,    82,    83,    84,    85,
      86,    87,    88,    89,    90,    91,    92,    93,     9,    -1,
      96,    97,    98,    99,    -1,   101,    -1,    -1,   104,    -1,
      -1,    -1,    23,    -1,    -1,   111,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   127,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    72,    73,    74,    75,    76,    77,    78,    79,    80,
      81,    82,    83,    84,    85,    86,    87,    88,    89,    90,
      91,    92,    93,     9,    -1,    96,    97,    98,    99,    -1,
     101,    -1,    -1,   104,    -1,    -1,    -1,    23,    -1,    -1,
     111,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   127,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    72,    73,    74,    75,
      76,    77,    78,    79,    80,    81,    82,    83,    84,    85,
      86,    87,    88,    89,    90,    91,    92,    93,     9,    -1,
      96,    97,    98,    99,    -1,   101,    -1,    -1,   104,    -1,
      -1,    -1,    23,    -1,    -1,   111,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   127,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    72,    73,    74,    75,    76,    77,    78,    79,    80,
      81,    82,    83,    84,    85,    86,    87,    88,    89,    90,
      91,    92,    93,     9,    -1,    96,    97,    98,    99,    -1,
     101,    -1,    -1,   104,    -1,    -1,    -1,    23,    -1,    -1,
     111,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   127,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    72,    73,    74,    75,
      76,    77,    78,    79,    80,    81,    82,    83,    84,    85,
      86,    87,    88,    89,    90,    91,    92,    93,     9,    -1,
      96,    97,    98,    99,    -1,   101,    -1,    -1,   104,    -1,
      -1,    -1,    23,    -1,    -1,   111,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   127,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,     9,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      23,    72,    73,    74,    75,    76,    77,    78,    79,    80,
      81,    82,    83,    84,    85,    86,    87,    88,    89,    90,
      91,    92,    93,     9,    -1,    96,    97,    98,    99,    -1,
     101,    -1,    -1,   104,    -1,    -1,    -1,    23,    -1,    -1,
     111,   112,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      73,   122,    75,    76,    77,    78,    79,    80,    81,    82,
      83,    84,    85,    86,    87,    88,    89,    90,    91,    92,
      93,    -1,    -1,    96,    97,    98,    99,    -1,   101,    -1,
      -1,   104,    -1,    -1,    -1,    -1,    72,    73,    74,    75,
      76,    77,    78,    79,    80,    81,    82,    83,    84,    85,
      86,    87,    88,    89,    90,    91,    92,    93,     9,    -1,
      96,    97,    98,    99,    -1,   101,    -1,    -1,   104,    -1,
      -1,    -1,    23,    -1,    -1,   111,   112,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   122,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    72,    73,    74,    75,    76,    77,    78,    79,    80,
      81,    82,    83,    84,    85,    86,    87,    88,    89,    90,
      91,    92,    93,     9,    -1,    96,    97,    98,    99,    -1,
     101,    -1,    -1,   104,    -1,    -1,    -1,    23,    -1,    -1,
     111,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   122,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    72,    73,    74,    75,
      76,    77,    78,    79,    80,    81,    82,    83,    84,    85,
      86,    87,    88,    89,    90,    91,    92,    93,     9,    -1,
      96,    97,    98,    99,    -1,   101,    -1,    -1,   104,    -1,
      -1,    -1,    23,    -1,    -1,   111,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   122,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    72,    73,    74,    75,    76,    77,    78,    79,    80,
      81,    82,    83,    84,    85,    86,    87,    88,    89,    90,
      91,    92,    93,     9,    -1,    96,    97,    98,    99,    -1,
     101,    -1,    -1,   104,    -1,    -1,    -1,    23,    -1,    -1,
     111,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   122,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    72,    73,    74,    75,
      76,    77,    78,    79,    80,    81,    82,    83,    84,    85,
      86,    87,    88,    89,    90,    91,    92,    93,     9,    -1,
      96,    97,    98,    99,    -1,   101,    -1,    -1,   104,    -1,
      -1,    -1,    23,    -1,    -1,   111,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   122,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    72,    73,    74,    75,    76,    77,    78,    79,    80,
      81,    82,    83,    84,    85,    86,    87,    88,    89,    90,
      91,    92,    93,     9,    -1,    96,    97,    98,    99,    -1,
     101,    -1,    -1,   104,    -1,    -1,    -1,    23,    -1,    -1,
     111,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   122,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    72,    73,    74,    75,
      76,    77,    78,    79,    80,    81,    82,    83,    84,    85,
      86,    87,    88,    89,    90,    91,    92,    93,     9,    -1,
      96,    97,    98,    99,    -1,   101,    -1,    -1,   104,    -1,
      -1,    -1,    23,    -1,    -1,   111,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   122,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    72,    73,    74,    75,    76,    77,    78,    79,    80,
      81,    82,    83,    84,    85,    86,    87,    88,    89,    90,
      91,    92,    93,     9,    -1,    96,    97,    98,    99,    -1,
     101,    -1,    -1,   104,    -1,    -1,    -1,    23,    -1,    -1,
     111,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   122,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    72,    73,    74,    75,
      76,    77,    78,    79,    80,    81,    82,    83,    84,    85,
      86,    87,    88,    89,    90,    91,    92,    93,     9,    -1,
      96,    97,    98,    99,    -1,   101,    -1,    -1,   104,    -1,
      -1,    -1,    23,    -1,    -1,   111,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   122,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    72,    73,    74,    75,    76,    77,    78,    79,    80,
      81,    82,    83,    84,    85,    86,    87,    88,    89,    90,
      91,    92,    93,     9,    -1,    96,    97,    98,    99,    -1,
     101,    -1,    -1,   104,    -1,    -1,    -1,    23,    -1,    -1,
     111,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   122,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    72,    73,    74,    75,
      76,    77,    78,    79,    80,    81,    82,    83,    84,    85,
      86,    87,    88,    89,    90,    91,    92,    93,     9,    -1,
      96,    97,    98,    99,    -1,   101,    -1,    -1,   104,    -1,
      -1,    -1,    23,    -1,    -1,   111,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   122,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    72,    73,    74,    75,    76,    77,    78,    79,    80,
      81,    82,    83,    84,    85,    86,    87,    88,    89,    90,
      91,    92,    93,     9,    -1,    96,    97,    98,    99,    -1,
     101,    -1,    -1,   104,    -1,    -1,    -1,    23,    -1,    -1,
     111,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   120,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    72,    73,    74,    75,
      76,    77,    78,    79,    80,    81,    82,    83,    84,    85,
      86,    87,    88,    89,    90,    91,    92,    93,     9,    -1,
      96,    97,    98,    99,    -1,   101,    -1,    -1,   104,    -1,
      -1,    -1,    23,    -1,    -1,   111,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   120,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    72,    73,    74,    75,    76,    77,    78,    79,    80,
      81,    82,    83,    84,    85,    86,    87,    88,    89,    90,
      91,    92,    93,     9,    -1,    96,    97,    98,    99,    -1,
     101,    -1,    -1,   104,    -1,    -1,    -1,    23,    -1,    -1,
     111,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   120,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    72,    73,    74,    75,
      76,    77,    78,    79,    80,    81,    82,    83,    84,    85,
      86,    87,    88,    89,    90,    91,    92,    93,     9,    -1,
      96,    97,    98,    99,    -1,   101,    -1,    -1,   104,    -1,
      -1,    -1,    23,    -1,    -1,   111,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   120,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,     9,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      23,    72,    73,    74,    75,    76,    77,    78,    79,    80,
      81,    82,    83,    84,    85,    86,    87,    88,    89,    90,
      91,    92,    93,    -1,    -1,    96,    97,    98,    99,    -1,
     101,    -1,    -1,   104,    -1,    -1,    -1,    -1,    -1,    -1,
     111,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   119,    72,
      73,    74,    75,    76,    77,    78,    79,    80,    81,    82,
      83,    84,    85,    86,    87,    88,    89,    90,    91,    92,
      93,     9,    -1,    96,    97,    98,    99,    -1,   101,    -1,
      -1,   104,    -1,    -1,    -1,    23,    -1,    -1,   111,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   119,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,     9,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    23,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    72,    73,    74,    75,    76,    77,
      78,    79,    80,    81,    82,    83,    84,    85,    86,    87,
      88,    89,    90,    91,    92,    93,     9,    -1,    96,    97,
      98,    99,    -1,   101,    -1,    -1,   104,    -1,    -1,    -1,
      23,    -1,    -1,   111,   112,    72,    73,    74,    75,    76,
      77,    78,    79,    80,    81,    82,    83,    84,    85,    86,
      87,    88,    89,    90,    91,    92,    93,     9,    -1,    96,
      97,    98,    99,    -1,   101,    -1,    -1,   104,    -1,    -1,
      -1,    23,    -1,    -1,   111,   112,    -1,    -1,    -1,    72,
      73,    74,    75,    76,    77,    78,    79,    80,    81,    82,
      83,    84,    85,    86,    87,    88,    89,    90,    91,    92,
      93,     9,    -1,    96,    97,    98,    99,    -1,   101,    -1,
      -1,   104,    -1,    -1,    -1,    23,    -1,    -1,   111,   112,
      72,    73,    74,    75,    76,    77,    78,    79,    80,    81,
      82,    83,    84,    85,    86,    87,    88,    89,    90,    91,
      92,    93,    -1,    -1,    96,    97,    98,    99,    -1,   101,
      -1,    -1,   104,    -1,    -1,    -1,    -1,    -1,    -1,   111,
      -1,    -1,    -1,    -1,    72,    73,    -1,    75,    76,    77,
      78,    79,    80,    81,    82,    83,    84,    85,    86,    87,
      88,    89,    90,    91,    92,    93,    -1,    -1,    96,    97,
      98,    99,    -1,   101,    -1,    -1,   104,    -1,    -1,    -1,
      -1,    -1,    -1,   111
};

  /* YYSTOS[STATE-NUM] -- The (internal number of the) accessing
     symbol of state STATE-NUM.  */
static const yytype_uint8 yystos[] =
{
       0,   115,   116,   117,   118,   133,     3,     4,     5,     6,
       7,     8,     9,    10,    11,    25,    26,    28,    29,    32,
      33,    34,    43,    47,    48,    52,    53,    86,    87,    96,
      97,   102,   103,   121,   123,   124,   126,   132,   138,   142,
     143,   145,   146,   147,   149,   157,   166,   167,   168,   169,
     170,   171,   172,   173,   202,    35,    37,    38,    39,    40,
     192,   193,   195,    11,    17,    19,    20,    22,    27,    41,
      42,    44,    46,    49,    50,    51,   120,   137,   142,   143,
     145,   147,   202,   207,   208,   211,    55,   134,   135,   136,
     137,   193,   208,     0,   166,   167,   168,   173,   121,   121,
     121,   121,   168,   148,   121,   142,   142,   142,   147,   211,
     100,   142,   158,   159,    56,    57,    58,    59,   128,   203,
       9,    23,    72,    73,    74,    75,    76,    77,    78,    79,
      80,    81,    82,    83,    84,    85,    86,    87,    88,    89,
      90,    91,    92,    93,    96,    97,    98,    99,   101,   104,
     111,   119,   142,   100,   121,   125,   126,   128,    94,    95,
     126,   144,   121,   138,   104,     7,     8,   139,   198,   199,
     139,   196,   197,   139,   200,   201,   120,   119,   139,   121,
     120,   121,   121,   121,   121,   120,   142,   120,   208,   120,
     142,   142,     6,   121,     6,     7,   120,   130,   130,    60,
      61,    62,    63,    64,    65,    66,    67,    68,    69,    70,
     112,   130,   205,   212,   213,   120,   120,   193,   136,   112,
     168,   142,   168,   142,   142,   119,   121,   161,   168,     6,
     122,   122,   126,   119,   154,   129,   193,   204,   208,   142,
     142,   142,   142,   142,   142,   142,   142,   142,   142,   142,
     142,   142,   142,   142,   142,   142,   142,   142,   142,   142,
     142,   142,   168,   168,   121,   142,   142,   139,   142,   150,
     151,   139,   112,   142,     7,     8,   139,   142,   155,   156,
     127,   142,   142,   140,   142,    83,   142,   130,   119,   130,
     119,   130,   119,   194,   142,   142,   142,     7,   120,   132,
     142,   120,    21,    45,   120,   120,   142,   152,   153,     6,
     120,   120,   142,   142,     7,   142,   142,   213,   121,   122,
     122,   122,   119,   122,   138,   139,   160,   112,   152,   142,
     159,   127,   129,   193,   208,   142,   112,   119,   122,   127,
     142,    71,   112,   127,   130,   119,   154,   127,   112,   119,
     154,   121,   132,   165,   168,   174,   177,   199,   142,   197,
     142,   201,   130,   112,   122,   122,   122,    23,   141,   142,
     192,   119,   122,   142,    19,   121,   202,   119,   120,   152,
     142,   142,   142,    83,    83,   139,   162,   163,   168,   160,
     122,   127,   122,   142,   151,   127,   142,   127,   142,   142,
     156,   129,   142,   142,   122,   109,   122,   168,   175,   176,
      13,   180,   161,   140,   208,   208,   142,   120,   120,   142,
     120,   142,   132,   142,   122,   112,   122,   122,   109,   122,
     119,   139,   202,   130,   127,   127,   168,   111,   122,   119,
      14,    15,   179,   112,   119,   122,    18,   132,    50,   206,
     207,   141,   122,   202,   163,   140,   168,   162,   130,   164,
     142,   168,   175,   168,   181,   140,   208,   209,   210,   119,
     122,   120,   122,   122,   112,   142,   128,   122,   122,    24,
     207,   208,   206,   202,   202,   129,   178,   208,   142,   122,
      19,    54,   182,   184,   185,   190,   193,   122,   208,   121,
     165,   129,   184,   185,   193,   105,   106,   183,   208,   142,
     139,   165,   122,   120,   139,   187,   186,    78,   112,   130,
     189,   142,   142,   142,    94,   188,   130,   112,   142,    19,
     191,   142,   142,   142,   120
};

  /* YYR1[YYN] -- Symbol number of symbol that rule YYN derives.  */
static const yytype_uint8 yyr1[] =
{
       0,   131,   132,   133,   133,   133,   133,   133,   133,   133,
     133,   133,   134,   134,   135,   135,   136,   136,   136,   136,
     137,   137,   138,   138,   139,   139,   140,   140,   140,   141,
     141,   142,   142,   142,   142,   142,   142,   142,   142,   142,
     142,   142,   142,   142,   142,   142,   142,   142,   142,   142,
     142,   142,   142,   142,   142,   142,   142,   142,   142,   142,
     142,   142,   142,   142,   142,   142,   142,   142,   142,   143,
     144,   144,   145,   145,   146,   146,   146,   146,   146,   146,
     147,   147,   147,   147,   147,   147,   147,   147,   147,   147,
     147,   147,   147,   147,   147,   147,   148,   147,   147,   147,
     147,   147,   147,   147,   147,   147,   147,   147,   147,   147,
     149,   150,   150,   150,   151,   152,   152,   152,   153,   154,
     154,   155,   155,   155,   156,   156,   157,   158,   158,   159,
     159,   160,   161,   161,   162,   162,   163,   163,   164,   164,
     165,   165,   165,   166,   167,   168,   168,   168,   168,   168,
     168,   168,   169,   169,   169,   170,   171,   171,   172,   172,
     173,   173,   174,   174,   175,   175,   176,   176,   176,   177,
     178,   177,   179,   179,   180,   180,   181,   181,   182,   182,
     182,   182,   182,   182,   183,   183,   183,   184,   186,   185,
     187,   187,   188,   188,   189,   189,   189,   189,   189,   189,
     190,   190,   191,   191,   192,   192,   192,   194,   193,   193,
     195,   195,   196,   196,   197,   198,   198,   199,   200,   200,
     201,   202,   202,   202,   203,   203,   203,   203,   204,   204,
     204,   204,   205,   205,   205,   205,   205,   205,   205,   205,
     205,   205,   205,   206,   206,   206,   207,   207,   207,   207,
     207,   207,   207,   207,   207,   207,   207,   207,   208,   208,
     208,   208,   208,   208,   208,   208,   209,   208,   210,   208,
     208,   208,   208,   208,   208,   208,   208,   208,   208,   208,
     208,   208,   211,   212,   212,   213
};

  /* YYR2[YYN] -- Number of symbols on the right hand side of rule YYN.  */
static const yytype_int8 yyr2[] =
{
       0,     2,     0,     2,     3,     2,     3,     2,     3,     2,
       3,     2,     0,     1,     1,     2,     1,     2,     1,     1,
       3,     3,     1,     1,     1,     1,     0,     1,     3,     0,
       1,     1,     2,     2,     5,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     5,
       3,     3,     1,     1,     2,     2,     2,     1,     1,     3,
       1,     1,     3,     5,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     3,     1,     3,     3,     4,     6,
       6,     4,     5,     5,     1,     3,     0,     3,     6,     8,
       5,     2,     2,     4,     4,     4,     6,     4,     5,     5,
       4,     0,     1,     3,     1,     0,     1,     3,     1,     0,
       1,     0,     1,     3,     1,     3,     4,     1,     3,     1,
       6,     0,     7,     4,     1,     3,     3,     2,     0,     2,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     3,     1,     1,     5,     5,
       3,     4,     4,     3,     1,     3,     1,     2,     1,     6,
       0,     8,     1,     1,     0,     1,     0,     1,     1,     1,
       1,     2,     2,     2,     0,     1,     1,     4,     0,     9,
       0,     1,     0,     2,     0,     2,     2,     4,     4,     2,
       0,     4,     0,     2,     2,     2,     2,     0,     5,     2,
       1,     1,     1,     3,     3,     1,     3,     3,     1,     3,
       3,     3,     4,     2,     1,     1,     1,     1,     1,     2,
       1,     2,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     0,     1,     3,     3,     3,     3,     3,
       1,     5,     4,     6,     1,     4,     6,     8,     1,     1,
       2,     5,     7,     5,    10,     8,     0,     9,     0,    11,
       2,     2,     2,     3,     4,     6,     8,     5,     2,     3,
       3,     4,     2,     1,     2,     3
};


enum { YYENOMEM = -2 };

#define yyerrok         (yyerrstatus = 0)
#define yyclearin       (yychar = PKL_TAB_EMPTY)

#define YYACCEPT        goto yyacceptlab
#define YYABORT         goto yyabortlab
#define YYERROR         goto yyerrorlab


#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)                                    \
  do                                                              \
    if (yychar == PKL_TAB_EMPTY)                                        \
      {                                                           \
        yychar = (Token);                                         \
        yylval = (Value);                                         \
        YYPOPSTACK (yylen);                                       \
        yystate = *yyssp;                                         \
        YY_LAC_DISCARD ("YYBACKUP");                              \
        goto yybackup;                                            \
      }                                                           \
    else                                                          \
      {                                                           \
        yyerror (&yylloc, pkl_parser, YY_("syntax error: cannot back up")); \
        YYERROR;                                                  \
      }                                                           \
  while (0)

/* Backward compatibility with an undocumented macro.
   Use PKL_TAB_error or PKL_TAB_UNDEF. */
#define YYERRCODE PKL_TAB_UNDEF

/* YYLLOC_DEFAULT -- Set CURRENT to span from RHS[1] to RHS[N].
   If N is 0, then set CURRENT to the empty location which ends
   the previous symbol: RHS[0] (always defined).  */

#ifndef YYLLOC_DEFAULT
# define YYLLOC_DEFAULT(Current, Rhs, N)                                \
    do                                                                  \
      if (N)                                                            \
        {                                                               \
          (Current).first_line   = YYRHSLOC (Rhs, 1).first_line;        \
          (Current).first_column = YYRHSLOC (Rhs, 1).first_column;      \
          (Current).last_line    = YYRHSLOC (Rhs, N).last_line;         \
          (Current).last_column  = YYRHSLOC (Rhs, N).last_column;       \
        }                                                               \
      else                                                              \
        {                                                               \
          (Current).first_line   = (Current).last_line   =              \
            YYRHSLOC (Rhs, 0).last_line;                                \
          (Current).first_column = (Current).last_column =              \
            YYRHSLOC (Rhs, 0).last_column;                              \
        }                                                               \
    while (0)
#endif

#define YYRHSLOC(Rhs, K) ((Rhs)[K])


/* Enable debugging if requested.  */
#if PKL_TAB_DEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)                        \
do {                                            \
  if (yydebug)                                  \
    YYFPRINTF Args;                             \
} while (0)


/* YY_LOCATION_PRINT -- Print the location on the stream.
   This macro was not mandated originally: define only if we know
   we won't break user code: when these are the locations we know.  */

# ifndef YY_LOCATION_PRINT
#  if defined PKL_TAB_LTYPE_IS_TRIVIAL && PKL_TAB_LTYPE_IS_TRIVIAL

/* Print *YYLOCP on YYO.  Private, do not rely on its existence. */

YY_ATTRIBUTE_UNUSED
static int
yy_location_print_ (FILE *yyo, YYLTYPE const * const yylocp)
{
  int res = 0;
  int end_col = 0 != yylocp->last_column ? yylocp->last_column - 1 : 0;
  if (0 <= yylocp->first_line)
    {
      res += YYFPRINTF (yyo, "%d", yylocp->first_line);
      if (0 <= yylocp->first_column)
        res += YYFPRINTF (yyo, ".%d", yylocp->first_column);
    }
  if (0 <= yylocp->last_line)
    {
      if (yylocp->first_line < yylocp->last_line)
        {
          res += YYFPRINTF (yyo, "-%d", yylocp->last_line);
          if (0 <= end_col)
            res += YYFPRINTF (yyo, ".%d", end_col);
        }
      else if (0 <= end_col && yylocp->first_column < end_col)
        res += YYFPRINTF (yyo, "-%d", end_col);
    }
  return res;
 }

#   define YY_LOCATION_PRINT(File, Loc)          \
  yy_location_print_ (File, &(Loc))

#  else
#   define YY_LOCATION_PRINT(File, Loc) ((void) 0)
#  endif
# endif /* !defined YY_LOCATION_PRINT */


# define YY_SYMBOL_PRINT(Title, Kind, Value, Location)                    \
do {                                                                      \
  if (yydebug)                                                            \
    {                                                                     \
      YYFPRINTF (stderr, "%s ", Title);                                   \
      yy_symbol_print (stderr,                                            \
                  Kind, Value, Location, pkl_parser); \
      YYFPRINTF (stderr, "\n");                                           \
    }                                                                     \
} while (0)


/*-----------------------------------.
| Print this symbol's value on YYO.  |
`-----------------------------------*/

static void
yy_symbol_value_print (FILE *yyo,
                       yysymbol_kind_t yykind, YYSTYPE const * const yyvaluep, YYLTYPE const * const yylocationp, struct pkl_parser *pkl_parser)
{
  FILE *yyoutput = yyo;
  YY_USE (yyoutput);
  YY_USE (yylocationp);
  YY_USE (pkl_parser);
  if (!yyvaluep)
    return;
# ifdef YYPRINT
  if (yykind < YYNTOKENS)
    YYPRINT (yyo, yytoknum[yykind], *yyvaluep);
# endif
  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  YY_USE (yykind);
  YY_IGNORE_MAYBE_UNINITIALIZED_END
}


/*---------------------------.
| Print this symbol on YYO.  |
`---------------------------*/

static void
yy_symbol_print (FILE *yyo,
                 yysymbol_kind_t yykind, YYSTYPE const * const yyvaluep, YYLTYPE const * const yylocationp, struct pkl_parser *pkl_parser)
{
  YYFPRINTF (yyo, "%s %s (",
             yykind < YYNTOKENS ? "token" : "nterm", yysymbol_name (yykind));

  YY_LOCATION_PRINT (yyo, *yylocationp);
  YYFPRINTF (yyo, ": ");
  yy_symbol_value_print (yyo, yykind, yyvaluep, yylocationp, pkl_parser);
  YYFPRINTF (yyo, ")");
}

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (included).                                                   |
`------------------------------------------------------------------*/

static void
yy_stack_print (yy_state_t *yybottom, yy_state_t *yytop)
{
  YYFPRINTF (stderr, "Stack now");
  for (; yybottom <= yytop; yybottom++)
    {
      int yybot = *yybottom;
      YYFPRINTF (stderr, " %d", yybot);
    }
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)                            \
do {                                                            \
  if (yydebug)                                                  \
    yy_stack_print ((Bottom), (Top));                           \
} while (0)


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

static void
yy_reduce_print (yy_state_t *yyssp, YYSTYPE *yyvsp, YYLTYPE *yylsp,
                 int yyrule, struct pkl_parser *pkl_parser)
{
  int yylno = yyrline[yyrule];
  int yynrhs = yyr2[yyrule];
  int yyi;
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %d):\n",
             yyrule - 1, yylno);
  /* The symbols being reduced.  */
  for (yyi = 0; yyi < yynrhs; yyi++)
    {
      YYFPRINTF (stderr, "   $%d = ", yyi + 1);
      yy_symbol_print (stderr,
                       YY_ACCESSING_SYMBOL (+yyssp[yyi + 1 - yynrhs]),
                       &yyvsp[(yyi + 1) - (yynrhs)],
                       &(yylsp[(yyi + 1) - (yynrhs)]), pkl_parser);
      YYFPRINTF (stderr, "\n");
    }
}

# define YY_REDUCE_PRINT(Rule)          \
do {                                    \
  if (yydebug)                          \
    yy_reduce_print (yyssp, yyvsp, yylsp, Rule, pkl_parser); \
} while (0)

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !PKL_TAB_DEBUG */
# define YYDPRINTF(Args) ((void) 0)
# define YY_SYMBOL_PRINT(Title, Kind, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !PKL_TAB_DEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   YYSTACK_ALLOC_MAXIMUM < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif


/* Given a state stack such that *YYBOTTOM is its bottom, such that
   *YYTOP is either its top or is YYTOP_EMPTY to indicate an empty
   stack, and such that *YYCAPACITY is the maximum number of elements it
   can hold without a reallocation, make sure there is enough room to
   store YYADD more elements.  If not, allocate a new stack using
   YYSTACK_ALLOC, copy the existing elements, and adjust *YYBOTTOM,
   *YYTOP, and *YYCAPACITY to reflect the new capacity and memory
   location.  If *YYBOTTOM != YYBOTTOM_NO_FREE, then free the old stack
   using YYSTACK_FREE.  Return 0 if successful or if no reallocation is
   required.  Return YYENOMEM if memory is exhausted.  */
static int
yy_lac_stack_realloc (YYPTRDIFF_T *yycapacity, YYPTRDIFF_T yyadd,
#if PKL_TAB_DEBUG
                      char const *yydebug_prefix,
                      char const *yydebug_suffix,
#endif
                      yy_state_t **yybottom,
                      yy_state_t *yybottom_no_free,
                      yy_state_t **yytop, yy_state_t *yytop_empty)
{
  YYPTRDIFF_T yysize_old =
    *yytop == yytop_empty ? 0 : *yytop - *yybottom + 1;
  YYPTRDIFF_T yysize_new = yysize_old + yyadd;
  if (*yycapacity < yysize_new)
    {
      YYPTRDIFF_T yyalloc = 2 * yysize_new;
      yy_state_t *yybottom_new;
      /* Use YYMAXDEPTH for maximum stack size given that the stack
         should never need to grow larger than the main state stack
         needs to grow without LAC.  */
      if (YYMAXDEPTH < yysize_new)
        {
          YYDPRINTF ((stderr, "%smax size exceeded%s", yydebug_prefix,
                      yydebug_suffix));
          return YYENOMEM;
        }
      if (YYMAXDEPTH < yyalloc)
        yyalloc = YYMAXDEPTH;
      yybottom_new =
        YY_CAST (yy_state_t *,
                 YYSTACK_ALLOC (YY_CAST (YYSIZE_T,
                                         yyalloc * YYSIZEOF (*yybottom_new))));
      if (!yybottom_new)
        {
          YYDPRINTF ((stderr, "%srealloc failed%s", yydebug_prefix,
                      yydebug_suffix));
          return YYENOMEM;
        }
      if (*yytop != yytop_empty)
        {
          YYCOPY (yybottom_new, *yybottom, yysize_old);
          *yytop = yybottom_new + (yysize_old - 1);
        }
      if (*yybottom != yybottom_no_free)
        YYSTACK_FREE (*yybottom);
      *yybottom = yybottom_new;
      *yycapacity = yyalloc;
    }
  return 0;
}

/* Establish the initial context for the current lookahead if no initial
   context is currently established.

   We define a context as a snapshot of the parser stacks.  We define
   the initial context for a lookahead as the context in which the
   parser initially examines that lookahead in order to select a
   syntactic action.  Thus, if the lookahead eventually proves
   syntactically unacceptable (possibly in a later context reached via a
   series of reductions), the initial context can be used to determine
   the exact set of tokens that would be syntactically acceptable in the
   lookahead's place.  Moreover, it is the context after which any
   further semantic actions would be erroneous because they would be
   determined by a syntactically unacceptable token.

   YY_LAC_ESTABLISH should be invoked when a reduction is about to be
   performed in an inconsistent state (which, for the purposes of LAC,
   includes consistent states that don't know they're consistent because
   their default reductions have been disabled).  Iff there is a
   lookahead token, it should also be invoked before reporting a syntax
   error.  This latter case is for the sake of the debugging output.

   For parse.lac=full, the implementation of YY_LAC_ESTABLISH is as
   follows.  If no initial context is currently established for the
   current lookahead, then check if that lookahead can eventually be
   shifted if syntactic actions continue from the current context.
   Report a syntax error if it cannot.  */
#define YY_LAC_ESTABLISH                                                \
do {                                                                    \
  if (!yy_lac_established)                                              \
    {                                                                   \
      YYDPRINTF ((stderr,                                               \
                  "LAC: initial context established for %s\n",          \
                  yysymbol_name (yytoken)));                            \
      yy_lac_established = 1;                                           \
      switch (yy_lac (yyesa, &yyes, &yyes_capacity, yyssp, yytoken))    \
        {                                                               \
        case YYENOMEM:                                                  \
          goto yyexhaustedlab;                                          \
        case 1:                                                         \
          goto yyerrlab;                                                \
        }                                                               \
    }                                                                   \
} while (0)

/* Discard any previous initial lookahead context because of Event,
   which may be a lookahead change or an invalidation of the currently
   established initial context for the current lookahead.

   The most common example of a lookahead change is a shift.  An example
   of both cases is syntax error recovery.  That is, a syntax error
   occurs when the lookahead is syntactically erroneous for the
   currently established initial context, so error recovery manipulates
   the parser stacks to try to find a new initial context in which the
   current lookahead is syntactically acceptable.  If it fails to find
   such a context, it discards the lookahead.  */
#if PKL_TAB_DEBUG
# define YY_LAC_DISCARD(Event)                                           \
do {                                                                     \
  if (yy_lac_established)                                                \
    {                                                                    \
      YYDPRINTF ((stderr, "LAC: initial context discarded due to "       \
                  Event "\n"));                                          \
      yy_lac_established = 0;                                            \
    }                                                                    \
} while (0)
#else
# define YY_LAC_DISCARD(Event) yy_lac_established = 0
#endif

/* Given the stack whose top is *YYSSP, return 0 iff YYTOKEN can
   eventually (after perhaps some reductions) be shifted, return 1 if
   not, or return YYENOMEM if memory is exhausted.  As preconditions and
   postconditions: *YYES_CAPACITY is the allocated size of the array to
   which *YYES points, and either *YYES = YYESA or *YYES points to an
   array allocated with YYSTACK_ALLOC.  yy_lac may overwrite the
   contents of either array, alter *YYES and *YYES_CAPACITY, and free
   any old *YYES other than YYESA.  */
static int
yy_lac (yy_state_t *yyesa, yy_state_t **yyes,
        YYPTRDIFF_T *yyes_capacity, yy_state_t *yyssp, yysymbol_kind_t yytoken)
{
  yy_state_t *yyes_prev = yyssp;
  yy_state_t *yyesp = yyes_prev;
  /* Reduce until we encounter a shift and thereby accept the token.  */
  YYDPRINTF ((stderr, "LAC: checking lookahead %s:", yysymbol_name (yytoken)));
  if (yytoken == YYSYMBOL_YYUNDEF)
    {
      YYDPRINTF ((stderr, " Always Err\n"));
      return 1;
    }
  while (1)
    {
      int yyrule = yypact[+*yyesp];
      if (yypact_value_is_default (yyrule)
          || (yyrule += yytoken) < 0 || YYLAST < yyrule
          || yycheck[yyrule] != yytoken)
        {
          /* Use the default action.  */
          yyrule = yydefact[+*yyesp];
          if (yyrule == 0)
            {
              YYDPRINTF ((stderr, " Err\n"));
              return 1;
            }
        }
      else
        {
          /* Use the action from yytable.  */
          yyrule = yytable[yyrule];
          if (yytable_value_is_error (yyrule))
            {
              YYDPRINTF ((stderr, " Err\n"));
              return 1;
            }
          if (0 < yyrule)
            {
              YYDPRINTF ((stderr, " S%d\n", yyrule));
              return 0;
            }
          yyrule = -yyrule;
        }
      /* By now we know we have to simulate a reduce.  */
      YYDPRINTF ((stderr, " R%d", yyrule - 1));
      {
        /* Pop the corresponding number of values from the stack.  */
        YYPTRDIFF_T yylen = yyr2[yyrule];
        /* First pop from the LAC stack as many tokens as possible.  */
        if (yyesp != yyes_prev)
          {
            YYPTRDIFF_T yysize = yyesp - *yyes + 1;
            if (yylen < yysize)
              {
                yyesp -= yylen;
                yylen = 0;
              }
            else
              {
                yyesp = yyes_prev;
                yylen -= yysize;
              }
          }
        /* Only afterwards look at the main stack.  */
        if (yylen)
          yyesp = yyes_prev -= yylen;
      }
      /* Push the resulting state of the reduction.  */
      {
        yy_state_fast_t yystate;
        {
          const int yylhs = yyr1[yyrule] - YYNTOKENS;
          const int yyi = yypgoto[yylhs] + *yyesp;
          yystate = (0 <= yyi && yyi <= YYLAST && yycheck[yyi] == *yyesp
                     ? yytable[yyi]
                     : yydefgoto[yylhs]);
        }
        if (yyesp == yyes_prev)
          {
            yyesp = *yyes;
            YY_IGNORE_USELESS_CAST_BEGIN
            *yyesp = YY_CAST (yy_state_t, yystate);
            YY_IGNORE_USELESS_CAST_END
          }
        else
          {
            if (yy_lac_stack_realloc (yyes_capacity, 1,
#if PKL_TAB_DEBUG
                                      " (", ")",
#endif
                                      yyes, yyesa, &yyesp, yyes_prev))
              {
                YYDPRINTF ((stderr, "\n"));
                return YYENOMEM;
              }
            YY_IGNORE_USELESS_CAST_BEGIN
            *++yyesp = YY_CAST (yy_state_t, yystate);
            YY_IGNORE_USELESS_CAST_END
          }
        YYDPRINTF ((stderr, " G%d", yystate));
      }
    }
}

/* Context of a parse error.  */
typedef struct
{
  yy_state_t *yyssp;
  yy_state_t *yyesa;
  yy_state_t **yyes;
  YYPTRDIFF_T *yyes_capacity;
  yysymbol_kind_t yytoken;
  YYLTYPE *yylloc;
} yypcontext_t;

/* Put in YYARG at most YYARGN of the expected tokens given the
   current YYCTX, and return the number of tokens stored in YYARG.  If
   YYARG is null, return the number of expected tokens (guaranteed to
   be less than YYNTOKENS).  Return YYENOMEM on memory exhaustion.
   Return 0 if there are more than YYARGN expected tokens, yet fill
   YYARG up to YYARGN. */
static int
yypcontext_expected_tokens (const yypcontext_t *yyctx,
                            yysymbol_kind_t yyarg[], int yyargn)
{
  /* Actual size of YYARG. */
  int yycount = 0;

  int yyx;
  for (yyx = 0; yyx < YYNTOKENS; ++yyx)
    {
      yysymbol_kind_t yysym = YY_CAST (yysymbol_kind_t, yyx);
      if (yysym != YYSYMBOL_YYerror && yysym != YYSYMBOL_YYUNDEF)
        switch (yy_lac (yyctx->yyesa, yyctx->yyes, yyctx->yyes_capacity, yyctx->yyssp, yysym))
          {
          case YYENOMEM:
            return YYENOMEM;
          case 1:
            continue;
          default:
            if (!yyarg)
              ++yycount;
            else if (yycount == yyargn)
              return 0;
            else
              yyarg[yycount++] = yysym;
          }
    }
  if (yyarg && yycount == 0 && 0 < yyargn)
    yyarg[0] = YYSYMBOL_YYEMPTY;
  return yycount;
}




/* The kind of the lookahead of this context.  */
static yysymbol_kind_t
yypcontext_token (const yypcontext_t *yyctx) YY_ATTRIBUTE_UNUSED;

static yysymbol_kind_t
yypcontext_token (const yypcontext_t *yyctx)
{
  return yyctx->yytoken;
}

/* The location of the lookahead of this context.  */
static YYLTYPE *
yypcontext_location (const yypcontext_t *yyctx) YY_ATTRIBUTE_UNUSED;

static YYLTYPE *
yypcontext_location (const yypcontext_t *yyctx)
{
  return yyctx->yylloc;
}

/* User defined function to report a syntax error.  */
static int
yyreport_syntax_error (const yypcontext_t *yyctx, struct pkl_parser *pkl_parser);

/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

static void
yydestruct (const char *yymsg,
            yysymbol_kind_t yykind, YYSTYPE *yyvaluep, YYLTYPE *yylocationp, struct pkl_parser *pkl_parser)
{
  YY_USE (yyvaluep);
  YY_USE (yylocationp);
  YY_USE (pkl_parser);
  if (!yymsg)
    yymsg = "Deleting";
  YY_SYMBOL_PRINT (yymsg, yykind, yyvaluep, yylocationp);

  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  switch (yykind)
    {
    case YYSYMBOL_INTEGER: /* "integer literal"  */
#line 386 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 3164 "pkl-tab.c"
        break;

    case YYSYMBOL_CHAR: /* "character literal"  */
#line 386 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 3192 "pkl-tab.c"
        break;

    case YYSYMBOL_STR: /* "string"  */
#line 386 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 3220 "pkl-tab.c"
        break;

    case YYSYMBOL_IDENTIFIER: /* "identifier"  */
#line 386 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 3248 "pkl-tab.c"
        break;

    case YYSYMBOL_TYPENAME: /* "type name"  */
#line 386 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 3276 "pkl-tab.c"
        break;

    case YYSYMBOL_UNIT: /* "offset unit"  */
#line 386 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 3304 "pkl-tab.c"
        break;

    case YYSYMBOL_OFFSET: /* "offset"  */
#line 386 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 3332 "pkl-tab.c"
        break;

    case YYSYMBOL_ATTR: /* "attribute"  */
#line 386 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 3360 "pkl-tab.c"
        break;

    case YYSYMBOL_start: /* start  */
#line 386 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 3388 "pkl-tab.c"
        break;

    case YYSYMBOL_program: /* program  */
#line 386 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 3416 "pkl-tab.c"
        break;

    case YYSYMBOL_program_elem_list: /* program_elem_list  */
#line 386 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 3444 "pkl-tab.c"
        break;

    case YYSYMBOL_program_elem: /* program_elem  */
#line 386 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 3472 "pkl-tab.c"
        break;

    case YYSYMBOL_load: /* load  */
#line 386 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 3500 "pkl-tab.c"
        break;

    case YYSYMBOL_integer: /* integer  */
#line 386 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 3528 "pkl-tab.c"
        break;

    case YYSYMBOL_identifier: /* identifier  */
#line 386 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 3556 "pkl-tab.c"
        break;

    case YYSYMBOL_expression_list: /* expression_list  */
#line 386 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 3584 "pkl-tab.c"
        break;

    case YYSYMBOL_expression_opt: /* expression_opt  */
#line 386 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 3612 "pkl-tab.c"
        break;

    case YYSYMBOL_expression: /* expression  */
#line 386 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 3640 "pkl-tab.c"
        break;

    case YYSYMBOL_bconc: /* bconc  */
#line 386 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 3668 "pkl-tab.c"
        break;

    case YYSYMBOL_map: /* map  */
#line 386 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 3696 "pkl-tab.c"
        break;

    case YYSYMBOL_primary: /* primary  */
#line 386 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 3724 "pkl-tab.c"
        break;

    case YYSYMBOL_funcall: /* funcall  */
#line 386 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 3752 "pkl-tab.c"
        break;

    case YYSYMBOL_funcall_arg_list: /* funcall_arg_list  */
#line 386 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 3780 "pkl-tab.c"
        break;

    case YYSYMBOL_funcall_arg: /* funcall_arg  */
#line 386 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 3808 "pkl-tab.c"
        break;

    case YYSYMBOL_format_arg_list: /* format_arg_list  */
#line 386 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 3836 "pkl-tab.c"
        break;

    case YYSYMBOL_format_arg: /* format_arg  */
#line 386 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 3864 "pkl-tab.c"
        break;

    case YYSYMBOL_struct_field_list: /* struct_field_list  */
#line 386 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 3892 "pkl-tab.c"
        break;

    case YYSYMBOL_struct_field: /* struct_field  */
#line 386 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 3920 "pkl-tab.c"
        break;

    case YYSYMBOL_array: /* array  */
#line 386 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 3948 "pkl-tab.c"
        break;

    case YYSYMBOL_array_initializer_list: /* array_initializer_list  */
#line 386 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 3976 "pkl-tab.c"
        break;

    case YYSYMBOL_array_initializer: /* array_initializer  */
#line 386 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 4004 "pkl-tab.c"
        break;

    case YYSYMBOL_function_specifier: /* function_specifier  */
#line 386 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 4032 "pkl-tab.c"
        break;

    case YYSYMBOL_function_arg_list: /* function_arg_list  */
#line 386 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 4060 "pkl-tab.c"
        break;

    case YYSYMBOL_function_arg: /* function_arg  */
#line 386 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 4088 "pkl-tab.c"
        break;

    case YYSYMBOL_function_arg_initial: /* function_arg_initial  */
#line 386 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 4116 "pkl-tab.c"
        break;

    case YYSYMBOL_type_specifier: /* type_specifier  */
#line 386 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 4144 "pkl-tab.c"
        break;

    case YYSYMBOL_typename: /* typename  */
#line 386 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 4172 "pkl-tab.c"
        break;

    case YYSYMBOL_string_type_specifier: /* string_type_specifier  */
#line 386 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 4200 "pkl-tab.c"
        break;

    case YYSYMBOL_simple_type_specifier: /* simple_type_specifier  */
#line 386 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 4228 "pkl-tab.c"
        break;

    case YYSYMBOL_cons_type_specifier: /* cons_type_specifier  */
#line 386 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 4256 "pkl-tab.c"
        break;

    case YYSYMBOL_integral_type_specifier: /* integral_type_specifier  */
#line 386 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 4284 "pkl-tab.c"
        break;

    case YYSYMBOL_offset_type_specifier: /* offset_type_specifier  */
#line 386 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 4312 "pkl-tab.c"
        break;

    case YYSYMBOL_array_type_specifier: /* array_type_specifier  */
#line 386 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 4340 "pkl-tab.c"
        break;

    case YYSYMBOL_function_type_specifier: /* function_type_specifier  */
#line 386 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 4368 "pkl-tab.c"
        break;

    case YYSYMBOL_function_type_arg_list: /* function_type_arg_list  */
#line 386 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 4396 "pkl-tab.c"
        break;

    case YYSYMBOL_function_type_arg: /* function_type_arg  */
#line 386 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 4424 "pkl-tab.c"
        break;

    case YYSYMBOL_struct_type_specifier: /* struct_type_specifier  */
#line 386 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 4452 "pkl-tab.c"
        break;

    case YYSYMBOL_integral_struct: /* integral_struct  */
#line 386 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 4480 "pkl-tab.c"
        break;

    case YYSYMBOL_struct_type_elem_list: /* struct_type_elem_list  */
#line 386 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 4508 "pkl-tab.c"
        break;

    case YYSYMBOL_struct_type_computed_field: /* struct_type_computed_field  */
#line 386 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 4536 "pkl-tab.c"
        break;

    case YYSYMBOL_struct_type_field: /* struct_type_field  */
#line 386 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 4564 "pkl-tab.c"
        break;

    case YYSYMBOL_struct_type_field_identifier: /* struct_type_field_identifier  */
#line 386 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 4592 "pkl-tab.c"
        break;

    case YYSYMBOL_struct_type_field_label: /* struct_type_field_label  */
#line 386 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 4620 "pkl-tab.c"
        break;

    case YYSYMBOL_struct_type_field_optcond_pre: /* struct_type_field_optcond_pre  */
#line 386 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 4648 "pkl-tab.c"
        break;

    case YYSYMBOL_struct_type_field_optcond_post: /* struct_type_field_optcond_post  */
#line 386 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 4676 "pkl-tab.c"
        break;

    case YYSYMBOL_simple_declaration: /* simple_declaration  */
#line 386 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 4704 "pkl-tab.c"
        break;

    case YYSYMBOL_declaration: /* declaration  */
#line 386 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 4732 "pkl-tab.c"
        break;

    case YYSYMBOL_defvar_list: /* defvar_list  */
#line 386 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 4760 "pkl-tab.c"
        break;

    case YYSYMBOL_defvar: /* defvar  */
#line 386 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 4788 "pkl-tab.c"
        break;

    case YYSYMBOL_deftype_list: /* deftype_list  */
#line 386 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 4816 "pkl-tab.c"
        break;

    case YYSYMBOL_deftype: /* deftype  */
#line 386 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 4844 "pkl-tab.c"
        break;

    case YYSYMBOL_defunit_list: /* defunit_list  */
#line 386 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 4872 "pkl-tab.c"
        break;

    case YYSYMBOL_defunit: /* defunit  */
#line 386 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 4900 "pkl-tab.c"
        break;

    case YYSYMBOL_comp_stmt: /* comp_stmt  */
#line 386 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 4928 "pkl-tab.c"
        break;

    case YYSYMBOL_stmt_decl_list: /* stmt_decl_list  */
#line 386 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 4956 "pkl-tab.c"
        break;

    case YYSYMBOL_simple_stmt_list: /* simple_stmt_list  */
#line 386 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 4984 "pkl-tab.c"
        break;

    case YYSYMBOL_simple_stmt: /* simple_stmt  */
#line 386 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 5012 "pkl-tab.c"
        break;

    case YYSYMBOL_stmt: /* stmt  */
#line 386 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 5040 "pkl-tab.c"
        break;

    case YYSYMBOL_funcall_stmt: /* funcall_stmt  */
#line 386 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 5068 "pkl-tab.c"
        break;

    case YYSYMBOL_funcall_stmt_arg_list: /* funcall_stmt_arg_list  */
#line 386 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 5096 "pkl-tab.c"
        break;

    case YYSYMBOL_funcall_stmt_arg: /* funcall_stmt_arg  */
#line 386 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 5124 "pkl-tab.c"
        break;

      default:
        break;
    }
  YY_IGNORE_MAYBE_UNINITIALIZED_END
}






/*----------.
| yyparse.  |
`----------*/

int
yyparse (struct pkl_parser *pkl_parser)
{
/* Lookahead token kind.  */
int yychar;


/* The semantic value of the lookahead symbol.  */
/* Default value used for initialization, for pacifying older GCCs
   or non-GCC compilers.  */
YY_INITIAL_VALUE (static YYSTYPE yyval_default;)
YYSTYPE yylval YY_INITIAL_VALUE (= yyval_default);

/* Location data for the lookahead symbol.  */
static YYLTYPE yyloc_default
# if defined PKL_TAB_LTYPE_IS_TRIVIAL && PKL_TAB_LTYPE_IS_TRIVIAL
  = { 1, 1, 1, 1 }
# endif
;
YYLTYPE yylloc = yyloc_default;

    /* Number of syntax errors so far.  */
    int yynerrs = 0;

    yy_state_fast_t yystate = 0;
    /* Number of tokens to shift before error messages enabled.  */
    int yyerrstatus = 0;

    /* Refer to the stacks through separate pointers, to allow yyoverflow
       to reallocate them elsewhere.  */

    /* Their size.  */
    YYPTRDIFF_T yystacksize = YYINITDEPTH;

    /* The state stack: array, bottom, top.  */
    yy_state_t yyssa[YYINITDEPTH];
    yy_state_t *yyss = yyssa;
    yy_state_t *yyssp = yyss;

    /* The semantic value stack: array, bottom, top.  */
    YYSTYPE yyvsa[YYINITDEPTH];
    YYSTYPE *yyvs = yyvsa;
    YYSTYPE *yyvsp = yyvs;

    /* The location stack: array, bottom, top.  */
    YYLTYPE yylsa[YYINITDEPTH];
    YYLTYPE *yyls = yylsa;
    YYLTYPE *yylsp = yyls;

    yy_state_t yyesa[20];
    yy_state_t *yyes = yyesa;
    YYPTRDIFF_T yyes_capacity = 20 < YYMAXDEPTH ? 20 : YYMAXDEPTH;

  /* Whether LAC context is established.  A Boolean.  */
  int yy_lac_established = 0;
  int yyn;
  /* The return value of yyparse.  */
  int yyresult;
  /* Lookahead symbol kind.  */
  yysymbol_kind_t yytoken = YYSYMBOL_YYEMPTY;
  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;
  YYLTYPE yyloc;

  /* The locations where the error started and ended.  */
  YYLTYPE yyerror_range[3];



#define YYPOPSTACK(N)   (yyvsp -= (N), yyssp -= (N), yylsp -= (N))

  /* The number of symbols on the RHS of the reduced rule.
     Keep to zero when no symbol should be popped.  */
  int yylen = 0;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yychar = PKL_TAB_EMPTY; /* Cause a token to be read.  */

/* User initialization code.  */
#line 30 "pkl-tab.y"
{
    yylloc.first_line = yylloc.last_line = pkl_parser->init_line;
    yylloc.first_column = yylloc.last_column = pkl_parser->init_column;
}

#line 5229 "pkl-tab.c"

  yylsp[0] = yylloc;
  goto yysetstate;


/*------------------------------------------------------------.
| yynewstate -- push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed.  So pushing a state here evens the stacks.  */
  yyssp++;


/*--------------------------------------------------------------------.
| yysetstate -- set current state (the top of the stack) to yystate.  |
`--------------------------------------------------------------------*/
yysetstate:
  YYDPRINTF ((stderr, "Entering state %d\n", yystate));
  YY_ASSERT (0 <= yystate && yystate < YYNSTATES);
  YY_IGNORE_USELESS_CAST_BEGIN
  *yyssp = YY_CAST (yy_state_t, yystate);
  YY_IGNORE_USELESS_CAST_END
  YY_STACK_PRINT (yyss, yyssp);

  if (yyss + yystacksize - 1 <= yyssp)
#if !defined yyoverflow && !defined YYSTACK_RELOCATE
    goto yyexhaustedlab;
#else
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYPTRDIFF_T yysize = yyssp - yyss + 1;

# if defined yyoverflow
      {
        /* Give user a chance to reallocate the stack.  Use copies of
           these so that the &'s don't force the real ones into
           memory.  */
        yy_state_t *yyss1 = yyss;
        YYSTYPE *yyvs1 = yyvs;
        YYLTYPE *yyls1 = yyls;

        /* Each stack pointer address is followed by the size of the
           data in use in that stack, in bytes.  This used to be a
           conditional around just the two extra args, but that might
           be undefined if yyoverflow is a macro.  */
        yyoverflow (YY_("memory exhausted"),
                    &yyss1, yysize * YYSIZEOF (*yyssp),
                    &yyvs1, yysize * YYSIZEOF (*yyvsp),
                    &yyls1, yysize * YYSIZEOF (*yylsp),
                    &yystacksize);
        yyss = yyss1;
        yyvs = yyvs1;
        yyls = yyls1;
      }
# else /* defined YYSTACK_RELOCATE */
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
        goto yyexhaustedlab;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
        yystacksize = YYMAXDEPTH;

      {
        yy_state_t *yyss1 = yyss;
        union yyalloc *yyptr =
          YY_CAST (union yyalloc *,
                   YYSTACK_ALLOC (YY_CAST (YYSIZE_T, YYSTACK_BYTES (yystacksize))));
        if (! yyptr)
          goto yyexhaustedlab;
        YYSTACK_RELOCATE (yyss_alloc, yyss);
        YYSTACK_RELOCATE (yyvs_alloc, yyvs);
        YYSTACK_RELOCATE (yyls_alloc, yyls);
#  undef YYSTACK_RELOCATE
        if (yyss1 != yyssa)
          YYSTACK_FREE (yyss1);
      }
# endif

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;
      yylsp = yyls + yysize - 1;

      YY_IGNORE_USELESS_CAST_BEGIN
      YYDPRINTF ((stderr, "Stack size increased to %ld\n",
                  YY_CAST (long, yystacksize)));
      YY_IGNORE_USELESS_CAST_END

      if (yyss + yystacksize - 1 <= yyssp)
        YYABORT;
    }
#endif /* !defined yyoverflow && !defined YYSTACK_RELOCATE */

  if (yystate == YYFINAL)
    YYACCEPT;

  goto yybackup;


/*-----------.
| yybackup.  |
`-----------*/
yybackup:
  /* Do appropriate processing given the current state.  Read a
     lookahead token if we need one and don't already have one.  */

  /* First try to decide what to do without reference to lookahead token.  */
  yyn = yypact[yystate];
  if (yypact_value_is_default (yyn))
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* YYCHAR is either empty, or end-of-input, or a valid lookahead.  */
  if (yychar == PKL_TAB_EMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token\n"));
      yychar = yylex (&yylval, &yylloc, scanner);
    }

  if (yychar <= PKL_TAB_EOF)
    {
      yychar = PKL_TAB_EOF;
      yytoken = YYSYMBOL_YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else if (yychar == PKL_TAB_error)
    {
      /* The scanner already issued an error message, process directly
         to error recovery.  But do not keep the error token as
         lookahead, it is too special and may lead us to an endless
         loop in error recovery. */
      yychar = PKL_TAB_UNDEF;
      yytoken = YYSYMBOL_YYerror;
      yyerror_range[1] = yylloc;
      goto yyerrlab1;
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YY_SYMBOL_PRINT ("Next token is", yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    {
      YY_LAC_ESTABLISH;
      goto yydefault;
    }
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yytable_value_is_error (yyn))
        goto yyerrlab;
      YY_LAC_ESTABLISH;
      yyn = -yyn;
      goto yyreduce;
    }

  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  /* Shift the lookahead token.  */
  YY_SYMBOL_PRINT ("Shifting", yytoken, &yylval, &yylloc);
  yystate = yyn;
  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  *++yyvsp = yylval;
  YY_IGNORE_MAYBE_UNINITIALIZED_END
  *++yylsp = yylloc;

  /* Discard the shifted token.  */
  yychar = PKL_TAB_EMPTY;
  YY_LAC_DISCARD ("shift");
  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     '$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];

  /* Default location. */
  YYLLOC_DEFAULT (yyloc, (yylsp - yylen), yylen);
  yyerror_range[1] = yyloc;
  YY_REDUCE_PRINT (yyn);
  {
    int yychar_backup = yychar;
    switch (yyn)
      {
  case 2: /* pushlevel: %empty  */
#line 600 "pkl-tab.y"
                {
                  pkl_parser->env = pkl_env_push_frame (pkl_parser->env);
                }
#line 5450 "pkl-tab.c"
    break;

  case 3: /* start: START_EXP expression  */
#line 615 "pkl-tab.y"
                  {
                  (yyval.ast) = pkl_ast_make_program (pkl_parser->ast, (yyvsp[0].ast));
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                  pkl_parser->ast->ast = ASTREF ((yyval.ast));
                }
#line 5460 "pkl-tab.c"
    break;

  case 4: /* start: START_EXP expression ','  */
#line 621 "pkl-tab.y"
                  {
                  (yyval.ast) = pkl_ast_make_program (pkl_parser->ast, (yyvsp[-1].ast));
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                  pkl_parser->ast->ast = ASTREF ((yyval.ast));
                  YYACCEPT;
                }
#line 5471 "pkl-tab.c"
    break;

  case 5: /* start: START_DECL declaration  */
#line 628 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_program (pkl_parser->ast, (yyvsp[0].ast));
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                  pkl_parser->ast->ast = ASTREF ((yyval.ast));
                }
#line 5481 "pkl-tab.c"
    break;

  case 6: /* start: START_DECL declaration ','  */
#line 634 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_program (pkl_parser->ast, (yyvsp[-1].ast));
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                  pkl_parser->ast->ast = ASTREF ((yyval.ast));
                }
#line 5491 "pkl-tab.c"
    break;

  case 7: /* start: START_STMT stmt  */
#line 640 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_program (pkl_parser->ast, (yyvsp[0].ast));
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                  pkl_parser->ast->ast = ASTREF ((yyval.ast));
                }
#line 5501 "pkl-tab.c"
    break;

  case 8: /* start: START_STMT stmt ';'  */
#line 646 "pkl-tab.y"
                {
                  /* This rule is to allow the presence of an extra
                     ';' after the sentence.  This to allow the poke
                     command manager to ease the handling of
                     semicolons in the command line.  */
                  (yyval.ast) = pkl_ast_make_program (pkl_parser->ast, (yyvsp[-1].ast));
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                  pkl_parser->ast->ast = ASTREF ((yyval.ast));
                }
#line 5515 "pkl-tab.c"
    break;

  case 9: /* start: START_STMT load  */
#line 656 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_program (pkl_parser->ast, (yyvsp[0].ast));
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                  pkl_parser->ast->ast = ASTREF ((yyval.ast));
                }
#line 5525 "pkl-tab.c"
    break;

  case 10: /* start: START_STMT load ';'  */
#line 662 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_program (pkl_parser->ast, (yyvsp[-1].ast));
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                  pkl_parser->ast->ast = ASTREF ((yyval.ast));
                }
#line 5535 "pkl-tab.c"
    break;

  case 11: /* start: START_PROGRAM program  */
#line 668 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_program (pkl_parser->ast, (yyvsp[0].ast));
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                  pkl_parser->ast->ast = ASTREF ((yyval.ast));
                }
#line 5545 "pkl-tab.c"
    break;

  case 12: /* program: %empty  */
#line 677 "pkl-tab.y"
                {
                  (yyval.ast) = NULL;
                }
#line 5553 "pkl-tab.c"
    break;

  case 15: /* program_elem_list: program_elem_list program_elem  */
#line 686 "pkl-tab.y"
                {
                  if ((yyvsp[0].ast) != NULL)
                    (yyval.ast) = pkl_ast_chainon ((yyvsp[-1].ast), (yyvsp[0].ast));
                  else
                    (yyval.ast) = (yyvsp[-1].ast);
                }
#line 5564 "pkl-tab.c"
    break;

  case 17: /* program_elem: IMMUTABLE declaration  */
#line 697 "pkl-tab.y"
          {
            PKL_AST_DECL_IMMUTABLE_P ((yyvsp[0].ast)) = 1;
            (yyval.ast) = (yyvsp[0].ast);
          }
#line 5573 "pkl-tab.c"
    break;

  case 20: /* load: "keyword `load'" "identifier" ';'  */
#line 707 "pkl-tab.y"
                {
                  char *filename = NULL;
                  int ret = load_module (pkl_parser,
                                         PKL_AST_IDENTIFIER_POINTER ((yyvsp[-1].ast)),
                                         &(yyval.ast), 0 /* filename_p */, &filename);
                  if (ret == 2)
                    /* The sub-parser should have emitted proper error
                       messages.  No need to be verbose here.  */
                    YYERROR;
                  else if (ret == 1)
                    {
                      pkl_error (pkl_parser->compiler, pkl_parser->ast, (yylsp[-1]),
                                 "cannot load `%s'",
                                 PKL_AST_IDENTIFIER_POINTER ((yyvsp[-1].ast)));
                      YYERROR;
                    }

                  /* Prepend and append SRC nodes to handle the change of
                     source files.  */
                  {
                      pkl_ast_node src1 = pkl_ast_make_src (pkl_parser->ast,
                                                            filename);
                      pkl_ast_node src2 = pkl_ast_make_src (pkl_parser->ast,
                                                            pkl_parser->filename);

                      (yyval.ast) = pkl_ast_chainon (src1, (yyval.ast));
                      (yyval.ast) = pkl_ast_chainon ((yyval.ast), src2);
                  }

                  (yyvsp[-1].ast) = ASTREF ((yyvsp[-1].ast));
                  pkl_ast_node_free ((yyvsp[-1].ast));
                  free (filename);
                }
#line 5611 "pkl-tab.c"
    break;

  case 21: /* load: "keyword `load'" "string" ';'  */
#line 741 "pkl-tab.y"
                {
                  char *filename = PKL_AST_STRING_POINTER ((yyvsp[-1].ast));
                  int ret = load_module (pkl_parser,
                                         filename,
                                         &(yyval.ast), 1 /* filename_p */, NULL);
                  if (ret == 2)
                    /* The sub-parser should have emitted proper error
                       messages.  No need to be verbose here.  */
                    YYERROR;
                  else if (ret == 1)
                    {
                      pkl_error (pkl_parser->compiler, pkl_parser->ast, (yylsp[-1]),
                                 "cannot load module from file `%s'",
                                 filename);
                      YYERROR;
                    }

                  /* Prepend and append SRC nodes to handle the change of
                     source files.  */
                  {
                      pkl_ast_node src1 = pkl_ast_make_src (pkl_parser->ast,
                                                            filename);
                      pkl_ast_node src2 = pkl_ast_make_src (pkl_parser->ast,
                                                            pkl_parser->filename);

                      (yyval.ast) = pkl_ast_chainon (src1, (yyval.ast));
                      (yyval.ast) = pkl_ast_chainon ((yyval.ast), src2);
                  }

                  (yyvsp[-1].ast) = ASTREF ((yyvsp[-1].ast));
                  pkl_ast_node_free ((yyvsp[-1].ast));
                }
#line 5648 "pkl-tab.c"
    break;

  case 23: /* integer: LEXER_EXCEPTION  */
#line 782 "pkl-tab.y"
          {
            (yyval.ast) = NULL; /* To avoid bison warning.  */
            pkl_error (pkl_parser->compiler, pkl_parser->ast, (yylsp[0]),
                       (yyvsp[0].exception_msg));
            free ((yyvsp[0].exception_msg));
            YYERROR;
          }
#line 5660 "pkl-tab.c"
    break;

  case 26: /* expression_list: %empty  */
#line 806 "pkl-tab.y"
                  { (yyval.ast) = NULL; }
#line 5666 "pkl-tab.c"
    break;

  case 28: /* expression_list: expression_list ',' expression  */
#line 809 "pkl-tab.y"
                  {
                    (yyval.ast) = pkl_ast_chainon ((yyvsp[-2].ast), (yyvsp[0].ast));
                  }
#line 5674 "pkl-tab.c"
    break;

  case 29: /* expression_opt: %empty  */
#line 815 "pkl-tab.y"
                 { (yyval.ast) = NULL; }
#line 5680 "pkl-tab.c"
    break;

  case 32: /* expression: unary_operator expression  */
#line 822 "pkl-tab.y"
                  {
                  (yyval.ast) = pkl_ast_make_unary_exp (pkl_parser->ast,
                                               (yyvsp[-1].opcode), (yyvsp[0].ast));
                  PKL_AST_LOC ((yyval.ast)) = (yylsp[-1]);
                }
#line 5690 "pkl-tab.c"
    break;

  case 33: /* expression: expression "attribute"  */
#line 828 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_binary_exp (pkl_parser->ast, PKL_AST_OP_ATTR,
                                                (yyvsp[-1].ast), (yyvsp[0].ast));
                  PKL_AST_LOC ((yyvsp[0].ast)) = (yylsp[0]);
                  PKL_AST_LOC ((yyval.ast)) = (yylsp[0]);
                }
#line 5701 "pkl-tab.c"
    break;

  case 34: /* expression: expression "attribute" '(' expression ')'  */
#line 835 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_ternary_exp (pkl_parser->ast, PKL_AST_OP_ATTR,
                                                 (yyvsp[-4].ast), (yyvsp[-3].ast), (yyvsp[-1].ast));
                  PKL_AST_LOC ((yyvsp[-3].ast)) = (yylsp[-3]);
                  PKL_AST_LOC ((yyval.ast)) = (yylsp[-3]);
                }
#line 5712 "pkl-tab.c"
    break;

  case 35: /* expression: expression "addition operator" expression  */
#line 842 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_binary_exp (pkl_parser->ast, PKL_AST_OP_ADD,
                                                (yyvsp[-2].ast), (yyvsp[0].ast));
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 5722 "pkl-tab.c"
    break;

  case 36: /* expression: expression "subtraction operator" expression  */
#line 848 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_binary_exp (pkl_parser->ast, PKL_AST_OP_SUB,
                                                (yyvsp[-2].ast), (yyvsp[0].ast));
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 5732 "pkl-tab.c"
    break;

  case 37: /* expression: expression "multiplication operator" expression  */
#line 854 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_binary_exp (pkl_parser->ast, PKL_AST_OP_MUL,
                                                (yyvsp[-2].ast), (yyvsp[0].ast));
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 5742 "pkl-tab.c"
    break;

  case 38: /* expression: expression "division operator" expression  */
#line 860 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_binary_exp (pkl_parser->ast, PKL_AST_OP_DIV,
                                                (yyvsp[-2].ast), (yyvsp[0].ast));
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 5752 "pkl-tab.c"
    break;

  case 39: /* expression: expression "ceiling division operator" expression  */
#line 866 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_binary_exp (pkl_parser->ast, PKL_AST_OP_CEILDIV, (yyvsp[-2].ast), (yyvsp[0].ast));
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 5761 "pkl-tab.c"
    break;

  case 40: /* expression: expression "power operator" expression  */
#line 871 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_binary_exp (pkl_parser->ast, PKL_AST_OP_POW, (yyvsp[-2].ast), (yyvsp[0].ast));
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 5770 "pkl-tab.c"
    break;

  case 41: /* expression: expression "modulus operator" expression  */
#line 876 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_binary_exp (pkl_parser->ast, PKL_AST_OP_MOD,
                                                (yyvsp[-2].ast), (yyvsp[0].ast));
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 5780 "pkl-tab.c"
    break;

  case 42: /* expression: expression "left shift operator" expression  */
#line 882 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_binary_exp (pkl_parser->ast, PKL_AST_OP_SL,
                                                (yyvsp[-2].ast), (yyvsp[0].ast));
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 5790 "pkl-tab.c"
    break;

  case 43: /* expression: expression "right shift operator" expression  */
#line 888 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_binary_exp (pkl_parser->ast, PKL_AST_OP_SR,
                                                (yyvsp[-2].ast), (yyvsp[0].ast));
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 5800 "pkl-tab.c"
    break;

  case 44: /* expression: expression "equality operator" expression  */
#line 894 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_binary_exp (pkl_parser->ast, PKL_AST_OP_EQ,
                                                (yyvsp[-2].ast), (yyvsp[0].ast));
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 5810 "pkl-tab.c"
    break;

  case 45: /* expression: expression "inequality operator" expression  */
#line 900 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_binary_exp (pkl_parser->ast, PKL_AST_OP_NE,
                                                (yyvsp[-2].ast), (yyvsp[0].ast));
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 5820 "pkl-tab.c"
    break;

  case 46: /* expression: expression "less-than operator" expression  */
#line 906 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_binary_exp (pkl_parser->ast, PKL_AST_OP_LT,
                                                (yyvsp[-2].ast), (yyvsp[0].ast));
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 5830 "pkl-tab.c"
    break;

  case 47: /* expression: expression "bigger-than operator" expression  */
#line 912 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_binary_exp (pkl_parser->ast, PKL_AST_OP_GT,
                                                (yyvsp[-2].ast), (yyvsp[0].ast));
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 5840 "pkl-tab.c"
    break;

  case 48: /* expression: expression "less-or-equal operator" expression  */
#line 918 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_binary_exp (pkl_parser->ast, PKL_AST_OP_LE,
                                                (yyvsp[-2].ast), (yyvsp[0].ast));
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 5850 "pkl-tab.c"
    break;

  case 49: /* expression: expression "bigger-or-equal-than operator" expression  */
#line 924 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_binary_exp (pkl_parser->ast, PKL_AST_OP_GE,
                                                (yyvsp[-2].ast), (yyvsp[0].ast));
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 5860 "pkl-tab.c"
    break;

  case 50: /* expression: expression "bit-wise or operator" expression  */
#line 930 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_binary_exp (pkl_parser->ast, PKL_AST_OP_IOR,
                                                (yyvsp[-2].ast), (yyvsp[0].ast));
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 5870 "pkl-tab.c"
    break;

  case 51: /* expression: expression "bit-wise xor operator" expression  */
#line 936 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_binary_exp (pkl_parser->ast, PKL_AST_OP_XOR,
                                                (yyvsp[-2].ast), (yyvsp[0].ast));
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 5880 "pkl-tab.c"
    break;

  case 52: /* expression: expression "bit-wise and operator" expression  */
#line 942 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_binary_exp (pkl_parser->ast, PKL_AST_OP_BAND,
                                                (yyvsp[-2].ast), (yyvsp[0].ast));
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 5890 "pkl-tab.c"
    break;

  case 53: /* expression: expression "logical and operator" expression  */
#line 948 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_binary_exp (pkl_parser->ast, PKL_AST_OP_AND,
                                                (yyvsp[-2].ast), (yyvsp[0].ast));
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 5900 "pkl-tab.c"
    break;

  case 54: /* expression: expression "logical or operator" expression  */
#line 954 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_binary_exp (pkl_parser->ast, PKL_AST_OP_OR,
                                                (yyvsp[-2].ast), (yyvsp[0].ast));
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 5910 "pkl-tab.c"
    break;

  case 55: /* expression: expression "logical implication operator" expression  */
#line 960 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_binary_exp (pkl_parser->ast, PKL_AST_OP_IMPL,
                                                (yyvsp[-2].ast), (yyvsp[0].ast));
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 5920 "pkl-tab.c"
    break;

  case 56: /* expression: expression "keyword `in'" expression  */
#line 966 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_binary_exp (pkl_parser->ast, PKL_AST_OP_IN,
                                                (yyvsp[-2].ast), (yyvsp[0].ast));
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 5930 "pkl-tab.c"
    break;

  case 57: /* expression: expression "cast operator" simple_type_specifier  */
#line 972 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_cast (pkl_parser->ast, (yyvsp[0].ast), (yyvsp[-2].ast));
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 5939 "pkl-tab.c"
    break;

  case 58: /* expression: expression "type identification operator" simple_type_specifier  */
#line 977 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_isa (pkl_parser->ast, (yyvsp[0].ast), (yyvsp[-2].ast));
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 5948 "pkl-tab.c"
    break;

  case 59: /* expression: expression '?' expression ':' expression  */
#line 982 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_cond_exp (pkl_parser->ast,
                                              (yyvsp[-4].ast), (yyvsp[-2].ast), (yyvsp[0].ast));
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 5958 "pkl-tab.c"
    break;

  case 60: /* expression: comp_stmt "conditional on exception operator" expression  */
#line 988 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_binary_exp (pkl_parser->ast, PKL_AST_OP_EXCOND,
                                                (yyvsp[-2].ast), (yyvsp[0].ast));
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 5968 "pkl-tab.c"
    break;

  case 61: /* expression: expression "conditional on exception operator" expression  */
#line 994 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_binary_exp (pkl_parser->ast, PKL_AST_OP_EXCOND,
                                                (yyvsp[-2].ast), (yyvsp[0].ast));
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 5978 "pkl-tab.c"
    break;

  case 62: /* expression: "offset unit"  */
#line 1000 "pkl-tab.y"
                {
                  if ((yyvsp[0].ast) == NULL)
                    {
                      pkl_error (pkl_parser->compiler, pkl_parser->ast, (yylsp[0]),
                                 "invalid unit in offset");
                      YYERROR;
                    }

                    (yyval.ast) = pkl_ast_make_offset (pkl_parser->ast, NULL, (yyvsp[0].ast));
                    PKL_AST_LOC ((yyvsp[0].ast)) = (yylsp[0]);
                    if (PKL_AST_TYPE ((yyvsp[0].ast)))
                        PKL_AST_LOC (PKL_AST_TYPE ((yyvsp[0].ast))) = (yylsp[0]);
                    PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 5997 "pkl-tab.c"
    break;

  case 63: /* expression: "offset"  */
#line 1015 "pkl-tab.y"
                {
                  (yyval.ast) = (yyvsp[0].ast);
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 6006 "pkl-tab.c"
    break;

  case 64: /* expression: expression "offset unit"  */
#line 1020 "pkl-tab.y"
                {
                  if ((yyvsp[0].ast) == NULL)
                    {
                      pkl_error (pkl_parser->compiler, pkl_parser->ast, (yylsp[0]),
                                 "invalid unit in offset");
                      YYERROR;
                    }

                    (yyval.ast) = pkl_ast_make_offset (pkl_parser->ast, (yyvsp[-1].ast), (yyvsp[0].ast));
                    PKL_AST_LOC ((yyvsp[0].ast)) = (yylsp[0]);
                    if (PKL_AST_TYPE ((yyvsp[0].ast)))
                        PKL_AST_LOC (PKL_AST_TYPE ((yyvsp[0].ast))) = (yylsp[0]);
                    PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 6025 "pkl-tab.c"
    break;

  case 65: /* expression: "increment operator" expression  */
#line 1035 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_incrdecr (pkl_parser->ast, (yyvsp[0].ast),
                                              PKL_AST_ORDER_PRE, PKL_AST_SIGN_INCR);
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 6035 "pkl-tab.c"
    break;

  case 66: /* expression: "decrement operator" expression  */
#line 1041 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_incrdecr (pkl_parser->ast, (yyvsp[0].ast),
                                              PKL_AST_ORDER_PRE, PKL_AST_SIGN_DECR);
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 6045 "pkl-tab.c"
    break;

  case 69: /* bconc: expression "bit-concatenation operator" expression  */
#line 1052 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_binary_exp (pkl_parser->ast, PKL_AST_OP_BCONC,
                                                (yyvsp[-2].ast), (yyvsp[0].ast));
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 6055 "pkl-tab.c"
    break;

  case 70: /* mapop: "map operator"  */
#line 1060 "pkl-tab.y"
             { (yyval.integer) = 1; }
#line 6061 "pkl-tab.c"
    break;

  case 71: /* mapop: "non-strict map operator"  */
#line 1061 "pkl-tab.y"
                { (yyval.integer) = 0; }
#line 6067 "pkl-tab.c"
    break;

  case 72: /* map: simple_type_specifier mapop expression  */
#line 1066 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_map (pkl_parser->ast, (yyvsp[-1].integer),
                                         (yyvsp[-2].ast), NULL, (yyvsp[0].ast));
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 6077 "pkl-tab.c"
    break;

  case 73: /* map: simple_type_specifier mapop expression ':' expression  */
#line 1072 "pkl-tab.y"
                 {
                   (yyval.ast) = pkl_ast_make_map (pkl_parser->ast, (yyvsp[-3].integer),
                                          (yyvsp[-4].ast), (yyvsp[-2].ast), (yyvsp[0].ast));
                   PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 6087 "pkl-tab.c"
    break;

  case 74: /* unary_operator: "subtraction operator"  */
#line 1080 "pkl-tab.y"
                             { (yyval.opcode) = PKL_AST_OP_NEG; }
#line 6093 "pkl-tab.c"
    break;

  case 75: /* unary_operator: "addition operator"  */
#line 1081 "pkl-tab.y"
                             { (yyval.opcode) = PKL_AST_OP_POS; }
#line 6099 "pkl-tab.c"
    break;

  case 76: /* unary_operator: '~'  */
#line 1082 "pkl-tab.y"
                             { (yyval.opcode) = PKL_AST_OP_BNOT; }
#line 6105 "pkl-tab.c"
    break;

  case 77: /* unary_operator: '!'  */
#line 1083 "pkl-tab.y"
                             { (yyval.opcode) = PKL_AST_OP_NOT; }
#line 6111 "pkl-tab.c"
    break;

  case 78: /* unary_operator: "unmap operator"  */
#line 1084 "pkl-tab.y"
                             { (yyval.opcode) = PKL_AST_OP_UNMAP; }
#line 6117 "pkl-tab.c"
    break;

  case 79: /* unary_operator: "remap operator"  */
#line 1085 "pkl-tab.y"
                             { (yyval.opcode) = PKL_AST_OP_REMAP; }
#line 6123 "pkl-tab.c"
    break;

  case 80: /* primary: "identifier"  */
#line 1090 "pkl-tab.y"
                  {
                  /* Search for a variable definition in the
                     compile-time environment, and create a
                     PKL_AST_VAR node with it's lexical environment,
                     annotated with its initialization.  */

                  int back, over;
                  const char *name = PKL_AST_IDENTIFIER_POINTER ((yyvsp[0].ast));

                  pkl_ast_node decl
                    = pkl_env_lookup (pkl_parser->env,
                                      PKL_ENV_NS_MAIN,
                                      name, &back, &over);
                  if (!decl
                      || (PKL_AST_DECL_KIND (decl) != PKL_AST_DECL_KIND_VAR
                          && PKL_AST_DECL_KIND (decl) != PKL_AST_DECL_KIND_FUNC))
                    {
                      pkl_error (pkl_parser->compiler, pkl_parser->ast, (yylsp[0]),
                                 "undefined variable '%s'", name);
                      YYERROR;
                    }

                  (yyval.ast) = pkl_ast_make_var (pkl_parser->ast,
                                         (yyvsp[0].ast), /* name.  */
                                         decl,
                                         back, over);
                  PKL_AST_LOC ((yyval.ast)) = (yylsp[0]);
                }
#line 6156 "pkl-tab.c"
    break;

  case 81: /* primary: integer  */
#line 1119 "pkl-tab.y"
                {
                  (yyval.ast) = (yyvsp[0].ast);
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                  PKL_AST_LOC (PKL_AST_TYPE ((yyval.ast))) = (yyloc);
                }
#line 6166 "pkl-tab.c"
    break;

  case 82: /* primary: "character literal"  */
#line 1125 "pkl-tab.y"
                {
                  (yyval.ast) = (yyvsp[0].ast);
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                  PKL_AST_LOC (PKL_AST_TYPE ((yyval.ast))) = (yyloc);
                }
#line 6176 "pkl-tab.c"
    break;

  case 83: /* primary: "string"  */
#line 1131 "pkl-tab.y"
                {
                  (yyval.ast) = (yyvsp[0].ast);
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                  PKL_AST_LOC (PKL_AST_TYPE ((yyval.ast))) = (yyloc);
                }
#line 6186 "pkl-tab.c"
    break;

  case 84: /* primary: '(' expression ')'  */
#line 1137 "pkl-tab.y"
                {
                  if (PKL_AST_CODE ((yyvsp[-1].ast)) == PKL_AST_VAR)
                    PKL_AST_VAR_IS_PARENTHESIZED ((yyvsp[-1].ast)) = 1;
                  else if (PKL_AST_CODE ((yyvsp[-1].ast)) == PKL_AST_STRUCT_REF)
                    PKL_AST_STRUCT_REF_IS_PARENTHESIZED ((yyvsp[-1].ast)) = 1;
                  (yyval.ast) = (yyvsp[-1].ast);
                }
#line 6198 "pkl-tab.c"
    break;

  case 86: /* primary: primary ".>" identifier  */
#line 1146 "pkl-tab.y"
                {
                    (yyval.ast) = pkl_ast_make_struct_ref (pkl_parser->ast, (yyvsp[-2].ast), (yyvsp[0].ast));
                    PKL_AST_LOC ((yyvsp[0].ast)) = (yylsp[0]);
                    PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 6208 "pkl-tab.c"
    break;

  case 87: /* primary: primary "dot operator" identifier  */
#line 1152 "pkl-tab.y"
                {
                    (yyval.ast) = pkl_ast_make_struct_ref (pkl_parser->ast, (yyvsp[-2].ast), (yyvsp[0].ast));
                    PKL_AST_LOC ((yyvsp[0].ast)) = (yylsp[0]);
                    PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 6218 "pkl-tab.c"
    break;

  case 88: /* primary: primary '[' expression ']'  */
#line 1158 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_indexer (pkl_parser->ast, (yyvsp[-3].ast), (yyvsp[-1].ast));
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 6227 "pkl-tab.c"
    break;

  case 89: /* primary: primary '[' expression "range separator" expression ']'  */
#line 1163 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_trimmer (pkl_parser->ast,
                                             (yyvsp[-5].ast), (yyvsp[-3].ast), NULL, (yyvsp[-1].ast));
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 6237 "pkl-tab.c"
    break;

  case 90: /* primary: primary '[' expression ':' expression ']'  */
#line 1169 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_trimmer (pkl_parser->ast,
                                             (yyvsp[-5].ast), (yyvsp[-3].ast), (yyvsp[-1].ast), NULL);
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 6247 "pkl-tab.c"
    break;

  case 91: /* primary: primary '[' ':' ']'  */
#line 1175 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_trimmer (pkl_parser->ast,
                                             (yyvsp[-3].ast), NULL, NULL, NULL);
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 6257 "pkl-tab.c"
    break;

  case 92: /* primary: primary '[' ':' expression ']'  */
#line 1181 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_trimmer (pkl_parser->ast,
                                             (yyvsp[-4].ast), NULL, (yyvsp[-1].ast), NULL);
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 6267 "pkl-tab.c"
    break;

  case 93: /* primary: primary '[' expression ':' ']'  */
#line 1187 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_trimmer (pkl_parser->ast,
                                             (yyvsp[-4].ast), (yyvsp[-2].ast), NULL, NULL);
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 6277 "pkl-tab.c"
    break;

  case 95: /* primary: '(' funcall_stmt ')'  */
#line 1194 "pkl-tab.y"
                {
                  (yyval.ast) = (yyvsp[-1].ast);
                }
#line 6285 "pkl-tab.c"
    break;

  case 96: /* $@1: %empty  */
#line 1198 "pkl-tab.y"
                {
                  /* function_specifier needs to know whether we are
                     in a function declaration or a method
                     declaration.  */
                  pkl_parser->in_method_decl_p = 0;
                }
#line 6296 "pkl-tab.c"
    break;

  case 97: /* primary: "keyword `lambda'" $@1 function_specifier  */
#line 1205 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_lambda (pkl_parser->ast, (yyvsp[0].ast));
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 6305 "pkl-tab.c"
    break;

  case 98: /* primary: "keyword `asm'" simple_type_specifier ':' '(' expression ')'  */
#line 1210 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_asm_exp (pkl_parser->ast, (yyvsp[-4].ast), (yyvsp[-1].ast), NULL);
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 6314 "pkl-tab.c"
    break;

  case 99: /* primary: "keyword `asm'" simple_type_specifier ':' '(' expression ':' expression_list ')'  */
#line 1215 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_asm_exp (pkl_parser->ast, (yyvsp[-6].ast), (yyvsp[-3].ast), (yyvsp[-1].ast));
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 6323 "pkl-tab.c"
    break;

  case 100: /* primary: "keyword `format'" '(' "string" format_arg_list ')'  */
#line 1220 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_format (pkl_parser->ast, (yyvsp[-2].ast), (yyvsp[-1].ast),
                                            0 /* printf_p */);
                  PKL_AST_TYPE ((yyval.ast))
                      = ASTREF (pkl_ast_make_string_type (pkl_parser->ast));
                  PKL_AST_LOC ((yyvsp[-2].ast)) = (yylsp[-2]);
                  if (PKL_AST_TYPE ((yyvsp[-2].ast)))
                    PKL_AST_LOC (PKL_AST_TYPE ((yyvsp[-2].ast))) = (yylsp[-2]);
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                  PKL_AST_LOC (PKL_AST_TYPE ((yyval.ast))) = (yyloc);
                }
#line 6339 "pkl-tab.c"
    break;

  case 101: /* primary: expression "increment operator"  */
#line 1232 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_incrdecr (pkl_parser->ast, (yyvsp[-1].ast),
                                              PKL_AST_ORDER_POST, PKL_AST_SIGN_INCR);
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 6349 "pkl-tab.c"
    break;

  case 102: /* primary: expression "decrement operator"  */
#line 1238 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_incrdecr (pkl_parser->ast, (yyvsp[-1].ast),
                                              PKL_AST_ORDER_POST, PKL_AST_SIGN_DECR);
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 6359 "pkl-tab.c"
    break;

  case 103: /* primary: "keyword `typeof'" '(' expression ')'  */
#line 1244 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_unary_exp (pkl_parser->ast, PKL_AST_OP_TYPEOF, (yyvsp[-1].ast));
                  PKL_AST_LOC ((yyval.ast)) = (yylsp[-3]);
                }
#line 6368 "pkl-tab.c"
    break;

  case 104: /* primary: "keyword `typeof'" '(' simple_type_specifier ')'  */
#line 1249 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_unary_exp (pkl_parser->ast, PKL_AST_OP_TYPEOF, (yyvsp[-1].ast));
                  PKL_AST_LOC ((yyval.ast)) = (yylsp[-3]);
                }
#line 6377 "pkl-tab.c"
    break;

  case 105: /* primary: "keyword `sizeof'" '(' simple_type_specifier ')'  */
#line 1254 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_unary_exp (pkl_parser->ast, PKL_AST_OP_SIZEOF, (yyvsp[-1].ast));
                  PKL_AST_LOC ((yyval.ast)) = (yylsp[-3]);
                }
#line 6386 "pkl-tab.c"
    break;

  case 106: /* primary: "keyword `apush'" '(' expression ',' expression ')'  */
#line 1259 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_binary_exp (pkl_parser->ast, PKL_AST_OP_APUSH,
                                                (yyvsp[-3].ast), (yyvsp[-1].ast));
                  PKL_AST_LOC ((yyval.ast)) = (yylsp[-5]);
                }
#line 6396 "pkl-tab.c"
    break;

  case 107: /* primary: "keyword `apop'" '(' expression ')'  */
#line 1265 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_unary_exp (pkl_parser->ast, PKL_AST_OP_APOP,
                                               (yyvsp[-1].ast));
                  PKL_AST_LOC ((yyval.ast)) = (yylsp[-3]);
                }
#line 6406 "pkl-tab.c"
    break;

  case 108: /* primary: cons_type_specifier '(' expression_list opt_comma ')'  */
#line 1271 "pkl-tab.y"
                {
                  /* This syntax is only used for array
                     constructors.  */
                  if (PKL_AST_TYPE_CODE ((yyvsp[-4].ast)) != PKL_TYPE_ARRAY)
                    {
                      pkl_error (pkl_parser->compiler, pkl_parser->ast, (yylsp[-4]),
                                 "expected array type in constructor");
                      YYERROR;
                    }

                  (yyval.ast) = pkl_ast_make_cons (pkl_parser->ast, (yyvsp[-4].ast), (yyvsp[-2].ast));
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 6424 "pkl-tab.c"
    break;

  case 109: /* primary: typename '{' struct_field_list opt_comma '}'  */
#line 1285 "pkl-tab.y"
                {
                  pkl_ast_node astruct;

                  /* This syntax is only used for struct
                     constructors.  */
                  if (PKL_AST_TYPE_CODE ((yyvsp[-4].ast)) != PKL_TYPE_STRUCT)
                    {
                      pkl_error (pkl_parser->compiler, pkl_parser->ast, (yylsp[-4]),
                                 "expected struct type in constructor");
                      YYERROR;
                    }

                  astruct = pkl_ast_make_struct (pkl_parser->ast,
                                           0 /* nelem */, (yyvsp[-2].ast));
                  PKL_AST_LOC (astruct) = (yyloc);

                  (yyval.ast) = pkl_ast_make_cons (pkl_parser->ast, (yyvsp[-4].ast), astruct);
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 6448 "pkl-tab.c"
    break;

  case 110: /* funcall: primary '(' funcall_arg_list ')'  */
#line 1308 "pkl-tab.y"
                  {
                  (yyval.ast) = pkl_ast_make_funcall (pkl_parser->ast,
                                             (yyvsp[-3].ast), (yyvsp[-1].ast));
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 6458 "pkl-tab.c"
    break;

  case 111: /* funcall_arg_list: %empty  */
#line 1317 "pkl-tab.y"
                { (yyval.ast) = NULL; }
#line 6464 "pkl-tab.c"
    break;

  case 113: /* funcall_arg_list: funcall_arg_list ',' funcall_arg  */
#line 1320 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_chainon ((yyvsp[-2].ast), (yyvsp[0].ast));
                }
#line 6472 "pkl-tab.c"
    break;

  case 114: /* funcall_arg: expression  */
#line 1327 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_funcall_arg (pkl_parser->ast,
                                                 (yyvsp[0].ast), NULL /* name */);
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 6482 "pkl-tab.c"
    break;

  case 115: /* format_arg_list: %empty  */
#line 1336 "pkl-tab.y"
                { (yyval.ast) = NULL; }
#line 6488 "pkl-tab.c"
    break;

  case 117: /* format_arg_list: format_arg_list ',' expression  */
#line 1339 "pkl-tab.y"
                {
                  pkl_ast_node arg
                    = pkl_ast_make_format_arg (pkl_parser->ast, (yyvsp[0].ast));
                  PKL_AST_LOC (arg) = (yylsp[0]);

                  (yyval.ast) = pkl_ast_chainon ((yyvsp[-2].ast), arg);
                }
#line 6500 "pkl-tab.c"
    break;

  case 118: /* format_arg: expression  */
#line 1350 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_format_arg (pkl_parser->ast, (yyvsp[0].ast));
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 6509 "pkl-tab.c"
    break;

  case 121: /* struct_field_list: %empty  */
#line 1363 "pkl-tab.y"
                { (yyval.ast) = NULL; }
#line 6515 "pkl-tab.c"
    break;

  case 123: /* struct_field_list: struct_field_list ',' struct_field  */
#line 1366 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_chainon ((yyvsp[-2].ast), (yyvsp[0].ast));
                }
#line 6523 "pkl-tab.c"
    break;

  case 124: /* struct_field: expression  */
#line 1373 "pkl-tab.y"
                  {
                    (yyval.ast) = pkl_ast_make_struct_field (pkl_parser->ast,
                                                    NULL /* name */,
                                                    (yyvsp[0].ast));
                    PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 6534 "pkl-tab.c"
    break;

  case 125: /* struct_field: identifier '=' expression  */
#line 1380 "pkl-tab.y"
                {
                    (yyval.ast) = pkl_ast_make_struct_field (pkl_parser->ast,
                                                    (yyvsp[-2].ast),
                                                    (yyvsp[0].ast));
                    PKL_AST_LOC ((yyvsp[-2].ast)) = (yylsp[-2]);
                    PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 6546 "pkl-tab.c"
    break;

  case 126: /* array: '[' array_initializer_list opt_comma ']'  */
#line 1391 "pkl-tab.y"
                {
                    (yyval.ast) = pkl_ast_make_array (pkl_parser->ast,
                                             0 /* nelem */,
                                             0 /* ninitializer */,
                                             (yyvsp[-2].ast));
                    PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 6558 "pkl-tab.c"
    break;

  case 128: /* array_initializer_list: array_initializer_list ',' array_initializer  */
#line 1403 "pkl-tab.y"
                  {
                  (yyval.ast) = pkl_ast_chainon ((yyvsp[-2].ast), (yyvsp[0].ast));
                }
#line 6566 "pkl-tab.c"
    break;

  case 129: /* array_initializer: expression  */
#line 1410 "pkl-tab.y"
                  {
                    (yyval.ast) = pkl_ast_make_array_initializer (pkl_parser->ast,
                                                         NULL, (yyvsp[0].ast));
                    PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 6576 "pkl-tab.c"
    break;

  case 130: /* array_initializer: "dot operator" '[' expression ']' '=' expression  */
#line 1416 "pkl-tab.y"
                {
                    (yyval.ast) = pkl_ast_make_array_initializer (pkl_parser->ast,
                                                         (yyvsp[-3].ast), (yyvsp[0].ast));
                    PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 6586 "pkl-tab.c"
    break;

  case 131: /* pushlevel_args: %empty  */
#line 1429 "pkl-tab.y"
                {
                  /* Push the lexical frame for the function's
                     arguments.  */
                  pkl_parser->env = pkl_env_push_frame (pkl_parser->env);

                  /* If in a method, register an argument SELF for the
                     initial implicit argument.  */
                  if (pkl_parser->in_method_decl_p)
                    {
                      pkl_ast_node arg_type
                        = pkl_ast_make_any_type (pkl_parser->ast);
                      pkl_ast_node arg_name
                        = pkl_ast_make_identifier (pkl_parser->ast,
                                                   "SELF");
                      pkl_ast_node arg
                        = pkl_ast_make_func_arg (pkl_parser->ast,
                                                 arg_type, arg_name,
                                                 NULL /* initial */);

                      assert (pkl_register_arg (pkl_parser, arg));
                    }
                }
#line 6613 "pkl-tab.c"
    break;

  case 132: /* function_specifier: '(' pushlevel_args function_arg_list ')' simple_type_specifier ':' comp_stmt  */
#line 1455 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_func (pkl_parser->ast,
                                          (yyvsp[-2].ast), (yyvsp[-4].ast), (yyvsp[0].ast));
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);

                  /* Pop the frame introduced by `pushlevel'
                     above.  */
                  pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);
                }
#line 6627 "pkl-tab.c"
    break;

  case 133: /* function_specifier: simple_type_specifier ':' pushlevel_args comp_stmt  */
#line 1465 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_func (pkl_parser->ast,
                                          (yyvsp[-3].ast), NULL, (yyvsp[0].ast));
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);

                  /* Pop the frame introduced by `pushlevel'
                     above.  */
                  pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);
                }
#line 6641 "pkl-tab.c"
    break;

  case 135: /* function_arg_list: function_arg ',' function_arg_list  */
#line 1479 "pkl-tab.y"
                  {
                  (yyval.ast) = pkl_ast_chainon ((yyvsp[-2].ast), (yyvsp[0].ast));
                }
#line 6649 "pkl-tab.c"
    break;

  case 136: /* function_arg: simple_type_specifier identifier function_arg_initial  */
#line 1486 "pkl-tab.y"
                  {
                  (yyval.ast) = pkl_ast_make_func_arg (pkl_parser->ast,
                                              (yyvsp[-2].ast), (yyvsp[-1].ast), (yyvsp[0].ast));
                  PKL_AST_LOC ((yyvsp[-1].ast)) = (yylsp[-1]);
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);

                  if (!pkl_register_arg (pkl_parser, (yyval.ast)))
                      YYERROR;
                }
#line 6663 "pkl-tab.c"
    break;

  case 137: /* function_arg: identifier "varargs indicator"  */
#line 1496 "pkl-tab.y"
                {
                  pkl_ast_node type
                    = pkl_ast_make_any_type (pkl_parser->ast);
                  pkl_ast_node array_type
                    = pkl_ast_make_array_type (pkl_parser->ast,
                                               type,
                                               NULL /* bound */);

                  PKL_AST_LOC (type) = (yylsp[-1]);
                  PKL_AST_LOC (array_type) = (yylsp[-1]);

                  (yyval.ast) = pkl_ast_make_func_arg (pkl_parser->ast,
                                              array_type,
                                              (yyvsp[-1].ast),
                                              NULL /* initial */);
                  PKL_AST_FUNC_ARG_VARARG ((yyval.ast)) = 1;
                  PKL_AST_LOC ((yyvsp[-1].ast)) = (yylsp[-1]);
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);

                  if (!pkl_register_arg (pkl_parser, (yyval.ast)))
                      YYERROR;
                }
#line 6690 "pkl-tab.c"
    break;

  case 138: /* function_arg_initial: %empty  */
#line 1521 "pkl-tab.y"
                                      { (yyval.ast) = NULL; }
#line 6696 "pkl-tab.c"
    break;

  case 139: /* function_arg_initial: '=' expression  */
#line 1522 "pkl-tab.y"
                                { (yyval.ast) = (yyvsp[0].ast); }
#line 6702 "pkl-tab.c"
    break;

  case 143: /* typename: "type name"  */
#line 1537 "pkl-tab.y"
                  {
                  pkl_ast_node decl = pkl_env_lookup (pkl_parser->env,
                                                      PKL_ENV_NS_MAIN,
                                                      PKL_AST_IDENTIFIER_POINTER ((yyvsp[0].ast)),
                                                      NULL, NULL);
                  assert (decl != NULL
                          && PKL_AST_DECL_KIND (decl) == PKL_AST_DECL_KIND_TYPE);
                  (yyval.ast) = PKL_AST_DECL_INITIAL (decl);
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                  (yyvsp[0].ast) = ASTREF ((yyvsp[0].ast)); pkl_ast_node_free ((yyvsp[0].ast));
                }
#line 6718 "pkl-tab.c"
    break;

  case 144: /* string_type_specifier: "string type specifier"  */
#line 1552 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_string_type (pkl_parser->ast);
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 6727 "pkl-tab.c"
    break;

  case 145: /* simple_type_specifier: "any type specifier"  */
#line 1560 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_any_type (pkl_parser->ast);
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 6736 "pkl-tab.c"
    break;

  case 146: /* simple_type_specifier: "void type specifier"  */
#line 1565 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_void_type (pkl_parser->ast);
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 6745 "pkl-tab.c"
    break;

  case 155: /* integral_type_specifier: integral_type_sign integer "bigger-than operator"  */
#line 1584 "pkl-tab.y"
                {
                    (yyval.ast) = pkl_ast_make_integral_type (pkl_parser->ast,
                                                     PKL_AST_INTEGER_VALUE ((yyvsp[-1].ast)),
                                                     (yyvsp[-2].integer));
                    (yyvsp[-1].ast) = ASTREF ((yyvsp[-1].ast)); pkl_ast_node_free ((yyvsp[-1].ast));
                    PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 6757 "pkl-tab.c"
    break;

  case 156: /* integral_type_sign: "int type constructor"  */
#line 1594 "pkl-tab.y"
                           { (yyval.integer) = 1; }
#line 6763 "pkl-tab.c"
    break;

  case 157: /* integral_type_sign: "uint type constructor"  */
#line 1595 "pkl-tab.y"
                            { (yyval.integer) = 0; }
#line 6769 "pkl-tab.c"
    break;

  case 158: /* offset_type_specifier: "offset type constructor" simple_type_specifier ',' identifier "bigger-than operator"  */
#line 1600 "pkl-tab.y"
                {
                  pkl_ast_node decl
                    = pkl_env_lookup (pkl_parser->env,
                                      PKL_ENV_NS_UNITS,
                                      PKL_AST_IDENTIFIER_POINTER ((yyvsp[-1].ast)),
                                      NULL, NULL);

                  if (!decl)
                    {
                      /* This could be the name of a type.  Try it out.  */
                      decl = pkl_env_lookup (pkl_parser->env,
                                             PKL_ENV_NS_MAIN,
                                             PKL_AST_IDENTIFIER_POINTER ((yyvsp[-1].ast)),
                                             NULL, NULL);

                      if (!decl)
                        {
                          pkl_error (pkl_parser->compiler, pkl_parser->ast, (yylsp[-1]),
                                     "invalid unit in offset type");
                          YYERROR;
                        }
                    }

                  (yyval.ast) = pkl_ast_make_offset_type (pkl_parser->ast,
                                                 (yyvsp[-3].ast),
                                                 PKL_AST_DECL_INITIAL (decl));

                  (yyvsp[-1].ast) = ASTREF ((yyvsp[-1].ast)); pkl_ast_node_free ((yyvsp[-1].ast));
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 6804 "pkl-tab.c"
    break;

  case 159: /* offset_type_specifier: "offset type constructor" simple_type_specifier ',' integer "bigger-than operator"  */
#line 1631 "pkl-tab.y"
                {
                    (yyval.ast) = pkl_ast_make_offset_type (pkl_parser->ast,
                                                   (yyvsp[-3].ast), (yyvsp[-1].ast));
                    PKL_AST_LOC (PKL_AST_TYPE ((yyvsp[-1].ast))) = (yylsp[-1]);
                    PKL_AST_LOC ((yyvsp[-1].ast)) = (yylsp[-1]);
                    PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 6816 "pkl-tab.c"
    break;

  case 160: /* array_type_specifier: simple_type_specifier '[' ']'  */
#line 1642 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_array_type (pkl_parser->ast, (yyvsp[-2].ast),
                                                NULL /* bound */);
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 6826 "pkl-tab.c"
    break;

  case 161: /* array_type_specifier: simple_type_specifier '[' expression ']'  */
#line 1648 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_array_type (pkl_parser->ast, (yyvsp[-3].ast), (yyvsp[-1].ast));
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 6835 "pkl-tab.c"
    break;

  case 162: /* function_type_specifier: '(' function_type_arg_list ')' simple_type_specifier  */
#line 1656 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_function_type (pkl_parser->ast,
                                                   (yyvsp[0].ast), 0 /* narg */,
                                                   (yyvsp[-2].ast));
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 6846 "pkl-tab.c"
    break;

  case 163: /* function_type_specifier: '(' ')' simple_type_specifier  */
#line 1663 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_function_type (pkl_parser->ast,
                                                   (yyvsp[0].ast), 0 /* narg */,
                                                   NULL);
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 6857 "pkl-tab.c"
    break;

  case 165: /* function_type_arg_list: function_type_arg ',' function_type_arg_list  */
#line 1674 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_chainon ((yyvsp[-2].ast), (yyvsp[0].ast));
                }
#line 6865 "pkl-tab.c"
    break;

  case 166: /* function_type_arg: simple_type_specifier  */
#line 1681 "pkl-tab.y"
                  {
                  (yyval.ast) = pkl_ast_make_func_type_arg (pkl_parser->ast,
                                                   (yyvsp[0].ast), NULL /* name */);
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 6875 "pkl-tab.c"
    break;

  case 167: /* function_type_arg: simple_type_specifier '?'  */
#line 1687 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_func_type_arg (pkl_parser->ast,
                                                   (yyvsp[-1].ast), NULL /* name */);
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                  PKL_AST_FUNC_TYPE_ARG_OPTIONAL ((yyval.ast)) = 1;
                }
#line 6886 "pkl-tab.c"
    break;

  case 168: /* function_type_arg: "varargs indicator"  */
#line 1694 "pkl-tab.y"
                {
                  pkl_ast_node type
                    = pkl_ast_make_any_type (pkl_parser->ast);
                  pkl_ast_node array_type
                    = pkl_ast_make_array_type (pkl_parser->ast,
                                               type, NULL /* bound */);

                  PKL_AST_LOC (type) = (yylsp[0]);
                  PKL_AST_LOC (array_type) = (yylsp[0]);

                  (yyval.ast) = pkl_ast_make_func_type_arg (pkl_parser->ast,
                                                   array_type, NULL /* name */);
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                  PKL_AST_FUNC_TYPE_ARG_VARARG ((yyval.ast)) = 1;
                }
#line 6906 "pkl-tab.c"
    break;

  case 169: /* struct_type_specifier: pushlevel struct_type_pinned struct_or_union integral_struct '{' '}'  */
#line 1714 "pkl-tab.y"
                  {
                    (yyval.ast) = pkl_ast_make_struct_type (pkl_parser->ast,
                                                   0 /* nelem */,
                                                   0 /* nfield */,
                                                   0 /* ndecl */,
                                                   (yyvsp[-2].ast),
                                                   NULL /* elems */,
                                                   (yyvsp[-4].integer), (yyvsp[-3].integer));
                    PKL_AST_LOC ((yyval.ast)) = (yyloc);

                    /* The pushlevel in this rule and the subsequent
                       pop_frame, while not strictly needed, is to
                       avoid shift/reduce conflicts with the next
                       rule.  */
                    pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);
                }
#line 6927 "pkl-tab.c"
    break;

  case 170: /* $@2: %empty  */
#line 1732 "pkl-tab.y"
                {
                  /* Register dummies for the locals used in
                     pkl-gen.pks:struct_mapper (not counting
                     OFFSET).  */
                  pkl_register_dummies (pkl_parser, 5);

                  /* Now register OFFSET with a type of
                     offset<uint<64>,1> */
                  {
                    pkl_ast_node decl, type;
                    pkl_ast_node offset_identifier
                      = pkl_ast_make_identifier (pkl_parser->ast, "OFFSET");
                    pkl_ast_node offset_magnitude
                      = pkl_ast_make_integer (pkl_parser->ast, 0);
                    pkl_ast_node offset_unit
                      = pkl_ast_make_integer (pkl_parser->ast, 1);
                    pkl_ast_node offset;

                    type = pkl_ast_make_integral_type (pkl_parser->ast, 64, 0);
                    PKL_AST_TYPE (offset_magnitude) = ASTREF (type);
                    PKL_AST_TYPE (offset_unit) = ASTREF (type);

                    offset = pkl_ast_make_offset (pkl_parser->ast,
                                                  offset_magnitude,
                                                  offset_unit);
                    type = pkl_ast_make_offset_type (pkl_parser->ast,
                                                     type,
                                                     offset_unit);
                    PKL_AST_TYPE (offset) = ASTREF (type);

                    decl = pkl_ast_make_decl (pkl_parser->ast,
                                              PKL_AST_DECL_KIND_VAR,
                                              offset_identifier,
                                              offset,
                                              NULL /* source */);

                    if (!pkl_env_register (pkl_parser->env,
                                           PKL_ENV_NS_MAIN,
                                           PKL_AST_IDENTIFIER_POINTER (offset_identifier),
                                           decl))
                      assert (0);
                  }
                }
#line 6975 "pkl-tab.c"
    break;

  case 171: /* struct_type_specifier: pushlevel struct_type_pinned struct_or_union integral_struct '{' $@2 struct_type_elem_list '}'  */
#line 1776 "pkl-tab.y"
                {
                    (yyval.ast) = pkl_ast_make_struct_type (pkl_parser->ast,
                                                   0 /* nelem */,
                                                   0 /* nfield */,
                                                   0 /* ndecl */,
                                                   (yyvsp[-4].ast),
                                                   (yyvsp[-1].ast),
                                                   (yyvsp[-6].integer), (yyvsp[-5].integer));
                    PKL_AST_LOC ((yyval.ast)) = (yyloc);

                    /* Pop the frame pushed in the `pushlevel' above.  */
                    pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);
                }
#line 6993 "pkl-tab.c"
    break;

  case 172: /* struct_or_union: "keyword `struct'"  */
#line 1792 "pkl-tab.y"
                        { (yyval.integer) = 0; }
#line 6999 "pkl-tab.c"
    break;

  case 173: /* struct_or_union: "keyword `union'"  */
#line 1793 "pkl-tab.y"
                        { (yyval.integer) = 1; }
#line 7005 "pkl-tab.c"
    break;

  case 174: /* struct_type_pinned: %empty  */
#line 1797 "pkl-tab.y"
                        { (yyval.integer) = 0; }
#line 7011 "pkl-tab.c"
    break;

  case 175: /* struct_type_pinned: "keyword `pinned'"  */
#line 1798 "pkl-tab.y"
                        { (yyval.integer) = 1; }
#line 7017 "pkl-tab.c"
    break;

  case 176: /* integral_struct: %empty  */
#line 1802 "pkl-tab.y"
                         { (yyval.ast) = NULL; }
#line 7023 "pkl-tab.c"
    break;

  case 177: /* integral_struct: simple_type_specifier  */
#line 1803 "pkl-tab.y"
                                { (yyval.ast) = (yyvsp[0].ast); }
#line 7029 "pkl-tab.c"
    break;

  case 181: /* struct_type_elem_list: struct_type_elem_list declaration  */
#line 1811 "pkl-tab.y"
                  { (yyval.ast) = pkl_ast_chainon ((yyvsp[-1].ast), (yyvsp[0].ast)); }
#line 7035 "pkl-tab.c"
    break;

  case 182: /* struct_type_elem_list: struct_type_elem_list struct_type_field  */
#line 1813 "pkl-tab.y"
                { (yyval.ast) = pkl_ast_chainon ((yyvsp[-1].ast), (yyvsp[0].ast)); }
#line 7041 "pkl-tab.c"
    break;

  case 183: /* struct_type_elem_list: struct_type_elem_list struct_type_computed_field  */
#line 1815 "pkl-tab.y"
                { (yyval.ast) = pkl_ast_chainon ((yyvsp[-1].ast), (yyvsp[0].ast)); }
#line 7047 "pkl-tab.c"
    break;

  case 184: /* endianness: %empty  */
#line 1819 "pkl-tab.y"
                        { (yyval.integer) = PKL_AST_ENDIAN_DFL; }
#line 7053 "pkl-tab.c"
    break;

  case 185: /* endianness: "keyword `little'"  */
#line 1820 "pkl-tab.y"
                        { (yyval.integer) = PKL_AST_ENDIAN_LSB; }
#line 7059 "pkl-tab.c"
    break;

  case 186: /* endianness: "keyword `big'"  */
#line 1821 "pkl-tab.y"
                             { (yyval.integer) = PKL_AST_ENDIAN_MSB; }
#line 7065 "pkl-tab.c"
    break;

  case 187: /* struct_type_computed_field: "keyword `computed'" type_specifier identifier ';'  */
#line 1826 "pkl-tab.y"
                  {
                    (yyval.ast) = pkl_ast_make_struct_type_field (pkl_parser->ast, (yyvsp[-1].ast), (yyvsp[-2].ast),
                                                         NULL /* constraint */,
                                                         NULL /* initializer */,
                                                         NULL /* label */,
                                                         PKL_AST_ENDIAN_DFL,
                                                         NULL /* optcond_pre */,
                                                         NULL /* optcond_post */);
                    PKL_AST_STRUCT_TYPE_FIELD_COMPUTED_P ((yyval.ast)) = 1;
                    PKL_AST_LOC ((yyval.ast)) = (yyloc);
                  }
#line 7081 "pkl-tab.c"
    break;

  case 188: /* $@3: %empty  */
#line 1842 "pkl-tab.y"
                  {
                    /* Register a variable in the current environment
                       for the field.  We do it in this mid-rule so
                       the element can be used in the constraint.  */

                    pkl_ast_node dummy, decl;
                    pkl_ast_node identifier
                      = ((yyvsp[0].ast) != NULL
                         ? (yyvsp[0].ast)
                         : pkl_ast_make_identifier (pkl_parser->ast, ""));


                    dummy = pkl_ast_make_integer (pkl_parser->ast, 0);
                    PKL_AST_TYPE (dummy) = ASTREF ((yyvsp[-1].ast));
                    decl = pkl_ast_make_decl (pkl_parser->ast,
                                              PKL_AST_DECL_KIND_VAR,
                                              identifier, dummy,
                                              NULL /* source */);
                    PKL_AST_DECL_STRUCT_FIELD_P (decl) = 1;
                    PKL_AST_LOC (decl) = (yyloc);

                    if (!pkl_env_register (pkl_parser->env,
                                           PKL_ENV_NS_MAIN,
                                           PKL_AST_IDENTIFIER_POINTER (identifier),
                                           decl))
                      {
                        pkl_error (pkl_parser->compiler, pkl_parser->ast, (yylsp[0]),
                                   "duplicated struct element '%s'",
                                   PKL_AST_IDENTIFIER_POINTER ((yyvsp[0].ast)));
                        YYERROR;
                      }

                    if (identifier)
                      {
                        identifier = ASTREF (identifier);
                        pkl_ast_node_free (identifier);
                      }
                  }
#line 7124 "pkl-tab.c"
    break;

  case 189: /* struct_type_field: struct_type_field_optcond_pre endianness type_specifier struct_type_field_identifier $@3 struct_type_field_constraint_and_init struct_type_field_label struct_type_field_optcond_post ';'  */
#line 1882 "pkl-tab.y"
                  {
                    pkl_ast_node constraint = (yyvsp[-3].field_const_init).constraint;
                    pkl_ast_node initializer = (yyvsp[-3].field_const_init).initializer;
                    int impl_constraint_p = (yyvsp[-3].field_const_init).impl_constraint_p;

                    if (initializer)
                      {
                        pkl_ast_node field_decl, field_var;
                        int back, over;

                        /* We need a field name.  */
                        if ((yyvsp[-5].ast) == NULL)
                          {
                            pkl_error (pkl_parser->compiler, pkl_parser->ast, (yyloc),
                                       "no initializer allowed in anonymous field");
                            YYERROR;
                          }

                        /* Build a constraint derived from the
                           initializer if a constraint has not been
                           specified.  */
                        if (impl_constraint_p)
                          {
                            field_decl = pkl_env_lookup (pkl_parser->env,
                                                         PKL_ENV_NS_MAIN,
                                                         PKL_AST_IDENTIFIER_POINTER ((yyvsp[-5].ast)),
                                                         &back, &over);
                            assert (field_decl);

                            field_var = pkl_ast_make_var (pkl_parser->ast,
                                                          (yyvsp[-5].ast),
                                                          field_decl,
                                                          back, over);
                            PKL_AST_LOC (field_var) = PKL_AST_LOC (initializer);

                            constraint = pkl_ast_make_binary_exp (pkl_parser->ast,
                                                                  PKL_AST_OP_EQ,
                                                                  field_var,
                                                                  initializer);
                            PKL_AST_LOC (constraint) = PKL_AST_LOC (initializer);
                          }
                      }

                    (yyval.ast) = pkl_ast_make_struct_type_field (pkl_parser->ast, (yyvsp[-5].ast), (yyvsp[-6].ast),
                                                         constraint, initializer,
                                                         (yyvsp[-2].ast), (yyvsp[-7].integer), (yyvsp[-8].ast), (yyvsp[-1].ast));
                    PKL_AST_LOC ((yyval.ast)) = (yyloc);

                    if (constraint)
                      {
                        char *code = pkl_loc_to_source (pkl_parser,
                                                        PKL_AST_LOC (constraint),
                                                        256);
                        if (impl_constraint_p)
                          {
                            assert ((yyvsp[-5].ast) != NULL);
                            code = pk_str_concat (PKL_AST_IDENTIFIER_POINTER ((yyvsp[-5].ast)),
                                                  " == ", code, NULL);
                          }

                        PKL_AST_STRUCT_TYPE_FIELD_CONSTRAINT_SRC ((yyval.ast))
                          = code;
                      }

                    /* If endianness is empty, bison includes the
                       blank characters before the type field as if
                       they were part of this rule.  Therefore the
                       location should be adjusted here.  */
                    if ((yyvsp[-7].integer) == PKL_AST_ENDIAN_DFL)
                      {
                        PKL_AST_LOC ((yyval.ast)).first_line = (yylsp[-6]).first_line;
                        PKL_AST_LOC ((yyval.ast)).first_column = (yylsp[-6]).first_column;
                      }

                    if ((yyvsp[-5].ast) != NULL)
                      {
                        PKL_AST_LOC ((yyvsp[-5].ast)) = (yylsp[-5]);
                        PKL_AST_TYPE ((yyvsp[-5].ast)) = pkl_ast_make_string_type (pkl_parser->ast);
                        PKL_AST_TYPE ((yyvsp[-5].ast)) = ASTREF (PKL_AST_TYPE ((yyvsp[-5].ast)));
                        PKL_AST_LOC (PKL_AST_TYPE ((yyvsp[-5].ast))) = (yylsp[-5]);
                      }
                  }
#line 7211 "pkl-tab.c"
    break;

  case 190: /* struct_type_field_identifier: %empty  */
#line 1967 "pkl-tab.y"
                        { (yyval.ast) = NULL; }
#line 7217 "pkl-tab.c"
    break;

  case 191: /* struct_type_field_identifier: identifier  */
#line 1968 "pkl-tab.y"
                            { (yyval.ast) = (yyvsp[0].ast); }
#line 7223 "pkl-tab.c"
    break;

  case 192: /* struct_type_field_label: %empty  */
#line 1973 "pkl-tab.y"
                {
                  (yyval.ast) = NULL;
                }
#line 7231 "pkl-tab.c"
    break;

  case 193: /* struct_type_field_label: "map operator" expression  */
#line 1977 "pkl-tab.y"
                {
                  (yyval.ast) = (yyvsp[0].ast);
                  PKL_AST_LOC ((yyval.ast)) = (yylsp[0]);
                }
#line 7240 "pkl-tab.c"
    break;

  case 194: /* struct_type_field_constraint_and_init: %empty  */
#line 1985 "pkl-tab.y"
                {
                  (yyval.field_const_init).constraint = NULL;
                  (yyval.field_const_init).initializer = NULL;
                  (yyval.field_const_init).impl_constraint_p = 0;
                }
#line 7250 "pkl-tab.c"
    break;

  case 195: /* struct_type_field_constraint_and_init: ':' expression  */
#line 1991 "pkl-tab.y"
                {
                  (yyval.field_const_init).constraint = (yyvsp[0].ast);
                  PKL_AST_LOC ((yyval.field_const_init).constraint) = (yylsp[0]);
                  (yyval.field_const_init).initializer = NULL;
                  (yyval.field_const_init).impl_constraint_p = 0;
                }
#line 7261 "pkl-tab.c"
    break;

  case 196: /* struct_type_field_constraint_and_init: '=' expression  */
#line 1998 "pkl-tab.y"
                {
                  (yyval.field_const_init).constraint = NULL;
                  (yyval.field_const_init).initializer = (yyvsp[0].ast);
                  PKL_AST_LOC ((yyval.field_const_init).initializer) = (yylsp[0]);
                  (yyval.field_const_init).impl_constraint_p = 0;
                }
#line 7272 "pkl-tab.c"
    break;

  case 197: /* struct_type_field_constraint_and_init: '=' expression ':' expression  */
#line 2005 "pkl-tab.y"
                {
                  (yyval.field_const_init).constraint = (yyvsp[0].ast);
                  PKL_AST_LOC ((yyval.field_const_init).constraint) = (yylsp[0]);
                  (yyval.field_const_init).initializer = (yyvsp[-2].ast);
                  PKL_AST_LOC ((yyval.field_const_init).initializer) = (yylsp[-2]);
                  (yyval.field_const_init).impl_constraint_p = 0;
                }
#line 7284 "pkl-tab.c"
    break;

  case 198: /* struct_type_field_constraint_and_init: ':' expression '=' expression  */
#line 2013 "pkl-tab.y"
                {
                  (yyval.field_const_init).constraint = (yyvsp[-2].ast);
                  PKL_AST_LOC ((yyval.field_const_init).constraint) = (yylsp[-2]);
                  (yyval.field_const_init).initializer = (yyvsp[0].ast);
                  PKL_AST_LOC ((yyval.field_const_init).initializer) = (yylsp[0]);
                  (yyval.field_const_init).impl_constraint_p = 0;
                }
#line 7296 "pkl-tab.c"
    break;

  case 199: /* struct_type_field_constraint_and_init: "equality operator" expression  */
#line 2021 "pkl-tab.y"
                {
                  (yyval.field_const_init).constraint = NULL;
                  (yyval.field_const_init).initializer = (yyvsp[0].ast);
                  PKL_AST_LOC ((yyval.field_const_init).initializer) = (yylsp[0]);
                  (yyval.field_const_init).impl_constraint_p = 1;
                }
#line 7307 "pkl-tab.c"
    break;

  case 200: /* struct_type_field_optcond_pre: %empty  */
#line 2031 "pkl-tab.y"
                {
                  (yyval.ast) = NULL;
                }
#line 7315 "pkl-tab.c"
    break;

  case 201: /* struct_type_field_optcond_pre: "keyword `if'" '(' expression ')'  */
#line 2035 "pkl-tab.y"
                {
                  (yyval.ast) = (yyvsp[-1].ast);
                  PKL_AST_LOC ((yyval.ast)) = (yylsp[-1]);
                }
#line 7324 "pkl-tab.c"
    break;

  case 202: /* struct_type_field_optcond_post: %empty  */
#line 2043 "pkl-tab.y"
                {
                  (yyval.ast) = NULL;
                }
#line 7332 "pkl-tab.c"
    break;

  case 203: /* struct_type_field_optcond_post: "keyword `if'" expression  */
#line 2047 "pkl-tab.y"
                {
                  (yyval.ast) = (yyvsp[0].ast);
                  PKL_AST_LOC ((yyval.ast)) = (yylsp[0]);
                }
#line 7341 "pkl-tab.c"
    break;

  case 204: /* simple_declaration: "keyword `var'" defvar_list  */
#line 2058 "pkl-tab.y"
                               { (yyval.ast) = (yyvsp[0].ast); }
#line 7347 "pkl-tab.c"
    break;

  case 205: /* simple_declaration: "keyword `type'" deftype_list  */
#line 2059 "pkl-tab.y"
                               { (yyval.ast) = (yyvsp[0].ast); }
#line 7353 "pkl-tab.c"
    break;

  case 206: /* simple_declaration: "keyword `unit'" defunit_list  */
#line 2060 "pkl-tab.y"
                               { (yyval.ast) = (yyvsp[0].ast); }
#line 7359 "pkl-tab.c"
    break;

  case 207: /* @4: %empty  */
#line 2065 "pkl-tab.y"
                {
                  /* In order to allow for the function to be called
                     from within itself (recursive calls) we should
                     register a partial declaration in the
                     compile-time environment before processing the
                     `function_specifier' below.  */

                  (yyval.ast) = pkl_ast_make_decl (pkl_parser->ast,
                                               PKL_AST_DECL_KIND_FUNC, (yyvsp[0].ast),
                                               NULL /* initial */,
                                               pkl_parser->filename);
                  PKL_AST_LOC ((yyvsp[0].ast)) = (yylsp[0]);
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);

                  if (!pkl_env_register (pkl_parser->env,
                                         PKL_ENV_NS_MAIN,
                                         PKL_AST_IDENTIFIER_POINTER ((yyvsp[0].ast)),
                                         (yyval.ast)))
                    {
                      pkl_error (pkl_parser->compiler, pkl_parser->ast, (yylsp[0]),
                                 "function or variable `%s' already defined",
                                 PKL_AST_IDENTIFIER_POINTER ((yyvsp[0].ast)));
                      YYERROR;
                    }

                  /* function_specifier needs to know whether we are
                     in a function declaration or a method
                     declaration.  */
                  pkl_parser->in_method_decl_p = ((yyvsp[-1].integer) == IS_METHOD);
                }
#line 7394 "pkl-tab.c"
    break;

  case 208: /* declaration: defun_or_method identifier @4 '=' function_specifier  */
#line 2096 "pkl-tab.y"
                {
                  /* Complete the declaration registered above with
                     it's initial value, which is the specifier of the
                     function being defined.  */
                  PKL_AST_DECL_INITIAL ((yyvsp[-2].ast))
                    = ASTREF ((yyvsp[0].ast));
                  (yyval.ast) = (yyvsp[-2].ast);

                  /* If the reference counting of the declaration is
                     bigger than 1, this means there are recursive
                     calls in the function body.  Reset the refcount
                     to 1, since these references are weak.  */
                  if (PKL_AST_REFCOUNT ((yyvsp[-2].ast)) > 1)
                    PKL_AST_REFCOUNT ((yyvsp[-2].ast)) = 1;

                  /* Annotate the function to be a method whenever
                     appropriate.  */
                  if ((yyvsp[-4].integer) == IS_METHOD)
                    PKL_AST_FUNC_METHOD_P ((yyvsp[0].ast)) = 1;

                  pkl_parser->in_method_decl_p = 0;
                }
#line 7421 "pkl-tab.c"
    break;

  case 209: /* declaration: simple_declaration ';'  */
#line 2118 "pkl-tab.y"
                                 { (yyval.ast) = (yyvsp[-1].ast); }
#line 7427 "pkl-tab.c"
    break;

  case 210: /* defun_or_method: "keyword `fun'"  */
#line 2122 "pkl-tab.y"
                               { (yyval.integer) = IS_DEFUN; }
#line 7433 "pkl-tab.c"
    break;

  case 211: /* defun_or_method: "keyword `method'"  */
#line 2123 "pkl-tab.y"
                        { (yyval.integer) = IS_METHOD; }
#line 7439 "pkl-tab.c"
    break;

  case 213: /* defvar_list: defvar_list ',' defvar  */
#line 2129 "pkl-tab.y"
          { (yyval.ast) = pkl_ast_chainon ((yyvsp[-2].ast), (yyvsp[0].ast)); }
#line 7445 "pkl-tab.c"
    break;

  case 214: /* defvar: identifier '=' expression  */
#line 2134 "pkl-tab.y"
            {
                (yyval.ast) = pkl_ast_make_decl (pkl_parser->ast,
                                        PKL_AST_DECL_KIND_VAR, (yyvsp[-2].ast), (yyvsp[0].ast),
                                        pkl_parser->filename);
                PKL_AST_LOC ((yyvsp[-2].ast)) = (yylsp[-2]);
                PKL_AST_LOC ((yyval.ast)) = (yyloc);

                if (!pkl_env_register (pkl_parser->env,
                                       PKL_ENV_NS_MAIN,
                                       PKL_AST_IDENTIFIER_POINTER ((yyvsp[-2].ast)),
                                       (yyval.ast)))
                  {
                    pkl_error (pkl_parser->compiler, pkl_parser->ast, (yylsp[-2]),
                               "the variable `%s' is already defined",
                               PKL_AST_IDENTIFIER_POINTER ((yyvsp[-2].ast)));
                    YYERROR;
                  }
          }
#line 7468 "pkl-tab.c"
    break;

  case 216: /* deftype_list: deftype_list ',' deftype  */
#line 2157 "pkl-tab.y"
          { (yyval.ast) = pkl_ast_chainon ((yyvsp[-2].ast), (yyvsp[0].ast)); }
#line 7474 "pkl-tab.c"
    break;

  case 217: /* deftype: identifier '=' type_specifier  */
#line 2162 "pkl-tab.y"
          {
            (yyval.ast) = pkl_ast_make_decl (pkl_parser->ast,
                                    PKL_AST_DECL_KIND_TYPE, (yyvsp[-2].ast), (yyvsp[0].ast),
                                    pkl_parser->filename);
            PKL_AST_LOC ((yyvsp[-2].ast)) = (yylsp[-2]);
            PKL_AST_LOC ((yyval.ast)) = (yyloc);

            PKL_AST_TYPE_NAME ((yyvsp[0].ast)) = ASTREF ((yyvsp[-2].ast));

            if (!pkl_env_register (pkl_parser->env,
                                   PKL_ENV_NS_MAIN,
                                   PKL_AST_IDENTIFIER_POINTER ((yyvsp[-2].ast)),
                                   (yyval.ast)))
              {
                pkl_error (pkl_parser->compiler, pkl_parser->ast, (yylsp[-2]),
                           "the type `%s' is already defined",
                           PKL_AST_IDENTIFIER_POINTER ((yyvsp[-2].ast)));
                YYERROR;
              }
          }
#line 7499 "pkl-tab.c"
    break;

  case 219: /* defunit_list: defunit_list ',' defunit  */
#line 2187 "pkl-tab.y"
          { (yyval.ast) = pkl_ast_chainon ((yyvsp[-2].ast), (yyvsp[0].ast)); }
#line 7505 "pkl-tab.c"
    break;

  case 220: /* defunit: identifier '=' expression  */
#line 2192 "pkl-tab.y"
            {
              /* We need to cast the expression to uint<64> here,
                 instead of pkl-promo, because the installed
                 initializer is used as earlier as in the lexer.  Not
                 pretty.  */
              pkl_ast_node type
                = pkl_ast_make_integral_type (pkl_parser->ast,
                                              64, 0);
              pkl_ast_node cast
                = pkl_ast_make_cast (pkl_parser->ast,
                                     type, (yyvsp[0].ast));

              (yyval.ast) = pkl_ast_make_decl (pkl_parser->ast,
                                      PKL_AST_DECL_KIND_UNIT, (yyvsp[-2].ast), cast,
                                      pkl_parser->filename);

              PKL_AST_LOC (type) = (yylsp[0]);
              PKL_AST_LOC (cast) = (yylsp[0]);
              PKL_AST_LOC ((yyvsp[-2].ast)) = (yylsp[-2]);
              PKL_AST_LOC ((yyval.ast)) = (yyloc);

              if (!pkl_env_register (pkl_parser->env,
                                     PKL_ENV_NS_UNITS,
                                     PKL_AST_IDENTIFIER_POINTER ((yyvsp[-2].ast)),
                                     (yyval.ast)))
                {
                  pkl_error (pkl_parser->compiler, pkl_parser->ast, (yylsp[-2]),
                             "the unit `%s' is already defined",
                             PKL_AST_IDENTIFIER_POINTER ((yyvsp[-2].ast)));
                  YYERROR;
                }
            }
#line 7542 "pkl-tab.c"
    break;

  case 221: /* comp_stmt: pushlevel '{' '}'  */
#line 2231 "pkl-tab.y"
            {
              (yyval.ast) = pkl_ast_make_comp_stmt (pkl_parser->ast, NULL);
              PKL_AST_LOC ((yyval.ast)) = (yyloc);

              /* Pop the frame pushed by the `pushlevel' above.  */
              pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);
            }
#line 7554 "pkl-tab.c"
    break;

  case 222: /* comp_stmt: pushlevel '{' stmt_decl_list '}'  */
#line 2239 "pkl-tab.y"
            {
              (yyval.ast) = pkl_ast_make_comp_stmt (pkl_parser->ast, (yyvsp[-1].ast));
              PKL_AST_LOC ((yyval.ast)) = (yyloc);

              /* Pop the frame pushed by the `pushlevel' above.  */
              pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);
            }
#line 7566 "pkl-tab.c"
    break;

  case 223: /* comp_stmt: pushlevel builtin  */
#line 2247 "pkl-tab.y"
        {
          (yyval.ast) = pkl_ast_make_builtin (pkl_parser->ast, (yyvsp[0].integer));
          PKL_AST_LOC ((yyval.ast)) = (yyloc);

          /* Pop the frame pushed by the `pushlevel' above.  */
          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);
        }
#line 7578 "pkl-tab.c"
    break;

  case 224: /* builtin: BUILTIN_TERM_GET_COLOR  */
#line 2257 "pkl-tab.y"
                                 { (yyval.integer) = PKL_AST_BUILTIN_TERM_GET_COLOR; }
#line 7584 "pkl-tab.c"
    break;

  case 225: /* builtin: BUILTIN_TERM_SET_COLOR  */
#line 2258 "pkl-tab.y"
                                 { (yyval.integer) = PKL_AST_BUILTIN_TERM_SET_COLOR; }
#line 7590 "pkl-tab.c"
    break;

  case 226: /* builtin: BUILTIN_TERM_GET_BGCOLOR  */
#line 2259 "pkl-tab.y"
                                   { (yyval.integer) = PKL_AST_BUILTIN_TERM_GET_BGCOLOR; }
#line 7596 "pkl-tab.c"
    break;

  case 227: /* builtin: BUILTIN_TERM_SET_BGCOLOR  */
#line 2260 "pkl-tab.y"
                                   { (yyval.integer) = PKL_AST_BUILTIN_TERM_SET_BGCOLOR; }
#line 7602 "pkl-tab.c"
    break;

  case 229: /* stmt_decl_list: stmt_decl_list stmt  */
#line 2266 "pkl-tab.y"
                  { (yyval.ast) = pkl_ast_chainon ((yyvsp[-1].ast), (yyvsp[0].ast)); }
#line 7608 "pkl-tab.c"
    break;

  case 231: /* stmt_decl_list: stmt_decl_list declaration  */
#line 2269 "pkl-tab.y"
                  { (yyval.ast) = pkl_ast_chainon ((yyvsp[-1].ast), (yyvsp[0].ast)); }
#line 7614 "pkl-tab.c"
    break;

  case 232: /* ass_exp_op: "power-and-assign operator"  */
#line 2273 "pkl-tab.y"
               { (yyval.integer) = PKL_AST_OP_POW; }
#line 7620 "pkl-tab.c"
    break;

  case 233: /* ass_exp_op: "multiply-and-assign operator"  */
#line 2274 "pkl-tab.y"
               { (yyval.integer) = PKL_AST_OP_MUL; }
#line 7626 "pkl-tab.c"
    break;

  case 234: /* ass_exp_op: "divide-and-assing operator"  */
#line 2275 "pkl-tab.y"
               { (yyval.integer) = PKL_AST_OP_DIV; }
#line 7632 "pkl-tab.c"
    break;

  case 235: /* ass_exp_op: "modulus-and-assign operator"  */
#line 2276 "pkl-tab.y"
               { (yyval.integer) = PKL_AST_OP_MOD; }
#line 7638 "pkl-tab.c"
    break;

  case 236: /* ass_exp_op: "add-and-assing operator"  */
#line 2277 "pkl-tab.y"
               { (yyval.integer) = PKL_AST_OP_ADD; }
#line 7644 "pkl-tab.c"
    break;

  case 237: /* ass_exp_op: "subtract-and-assign operator"  */
#line 2278 "pkl-tab.y"
               { (yyval.integer) = PKL_AST_OP_SUB; }
#line 7650 "pkl-tab.c"
    break;

  case 238: /* ass_exp_op: "shift-left-and-assign operator"  */
#line 2279 "pkl-tab.y"
               { (yyval.integer) = PKL_AST_OP_SL; }
#line 7656 "pkl-tab.c"
    break;

  case 239: /* ass_exp_op: "shift-right-and-assign operator"  */
#line 2280 "pkl-tab.y"
               { (yyval.integer) = PKL_AST_OP_SR; }
#line 7662 "pkl-tab.c"
    break;

  case 240: /* ass_exp_op: "bit-and-and-assign operator"  */
#line 2281 "pkl-tab.y"
                { (yyval.integer) = PKL_AST_OP_BAND; }
#line 7668 "pkl-tab.c"
    break;

  case 241: /* ass_exp_op: "bit-or-and-assign operator"  */
#line 2282 "pkl-tab.y"
               { (yyval.integer) = PKL_AST_OP_IOR; }
#line 7674 "pkl-tab.c"
    break;

  case 242: /* ass_exp_op: "bit-xor-and-assign operator"  */
#line 2283 "pkl-tab.y"
               { (yyval.integer) = PKL_AST_OP_XOR; }
#line 7680 "pkl-tab.c"
    break;

  case 243: /* simple_stmt_list: %empty  */
#line 2287 "pkl-tab.y"
                 { (yyval.ast) = NULL; }
#line 7686 "pkl-tab.c"
    break;

  case 245: /* simple_stmt_list: simple_stmt_list ',' simple_stmt  */
#line 2290 "pkl-tab.y"
                 { (yyval.ast) = pkl_ast_chainon ((yyvsp[-2].ast), (yyvsp[0].ast)); }
#line 7692 "pkl-tab.c"
    break;

  case 246: /* simple_stmt: primary '=' expression  */
#line 2295 "pkl-tab.y"
                  {
                  (yyval.ast) = pkl_ast_make_ass_stmt (pkl_parser->ast,
                                              (yyvsp[-2].ast), (yyvsp[0].ast));
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 7702 "pkl-tab.c"
    break;

  case 247: /* simple_stmt: primary ass_exp_op expression  */
#line 2301 "pkl-tab.y"
                {
                  pkl_ast_node exp
                    = pkl_ast_make_binary_exp (pkl_parser->ast,
                                               (yyvsp[-1].integer), (yyvsp[-2].ast), (yyvsp[0].ast));

                  (yyval.ast) = pkl_ast_make_ass_stmt (pkl_parser->ast,
                                              (yyvsp[-2].ast), exp);
                  PKL_AST_LOC (exp) = (yyloc);
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 7717 "pkl-tab.c"
    break;

  case 248: /* simple_stmt: bconc '=' expression  */
#line 2312 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_ass_stmt (pkl_parser->ast,
                                              (yyvsp[-2].ast), (yyvsp[0].ast));
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 7727 "pkl-tab.c"
    break;

  case 249: /* simple_stmt: map '=' expression  */
#line 2318 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_ass_stmt (pkl_parser->ast,
                                              (yyvsp[-2].ast), (yyvsp[0].ast));
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 7737 "pkl-tab.c"
    break;

  case 250: /* simple_stmt: expression  */
#line 2324 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_exp_stmt (pkl_parser->ast,
                                              (yyvsp[0].ast));
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 7747 "pkl-tab.c"
    break;

  case 251: /* simple_stmt: "keyword `printf'" '(' "string" format_arg_list ')'  */
#line 2330 "pkl-tab.y"
                {
                  pkl_ast_node format =
                    pkl_ast_make_format (pkl_parser->ast, (yyvsp[-2].ast), (yyvsp[-1].ast),
                                         1 /* printf_p */);
                  (yyval.ast) = pkl_ast_make_print_stmt (pkl_parser->ast,
                                                1 /* printf_p */, format);
                  PKL_AST_LOC (format) = (yyloc);
                  PKL_AST_LOC ((yyvsp[-2].ast)) = (yylsp[-2]);
                  if (PKL_AST_TYPE ((yyvsp[-2].ast)))
                    PKL_AST_LOC (PKL_AST_TYPE ((yyvsp[-2].ast))) = (yylsp[-2]);
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 7764 "pkl-tab.c"
    break;

  case 252: /* simple_stmt: "keyword `assert'" '(' expression ')'  */
#line 2343 "pkl-tab.y"
                {
                  if (((yyval.ast) = pkl_make_assertion (pkl_parser, (yyvsp[-1].ast), NULL, (yyloc)))
                      == NULL)
                    YYERROR;
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 7775 "pkl-tab.c"
    break;

  case 253: /* simple_stmt: "keyword `assert'" '(' expression ',' expression ')'  */
#line 2350 "pkl-tab.y"
                {
                  if (((yyval.ast) = pkl_make_assertion (pkl_parser, (yyvsp[-3].ast), (yyvsp[-1].ast), (yyloc)))
                      == NULL)
                    YYERROR;
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 7786 "pkl-tab.c"
    break;

  case 254: /* simple_stmt: funcall_stmt  */
#line 2357 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_exp_stmt (pkl_parser->ast,
                                              (yyvsp[0].ast));
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 7796 "pkl-tab.c"
    break;

  case 255: /* simple_stmt: "keyword `asm'" '(' expression ')'  */
#line 2363 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_asm_stmt (pkl_parser->ast,
                                              (yyvsp[-1].ast), NULL, NULL);
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 7806 "pkl-tab.c"
    break;

  case 256: /* simple_stmt: "keyword `asm'" '(' expression ':' expression_list ')'  */
#line 2369 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_asm_stmt (pkl_parser->ast,
                                              (yyvsp[-3].ast), NULL, (yyvsp[-1].ast));
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 7816 "pkl-tab.c"
    break;

  case 257: /* simple_stmt: "keyword `asm'" '(' expression ':' expression_list ':' expression_list ')'  */
#line 2375 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_asm_stmt (pkl_parser->ast,
                                              (yyvsp[-5].ast), (yyvsp[-1].ast), (yyvsp[-3].ast));
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 7826 "pkl-tab.c"
    break;

  case 259: /* stmt: ';'  */
#line 2385 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_null_stmt (pkl_parser->ast);
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 7835 "pkl-tab.c"
    break;

  case 260: /* stmt: simple_stmt ';'  */
#line 2390 "pkl-tab.y"
                {
                  (yyval.ast) = (yyvsp[-1].ast);
                }
#line 7843 "pkl-tab.c"
    break;

  case 261: /* stmt: "keyword `if'" '(' expression ')' stmt  */
#line 2394 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_if_stmt (pkl_parser->ast,
                                             (yyvsp[-2].ast), (yyvsp[0].ast), NULL);
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 7853 "pkl-tab.c"
    break;

  case 262: /* stmt: "keyword `if'" '(' expression ')' stmt "keyword `else'" stmt  */
#line 2400 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_if_stmt (pkl_parser->ast,
                                             (yyvsp[-4].ast), (yyvsp[-2].ast), (yyvsp[0].ast));
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 7863 "pkl-tab.c"
    break;

  case 263: /* stmt: "keyword `while'" '(' expression ')' stmt  */
#line 2406 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_loop_stmt (pkl_parser->ast,
                                               PKL_AST_LOOP_STMT_KIND_WHILE,
                                               NULL, /* iterator */
                                               (yyvsp[-2].ast),   /* condition */
                                               NULL, /* head */
                                               NULL, /* tail */
                                               (yyvsp[0].ast));  /* body */
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 7878 "pkl-tab.c"
    break;

  case 264: /* stmt: "keyword `for'" '(' pushlevel simple_declaration ';' expression_opt ';' simple_stmt_list ')' stmt  */
#line 2417 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_loop_stmt (pkl_parser->ast,
                                               PKL_AST_LOOP_STMT_KIND_FOR,
                                               NULL, /* iterator */
                                               (yyvsp[-4].ast),   /* condition */
                                               (yyvsp[-6].ast),   /* head */
                                               (yyvsp[-2].ast),   /* tail */
                                               (yyvsp[0].ast)); /* body */
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);

                  /* Pop the frame introduced by `pushlevel'
                     above.  */
                  pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);
                }
#line 7897 "pkl-tab.c"
    break;

  case 265: /* stmt: "keyword `for'" '(' ';' expression_opt ';' simple_stmt_list ')' stmt  */
#line 2432 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_loop_stmt (pkl_parser->ast,
                                               PKL_AST_LOOP_STMT_KIND_FOR,
                                               NULL, /* iterator */
                                               (yyvsp[-4].ast),   /* condition */
                                               NULL, /* head */
                                               (yyvsp[-2].ast),   /* tail */
                                               (yyvsp[0].ast));  /* body */

                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 7913 "pkl-tab.c"
    break;

  case 266: /* @5: %empty  */
#line 2444 "pkl-tab.y"
                {
                  /* Push a new lexical level and register a variable
                     with name IDENTIFIER.  Note that the variable is
                     created with a dummy INITIAL, as there is none.  */

                  pkl_ast_node dummy = pkl_ast_make_integer (pkl_parser->ast,
                                                             0);
                  PKL_AST_LOC (dummy) = (yylsp[-3]);

                  (yyval.ast) = pkl_ast_make_decl (pkl_parser->ast,
                                               PKL_AST_DECL_KIND_VAR,
                                               (yyvsp[-3].ast),
                                               dummy,
                                               pkl_parser->filename);
                  PKL_AST_LOC ((yyval.ast)) = (yylsp[-3]);

                  if (!pkl_env_register (pkl_parser->env,
                                         PKL_ENV_NS_MAIN,
                                         PKL_AST_IDENTIFIER_POINTER ((yyvsp[-3].ast)),
                                         (yyval.ast)))
                    /* This should never happen.  */
                    assert (0);
                }
#line 7941 "pkl-tab.c"
    break;

  case 267: /* stmt: "keyword `for'" '(' "identifier" "keyword `in'" expression pushlevel @5 ')' stmt  */
#line 2468 "pkl-tab.y"
                {
                  pkl_ast_node iterator
                    = pkl_ast_make_loop_stmt_iterator (pkl_parser->ast,
                                                       (yyvsp[-2].ast), /* decl */
                                                       (yyvsp[-4].ast)); /* container */
                  PKL_AST_LOC (iterator) = (yyloc);

                  (yyval.ast) = pkl_ast_make_loop_stmt (pkl_parser->ast,
                                               PKL_AST_LOOP_STMT_KIND_FOR_IN,
                                               iterator,
                                               NULL, /* condition */
                                               NULL, /* head */
                                               NULL, /* tail */
                                               (yyvsp[0].ast));  /* body */
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);

                  /* Free the identifier.  */
                  (yyvsp[-6].ast) = ASTREF ((yyvsp[-6].ast)); pkl_ast_node_free ((yyvsp[-6].ast));

                  /* Pop the frame introduced by `pushlevel'
                     above.  */
                  pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);
                }
#line 7969 "pkl-tab.c"
    break;

  case 268: /* @6: %empty  */
#line 2492 "pkl-tab.y"
                {
                  /* XXX: avoid code replication here.  */

                  /* Push a new lexical level and register a variable
                     with name IDENTIFIER.  Note that the variable is
                     created with a dummy INITIAL, as there is none.  */

                  pkl_ast_node dummy = pkl_ast_make_integer (pkl_parser->ast,
                                                             0);
                  PKL_AST_LOC (dummy) = (yylsp[-3]);

                  (yyval.ast) = pkl_ast_make_decl (pkl_parser->ast,
                                               PKL_AST_DECL_KIND_VAR,
                                               (yyvsp[-3].ast),
                                               dummy,
                                               pkl_parser->filename);
                  PKL_AST_LOC ((yyval.ast)) = (yylsp[-3]);

                  if (!pkl_env_register (pkl_parser->env,
                                         PKL_ENV_NS_MAIN,
                                         PKL_AST_IDENTIFIER_POINTER ((yyvsp[-3].ast)),
                                         (yyval.ast)))
                    /* This should never happen.  */
                    assert (0);
                }
#line 7999 "pkl-tab.c"
    break;

  case 269: /* stmt: "keyword `for'" '(' "identifier" "keyword `in'" expression pushlevel @6 "keyword `where'" expression ')' stmt  */
#line 2518 "pkl-tab.y"
                {
                  pkl_ast_node iterator
                    = pkl_ast_make_loop_stmt_iterator (pkl_parser->ast,
                                                       (yyvsp[-4].ast), /* decl */
                                                       (yyvsp[-6].ast)); /* container */
                  PKL_AST_LOC (iterator) = (yyloc);

                  (yyval.ast) = pkl_ast_make_loop_stmt (pkl_parser->ast,
                                               PKL_AST_LOOP_STMT_KIND_FOR_IN,
                                               iterator,
                                               (yyvsp[-2].ast), /* condition */
                                               NULL, /* head */
                                               NULL, /* tail */
                                               (yyvsp[0].ast)); /* body */
                  PKL_AST_LOC ((yyvsp[-8].ast)) = (yylsp[-8]);
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);

                  /* Pop the frame introduced by `pushlevel'
                     above.  */
                  pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);
                }
#line 8025 "pkl-tab.c"
    break;

  case 270: /* stmt: "keyword `break'" ';'  */
#line 2540 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_break_continue_stmt (pkl_parser->ast,
                                                         PKL_AST_BREAK_CONTINUE_STMT_KIND_BREAK);
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 8035 "pkl-tab.c"
    break;

  case 271: /* stmt: "keyword `continue'" ';'  */
#line 2546 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_break_continue_stmt (pkl_parser->ast,
                                                         PKL_AST_BREAK_CONTINUE_STMT_KIND_CONTINUE);
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 8045 "pkl-tab.c"
    break;

  case 272: /* stmt: "keyword `return'" ';'  */
#line 2552 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_return_stmt (pkl_parser->ast,
                                                 NULL);
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 8055 "pkl-tab.c"
    break;

  case 273: /* stmt: "keyword `return'" expression ';'  */
#line 2558 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_return_stmt (pkl_parser->ast,
                                                 (yyvsp[-1].ast));
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 8065 "pkl-tab.c"
    break;

  case 274: /* stmt: "keyword `try'" stmt "keyword `catch'" comp_stmt  */
#line 2564 "pkl-tab.y"
                {
                  pkl_ast_node body
                    = pkl_ast_make_try_stmt_body (pkl_parser->ast, (yyvsp[-2].ast));
                  pkl_ast_node handler
                    = pkl_ast_make_try_stmt_handler (pkl_parser->ast, (yyvsp[0].ast));

                  (yyval.ast) = pkl_ast_make_try_stmt (pkl_parser->ast,
                                              PKL_AST_TRY_STMT_KIND_CATCH,
                                              body, handler, NULL, NULL);
                  PKL_AST_LOC (body) = (yylsp[-2]);
                  PKL_AST_LOC (handler) = (yylsp[0]);
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 8083 "pkl-tab.c"
    break;

  case 275: /* stmt: "keyword `try'" stmt "keyword `catch'" "keyword `if'" expression comp_stmt  */
#line 2578 "pkl-tab.y"
                {
                  pkl_ast_node body
                    = pkl_ast_make_try_stmt_body (pkl_parser->ast, (yyvsp[-4].ast));
                  pkl_ast_node handler
                    = pkl_ast_make_try_stmt_handler (pkl_parser->ast, (yyvsp[0].ast));

                  (yyval.ast) = pkl_ast_make_try_stmt (pkl_parser->ast,
                                              PKL_AST_TRY_STMT_KIND_CATCH,
                                              body, handler, NULL, (yyvsp[-1].ast));
                  PKL_AST_LOC (body) = (yylsp[-4]);
                  PKL_AST_LOC (handler) = (yylsp[0]);
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 8101 "pkl-tab.c"
    break;

  case 276: /* stmt: "keyword `try'" stmt "keyword `catch'" '(' pushlevel function_arg ')' comp_stmt  */
#line 2592 "pkl-tab.y"
                {
                  pkl_ast_node body
                    = pkl_ast_make_try_stmt_body (pkl_parser->ast, (yyvsp[-6].ast));
                  pkl_ast_node handler
                    = pkl_ast_make_try_stmt_handler (pkl_parser->ast, (yyvsp[0].ast));

                  (yyval.ast) = pkl_ast_make_try_stmt (pkl_parser->ast,
                                              PKL_AST_TRY_STMT_KIND_CATCH,
                                              body, handler, (yyvsp[-2].ast), NULL);
                  PKL_AST_LOC (body) = (yylsp[-6]);
                  PKL_AST_LOC (handler) = (yylsp[0]);
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);

                  /* Pop the frame introduced by `pushlevel'
                     above.  */
                  pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);
                }
#line 8123 "pkl-tab.c"
    break;

  case 277: /* stmt: "keyword `try'" stmt "keyword `until'" expression ';'  */
#line 2610 "pkl-tab.y"
                {
                  pkl_ast_node body = pkl_ast_make_try_stmt_body (pkl_parser->ast,
                                                                  (yyvsp[-3].ast));

                  (yyval.ast) = pkl_ast_make_try_stmt (pkl_parser->ast,
                                              PKL_AST_TRY_STMT_KIND_UNTIL,
                                              body, NULL /* handler */,
                                              NULL /* arg */, (yyvsp[-1].ast));
                  PKL_AST_LOC (body) = (yylsp[-3]);
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 8139 "pkl-tab.c"
    break;

  case 278: /* stmt: "keyword `raise'" ';'  */
#line 2622 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_raise_stmt (pkl_parser->ast,
                                                NULL);
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 8149 "pkl-tab.c"
    break;

  case 279: /* stmt: "keyword `raise'" expression ';'  */
#line 2628 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_raise_stmt (pkl_parser->ast,
                                                (yyvsp[-1].ast));
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 8159 "pkl-tab.c"
    break;

  case 280: /* stmt: "keyword `print'" expression ';'  */
#line 2634 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_print_stmt (pkl_parser->ast,
                                                0 /* printf_p */, (yyvsp[-1].ast));
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 8169 "pkl-tab.c"
    break;

  case 281: /* stmt: "keyword `printf'" "string" format_arg_list ';'  */
#line 2640 "pkl-tab.y"
                {
                  pkl_ast_node format =
                    pkl_ast_make_format (pkl_parser->ast, (yyvsp[-2].ast), (yyvsp[-1].ast),
                                         1 /* printf_p */);
                  (yyval.ast) = pkl_ast_make_print_stmt (pkl_parser->ast,
                                                1 /* printf_p */, format);
                  PKL_AST_LOC (format) = (yyloc);
                  PKL_AST_LOC ((yyvsp[-2].ast)) = (yylsp[-2]);
                  if (PKL_AST_TYPE ((yyvsp[-2].ast)))
                    PKL_AST_LOC (PKL_AST_TYPE ((yyvsp[-2].ast))) = (yylsp[-2]);
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 8186 "pkl-tab.c"
    break;

  case 282: /* funcall_stmt: primary funcall_stmt_arg_list  */
#line 2656 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_funcall (pkl_parser->ast,
                                             (yyvsp[-1].ast), (yyvsp[0].ast));
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 8196 "pkl-tab.c"
    break;

  case 284: /* funcall_stmt_arg_list: funcall_stmt_arg_list funcall_stmt_arg  */
#line 2666 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_chainon ((yyvsp[-1].ast), (yyvsp[0].ast));
                }
#line 8204 "pkl-tab.c"
    break;

  case 285: /* funcall_stmt_arg: ':' "identifier" expression  */
#line 2673 "pkl-tab.y"
                  {
                  (yyval.ast) = pkl_ast_make_funcall_arg (pkl_parser->ast,
                                                 (yyvsp[0].ast), (yyvsp[-1].ast));
                  PKL_AST_LOC ((yyvsp[-1].ast)) = (yylsp[-1]);
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 8215 "pkl-tab.c"
    break;


#line 8219 "pkl-tab.c"

        default: break;
      }
    if (yychar_backup != yychar)
      YY_LAC_DISCARD ("yychar change");
  }
  /* User semantic actions sometimes alter yychar, and that requires
     that yytoken be updated with the new translation.  We take the
     approach of translating immediately before every use of yytoken.
     One alternative is translating here after every semantic action,
     but that translation would be missed if the semantic action invokes
     YYABORT, YYACCEPT, or YYERROR immediately after altering yychar or
     if it invokes YYBACKUP.  In the case of YYABORT or YYACCEPT, an
     incorrect destructor might then be invoked immediately.  In the
     case of YYERROR or YYBACKUP, subsequent parser actions might lead
     to an incorrect destructor call or verbose syntax error message
     before the lookahead is translated.  */
  YY_SYMBOL_PRINT ("-> $$ =", YY_CAST (yysymbol_kind_t, yyr1[yyn]), &yyval, &yyloc);

  YYPOPSTACK (yylen);
  yylen = 0;

  *++yyvsp = yyval;
  *++yylsp = yyloc;

  /* Now 'shift' the result of the reduction.  Determine what state
     that goes to, based on the state we popped back to and the rule
     number reduced by.  */
  {
    const int yylhs = yyr1[yyn] - YYNTOKENS;
    const int yyi = yypgoto[yylhs] + *yyssp;
    yystate = (0 <= yyi && yyi <= YYLAST && yycheck[yyi] == *yyssp
               ? yytable[yyi]
               : yydefgoto[yylhs]);
  }

  goto yynewstate;


/*--------------------------------------.
| yyerrlab -- here on detecting error.  |
`--------------------------------------*/
yyerrlab:
  /* Make sure we have latest lookahead translation.  See comments at
     user semantic actions for why this is necessary.  */
  yytoken = yychar == PKL_TAB_EMPTY ? YYSYMBOL_YYEMPTY : YYTRANSLATE (yychar);
  /* If not already recovering from an error, report this error.  */
  if (!yyerrstatus)
    {
      ++yynerrs;
      {
        yypcontext_t yyctx
          = {yyssp, yyesa, &yyes, &yyes_capacity, yytoken, &yylloc};
        if (yychar != PKL_TAB_EMPTY)
          YY_LAC_ESTABLISH;
        if (yyreport_syntax_error (&yyctx, pkl_parser) == 2)
          goto yyexhaustedlab;
      }
    }

  yyerror_range[1] = yylloc;
  if (yyerrstatus == 3)
    {
      /* If just tried and failed to reuse lookahead token after an
         error, discard it.  */

      if (yychar <= PKL_TAB_EOF)
        {
          /* Return failure if at end of input.  */
          if (yychar == PKL_TAB_EOF)
            YYABORT;
        }
      else
        {
          yydestruct ("Error: discarding",
                      yytoken, &yylval, &yylloc, pkl_parser);
          yychar = PKL_TAB_EMPTY;
        }
    }

  /* Else will try to reuse lookahead token after shifting the error
     token.  */
  goto yyerrlab1;


/*---------------------------------------------------.
| yyerrorlab -- error raised explicitly by YYERROR.  |
`---------------------------------------------------*/
yyerrorlab:
  /* Pacify compilers when the user code never invokes YYERROR and the
     label yyerrorlab therefore never appears in user code.  */
  if (0)
    YYERROR;

  /* Do not reclaim the symbols of the rule whose action triggered
     this YYERROR.  */
  YYPOPSTACK (yylen);
  yylen = 0;
  YY_STACK_PRINT (yyss, yyssp);
  yystate = *yyssp;
  goto yyerrlab1;


/*-------------------------------------------------------------.
| yyerrlab1 -- common code for both syntax error and YYERROR.  |
`-------------------------------------------------------------*/
yyerrlab1:
  yyerrstatus = 3;      /* Each real token shifted decrements this.  */

  /* Pop stack until we find a state that shifts the error token.  */
  for (;;)
    {
      yyn = yypact[yystate];
      if (!yypact_value_is_default (yyn))
        {
          yyn += YYSYMBOL_YYerror;
          if (0 <= yyn && yyn <= YYLAST && yycheck[yyn] == YYSYMBOL_YYerror)
            {
              yyn = yytable[yyn];
              if (0 < yyn)
                break;
            }
        }

      /* Pop the current state because it cannot handle the error token.  */
      if (yyssp == yyss)
        YYABORT;

      yyerror_range[1] = *yylsp;
      yydestruct ("Error: popping",
                  YY_ACCESSING_SYMBOL (yystate), yyvsp, yylsp, pkl_parser);
      YYPOPSTACK (1);
      yystate = *yyssp;
      YY_STACK_PRINT (yyss, yyssp);
    }

  /* If the stack popping above didn't lose the initial context for the
     current lookahead token, the shift below will for sure.  */
  YY_LAC_DISCARD ("error recovery");

  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  *++yyvsp = yylval;
  YY_IGNORE_MAYBE_UNINITIALIZED_END

  yyerror_range[2] = yylloc;
  ++yylsp;
  YYLLOC_DEFAULT (*yylsp, yyerror_range, 2);

  /* Shift the error token.  */
  YY_SYMBOL_PRINT ("Shifting", YY_ACCESSING_SYMBOL (yyn), yyvsp, yylsp);

  yystate = yyn;
  goto yynewstate;


/*-------------------------------------.
| yyacceptlab -- YYACCEPT comes here.  |
`-------------------------------------*/
yyacceptlab:
  yyresult = 0;
  goto yyreturn;


/*-----------------------------------.
| yyabortlab -- YYABORT comes here.  |
`-----------------------------------*/
yyabortlab:
  yyresult = 1;
  goto yyreturn;


#if 1
/*-------------------------------------------------.
| yyexhaustedlab -- memory exhaustion comes here.  |
`-------------------------------------------------*/
yyexhaustedlab:
  yyerror (&yylloc, pkl_parser, YY_("memory exhausted"));
  yyresult = 2;
  goto yyreturn;
#endif


/*-------------------------------------------------------.
| yyreturn -- parsing is finished, clean up and return.  |
`-------------------------------------------------------*/
yyreturn:
  if (yychar != PKL_TAB_EMPTY)
    {
      /* Make sure we have latest lookahead translation.  See comments at
         user semantic actions for why this is necessary.  */
      yytoken = YYTRANSLATE (yychar);
      yydestruct ("Cleanup: discarding lookahead",
                  yytoken, &yylval, &yylloc, pkl_parser);
    }
  /* Do not reclaim the symbols of the rule whose action triggered
     this YYABORT or YYACCEPT.  */
  YYPOPSTACK (yylen);
  YY_STACK_PRINT (yyss, yyssp);
  while (yyssp != yyss)
    {
      yydestruct ("Cleanup: popping",
                  YY_ACCESSING_SYMBOL (+*yyssp), yyvsp, yylsp, pkl_parser);
      YYPOPSTACK (1);
    }
#ifndef yyoverflow
  if (yyss != yyssa)
    YYSTACK_FREE (yyss);
#endif
  if (yyes != yyesa)
    YYSTACK_FREE (yyes);

  return yyresult;
}

#line 2712 "pkl-tab.y"


/* Handle syntax errors.  */

int
yyreport_syntax_error (const yypcontext_t *ctx,
                       struct pkl_parser *pkl_parser)
{
  int res = 0;
  yysymbol_kind_t lookahead = yypcontext_token (ctx);

  /* if the unexpected token is alien, then report
     pkl_parser->alien_err_msg.  */
  if (lookahead == YYSYMBOL_ALIEN)
    {
      pkl_tab_error (yypcontext_location (ctx),
                     pkl_parser,
                     pkl_parser->alien_errmsg);
      free (pkl_parser->alien_errmsg);
      pkl_parser->alien_errmsg = NULL;
    }
  else
    {
      /* report tokens expected at this point.  */
      yysymbol_kind_t expected[YYNTOKENS];
      int nexpected = yypcontext_expected_tokens (ctx, expected, YYNTOKENS);

      if (nexpected < 0)
        /* forward errors to yyparse.  */
        res = nexpected;
      else
        {
          char *errmsg = strdup ("syntax error");

          if (!errmsg)
            return YYENOMEM;

          if (lookahead != YYSYMBOL_YYEMPTY)
            {
              char *tmp = pk_str_concat (errmsg,
                                         ": unexpected ",
                                         yysymbol_name (lookahead),
                                         NULL);
              free (errmsg);
              if (!tmp)
                return YYENOMEM;
              errmsg = tmp;
            }

          pkl_tab_error (yypcontext_location (ctx), pkl_parser, errmsg);
          free (errmsg);
        }
    }

  return res;
}
