/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.models;

import gnu.kawa.models.DrawImage;
import gnu.kawa.models.DrawShape;
import gnu.kawa.models.Paintable;
import gnu.kawa.models.WithTransform;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;

public class PBox
implements Paintable {
    char axis;
    Paintable[] paintables;
    Rectangle2D bounds;
    double[] translations;

    private PBox(char axis, Paintable[] paintables) {
        this.axis = axis;
        this.paintables = paintables;
        this.init();
    }

    @Override
    public Rectangle2D getBounds2D() {
        return this.bounds;
    }

    void init() {
        int n = this.paintables.length;
        if (n == 0) {
            return;
        }
        Rectangle2D prevBounds = this.paintables[0].getBounds2D();
        double minX = prevBounds.getMinX();
        double maxX = prevBounds.getMaxX();
        double minY = prevBounds.getMinY();
        double maxY = prevBounds.getMaxY();
        double deltaX = 0.0;
        double deltaY = 0.0;
        this.translations = new double[n];
        for (int i = 1; i < n; ++i) {
            double cmaxY;
            double cmaxX;
            double cminY;
            Rectangle2D curBounds = this.paintables[i].getBounds2D();
            double delta = 0.0;
            if (this.axis == 'X') {
                delta = prevBounds.getMaxX() - curBounds.getMinX();
                deltaX += delta;
            } else if (this.axis == 'Y') {
                delta = prevBounds.getMaxY() - curBounds.getMinY();
                deltaY += delta;
            }
            this.translations[i] = delta + this.translations[i - 1];
            double cminX = curBounds.getMinX() + deltaX;
            if (cminX < minX) {
                minX = cminX;
            }
            if ((cminY = curBounds.getMinY() + deltaY) < minY) {
                minY = cminY;
            }
            if ((cmaxX = curBounds.getMaxX() + deltaX) > maxX) {
                maxX = cmaxX;
            }
            if ((cmaxY = curBounds.getMaxY() + deltaY) > maxY) {
                maxY = cmaxY;
            }
            prevBounds = curBounds;
        }
        this.bounds = new Rectangle2D.Double(minX, minY, maxX - minX, maxY - minY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(Graphics2D graphics) {
        AffineTransform saved = graphics.getTransform();
        try {
            int n = this.paintables.length;
            double prevOffset = 0.0;
            for (int i = 0; i < n; ++i) {
                double offset = this.translations[i];
                if (i > 0 && this.axis != 'Z') {
                    double delta = offset - prevOffset;
                    if (this.axis == 'X') {
                        graphics.translate(delta, 0.0);
                    } else {
                        graphics.translate(0.0, delta);
                    }
                }
                prevOffset = offset;
                this.paintables[i].paint(graphics);
            }
        }
        finally {
            graphics.setTransform(saved);
        }
    }

    @Override
    public Paintable transform(AffineTransform tr) {
        return new WithTransform(this, tr);
    }

    public static PBox makeHBox(Object ... args) {
        return new PBox('X', PBox.asPaintableAll(args));
    }

    public static PBox makeVBox(Object ... args) {
        return new PBox('Y', PBox.asPaintableAll(args));
    }

    public static PBox makeZBox(Object ... args) {
        return new PBox('Z', PBox.asPaintableAll(args));
    }

    public static Paintable asPaintable(Object arg) {
        if (arg instanceof BufferedImage) {
            return new DrawImage((BufferedImage)arg);
        }
        if (arg instanceof Shape) {
            return new DrawShape((Shape)arg);
        }
        return (Paintable)arg;
    }

    public static Paintable[] asPaintableAll(Object[] args) {
        int np = args.length;
        Paintable[] p = new Paintable[np];
        for (int i = 0; i < np; ++i) {
            p[i] = PBox.asPaintable(args[i]);
        }
        return p;
    }
}

