/* lisp.c generated by valac 0.50.1.44-10688, the Vala compiler
 * generated from lisp.vala, do not modify */

/* "Lisp" "interpreter".

   Copyright (c) 2001-2020 Free Software Foundation, Inc.

   This file is part of GNU Zile.

   GNU Zile is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3, or (at your option)
   any later version.

   GNU Zile is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, see <https://www.gnu.org/licenses/>.  */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <gobject/gvaluecollector.h>
#include <errno.h>
#include <glib/gstdio.h>

#define TYPE_LEXP (lexp_get_type ())
#define LEXP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LEXP, Lexp))
#define LEXP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LEXP, LexpClass))
#define IS_LEXP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LEXP))
#define IS_LEXP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LEXP))
#define LEXP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LEXP, LexpClass))

typedef struct _Lexp Lexp;
typedef struct _LexpClass LexpClass;
typedef struct _LexpPrivate LexpPrivate;
typedef enum  {
	LEXP_TOKEN_TYPE_closeparen,
	LEXP_TOKEN_TYPE_openparen,
	LEXP_TOKEN_TYPE_quote,
	LEXP_TOKEN_TYPE_word
} LexpTokenType;

#define LEXP_TYPE_TOKEN_TYPE (lexp_token_type_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _lexp_unref0(var) ((var == NULL) ? NULL : (var = (lexp_unref (var), NULL)))

#define TYPE_LISP_FUNC (lisp_func_get_type ())
#define LISP_FUNC(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LISP_FUNC, LispFunc))
#define LISP_FUNC_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LISP_FUNC, LispFuncClass))
#define IS_LISP_FUNC(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LISP_FUNC))
#define IS_LISP_FUNC_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LISP_FUNC))
#define LISP_FUNC_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LISP_FUNC, LispFuncClass))

typedef struct _LispFunc LispFunc;
typedef struct _LispFuncClass LispFuncClass;
#define _lisp_func_unref0(var) ((var == NULL) ? NULL : (var = (lisp_func_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _ParamSpecLexp ParamSpecLexp;
typedef gboolean (*Function) (glong uniarg, GeeQueue* args);
typedef struct _LispFuncPrivate LispFuncPrivate;
typedef enum  {
	FLAGS_NEED_RESYNC = 1 << 0,
	FLAGS_SET_UNIARG = 1 << 1,
	FLAGS_UNIARG_EMPTY = 1 << 2,
	FLAGS_DEFINING_MACRO = 1 << 3
} Flags;

#define TYPE_FLAGS (flags_get_type ())

typedef enum  {
	PARSE_ERROR_EOF,
	PARSE_ERROR_UNCLOSED_QUOTE
} ParseError;
#define PARSE_ERROR parse_error_quark ()
struct _Lexp {
	GTypeInstance parent_instance;
	volatile int ref_count;
	LexpPrivate * priv;
	gboolean quoted;
	gchar* atom;
	GeeList* list;
};

struct _LexpClass {
	GTypeClass parent_class;
	void (*finalize) (Lexp *self);
};

struct _ParamSpecLexp {
	GParamSpec parent_instance;
};

struct _LispFunc {
	GTypeInstance parent_instance;
	volatile int ref_count;
	LispFuncPrivate * priv;
	gchar* name;
	Function func;
	gboolean interactive;
	gchar* doc;
};

struct _LispFuncClass {
	GTypeClass parent_class;
	void (*finalize) (LispFunc *self);
};

static gpointer lexp_parent_class = NULL;
extern Flags lastflag;

GQuark parse_error_quark (void);
gpointer lexp_ref (gpointer instance);
void lexp_unref (gpointer instance);
GParamSpec* param_spec_lexp (const gchar* name,
                             const gchar* nick,
                             const gchar* blurb,
                             GType object_type,
                             GParamFlags flags);
void value_set_lexp (GValue* value,
                     gpointer v_object);
void value_take_lexp (GValue* value,
                      gpointer v_object);
gpointer value_get_lexp (const GValue* value);
GType lexp_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Lexp, lexp_unref)
static GType lexp_token_type_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
Lexp* lexp_new (const gchar* text);
Lexp* lexp_construct (GType object_type,
                      const gchar* text);
gboolean lexp_eval (Lexp* self);
static gchar* ___lambda22_ (Lexp* self,
                     Lexp* l);
static gpointer ____lambda22__gee_map_func (gpointer g,
                                     gpointer self);
gpointer lisp_func_ref (gpointer instance);
void lisp_func_unref (gpointer instance);
GParamSpec* param_spec_lisp_func (const gchar* name,
                                  const gchar* nick,
                                  const gchar* blurb,
                                  GType object_type,
                                  GParamFlags flags);
void value_set_lisp_func (GValue* value,
                          gpointer v_object);
void value_take_lisp_func (GValue* value,
                           gpointer v_object);
gpointer value_get_lisp_func (const GValue* value);
GType lisp_func_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (LispFunc, lisp_func_unref)
LispFunc* lisp_func_find (const gchar* name);
gboolean call_command (LispFunc* f,
                       glong uniarg,
                       GeeQueue* args);
void lexp_eval_list (GeeList* list);
static gchar lexp_read_char (const gchar* a,
                      guint* pos,
                      GError** error);
static LexpTokenType lexp_read_token (const gchar* a,
                               guint* pos,
                               gchar* * tok,
                               GError** error);
static Lexp* lexp_read_sexp (const gchar* a,
                      guint* pos,
                      LexpTokenType* tokenid,
                      GError** error);
GeeList* lexp_read_list (const gchar* a,
                         guint* pos);
static void lexp_finalize (Lexp * obj);
static GType lexp_get_type_once (void);
gboolean funcall (const gchar* name,
                  glong* maybe_uniarg);
gboolean noarg (GeeQueue* args);
GType flags_get_type (void) G_GNUC_CONST ;
gboolean bool_arg (GeeQueue* args,
                   gboolean* val);
glong* parse_number (const gchar* s);
static glong* _long_dup (glong* self);
gboolean int_arg (GeeQueue* args,
                  glong* n);
gboolean int_or_uniarg (GeeQueue* args,
                        glong* n,
                        glong uniarg);
void lisp_loadstring (const gchar* a);
gboolean lisp_loadfile (const gchar* file);
void lisp_init (void);
static gboolean __lambda113_ (glong uniarg,
                       GeeQueue* args);
static gboolean ___lambda113__function (glong uniarg,
                                 GeeQueue* args);
LispFunc* lisp_func_new (const gchar* name,
                         Function func,
                         gboolean interactive,
                         const gchar* doc);
LispFunc* lisp_func_construct (GType object_type,
                               const gchar* name,
                               Function func,
                               gboolean interactive,
                               const gchar* doc);

GQuark
parse_error_quark (void)
{
	return g_quark_from_static_string ("parse-error-quark");
}

static GType
lexp_token_type_get_type_once (void)
{
	static const GEnumValue values[] = {{LEXP_TOKEN_TYPE_closeparen, "LEXP_TOKEN_TYPE_closeparen", "closeparen"}, {LEXP_TOKEN_TYPE_openparen, "LEXP_TOKEN_TYPE_openparen", "openparen"}, {LEXP_TOKEN_TYPE_quote, "LEXP_TOKEN_TYPE_quote", "quote"}, {LEXP_TOKEN_TYPE_word, "LEXP_TOKEN_TYPE_word", "word"}, {0, NULL, NULL}};
	GType lexp_token_type_type_id;
	lexp_token_type_type_id = g_enum_register_static ("LexpTokenType", values);
	return lexp_token_type_type_id;
}

static GType
lexp_token_type_get_type (void)
{
	static volatile gsize lexp_token_type_type_id__volatile = 0;
	if (g_once_init_enter (&lexp_token_type_type_id__volatile)) {
		GType lexp_token_type_type_id;
		lexp_token_type_type_id = lexp_token_type_get_type_once ();
		g_once_init_leave (&lexp_token_type_type_id__volatile, lexp_token_type_type_id);
	}
	return lexp_token_type_type_id__volatile;
}

Lexp*
lexp_construct (GType object_type,
                const gchar* text)
{
	Lexp* self = NULL;
#line 31 "src/lisp.vala"
	self = (Lexp*) g_type_create_instance (object_type);
#line 32 "src/lisp.vala"
	if (text != NULL) {
#line 243 "lisp.c"
		gchar* _tmp0_;
#line 33 "src/lisp.vala"
		_tmp0_ = g_strdup (text);
#line 33 "src/lisp.vala"
		_g_free0 (self->atom);
#line 33 "src/lisp.vala"
		self->atom = _tmp0_;
#line 251 "lisp.c"
	} else {
		GeeArrayList* _tmp1_;
#line 35 "src/lisp.vala"
		_tmp1_ = gee_array_list_new (TYPE_LEXP, (GBoxedCopyFunc) lexp_ref, (GDestroyNotify) lexp_unref, NULL, NULL, NULL);
#line 35 "src/lisp.vala"
		_g_object_unref0 (self->list);
#line 35 "src/lisp.vala"
		self->list = (GeeList*) _tmp1_;
#line 260 "lisp.c"
	}
#line 31 "src/lisp.vala"
	return self;
#line 264 "lisp.c"
}

Lexp*
lexp_new (const gchar* text)
{
#line 31 "src/lisp.vala"
	return lexp_construct (TYPE_LEXP, text);
#line 272 "lisp.c"
}

static gchar*
___lambda22_ (Lexp* self,
              Lexp* l)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result = NULL;
#line 45 "src/lisp.vala"
	g_return_val_if_fail (l != NULL, NULL);
#line 45 "src/lisp.vala"
	_tmp0_ = l->atom;
#line 45 "src/lisp.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 45 "src/lisp.vala"
	result = _tmp1_;
#line 45 "src/lisp.vala"
	_lexp_unref0 (l);
#line 45 "src/lisp.vala"
	return result;
#line 294 "lisp.c"
}

static gpointer
____lambda22__gee_map_func (gpointer g,
                            gpointer self)
{
	gpointer result;
	result = ___lambda22_ ((Lexp*) self, (Lexp*) g);
#line 45 "src/lisp.vala"
	return result;
#line 305 "lisp.c"
}

gboolean
lexp_eval (Lexp* self)
{
	const gchar* _tmp0_;
	GeeQueue* args = NULL;
	GeeList* _tmp1_;
	LispFunc* func = NULL;
	GeeQueue* _tmp7_;
	gpointer _tmp8_;
	gchar* _tmp9_;
	LispFunc* _tmp10_;
	LispFunc* _tmp11_;
	LispFunc* _tmp12_;
	gboolean result = FALSE;
#line 38 "src/lisp.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 39 "src/lisp.vala"
	_tmp0_ = self->atom;
#line 39 "src/lisp.vala"
	if (_tmp0_ != NULL) {
#line 40 "src/lisp.vala"
		result = FALSE;
#line 40 "src/lisp.vala"
		return result;
#line 332 "lisp.c"
	}
#line 42 "src/lisp.vala"
	args = NULL;
#line 43 "src/lisp.vala"
	_tmp1_ = self->list;
#line 43 "src/lisp.vala"
	if (_tmp1_ != NULL) {
#line 340 "lisp.c"
		GeeArrayQueue* _tmp2_;
		GeeQueue* _tmp3_;
		GeeList* _tmp4_;
		GeeIterator* _tmp5_;
		GeeIterator* _tmp6_;
#line 44 "src/lisp.vala"
		_tmp2_ = gee_array_queue_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
#line 44 "src/lisp.vala"
		_g_object_unref0 (args);
#line 44 "src/lisp.vala"
		args = (GeeQueue*) _tmp2_;
#line 45 "src/lisp.vala"
		_tmp3_ = args;
#line 45 "src/lisp.vala"
		_tmp4_ = self->list;
#line 45 "src/lisp.vala"
		_tmp5_ = gee_traversable_map ((GeeTraversable*) _tmp4_, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, ____lambda22__gee_map_func, self);
#line 45 "src/lisp.vala"
		_tmp6_ = _tmp5_;
#line 45 "src/lisp.vala"
		gee_collection_add_all_iterator ((GeeCollection*) _tmp3_, _tmp6_);
#line 45 "src/lisp.vala"
		_g_object_unref0 (_tmp6_);
#line 364 "lisp.c"
	}
#line 48 "src/lisp.vala"
	_tmp7_ = args;
#line 48 "src/lisp.vala"
	_tmp8_ = gee_queue_poll (_tmp7_);
#line 48 "src/lisp.vala"
	_tmp9_ = (gchar*) _tmp8_;
#line 48 "src/lisp.vala"
	_tmp10_ = lisp_func_find (_tmp9_);
#line 48 "src/lisp.vala"
	_tmp11_ = _tmp10_;
#line 48 "src/lisp.vala"
	_g_free0 (_tmp9_);
#line 48 "src/lisp.vala"
	func = _tmp11_;
#line 49 "src/lisp.vala"
	_tmp12_ = func;
#line 49 "src/lisp.vala"
	if (_tmp12_ != NULL) {
#line 384 "lisp.c"
		LispFunc* _tmp13_;
		GeeQueue* _tmp14_;
#line 50 "src/lisp.vala"
		_tmp13_ = func;
#line 50 "src/lisp.vala"
		_tmp14_ = args;
#line 50 "src/lisp.vala"
		result = call_command (_tmp13_, (glong) 1, _tmp14_);
#line 50 "src/lisp.vala"
		_lisp_func_unref0 (func);
#line 50 "src/lisp.vala"
		_g_object_unref0 (args);
#line 50 "src/lisp.vala"
		return result;
#line 399 "lisp.c"
	}
#line 51 "src/lisp.vala"
	result = FALSE;
#line 51 "src/lisp.vala"
	_lisp_func_unref0 (func);
#line 51 "src/lisp.vala"
	_g_object_unref0 (args);
#line 51 "src/lisp.vala"
	return result;
#line 409 "lisp.c"
}

void
lexp_eval_list (GeeList* list)
{
#line 54 "src/lisp.vala"
	g_return_if_fail (list != NULL);
#line 417 "lisp.c"
	{
		GeeList* _l_list = NULL;
		gint _l_size = 0;
		GeeList* _tmp0_;
		gint _tmp1_;
		gint _tmp2_;
		gint _l_index = 0;
#line 55 "src/lisp.vala"
		_l_list = list;
#line 55 "src/lisp.vala"
		_tmp0_ = _l_list;
#line 55 "src/lisp.vala"
		_tmp1_ = gee_collection_get_size ((GeeCollection*) _tmp0_);
#line 55 "src/lisp.vala"
		_tmp2_ = _tmp1_;
#line 55 "src/lisp.vala"
		_l_size = _tmp2_;
#line 55 "src/lisp.vala"
		_l_index = -1;
#line 55 "src/lisp.vala"
		while (TRUE) {
#line 439 "lisp.c"
			gint _tmp3_;
			gint _tmp4_;
			Lexp* l = NULL;
			GeeList* _tmp5_;
			gpointer _tmp6_;
			Lexp* _tmp7_;
#line 55 "src/lisp.vala"
			_l_index = _l_index + 1;
#line 55 "src/lisp.vala"
			_tmp3_ = _l_index;
#line 55 "src/lisp.vala"
			_tmp4_ = _l_size;
#line 55 "src/lisp.vala"
			if (!(_tmp3_ < _tmp4_)) {
#line 55 "src/lisp.vala"
				break;
#line 456 "lisp.c"
			}
#line 55 "src/lisp.vala"
			_tmp5_ = _l_list;
#line 55 "src/lisp.vala"
			_tmp6_ = gee_list_get (_tmp5_, _l_index);
#line 55 "src/lisp.vala"
			l = (Lexp*) _tmp6_;
#line 56 "src/lisp.vala"
			_tmp7_ = l;
#line 56 "src/lisp.vala"
			lexp_eval (_tmp7_);
#line 55 "src/lisp.vala"
			_lexp_unref0 (l);
#line 470 "lisp.c"
		}
	}
}

static gchar
string_get (const gchar* self,
            glong index)
{
	gchar _tmp0_;
	gchar result = '\0';
#line 1232 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, '\0');
#line 1233 "glib-2.0.vapi"
	_tmp0_ = ((gchar*) self)[index];
#line 1233 "glib-2.0.vapi"
	result = _tmp0_;
#line 1233 "glib-2.0.vapi"
	return result;
#line 489 "lisp.c"
}

static gchar
lexp_read_char (const gchar* a,
                guint* pos,
                GError** error)
{
	gint _tmp0_;
	gint _tmp1_;
	const gchar* _tmp5_;
	guint _tmp6_;
	GError* _inner_error0_ = NULL;
	gchar result = '\0';
#line 69 "src/lisp.vala"
	g_return_val_if_fail (a != NULL, '\0');
#line 70 "src/lisp.vala"
	_tmp0_ = strlen (a);
#line 70 "src/lisp.vala"
	_tmp1_ = _tmp0_;
#line 70 "src/lisp.vala"
	if ((*pos) >= ((guint) _tmp1_)) {
#line 511 "lisp.c"
		GError* _tmp2_;
#line 71 "src/lisp.vala"
		_tmp2_ = g_error_new_literal (PARSE_ERROR, PARSE_ERROR_EOF, "EOF");
#line 71 "src/lisp.vala"
		_inner_error0_ = _tmp2_;
#line 71 "src/lisp.vala"
		if (_inner_error0_->domain == PARSE_ERROR) {
#line 519 "lisp.c"
			gchar _tmp3_ = '\0';
#line 71 "src/lisp.vala"
			g_propagate_error (error, _inner_error0_);
#line 71 "src/lisp.vala"
			return _tmp3_;
#line 525 "lisp.c"
		} else {
			gchar _tmp4_ = '\0';
#line 71 "src/lisp.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 71 "src/lisp.vala"
			g_clear_error (&_inner_error0_);
#line 71 "src/lisp.vala"
			return _tmp4_;
#line 534 "lisp.c"
		}
	}
#line 72 "src/lisp.vala"
	_tmp5_ = a;
#line 72 "src/lisp.vala"
	_tmp6_ = *pos;
#line 72 "src/lisp.vala"
	*pos = _tmp6_ + 1;
#line 72 "src/lisp.vala"
	result = string_get (_tmp5_, (glong) _tmp6_);
#line 72 "src/lisp.vala"
	return result;
#line 547 "lisp.c"
}

static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gchar* _tmp4_;
	gchar* result = NULL;
#line 1480 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1481 "glib-2.0.vapi"
	_tmp0_ = strlen (self);
#line 1481 "glib-2.0.vapi"
	_tmp1_ = _tmp0_;
#line 1481 "glib-2.0.vapi"
	string_length = (glong) _tmp1_;
#line 1482 "glib-2.0.vapi"
	if (start < ((glong) 0)) {
#line 1483 "glib-2.0.vapi"
		start = string_length + start;
#line 574 "lisp.c"
	}
#line 1485 "glib-2.0.vapi"
	if (end < ((glong) 0)) {
#line 1486 "glib-2.0.vapi"
		end = string_length + end;
#line 580 "lisp.c"
	}
#line 1488 "glib-2.0.vapi"
	if (start >= ((glong) 0)) {
#line 1488 "glib-2.0.vapi"
		_tmp2_ = start <= string_length;
#line 586 "lisp.c"
	} else {
#line 1488 "glib-2.0.vapi"
		_tmp2_ = FALSE;
#line 590 "lisp.c"
	}
#line 1488 "glib-2.0.vapi"
	g_return_val_if_fail (_tmp2_, NULL);
#line 1489 "glib-2.0.vapi"
	if (end >= ((glong) 0)) {
#line 1489 "glib-2.0.vapi"
		_tmp3_ = end <= string_length;
#line 598 "lisp.c"
	} else {
#line 1489 "glib-2.0.vapi"
		_tmp3_ = FALSE;
#line 602 "lisp.c"
	}
#line 1489 "glib-2.0.vapi"
	g_return_val_if_fail (_tmp3_, NULL);
#line 1490 "glib-2.0.vapi"
	g_return_val_if_fail (start <= end, NULL);
#line 1491 "glib-2.0.vapi"
	_tmp4_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
#line 1491 "glib-2.0.vapi"
	result = _tmp4_;
#line 1491 "glib-2.0.vapi"
	return result;
#line 614 "lisp.c"
}

static LexpTokenType
lexp_read_token (const gchar* a,
                 guint* pos,
                 gchar* * tok,
                 GError** error)
{
	gchar* _vala_tok = NULL;
	gchar c = '\0';
	gchar* _tmp6_;
	gboolean doublequotes = FALSE;
	GError* _inner_error0_ = NULL;
	LexpTokenType result = 0;
#line 75 "src/lisp.vala"
	g_return_val_if_fail (a != NULL, 0);
#line 78 "src/lisp.vala"
	c = (gchar) 0;
#line 633 "lisp.c"
	{
		gboolean _tmp0_ = FALSE;
#line 79 "src/lisp.vala"
		_tmp0_ = TRUE;
#line 79 "src/lisp.vala"
		while (TRUE) {
#line 640 "lisp.c"
			gchar _tmp1_ = '\0';
			gchar _tmp2_;
#line 79 "src/lisp.vala"
			if (!_tmp0_) {
#line 87 "src/lisp.vala"
				if (!g_ascii_isspace (c)) {
#line 87 "src/lisp.vala"
					break;
#line 649 "lisp.c"
				}
			}
#line 79 "src/lisp.vala"
			_tmp0_ = FALSE;
#line 80 "src/lisp.vala"
			_tmp2_ = lexp_read_char (a, pos, &_inner_error0_);
#line 80 "src/lisp.vala"
			_tmp1_ = _tmp2_;
#line 80 "src/lisp.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 80 "src/lisp.vala"
				if (_inner_error0_->domain == PARSE_ERROR) {
#line 80 "src/lisp.vala"
					g_propagate_error (error, _inner_error0_);
#line 80 "src/lisp.vala"
					return 0;
#line 666 "lisp.c"
				} else {
#line 80 "src/lisp.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 80 "src/lisp.vala"
					g_clear_error (&_inner_error0_);
#line 80 "src/lisp.vala"
					return 0;
#line 674 "lisp.c"
				}
			}
#line 80 "src/lisp.vala"
			c = _tmp1_;
#line 83 "src/lisp.vala"
			if (c == ';') {
#line 681 "lisp.c"
				{
					gboolean _tmp3_ = FALSE;
#line 84 "src/lisp.vala"
					_tmp3_ = TRUE;
#line 84 "src/lisp.vala"
					while (TRUE) {
#line 688 "lisp.c"
						gchar _tmp4_ = '\0';
						gchar _tmp5_;
#line 84 "src/lisp.vala"
						if (!_tmp3_) {
#line 86 "src/lisp.vala"
							if (!(c != '\n')) {
#line 86 "src/lisp.vala"
								break;
#line 697 "lisp.c"
							}
						}
#line 84 "src/lisp.vala"
						_tmp3_ = FALSE;
#line 85 "src/lisp.vala"
						_tmp5_ = lexp_read_char (a, pos, &_inner_error0_);
#line 85 "src/lisp.vala"
						_tmp4_ = _tmp5_;
#line 85 "src/lisp.vala"
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 85 "src/lisp.vala"
							if (_inner_error0_->domain == PARSE_ERROR) {
#line 85 "src/lisp.vala"
								g_propagate_error (error, _inner_error0_);
#line 85 "src/lisp.vala"
								return 0;
#line 714 "lisp.c"
							} else {
#line 85 "src/lisp.vala"
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 85 "src/lisp.vala"
								g_clear_error (&_inner_error0_);
#line 85 "src/lisp.vala"
								return 0;
#line 722 "lisp.c"
							}
						}
#line 85 "src/lisp.vala"
						c = _tmp4_;
#line 727 "lisp.c"
					}
				}
			}
		}
	}
#line 90 "src/lisp.vala"
	_tmp6_ = g_strdup ("");
#line 90 "src/lisp.vala"
	_g_free0 (_vala_tok);
#line 90 "src/lisp.vala"
	_vala_tok = _tmp6_;
#line 92 "src/lisp.vala"
	if (c == '(') {
#line 93 "src/lisp.vala"
		result = LEXP_TOKEN_TYPE_openparen;
#line 93 "src/lisp.vala"
		if (tok) {
#line 93 "src/lisp.vala"
			*tok = _vala_tok;
#line 747 "lisp.c"
		} else {
#line 93 "src/lisp.vala"
			_g_free0 (_vala_tok);
#line 751 "lisp.c"
		}
#line 93 "src/lisp.vala"
		return result;
#line 755 "lisp.c"
	} else {
#line 94 "src/lisp.vala"
		if (c == ')') {
#line 95 "src/lisp.vala"
			result = LEXP_TOKEN_TYPE_closeparen;
#line 95 "src/lisp.vala"
			if (tok) {
#line 95 "src/lisp.vala"
				*tok = _vala_tok;
#line 765 "lisp.c"
			} else {
#line 95 "src/lisp.vala"
				_g_free0 (_vala_tok);
#line 769 "lisp.c"
			}
#line 95 "src/lisp.vala"
			return result;
#line 773 "lisp.c"
		} else {
#line 96 "src/lisp.vala"
			if (c == '\'') {
#line 97 "src/lisp.vala"
				result = LEXP_TOKEN_TYPE_quote;
#line 97 "src/lisp.vala"
				if (tok) {
#line 97 "src/lisp.vala"
					*tok = _vala_tok;
#line 783 "lisp.c"
				} else {
#line 97 "src/lisp.vala"
					_g_free0 (_vala_tok);
#line 787 "lisp.c"
				}
#line 97 "src/lisp.vala"
				return result;
#line 791 "lisp.c"
			}
		}
	}
#line 100 "src/lisp.vala"
	doublequotes = FALSE;
#line 101 "src/lisp.vala"
	if (c == '\"') {
#line 799 "lisp.c"
		gchar _tmp7_ = '\0';
		gchar _tmp8_;
#line 102 "src/lisp.vala"
		doublequotes = TRUE;
#line 103 "src/lisp.vala"
		_tmp8_ = lexp_read_char (a, pos, &_inner_error0_);
#line 103 "src/lisp.vala"
		_tmp7_ = _tmp8_;
#line 103 "src/lisp.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 103 "src/lisp.vala"
			if (_inner_error0_->domain == PARSE_ERROR) {
#line 103 "src/lisp.vala"
				g_propagate_error (error, _inner_error0_);
#line 103 "src/lisp.vala"
				return 0;
#line 816 "lisp.c"
			} else {
#line 103 "src/lisp.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 103 "src/lisp.vala"
				g_clear_error (&_inner_error0_);
#line 103 "src/lisp.vala"
				return 0;
#line 824 "lisp.c"
			}
		}
#line 103 "src/lisp.vala"
		c = _tmp7_;
#line 829 "lisp.c"
	}
	{
		gboolean _tmp9_ = FALSE;
#line 106 "src/lisp.vala"
		_tmp9_ = TRUE;
#line 106 "src/lisp.vala"
		while (TRUE) {
#line 837 "lisp.c"
			const gchar* _tmp12_;
			gchar* _tmp13_;
			gchar* _tmp14_;
			gchar* _tmp15_;
#line 106 "src/lisp.vala"
			if (!_tmp9_) {
#line 844 "lisp.c"
				gchar _tmp10_ = '\0';
				gchar _tmp11_;
#line 106 "src/lisp.vala"
				_tmp11_ = lexp_read_char (a, pos, &_inner_error0_);
#line 106 "src/lisp.vala"
				_tmp10_ = _tmp11_;
#line 106 "src/lisp.vala"
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 106 "src/lisp.vala"
					if (_inner_error0_->domain == PARSE_ERROR) {
#line 106 "src/lisp.vala"
						g_propagate_error (error, _inner_error0_);
#line 106 "src/lisp.vala"
						return 0;
#line 859 "lisp.c"
					} else {
#line 106 "src/lisp.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 106 "src/lisp.vala"
						g_clear_error (&_inner_error0_);
#line 106 "src/lisp.vala"
						return 0;
#line 867 "lisp.c"
					}
				}
#line 106 "src/lisp.vala"
				c = _tmp10_;
#line 872 "lisp.c"
			}
#line 106 "src/lisp.vala"
			_tmp9_ = FALSE;
#line 107 "src/lisp.vala"
			_tmp12_ = _vala_tok;
#line 107 "src/lisp.vala"
			_tmp13_ = g_strdup_printf ("%c", (gchar) c);
#line 107 "src/lisp.vala"
			_tmp14_ = _tmp13_;
#line 107 "src/lisp.vala"
			_tmp15_ = g_strconcat (_tmp12_, _tmp14_, NULL);
#line 107 "src/lisp.vala"
			_g_free0 (_vala_tok);
#line 107 "src/lisp.vala"
			_vala_tok = _tmp15_;
#line 107 "src/lisp.vala"
			_g_free0 (_tmp14_);
#line 109 "src/lisp.vala"
			if (!doublequotes) {
#line 892 "lisp.c"
				gboolean _tmp16_ = FALSE;
				gboolean _tmp17_ = FALSE;
				gboolean _tmp18_ = FALSE;
#line 110 "src/lisp.vala"
				if (c == ')') {
#line 110 "src/lisp.vala"
					_tmp18_ = TRUE;
#line 900 "lisp.c"
				} else {
#line 110 "src/lisp.vala"
					_tmp18_ = c == '(';
#line 904 "lisp.c"
				}
#line 110 "src/lisp.vala"
				if (_tmp18_) {
#line 110 "src/lisp.vala"
					_tmp17_ = TRUE;
#line 910 "lisp.c"
				} else {
#line 110 "src/lisp.vala"
					_tmp17_ = c == ';';
#line 914 "lisp.c"
				}
#line 110 "src/lisp.vala"
				if (_tmp17_) {
#line 110 "src/lisp.vala"
					_tmp16_ = TRUE;
#line 920 "lisp.c"
				} else {
#line 110 "src/lisp.vala"
					_tmp16_ = g_ascii_isspace (c);
#line 924 "lisp.c"
				}
#line 110 "src/lisp.vala"
				if (_tmp16_) {
#line 928 "lisp.c"
					guint _tmp19_;
					const gchar* _tmp20_;
					gchar* _tmp21_;
#line 111 "src/lisp.vala"
					_tmp19_ = *pos;
#line 111 "src/lisp.vala"
					*pos = _tmp19_ - 1;
#line 112 "src/lisp.vala"
					_tmp20_ = _vala_tok;
#line 112 "src/lisp.vala"
					_tmp21_ = string_slice (_tmp20_, (glong) 0, (glong) -1);
#line 112 "src/lisp.vala"
					_g_free0 (_vala_tok);
#line 112 "src/lisp.vala"
					_vala_tok = _tmp21_;
#line 113 "src/lisp.vala"
					result = LEXP_TOKEN_TYPE_word;
#line 113 "src/lisp.vala"
					if (tok) {
#line 113 "src/lisp.vala"
						*tok = _vala_tok;
#line 950 "lisp.c"
					} else {
#line 113 "src/lisp.vala"
						_g_free0 (_vala_tok);
#line 954 "lisp.c"
					}
#line 113 "src/lisp.vala"
					return result;
#line 958 "lisp.c"
				}
			} else {
				gboolean _tmp22_ = FALSE;
#line 116 "src/lisp.vala"
				if (c == '\n') {
#line 116 "src/lisp.vala"
					_tmp22_ = TRUE;
#line 966 "lisp.c"
				} else {
#line 116 "src/lisp.vala"
					_tmp22_ = c == '\r';
#line 970 "lisp.c"
				}
#line 116 "src/lisp.vala"
				if (_tmp22_) {
#line 974 "lisp.c"
					GError* _tmp23_;
#line 117 "src/lisp.vala"
					_tmp23_ = g_error_new_literal (PARSE_ERROR, PARSE_ERROR_UNCLOSED_QUOTE, "EOL");
#line 117 "src/lisp.vala"
					_inner_error0_ = _tmp23_;
#line 117 "src/lisp.vala"
					if (_inner_error0_->domain == PARSE_ERROR) {
#line 117 "src/lisp.vala"
						g_propagate_error (error, _inner_error0_);
#line 117 "src/lisp.vala"
						return 0;
#line 986 "lisp.c"
					} else {
#line 117 "src/lisp.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 117 "src/lisp.vala"
						g_clear_error (&_inner_error0_);
#line 117 "src/lisp.vala"
						return 0;
#line 994 "lisp.c"
					}
				}
#line 118 "src/lisp.vala"
				if (c == '\"') {
#line 999 "lisp.c"
					const gchar* _tmp24_;
					gchar* _tmp25_;
#line 119 "src/lisp.vala"
					_tmp24_ = _vala_tok;
#line 119 "src/lisp.vala"
					_tmp25_ = string_slice (_tmp24_, (glong) 0, (glong) -1);
#line 119 "src/lisp.vala"
					_g_free0 (_vala_tok);
#line 119 "src/lisp.vala"
					_vala_tok = _tmp25_;
#line 120 "src/lisp.vala"
					result = LEXP_TOKEN_TYPE_word;
#line 120 "src/lisp.vala"
					if (tok) {
#line 120 "src/lisp.vala"
						*tok = _vala_tok;
#line 1016 "lisp.c"
					} else {
#line 120 "src/lisp.vala"
						_g_free0 (_vala_tok);
#line 1020 "lisp.c"
					}
#line 120 "src/lisp.vala"
					return result;
#line 1024 "lisp.c"
				}
			}
		}
	}
#line 75 "src/lisp.vala"
	if (tok) {
#line 75 "src/lisp.vala"
		*tok = _vala_tok;
#line 1033 "lisp.c"
	} else {
#line 75 "src/lisp.vala"
		_g_free0 (_vala_tok);
#line 1037 "lisp.c"
	}
}

static Lexp*
lexp_read_sexp (const gchar* a,
                guint* pos,
                LexpTokenType* tokenid,
                GError** error)
{
	LexpTokenType _vala_tokenid = 0;
	gchar* tok = NULL;
	LexpTokenType _tmp0_ = 0;
	gchar* _tmp1_ = NULL;
	LexpTokenType _tmp2_;
	Lexp* sexp = NULL;
	Lexp* _tmp3_;
	LexpTokenType _tmp4_;
	LexpTokenType _tmp9_;
	GError* _inner_error0_ = NULL;
	Lexp* result = NULL;
#line 126 "src/lisp.vala"
	g_return_val_if_fail (a != NULL, NULL);
#line 129 "src/lisp.vala"
	_tmp2_ = lexp_read_token (a, pos, &_tmp1_, &_inner_error0_);
#line 129 "src/lisp.vala"
	_g_free0 (tok);
#line 129 "src/lisp.vala"
	tok = _tmp1_;
#line 129 "src/lisp.vala"
	_tmp0_ = _tmp2_;
#line 129 "src/lisp.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 129 "src/lisp.vala"
		if (_inner_error0_->domain == PARSE_ERROR) {
#line 129 "src/lisp.vala"
			g_propagate_error (error, _inner_error0_);
#line 129 "src/lisp.vala"
			_g_free0 (tok);
#line 129 "src/lisp.vala"
			return NULL;
#line 1078 "lisp.c"
		} else {
#line 129 "src/lisp.vala"
			_g_free0 (tok);
#line 129 "src/lisp.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 129 "src/lisp.vala"
			g_clear_error (&_inner_error0_);
#line 129 "src/lisp.vala"
			return NULL;
#line 1088 "lisp.c"
		}
	}
#line 129 "src/lisp.vala"
	_vala_tokenid = _tmp0_;
#line 130 "src/lisp.vala"
	_tmp3_ = lexp_new (NULL);
#line 130 "src/lisp.vala"
	sexp = _tmp3_;
#line 132 "src/lisp.vala"
	_tmp4_ = _vala_tokenid;
#line 132 "src/lisp.vala"
	if (_tmp4_ == LEXP_TOKEN_TYPE_quote) {
#line 1101 "lisp.c"
		Lexp* _tmp5_;
		LexpTokenType _tmp6_ = 0;
		gchar* _tmp7_ = NULL;
		LexpTokenType _tmp8_;
#line 133 "src/lisp.vala"
		_tmp5_ = sexp;
#line 133 "src/lisp.vala"
		_tmp5_->quoted = TRUE;
#line 134 "src/lisp.vala"
		_tmp8_ = lexp_read_token (a, pos, &_tmp7_, &_inner_error0_);
#line 134 "src/lisp.vala"
		_g_free0 (tok);
#line 134 "src/lisp.vala"
		tok = _tmp7_;
#line 134 "src/lisp.vala"
		_tmp6_ = _tmp8_;
#line 134 "src/lisp.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 134 "src/lisp.vala"
			if (_inner_error0_->domain == PARSE_ERROR) {
#line 134 "src/lisp.vala"
				g_propagate_error (error, _inner_error0_);
#line 134 "src/lisp.vala"
				_lexp_unref0 (sexp);
#line 134 "src/lisp.vala"
				_g_free0 (tok);
#line 134 "src/lisp.vala"
				return NULL;
#line 1130 "lisp.c"
			} else {
#line 134 "src/lisp.vala"
				_lexp_unref0 (sexp);
#line 134 "src/lisp.vala"
				_g_free0 (tok);
#line 134 "src/lisp.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 134 "src/lisp.vala"
				g_clear_error (&_inner_error0_);
#line 134 "src/lisp.vala"
				return NULL;
#line 1142 "lisp.c"
			}
		}
#line 134 "src/lisp.vala"
		_vala_tokenid = _tmp6_;
#line 1147 "lisp.c"
	}
#line 137 "src/lisp.vala"
	_tmp9_ = _vala_tokenid;
#line 137 "src/lisp.vala"
	switch (_tmp9_) {
#line 137 "src/lisp.vala"
		case LEXP_TOKEN_TYPE_openparen:
#line 1155 "lisp.c"
		{
			Lexp* _tmp10_;
			GeeList* _tmp11_;
#line 139 "src/lisp.vala"
			_tmp10_ = sexp;
#line 139 "src/lisp.vala"
			_tmp11_ = lexp_read_list (a, pos);
#line 139 "src/lisp.vala"
			_g_object_unref0 (_tmp10_->list);
#line 139 "src/lisp.vala"
			_tmp10_->list = _tmp11_;
#line 140 "src/lisp.vala"
			break;
#line 1169 "lisp.c"
		}
#line 137 "src/lisp.vala"
		case LEXP_TOKEN_TYPE_word:
#line 1173 "lisp.c"
		{
			Lexp* _tmp12_;
			const gchar* _tmp13_;
			gchar* _tmp14_;
#line 143 "src/lisp.vala"
			_tmp12_ = sexp;
#line 143 "src/lisp.vala"
			_tmp13_ = tok;
#line 143 "src/lisp.vala"
			_tmp14_ = g_strdup (_tmp13_);
#line 143 "src/lisp.vala"
			_g_free0 (_tmp12_->atom);
#line 143 "src/lisp.vala"
			_tmp12_->atom = _tmp14_;
#line 144 "src/lisp.vala"
			break;
#line 1190 "lisp.c"
		}
#line 137 "src/lisp.vala"
		case LEXP_TOKEN_TYPE_closeparen:
#line 1194 "lisp.c"
		{
#line 147 "src/lisp.vala"
			break;
#line 1198 "lisp.c"
		}
		default:
		{
#line 150 "src/lisp.vala"
			break;
#line 1204 "lisp.c"
		}
	}
#line 153 "src/lisp.vala"
	result = sexp;
#line 153 "src/lisp.vala"
	_g_free0 (tok);
#line 153 "src/lisp.vala"
	if (tokenid) {
#line 153 "src/lisp.vala"
		*tokenid = _vala_tokenid;
#line 1215 "lisp.c"
	}
#line 153 "src/lisp.vala"
	return result;
#line 1219 "lisp.c"
}

GeeList*
lexp_read_list (const gchar* a,
                guint* pos)
{
	GeeList* list = NULL;
	GeeArrayList* _tmp0_;
	GError* _inner_error0_ = NULL;
	GeeList* result = NULL;
#line 156 "src/lisp.vala"
	g_return_val_if_fail (a != NULL, NULL);
#line 157 "src/lisp.vala"
	_tmp0_ = gee_array_list_new (TYPE_LEXP, (GBoxedCopyFunc) lexp_ref, (GDestroyNotify) lexp_unref, NULL, NULL, NULL);
#line 157 "src/lisp.vala"
	list = (GeeList*) _tmp0_;
#line 1236 "lisp.c"
	{
#line 159 "src/lisp.vala"
		while (TRUE) {
#line 1240 "lisp.c"
			LexpTokenType tokenid = 0;
			Lexp* sexp = NULL;
			LexpTokenType _tmp1_ = 0;
			Lexp* _tmp2_;
			LexpTokenType _tmp3_;
			GeeList* _tmp4_;
			Lexp* _tmp5_;
#line 161 "src/lisp.vala"
			_tmp2_ = lexp_read_sexp (a, pos, &_tmp1_, &_inner_error0_);
#line 161 "src/lisp.vala"
			tokenid = _tmp1_;
#line 161 "src/lisp.vala"
			sexp = _tmp2_;
#line 161 "src/lisp.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 161 "src/lisp.vala"
				if (_inner_error0_->domain == PARSE_ERROR) {
#line 1258 "lisp.c"
					goto __catch0_parse_error;
				}
#line 161 "src/lisp.vala"
				_g_object_unref0 (list);
#line 161 "src/lisp.vala"
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 161 "src/lisp.vala"
				g_clear_error (&_inner_error0_);
#line 161 "src/lisp.vala"
				return NULL;
#line 1269 "lisp.c"
			}
#line 162 "src/lisp.vala"
			_tmp3_ = tokenid;
#line 162 "src/lisp.vala"
			if (_tmp3_ == LEXP_TOKEN_TYPE_closeparen) {
#line 163 "src/lisp.vala"
				_lexp_unref0 (sexp);
#line 163 "src/lisp.vala"
				break;
#line 1279 "lisp.c"
			}
#line 164 "src/lisp.vala"
			_tmp4_ = list;
#line 164 "src/lisp.vala"
			_tmp5_ = sexp;
#line 164 "src/lisp.vala"
			gee_collection_add ((GeeCollection*) _tmp4_, _tmp5_);
#line 159 "src/lisp.vala"
			_lexp_unref0 (sexp);
#line 1289 "lisp.c"
		}
	}
	goto __finally0;
	__catch0_parse_error:
	{
		GError* e = NULL;
		GError* _tmp6_;
#line 158 "src/lisp.vala"
		e = _inner_error0_;
#line 158 "src/lisp.vala"
		_inner_error0_ = NULL;
#line 167 "src/lisp.vala"
		_tmp6_ = e;
#line 167 "src/lisp.vala"
		if (!g_error_matches (_tmp6_, PARSE_ERROR, PARSE_ERROR_EOF)) {
#line 168 "src/lisp.vala"
			_g_object_unref0 (list);
#line 168 "src/lisp.vala"
			list = NULL;
#line 1309 "lisp.c"
		}
#line 158 "src/lisp.vala"
		_g_error_free0 (e);
#line 1313 "lisp.c"
	}
	__finally0:
#line 158 "src/lisp.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 158 "src/lisp.vala"
		_g_object_unref0 (list);
#line 158 "src/lisp.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 158 "src/lisp.vala"
		g_clear_error (&_inner_error0_);
#line 158 "src/lisp.vala"
		return NULL;
#line 1326 "lisp.c"
	}
#line 170 "src/lisp.vala"
	result = list;
#line 170 "src/lisp.vala"
	return result;
#line 1332 "lisp.c"
}

static void
value_lexp_init (GValue* value)
{
#line 24 "src/lisp.vala"
	value->data[0].v_pointer = NULL;
#line 1340 "lisp.c"
}

static void
value_lexp_free_value (GValue* value)
{
#line 24 "src/lisp.vala"
	if (value->data[0].v_pointer) {
#line 24 "src/lisp.vala"
		lexp_unref (value->data[0].v_pointer);
#line 1350 "lisp.c"
	}
}

static void
value_lexp_copy_value (const GValue* src_value,
                       GValue* dest_value)
{
#line 24 "src/lisp.vala"
	if (src_value->data[0].v_pointer) {
#line 24 "src/lisp.vala"
		dest_value->data[0].v_pointer = lexp_ref (src_value->data[0].v_pointer);
#line 1362 "lisp.c"
	} else {
#line 24 "src/lisp.vala"
		dest_value->data[0].v_pointer = NULL;
#line 1366 "lisp.c"
	}
}

static gpointer
value_lexp_peek_pointer (const GValue* value)
{
#line 24 "src/lisp.vala"
	return value->data[0].v_pointer;
#line 1375 "lisp.c"
}

static gchar*
value_lexp_collect_value (GValue* value,
                          guint n_collect_values,
                          GTypeCValue* collect_values,
                          guint collect_flags)
{
#line 24 "src/lisp.vala"
	if (collect_values[0].v_pointer) {
#line 1386 "lisp.c"
		Lexp * object;
		object = collect_values[0].v_pointer;
#line 24 "src/lisp.vala"
		if (object->parent_instance.g_class == NULL) {
#line 24 "src/lisp.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1393 "lisp.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 24 "src/lisp.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1397 "lisp.c"
		}
#line 24 "src/lisp.vala"
		value->data[0].v_pointer = lexp_ref (object);
#line 1401 "lisp.c"
	} else {
#line 24 "src/lisp.vala"
		value->data[0].v_pointer = NULL;
#line 1405 "lisp.c"
	}
#line 24 "src/lisp.vala"
	return NULL;
#line 1409 "lisp.c"
}

static gchar*
value_lexp_lcopy_value (const GValue* value,
                        guint n_collect_values,
                        GTypeCValue* collect_values,
                        guint collect_flags)
{
	Lexp ** object_p;
	object_p = collect_values[0].v_pointer;
#line 24 "src/lisp.vala"
	if (!object_p) {
#line 24 "src/lisp.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 1424 "lisp.c"
	}
#line 24 "src/lisp.vala"
	if (!value->data[0].v_pointer) {
#line 24 "src/lisp.vala"
		*object_p = NULL;
#line 1430 "lisp.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 24 "src/lisp.vala"
		*object_p = value->data[0].v_pointer;
#line 1434 "lisp.c"
	} else {
#line 24 "src/lisp.vala"
		*object_p = lexp_ref (value->data[0].v_pointer);
#line 1438 "lisp.c"
	}
#line 24 "src/lisp.vala"
	return NULL;
#line 1442 "lisp.c"
}

GParamSpec*
param_spec_lexp (const gchar* name,
                 const gchar* nick,
                 const gchar* blurb,
                 GType object_type,
                 GParamFlags flags)
{
	ParamSpecLexp* spec;
#line 24 "src/lisp.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_LEXP), NULL);
#line 24 "src/lisp.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 24 "src/lisp.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 24 "src/lisp.vala"
	return G_PARAM_SPEC (spec);
#line 1461 "lisp.c"
}

gpointer
value_get_lexp (const GValue* value)
{
#line 24 "src/lisp.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_LEXP), NULL);
#line 24 "src/lisp.vala"
	return value->data[0].v_pointer;
#line 1471 "lisp.c"
}

void
value_set_lexp (GValue* value,
                gpointer v_object)
{
	Lexp * old;
#line 24 "src/lisp.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_LEXP));
#line 24 "src/lisp.vala"
	old = value->data[0].v_pointer;
#line 24 "src/lisp.vala"
	if (v_object) {
#line 24 "src/lisp.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_LEXP));
#line 24 "src/lisp.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 24 "src/lisp.vala"
		value->data[0].v_pointer = v_object;
#line 24 "src/lisp.vala"
		lexp_ref (value->data[0].v_pointer);
#line 1493 "lisp.c"
	} else {
#line 24 "src/lisp.vala"
		value->data[0].v_pointer = NULL;
#line 1497 "lisp.c"
	}
#line 24 "src/lisp.vala"
	if (old) {
#line 24 "src/lisp.vala"
		lexp_unref (old);
#line 1503 "lisp.c"
	}
}

void
value_take_lexp (GValue* value,
                 gpointer v_object)
{
	Lexp * old;
#line 24 "src/lisp.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_LEXP));
#line 24 "src/lisp.vala"
	old = value->data[0].v_pointer;
#line 24 "src/lisp.vala"
	if (v_object) {
#line 24 "src/lisp.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_LEXP));
#line 24 "src/lisp.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 24 "src/lisp.vala"
		value->data[0].v_pointer = v_object;
#line 1524 "lisp.c"
	} else {
#line 24 "src/lisp.vala"
		value->data[0].v_pointer = NULL;
#line 1528 "lisp.c"
	}
#line 24 "src/lisp.vala"
	if (old) {
#line 24 "src/lisp.vala"
		lexp_unref (old);
#line 1534 "lisp.c"
	}
}

static void
lexp_class_init (LexpClass * klass,
                 gpointer klass_data)
{
#line 24 "src/lisp.vala"
	lexp_parent_class = g_type_class_peek_parent (klass);
#line 24 "src/lisp.vala"
	((LexpClass *) klass)->finalize = lexp_finalize;
#line 1546 "lisp.c"
}

static void
lexp_instance_init (Lexp * self,
                    gpointer klass)
{
#line 24 "src/lisp.vala"
	self->ref_count = 1;
#line 1555 "lisp.c"
}

static void
lexp_finalize (Lexp * obj)
{
	Lexp * self;
#line 24 "src/lisp.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_LEXP, Lexp);
#line 24 "src/lisp.vala"
	g_signal_handlers_destroy (self);
#line 28 "src/lisp.vala"
	_g_free0 (self->atom);
#line 29 "src/lisp.vala"
	_g_object_unref0 (self->list);
#line 1570 "lisp.c"
}

static GType
lexp_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_lexp_init, value_lexp_free_value, value_lexp_copy_value, value_lexp_peek_pointer, "p", value_lexp_collect_value, "p", value_lexp_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (LexpClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) lexp_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Lexp), 0, (GInstanceInitFunc) lexp_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType lexp_type_id;
	lexp_type_id = g_type_register_fundamental (g_type_fundamental_next (), "Lexp", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return lexp_type_id;
}

GType
lexp_get_type (void)
{
	static volatile gsize lexp_type_id__volatile = 0;
	if (g_once_init_enter (&lexp_type_id__volatile)) {
		GType lexp_type_id;
		lexp_type_id = lexp_get_type_once ();
		g_once_init_leave (&lexp_type_id__volatile, lexp_type_id);
	}
	return lexp_type_id__volatile;
}

gpointer
lexp_ref (gpointer instance)
{
	Lexp * self;
	self = instance;
#line 24 "src/lisp.vala"
	g_atomic_int_inc (&self->ref_count);
#line 24 "src/lisp.vala"
	return instance;
#line 1605 "lisp.c"
}

void
lexp_unref (gpointer instance)
{
	Lexp * self;
	self = instance;
#line 24 "src/lisp.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 24 "src/lisp.vala"
		LEXP_GET_CLASS (self)->finalize (self);
#line 24 "src/lisp.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 1619 "lisp.c"
	}
}

gboolean
funcall (const gchar* name,
         glong* maybe_uniarg)
{
	glong uniarg = 0L;
	GeeQueue* args = NULL;
	LispFunc* _tmp1_;
	LispFunc* _tmp2_;
	Function _tmp3_;
	GeeQueue* _tmp4_;
	gboolean _tmp5_;
	gboolean result = FALSE;
#line 180 "src/lisp.vala"
	g_return_val_if_fail (name != NULL, FALSE);
#line 186 "src/lisp.vala"
	if (maybe_uniarg == NULL) {
#line 1639 "lisp.c"
		GeeArrayQueue* _tmp0_;
#line 187 "src/lisp.vala"
		uniarg = (glong) 1;
#line 188 "src/lisp.vala"
		_tmp0_ = gee_array_queue_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
#line 188 "src/lisp.vala"
		_g_object_unref0 (args);
#line 188 "src/lisp.vala"
		args = (GeeQueue*) _tmp0_;
#line 1649 "lisp.c"
	} else {
#line 190 "src/lisp.vala"
		uniarg = *maybe_uniarg;
#line 191 "src/lisp.vala"
		_g_object_unref0 (args);
#line 191 "src/lisp.vala"
		args = NULL;
#line 1657 "lisp.c"
	}
#line 193 "src/lisp.vala"
	_tmp1_ = lisp_func_find (name);
#line 193 "src/lisp.vala"
	_tmp2_ = _tmp1_;
#line 193 "src/lisp.vala"
	_tmp3_ = _tmp2_->func;
#line 193 "src/lisp.vala"
	_tmp4_ = args;
#line 193 "src/lisp.vala"
	_tmp5_ = _tmp3_ (uniarg, _tmp4_);
#line 193 "src/lisp.vala"
	_lisp_func_unref0 (_tmp2_);
#line 193 "src/lisp.vala"
	result = _tmp5_;
#line 193 "src/lisp.vala"
	_g_object_unref0 (args);
#line 193 "src/lisp.vala"
	return result;
#line 1677 "lisp.c"
}

gboolean
noarg (GeeQueue* args)
{
	gboolean _tmp0_ = FALSE;
	Flags _tmp1_;
	gboolean result = FALSE;
#line 197 "src/lisp.vala"
	_tmp1_ = lastflag;
#line 197 "src/lisp.vala"
	if (!((_tmp1_ & FLAGS_SET_UNIARG) == FLAGS_SET_UNIARG)) {
#line 1690 "lisp.c"
		gboolean _tmp2_ = FALSE;
#line 197 "src/lisp.vala"
		if (args != NULL) {
#line 1694 "lisp.c"
			gint _tmp3_;
			gint _tmp4_;
#line 197 "src/lisp.vala"
			_tmp3_ = gee_collection_get_size ((GeeCollection*) args);
#line 197 "src/lisp.vala"
			_tmp4_ = _tmp3_;
#line 197 "src/lisp.vala"
			_tmp2_ = _tmp4_ == 0;
#line 1703 "lisp.c"
		} else {
#line 197 "src/lisp.vala"
			_tmp2_ = FALSE;
#line 1707 "lisp.c"
		}
#line 197 "src/lisp.vala"
		_tmp0_ = _tmp2_;
#line 1711 "lisp.c"
	} else {
#line 197 "src/lisp.vala"
		_tmp0_ = FALSE;
#line 1715 "lisp.c"
	}
#line 197 "src/lisp.vala"
	result = _tmp0_;
#line 197 "src/lisp.vala"
	return result;
#line 1721 "lisp.c"
}

gboolean
bool_arg (GeeQueue* args,
          gboolean* val)
{
	gboolean _vala_val = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean result = FALSE;
#line 201 "src/lisp.vala"
	_vala_val = FALSE;
#line 202 "src/lisp.vala"
	if (args != NULL) {
#line 1735 "lisp.c"
		gint _tmp1_;
		gint _tmp2_;
#line 202 "src/lisp.vala"
		_tmp1_ = gee_collection_get_size ((GeeCollection*) args);
#line 202 "src/lisp.vala"
		_tmp2_ = _tmp1_;
#line 202 "src/lisp.vala"
		_tmp0_ = _tmp2_ > 0;
#line 1744 "lisp.c"
	} else {
#line 202 "src/lisp.vala"
		_tmp0_ = FALSE;
#line 1748 "lisp.c"
	}
#line 202 "src/lisp.vala"
	if (_tmp0_) {
#line 1752 "lisp.c"
		gchar* s = NULL;
		gpointer _tmp3_;
		gboolean _tmp4_ = FALSE;
		const gchar* _tmp5_;
#line 203 "src/lisp.vala"
		_tmp3_ = gee_queue_poll (args);
#line 203 "src/lisp.vala"
		s = (gchar*) _tmp3_;
#line 204 "src/lisp.vala"
		_tmp5_ = s;
#line 204 "src/lisp.vala"
		if (_tmp5_ != NULL) {
#line 1765 "lisp.c"
			const gchar* _tmp6_;
#line 204 "src/lisp.vala"
			_tmp6_ = s;
#line 204 "src/lisp.vala"
			_tmp4_ = g_strcmp0 (_tmp6_, "nil") == 0;
#line 1771 "lisp.c"
		} else {
#line 204 "src/lisp.vala"
			_tmp4_ = FALSE;
#line 1775 "lisp.c"
		}
#line 204 "src/lisp.vala"
		_vala_val = !_tmp4_;
#line 205 "src/lisp.vala"
		result = TRUE;
#line 205 "src/lisp.vala"
		_g_free0 (s);
#line 205 "src/lisp.vala"
		if (val) {
#line 205 "src/lisp.vala"
			*val = _vala_val;
#line 1787 "lisp.c"
		}
#line 205 "src/lisp.vala"
		return result;
#line 1791 "lisp.c"
	}
#line 207 "src/lisp.vala"
	result = FALSE;
#line 207 "src/lisp.vala"
	if (val) {
#line 207 "src/lisp.vala"
		*val = _vala_val;
#line 1799 "lisp.c"
	}
#line 207 "src/lisp.vala"
	return result;
#line 1803 "lisp.c"
}

static gboolean
long_try_parse (const gchar* str,
                glong* _result_,
                const gchar* * unparsed,
                guint _base)
{
	glong _vala__result_ = 0L;
	const gchar* _vala_unparsed = NULL;
	gchar* endptr = NULL;
	gchar* _tmp0_ = NULL;
	glong _tmp1_;
	gchar* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gboolean result = FALSE;
#line 319 "glib-2.0.vapi"
	g_return_val_if_fail (str != NULL, FALSE);
#line 321 "glib-2.0.vapi"
	errno = 0;
#line 322 "glib-2.0.vapi"
	_tmp1_ = strtol (str, &_tmp0_, (gint) _base);
#line 322 "glib-2.0.vapi"
	endptr = _tmp0_;
#line 322 "glib-2.0.vapi"
	_vala__result_ = _tmp1_;
#line 323 "glib-2.0.vapi"
	_tmp2_ = endptr;
#line 323 "glib-2.0.vapi"
	_tmp3_ = strlen (str);
#line 323 "glib-2.0.vapi"
	_tmp4_ = _tmp3_;
#line 323 "glib-2.0.vapi"
	if (_tmp2_ == (((gchar*) str) + _tmp4_)) {
#line 1839 "lisp.c"
		gboolean _tmp5_ = FALSE;
#line 324 "glib-2.0.vapi"
		_vala_unparsed = "";
#line 325 "glib-2.0.vapi"
		if (errno != ERANGE) {
#line 325 "glib-2.0.vapi"
			_tmp5_ = errno != EINVAL;
#line 1847 "lisp.c"
		} else {
#line 325 "glib-2.0.vapi"
			_tmp5_ = FALSE;
#line 1851 "lisp.c"
		}
#line 325 "glib-2.0.vapi"
		result = _tmp5_;
#line 325 "glib-2.0.vapi"
		if (_result_) {
#line 325 "glib-2.0.vapi"
			*_result_ = _vala__result_;
#line 1859 "lisp.c"
		}
#line 325 "glib-2.0.vapi"
		if (unparsed) {
#line 325 "glib-2.0.vapi"
			*unparsed = _vala_unparsed;
#line 1865 "lisp.c"
		}
#line 325 "glib-2.0.vapi"
		return result;
#line 1869 "lisp.c"
	} else {
		gchar* _tmp6_;
#line 327 "glib-2.0.vapi"
		_tmp6_ = endptr;
#line 327 "glib-2.0.vapi"
		_vala_unparsed = (const gchar*) _tmp6_;
#line 328 "glib-2.0.vapi"
		result = FALSE;
#line 328 "glib-2.0.vapi"
		if (_result_) {
#line 328 "glib-2.0.vapi"
			*_result_ = _vala__result_;
#line 1882 "lisp.c"
		}
#line 328 "glib-2.0.vapi"
		if (unparsed) {
#line 328 "glib-2.0.vapi"
			*unparsed = _vala_unparsed;
#line 1888 "lisp.c"
		}
#line 328 "glib-2.0.vapi"
		return result;
#line 1892 "lisp.c"
	}
#line 319 "glib-2.0.vapi"
	if (_result_) {
#line 319 "glib-2.0.vapi"
		*_result_ = _vala__result_;
#line 1898 "lisp.c"
	}
#line 319 "glib-2.0.vapi"
	if (unparsed) {
#line 319 "glib-2.0.vapi"
		*unparsed = _vala_unparsed;
#line 1904 "lisp.c"
	}
}

static glong*
_long_dup (glong* self)
{
	glong* dup;
#line 215 "src/lisp.vala"
	dup = g_new0 (glong, 1);
#line 215 "src/lisp.vala"
	memcpy (dup, self, sizeof (glong));
#line 215 "src/lisp.vala"
	return dup;
#line 1918 "lisp.c"
}

static gpointer
__long_dup0 (gpointer self)
{
#line 215 "src/lisp.vala"
	return self ? _long_dup (self) : NULL;
#line 1926 "lisp.c"
}

glong*
parse_number (const gchar* s)
{
	glong res = 0L;
	glong _tmp0_ = 0L;
	gboolean _tmp1_;
	glong* result = NULL;
#line 211 "src/lisp.vala"
	if (s == NULL) {
#line 212 "src/lisp.vala"
		result = NULL;
#line 212 "src/lisp.vala"
		return result;
#line 1942 "lisp.c"
	}
#line 214 "src/lisp.vala"
	_tmp1_ = long_try_parse (s, &_tmp0_, NULL, (guint) 10);
#line 214 "src/lisp.vala"
	res = _tmp0_;
#line 214 "src/lisp.vala"
	if (_tmp1_) {
#line 1950 "lisp.c"
		glong* _tmp2_;
#line 215 "src/lisp.vala"
		_tmp2_ = __long_dup0 (&res);
#line 215 "src/lisp.vala"
		result = _tmp2_;
#line 215 "src/lisp.vala"
		return result;
#line 1958 "lisp.c"
	}
#line 216 "src/lisp.vala"
	result = NULL;
#line 216 "src/lisp.vala"
	return result;
#line 1964 "lisp.c"
}

gboolean
int_arg (GeeQueue* args,
         glong* n)
{
	glong _vala_n = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* s = NULL;
	gpointer _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	glong _tmp6_ = 0L;
	gboolean _tmp7_;
	gboolean result = FALSE;
#line 220 "src/lisp.vala"
	_vala_n = (glong) 0;
#line 221 "src/lisp.vala"
	if (args == NULL) {
#line 221 "src/lisp.vala"
		_tmp0_ = TRUE;
#line 1986 "lisp.c"
	} else {
		gint _tmp1_;
		gint _tmp2_;
#line 221 "src/lisp.vala"
		_tmp1_ = gee_collection_get_size ((GeeCollection*) args);
#line 221 "src/lisp.vala"
		_tmp2_ = _tmp1_;
#line 221 "src/lisp.vala"
		_tmp0_ = _tmp2_ == 0;
#line 1996 "lisp.c"
	}
#line 221 "src/lisp.vala"
	if (_tmp0_) {
#line 222 "src/lisp.vala"
		result = FALSE;
#line 222 "src/lisp.vala"
		if (n) {
#line 222 "src/lisp.vala"
			*n = _vala_n;
#line 2006 "lisp.c"
		}
#line 222 "src/lisp.vala"
		return result;
#line 2010 "lisp.c"
	}
#line 223 "src/lisp.vala"
	_tmp3_ = gee_queue_poll (args);
#line 223 "src/lisp.vala"
	s = (gchar*) _tmp3_;
#line 224 "src/lisp.vala"
	_tmp4_ = s;
#line 224 "src/lisp.vala"
	if (_tmp4_ == NULL) {
#line 225 "src/lisp.vala"
		result = FALSE;
#line 225 "src/lisp.vala"
		_g_free0 (s);
#line 225 "src/lisp.vala"
		if (n) {
#line 225 "src/lisp.vala"
			*n = _vala_n;
#line 2028 "lisp.c"
		}
#line 225 "src/lisp.vala"
		return result;
#line 2032 "lisp.c"
	}
#line 226 "src/lisp.vala"
	_tmp5_ = s;
#line 226 "src/lisp.vala"
	_tmp7_ = long_try_parse (_tmp5_, &_tmp6_, NULL, (guint) 10);
#line 226 "src/lisp.vala"
	_vala_n = _tmp6_;
#line 226 "src/lisp.vala"
	result = _tmp7_;
#line 226 "src/lisp.vala"
	_g_free0 (s);
#line 226 "src/lisp.vala"
	if (n) {
#line 226 "src/lisp.vala"
		*n = _vala_n;
#line 2048 "lisp.c"
	}
#line 226 "src/lisp.vala"
	return result;
#line 2052 "lisp.c"
}

gboolean
int_or_uniarg (GeeQueue* args,
               glong* n,
               glong uniarg)
{
	gboolean _tmp0_ = FALSE;
	gboolean result = FALSE;
#line 230 "src/lisp.vala"
	if (args != NULL) {
#line 2064 "lisp.c"
		gint _tmp1_;
		gint _tmp2_;
#line 230 "src/lisp.vala"
		_tmp1_ = gee_collection_get_size ((GeeCollection*) args);
#line 230 "src/lisp.vala"
		_tmp2_ = _tmp1_;
#line 230 "src/lisp.vala"
		_tmp0_ = _tmp2_ > 0;
#line 2073 "lisp.c"
	} else {
#line 230 "src/lisp.vala"
		_tmp0_ = FALSE;
#line 2077 "lisp.c"
	}
#line 230 "src/lisp.vala"
	if (_tmp0_) {
#line 2081 "lisp.c"
		glong* num = NULL;
		gpointer _tmp3_;
		gchar* _tmp4_;
		glong* _tmp5_;
		glong* _tmp6_;
		glong* _tmp7_;
		glong* _tmp9_;
#line 231 "src/lisp.vala"
		_tmp3_ = gee_queue_poll (args);
#line 231 "src/lisp.vala"
		_tmp4_ = (gchar*) _tmp3_;
#line 231 "src/lisp.vala"
		_tmp5_ = parse_number (_tmp4_);
#line 231 "src/lisp.vala"
		_tmp6_ = _tmp5_;
#line 231 "src/lisp.vala"
		_g_free0 (_tmp4_);
#line 231 "src/lisp.vala"
		num = _tmp6_;
#line 232 "src/lisp.vala"
		_tmp7_ = num;
#line 232 "src/lisp.vala"
		if (_tmp7_ != NULL) {
#line 2105 "lisp.c"
			glong* _tmp8_;
#line 233 "src/lisp.vala"
			_tmp8_ = num;
#line 233 "src/lisp.vala"
			*n = *_tmp8_;
#line 2111 "lisp.c"
		}
#line 234 "src/lisp.vala"
		_tmp9_ = num;
#line 234 "src/lisp.vala"
		result = _tmp9_ != NULL;
#line 234 "src/lisp.vala"
		_g_free0 (num);
#line 234 "src/lisp.vala"
		return result;
#line 2121 "lisp.c"
	}
#line 236 "src/lisp.vala"
	*n = uniarg;
#line 237 "src/lisp.vala"
	result = TRUE;
#line 237 "src/lisp.vala"
	return result;
#line 2129 "lisp.c"
}

void
lisp_loadstring (const gchar* a)
{
	guint pos = 0U;
	GeeList* _tmp0_;
	GeeList* _tmp1_;
#line 243 "src/lisp.vala"
	g_return_if_fail (a != NULL);
#line 244 "src/lisp.vala"
	pos = (guint) 0;
#line 245 "src/lisp.vala"
	_tmp0_ = lexp_read_list (a, &pos);
#line 245 "src/lisp.vala"
	_tmp1_ = _tmp0_;
#line 245 "src/lisp.vala"
	lexp_eval_list (_tmp1_);
#line 245 "src/lisp.vala"
	_g_object_unref0 (_tmp1_);
#line 2150 "lisp.c"
}

gboolean
lisp_loadfile (const gchar* file)
{
	gchar* s = NULL;
	const gchar* _tmp2_;
	GError* _inner_error0_ = NULL;
	gboolean result = FALSE;
#line 248 "src/lisp.vala"
	g_return_val_if_fail (file != NULL, FALSE);
#line 2162 "lisp.c"
	{
		gchar* _tmp0_ = NULL;
#line 251 "src/lisp.vala"
		g_file_get_contents (file, &_tmp0_, NULL, &_inner_error0_);
#line 251 "src/lisp.vala"
		_g_free0 (s);
#line 251 "src/lisp.vala"
		s = _tmp0_;
#line 251 "src/lisp.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 2173 "lisp.c"
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
#line 250 "src/lisp.vala"
		g_clear_error (&_inner_error0_);
#line 253 "src/lisp.vala"
		result = FALSE;
#line 253 "src/lisp.vala"
		_g_free0 (s);
#line 253 "src/lisp.vala"
		return result;
#line 2188 "lisp.c"
	}
	__finally0:
#line 250 "src/lisp.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 2193 "lisp.c"
		gboolean _tmp1_ = FALSE;
#line 250 "src/lisp.vala"
		_g_free0 (s);
#line 250 "src/lisp.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 250 "src/lisp.vala"
		g_clear_error (&_inner_error0_);
#line 250 "src/lisp.vala"
		return _tmp1_;
#line 2203 "lisp.c"
	}
#line 255 "src/lisp.vala"
	_tmp2_ = s;
#line 255 "src/lisp.vala"
	lisp_loadstring (_tmp2_);
#line 256 "src/lisp.vala"
	result = TRUE;
#line 256 "src/lisp.vala"
	_g_free0 (s);
#line 256 "src/lisp.vala"
	return result;
#line 2215 "lisp.c"
}

static gboolean
__lambda113_ (glong uniarg,
              GeeQueue* args)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean result = FALSE;
#line 264 "src/lisp.vala"
	if (args != NULL) {
#line 2227 "lisp.c"
		gboolean _tmp2_;
		gboolean _tmp3_;
#line 264 "src/lisp.vala"
		_tmp2_ = gee_collection_get_is_empty ((GeeCollection*) args);
#line 264 "src/lisp.vala"
		_tmp3_ = _tmp2_;
#line 264 "src/lisp.vala"
		_tmp1_ = !_tmp3_;
#line 2236 "lisp.c"
	} else {
#line 264 "src/lisp.vala"
		_tmp1_ = FALSE;
#line 2240 "lisp.c"
	}
#line 264 "src/lisp.vala"
	if (_tmp1_) {
#line 2244 "lisp.c"
		gpointer _tmp4_;
		gchar* _tmp5_;
#line 264 "src/lisp.vala"
		_tmp4_ = gee_queue_poll (args);
#line 264 "src/lisp.vala"
		_tmp5_ = (gchar*) _tmp4_;
#line 264 "src/lisp.vala"
		_tmp0_ = lisp_loadfile (_tmp5_);
#line 264 "src/lisp.vala"
		_g_free0 (_tmp5_);
#line 2255 "lisp.c"
	} else {
#line 264 "src/lisp.vala"
		_tmp0_ = FALSE;
#line 2259 "lisp.c"
	}
#line 264 "src/lisp.vala"
	result = _tmp0_;
#line 264 "src/lisp.vala"
	return result;
#line 2265 "lisp.c"
}

static gboolean
___lambda113__function (glong uniarg,
                        GeeQueue* args)
{
	gboolean result;
	result = __lambda113_ (uniarg, args);
#line 261 "src/lisp.vala"
	return result;
#line 2276 "lisp.c"
}

void
lisp_init (void)
{
	LispFunc* _tmp0_;
	LispFunc* _tmp1_;
#line 261 "src/lisp.vala"
	_tmp0_ = lisp_func_new ("load", ___lambda113__function, TRUE, "Execute a file of Lisp code named FILE.");
#line 261 "src/lisp.vala"
	_tmp1_ = _tmp0_;
#line 261 "src/lisp.vala"
	_lisp_func_unref0 (_tmp1_);
#line 2290 "lisp.c"
}

