/*
 * Decompiled with CFR 0.152.
 */
package gnu.inet.encoding;

import gnu.inet.encoding.PunycodeException;

public class Punycode {
    static final int TMIN = 1;
    static final int TMAX = 26;
    static final int BASE = 36;
    static final int INITIAL_N = 128;
    static final int INITIAL_BIAS = 72;
    static final int DAMP = 700;
    static final int SKEW = 38;
    static final char DELIMITER = '-';

    public static String encode(String string) throws PunycodeException {
        int n;
        int n2 = 128;
        int n3 = 0;
        int n4 = 72;
        StringBuffer stringBuffer = new StringBuffer();
        int n5 = 0;
        int n6 = 0;
        while (n6 < string.length()) {
            n = string.charAt(n6);
            if (Punycode.isBasic((char)n)) {
                stringBuffer.append((char)n);
                ++n5;
            }
            ++n6;
        }
        if (n5 > 0) {
            stringBuffer.append('-');
        }
        n6 = n5;
        while (n6 < string.length()) {
            int n7;
            n = Integer.MAX_VALUE;
            int n8 = 0;
            while (n8 < string.length()) {
                n7 = string.charAt(n8);
                if (n7 >= n2 && n7 < n) {
                    n = n7;
                }
                ++n8;
            }
            if (n - n2 > (Integer.MAX_VALUE - n3) / (n6 + 1)) {
                throw new PunycodeException(PunycodeException.OVERFLOW);
            }
            n3 += (n - n2) * (n6 + 1);
            n2 = n;
            n8 = 0;
            while (n8 < string.length()) {
                n7 = string.charAt(n8);
                if (n7 < n2 && ++n3 == 0) {
                    throw new PunycodeException(PunycodeException.OVERFLOW);
                }
                if (n7 == n2) {
                    int n9;
                    int n10 = n3;
                    int n11 = 36;
                    while (n10 >= (n9 = n11 <= n4 ? 1 : (n11 >= n4 + 26 ? 26 : n11 - n4))) {
                        stringBuffer.append((char)Punycode.digit2codepoint(n9 + (n10 - n9) % (36 - n9)));
                        n10 = (n10 - n9) / (36 - n9);
                        n11 += 36;
                    }
                    stringBuffer.append((char)Punycode.digit2codepoint(n10));
                    n4 = Punycode.adapt(n3, n6 + 1, n6 == n5);
                    n3 = 0;
                    ++n6;
                }
                ++n8;
            }
            ++n3;
            ++n2;
        }
        return stringBuffer.toString();
    }

    public static String decode(String string) throws PunycodeException {
        int n;
        int n2;
        int n3 = 128;
        int n4 = 0;
        int n5 = 72;
        StringBuffer stringBuffer = new StringBuffer();
        int n6 = string.lastIndexOf(45);
        if (n6 > 0) {
            n2 = 0;
            while (n2 < n6) {
                n = string.charAt(n2);
                if (!Punycode.isBasic((char)n)) {
                    throw new PunycodeException(PunycodeException.BAD_INPUT);
                }
                stringBuffer.append((char)n);
                ++n2;
            }
            ++n6;
        } else {
            n6 = 0;
        }
        while (n6 < string.length()) {
            n2 = n4;
            n = 1;
            int n7 = 36;
            while (true) {
                char c;
                int n8;
                if (n6 == string.length()) {
                    throw new PunycodeException(PunycodeException.BAD_INPUT);
                }
                if ((n8 = Punycode.codepoint2digit(c = string.charAt(n6++))) > (Integer.MAX_VALUE - n4) / n) {
                    throw new PunycodeException(PunycodeException.OVERFLOW);
                }
                n4 += n8 * n;
                int n9 = n7 <= n5 ? 1 : (n7 >= n5 + 26 ? 26 : n7 - n5);
                if (n8 < n9) break;
                n *= 36 - n9;
                n7 += 36;
            }
            n5 = Punycode.adapt(n4 - n2, stringBuffer.length() + 1, n2 == 0);
            if (n4 / (stringBuffer.length() + 1) > Integer.MAX_VALUE - n3) {
                throw new PunycodeException(PunycodeException.OVERFLOW);
            }
            n3 += n4 / (stringBuffer.length() + 1);
            stringBuffer.insert(n4 %= stringBuffer.length() + 1, (char)n3);
            ++n4;
        }
        return stringBuffer.toString();
    }

    public static final int adapt(int n, int n2, boolean bl) {
        n = bl ? (n /= 700) : (n /= 2);
        n += n / n2;
        int n3 = 0;
        while (n > 455) {
            n /= 35;
            n3 += 36;
        }
        return n3 + 36 * n / (n + 38);
    }

    public static final boolean isBasic(char c) {
        return c < '\u0080';
    }

    public static final int digit2codepoint(int n) throws PunycodeException {
        if (n < 26) {
            return n + 97;
        }
        if (n < 36) {
            return n - 26 + 48;
        }
        throw new PunycodeException(PunycodeException.BAD_INPUT);
    }

    public static final int codepoint2digit(int n) throws PunycodeException {
        if (n - 48 < 10) {
            return n - 48 + 26;
        }
        if (n - 97 < 26) {
            return n - 97;
        }
        throw new PunycodeException(PunycodeException.BAD_INPUT);
    }
}

