"create table if not exists ValidPaths (\n    id               integer primary key autoincrement not null,\n    path             text unique not null,\n    hash             text not null,\n    registrationTime integer not null,\n    deriver          text,\n    narSize          integer\n);\n\ncreate table if not exists Refs (\n    referrer  integer not null,\n    reference integer not null,\n    primary key (referrer, reference),\n    foreign key (referrer) references ValidPaths(id) on delete cascade,\n    foreign key (reference) references ValidPaths(id) on delete restrict\n);\n\ncreate index if not exists IndexReferrer on Refs(referrer);\ncreate index if not exists IndexReference on Refs(reference);\n\n-- Paths can refer to themselves, causing a tuple (N, N) in the Refs\n-- table.  This causes a deletion of the corresponding row in\n-- ValidPaths to cause a foreign key constraint violation (due to `on\n-- delete restrict' on the `reference' column).  Therefore, explicitly\n-- get rid of self-references.\ncreate trigger if not exists DeleteSelfRefs before delete on ValidPaths\n  begin\n    delete from Refs where referrer = old.id and reference = old.id;\n  end;\n\ncreate table if not exists DerivationOutputs (\n    drv  integer not null,\n    id   text not null, -- symbolic output id, usually \"out\"\n    path text not null,\n    primary key (drv, id),\n    foreign key (drv) references ValidPaths(id) on delete cascade\n);\n\ncreate index if not exists IndexDerivationOutputs on DerivationOutputs(path);\n\ncreate table if not exists FailedPaths (\n    path text primary key not null,\n    time integer not null\n);\n"