'\" t
.TH GROFF_MAN @MAN7EXT@ "@MDATE@" "groff @VERSION@"
.SH NAME
groff_man \- GNU roff macro package for formatting man pages
.
.
.\" Save and disable compatibility mode (for, e.g., Solaris 10/11).
.do nr groff_man_C \n[.C]
.cp 0
.
.
.\" ====================================================================
.\" Legal Terms
.\" ====================================================================
.\"
.\" Copyright (C) 1999-2018 Free Software Foundation, Inc.
.\"
.\" Permission is granted to make and distribute verbatim copies of this
.\" manual provided the copyright notice and this permission notice are
.\" preserved on all copies.
.\"
.\" Permission is granted to copy and distribute modified versions of
.\" this manual under the conditions for verbatim copying, provided that
.\" the entire resulting derived work is distributed under the terms of
.\" a permission notice identical to this one.
.\"
.\" Permission is granted to copy and distribute translations of this
.\" manual into another language, under the above conditions for
.\" modified versions, except that this permission notice may be
.\" included in translations approved by the Free Software Foundation
.\" instead of in the original English.
.
.
.\" ====================================================================
.SH SYNOPSIS
.\" ====================================================================
.
.SY "groff \-man"
.RI [ option
\&.\|.\|.\&]
.RI [ input-file
\&.\|.\|.\&]
.SY "groff \-m man"
.RI [ option
\&.\|.\|.\&]
.RI [ input-file
\&.\|.\|.\&]
.YS
.
.
.\" ====================================================================
.SH DESCRIPTION
.\" ====================================================================
.
The
.B man
macro package for
.I groff
is used to produce manual pages
.\" We use an unbreakable space \~ here to keep the phrase intact for
.\" its introduction; in subsequent discussion, that is not important.
(\(lqman\~pages\(rq)
like the one you are reading.
.
GNU
.IR roff 's
implementation was written by James Clark.
.
.
.PP
This document presents the macros thematically to aid learners;
for those needing only a quick reference,
the following table lists them alphabetically,
with cross-references to appropriate subsections below.
.
.
.PP
.TS
l l l.
Macro	Meaning	Subsection
.T&
lB l l.
_
\&.B	Boldface	Font face macros
\&.BI	Boldface, italic alternating	Font face macros
\&.BR	Boldface, roman alternating	Font face macros
\&.EE	Example end	Document structure macros
\&.EX	Example begin	Document structure macros
\&.I	Italic	Font face macros
\&.IB	Italic, boldface alternating	Font face macros
\&.IP	Indented paragraph	Paragraph macros
\&.IR	Italic, roman alternating	Font face macros
\&.LP	(Left) paragraph	Paragraph macros
\&.ME	Mail-to end	Hyperlink and email macros
\&.MT	Mail-to start	Hyperlink and email macros
\&.OP	(Command-line) option	Command synopsis macros
\&.P	Paragraph	Paragraph macros
\&.PP	Paragraph	Paragraph macros
\&.RB	Roman, boldface alternating	Font face macros
\&.RE	Relative-indent end	Document structure macros
\&.RI	Roman, italic alternating	Font face macros
\&.RS	Relative-indent start	Document structure macros
\&.SB	Small boldface	Font face macros
\&.SH	Section heading	Document structure macros
\&.SM	Small	Font face macros
\&.SS	Subection heading	Document structure macros
\&.SY	Synopsis start	Command synopsis macros
\&.TH	Title heading	Document structure macros
\&.TP	Tagged paragraph	Paragraph macros
\&.TQ	Tagged paragraph continuation	Paragraph macros
\&.UE	URL end	Hyperlink and email macros
\&.UR	URL start	Hyperlink and email macros
\&.YS	Synopsis end	Command synopsis macros
.TE
.
.
.PP
Macros whose use we discourage
.RB ( .AT ,
.BR .BT ,
.BR .DT ,
.BR .HP ,
.BR .PD ,
.BR .PT ,
and
.BR .UC )
are described in subsection \(lqDeprecated features\(rq, below.
.
.
.\" ====================================================================
.SS "Macro reference preliminaries"
.\" ====================================================================
.
Each macro is described in a tagged paragraph.
.
Closely related macros,
such as
.B .EX
and
.BR .EE ,
are grouped together.
.
.
.PP
Optional macro arguments are indicated by surrounding them with square
brackets.
.
If a macro accepts multiple arguments,
arguments containing whitespace must be double-quoted ("one two"),
to be interpreted correctly.
.
Most macro arguments are strings that will be output as text;
exceptions are noted.
.
.
.PP
Bear in mind that
.I groff
is fundamentally a programming language for typesetting.
.
Consequently,
the verb \(lqset\(rq is frequently used below in the sense of \(lqto
typeset\(rq.
.
.
.\" ====================================================================
.SS "Document structure macros"
.\" ====================================================================
.
The highest level of organization of a man page is determined by this
group of macros.
.
.B .TH
(title heading) identifies the document as a man page and defines
fundamental information enabling its indexing by
.BR mandb (8).
.
Sections
.RB ( .SH ),
one of which is mandatory and many of which are standardized,
facilitate quick location of relevant information by the reader and aid
the man page writer to comprehensively discuss all essential aspects of
the topic.
.
Subsections
.RB ( .SS )
are optional and permit sections that grow long to develop in a
controlled way.
.
Many technical discussions require examples;
lengthy ones,
especially those reflecting multiple lines of input to or output from
the system,
are usefully bracketed by
.B .EX
and
.BR .EE .
.
When none of the foregoing meets a structural demand,
a section of the discussion can be manually indented within
.B .RS
and
.B .RE
macros.
.
.
.TP
.BI .TH " title section \fR[\fPextra1\fR]\fP \fR[\fPextra2\fR]\fP \fR[\fPextra3\fR]"
Set the title of the man page to
.I title
and the section to
.IR section ,
which must take on a value between 1 and\~8.
.
The value
.I section
may also have a string appended, e.g.\& \[oq]pm\[cq], to indicate a
specific subsection of the man pages.
.
Both
.I title
and
.I section
are positioned at the left and right in the header line (with
.I section
in parentheses immediately appended to
.IR title .
.
.I extra1
is positioned in the middle of the footer line.
.
.I extra2
is positioned at the left in the footer line (or at the left on
even pages and at the right on odd pages if double-sided printing is
active).
.
.I extra3
is centered in the header line.
.
.
.IP
For HTML output, headers and footers are completely suppressed.
.
.
.IP
Additionally, this macro starts a new page; the new line number is\~1
again (except if the \[oq]\-rC1\[cq] option is given on the command
line).
.
This feature is intended only for formatting multiple man pages;
a single man page should contain exactly one
.B TH
macro at the beginning of the file.
.
.
.TP
.BI .SH " \fR[\fPtext for a heading\fR]\fP"
Set up an unnumbered section heading sticking out to the left.
.
Prints out all the text following
.B .SH
up to the end of the line (or the text in the next input line if there
is no argument to
.BR .SH )
in bold face
(or the font specified by the string
.BR HF ),
one size larger than the base document size.
.
Additionally, the left margin and the indentation for the following
text is reset to the default values.
.
.
.TP
.BI .SS " \fR[\fPtext for a heading\fR]\fP"
Set up a secondary, unnumbered section heading.
.
Prints out all the text following
.B .SS
up to the end of the line (or the text in the next input line if there
is no argument to
.BR .SS )
in bold face
(or the font specified by the string
.BR HF ),
at the same size as the base document size.
.
Additionally, the left margin and the indentation for the following
text is reset to the default values.
.
.
.TP
.B .EX
.TQ
.B .EE
Example/End Example.
.
After
.BR .EX ,
filling is disabled and the font is set to constant-width.
.
This is useful for formatting code, command, and configuration-file
examples.
.
The
.B EE
macro restores filling and restores the previous font.
.
.
.IP
These macros are defined on many (but not all) legacy Unix systems
running classic troff.
.
To be certain your page will be portable to those systems, copy
their definitions from the
.I \%an\-ext.tmac
file of a
.BR groff
installation.
.
.
.TP
.BI .RS " \fR[\fPnnn\fR]\fP"
This macro moves the left margin to the right by the value
.I nnn
if specified (default unit is \[oq]n\[cq]); otherwise it is set to the
previous indentation value specified with
.BR .TP ,
.BR .IP ,
or
.B .HP
(or to the default value if none of them have been used yet).
.
The indentation value is then set to the default.
.
.
.IP
Calls to the
.B RS
macro can be nested.
.
.
.TP
.BI .RE " \fR[\fPnnn\fR]\fP"
This macro moves the left margin back to level
.IR nnn ,
restoring the previous left margin.
.
If no argument is given, it moves one level back.
.
The first level (i.e., no call to
.B .RS
yet) has number\~1, and each call to
.B .RS
increases the level by\~1.
.
.
.\" ====================================================================
.SS "Paragraph macros"
.\" ====================================================================
.
A typical paragraph
.RB ( .PP )
is set at the current left margin.
.
In man pages and other technical literature,
definition lists are frequently encountered;
these can be set as \(lqtagged paragraphs\(rq
.RB ( .TP
and
.BR .TQ ),
which have one or more leading tags followed by a paragraph that has an
additional left indent.
.
The indented paragraph
.RB ( .IP )
macro is useful to continue the indented content of a narrative started
with
.BR .TP ,
or to present an itemized or ordered list.
.
.
.TP
.B .LP
.TQ
.B .PP
.TQ
.B .P
These macros are mutual aliases.
.
Any of them causes a line break at the current position, followed by a
vertical space downwards by the amount specified by the
.B PD
macro.
.
The font size and shape are reset to the default value (normally 10pt
Roman).
.
Finally, the current left margin and the indentation is reset to the
default values.
.
.
.TP
.BI .TP " \fR[\fPnnn\fR]\fP"
Set up an indented paragraph with label.
.
The indentation is set to
.I nnn
if that argument is supplied (the default unit is \[oq]n\[cq] if omitted),
otherwise it is set to the previous indentation value specified with
.BR .TP ,
.BR .IP ,
or
.B .HP
(or to the default value if none of them have been used yet).
.
.
.IP
The first input line of text following this macro is interpreted as a
string to be printed flush-left, as it is appropriate for a label.
.
It is not interpreted as part of a paragraph, so there is no attempt
to fill the first line with text from the following input lines.
.
Nevertheless, if the label is not as wide as the indentation the
paragraph starts at the same line (but indented), continuing on the
following lines.
.
If the label is wider than the indentation the descriptive part of the
paragraph begins on the line following the label, entirely indented.
.
Note that neither font shape nor font size of the label is set to a
default value; on the other hand, the rest of the text has default
font settings.
.
.
.IP
.B .TP
was used to write the first paragraph of this description of
.BR .TP ,
and
.B .IP
the subsequent ones.
.
.
.TP
.B .TQ
The
.B TQ
macro sets up header continuation for a
.B TP
macro.
.
With it, you can stack up any number of labels (such as in a
glossary, or list of commands) before beginning the indented
paragraph.
.
For an example, look up the documentation of the
.BR LP ,
.BR PP ,
and
.BR P
macros.
.
.
.IP
This macro is not defined on legacy Unix systems running classic
troff.
.
To be certain your page will be portable to those systems,
copy its definition from the
.I \%an\-ext.tmac
file of a
.BR groff
installation.
.
.
.TP
.BI .IP " \fR[\fPdesignator\fR]\fP \fR[\fPnnn\fR]\fP"
Set up an indented paragraph, using
.I designator
as a tag to mark its beginning.
.
The indentation is set to
.I nnn
if that argument is supplied (the default unit is \[oq]n\[cq] if
omitted), otherwise it is set to the previous indentation value
specified with
.BR .TP ,
.BR .IP ,
or
.B .HP
(or to the default value if none of them have been used yet).
.
Font size and face of the paragraph (but not the designator) are reset
to its default values.
.
.
.IP
To start an indented paragraph with a particular indentation but
without a designator, use \[oq]""\[cq] (two doublequotes) as the
first argument.
.
.
.IP
For example, the following paragraphs were all set up with bullets as
the designator, using \[oq].IP\ \e(bu\ 4\[cq].
.
The whole block has been enclosed with
.B .RS
and
.B .RE
to set the left margin temporarily to the current indentation value.
.
.
.RS
.IP \(bu 4
.B IP
is one of the three macros used in the
.B man
package to format lists.
.
.
.IP \(bu 4
.B HP
is another.
.
This macro produces a paragraph with a left hanging indentation.
.
.
.IP \(bu 4
.B TP
is another.
.
This macro produces an unindented label followed by an indented
paragraph.
.RE
.
.
.\" ====================================================================
.SS "Command synopsis macros"
.\" ====================================================================
.
The following macros are not defined on legacy Unix systems
running classic troff.
.
To be certain your page will be portable to those systems, copy their
definitions from the
.I \%an\-ext.tmac
file of a
.BR groff
installation.
.
.
.PP
These macros are a convenience for authors.
.
Together, they produce the traditional look of a Unix command synopsis.
.
They also assist automated translation tools and help browsers in
recognizing command synopses and treating them differently from
running text.
.
.
.TP
.BI .SY " command"
Begin synopsis.
.
Takes a single argument, the name of a command.
.
Text following, until closed by
.BR .YS ,
is set with a hanging indentation of the width of
.I command
plus a space.
.
Hyphenation is turned off.
.
.
.TP
.BI .OP " option-name"\/\c
.RI " [" option-argument ]
Indicate an optional command parameter called
.IR option-name .
.
If the option takes an argument, specify
.I option-argument
using a noun, abbreviation, or hyphenated noun phrase.
.
.
.TP
.B .YS
End synopsis.
.
Restores indentation and hyphenation to previous values.
.
.
.PP
For example,
.
.
.IP
.EX
\&.SY groff
\&.OP \e\-abcegiklpstzCEGNRSUVXZ
\&.OP \e\-d cs
\&.OP \e\-f fam
\&.OP \e\-F dir
\&.OP \e\-I dir
\&.OP \e\-K arg
\&.OP \e\-L arg
\&.OP \e\-m name
\&.OP \e\-M dir
\&.OP \e\-n num
\&.OP \e\-o list
\&.OP \e\-P arg
\&.OP \e\-r cn
\&.OP \e\-T dev
\&.OP \e\-w name
\&.OP \e\-W name
\&.RI [ file
\e&.\e|.\e|.\e&]
\&.YS
.EE
.
.
.PP
produces the following output.
.
.
.RS
.PP
.SY groff
.OP \-abcegiklpstzCEGNRSUVXZ
.OP \-d cs
.OP \-f fam
.OP \-F dir
.OP \-I dir
.OP \-K arg
.OP \-L arg
.OP \-m name
.OP \-M dir
.OP \-n num
.OP \-o list
.OP \-P arg
.OP \-r cn
.OP \-T dev
.OP \-w name
.OP \-W name
.RI [ file
\&.\|.\|.\&]
.YS
.RE
.
.
.PP
Multiple
.B .SY/.YS
blocks can be specified,
for instance to distinguish differing modes of operation of a complex
command like
.BR tar (1);
each will be separated by a paragraph space.
.
If necessary, you can use a
.B br
request to insert a mandatory line break.
.
.
.PP
Several features of the above example are of note.
.
.
.IP \(bu
The command and option names are presented in
.B boldface
to cue the user that they should be input literally.
.
.
.IP \(bu
Option dashes are specified with the \(lq\e\-\(rq escape sequence;
this is an important practice to make them clearly visible and to
facilitate cut-and-paste from the rendered man page to a shell prompt or
text file.
.
.
.IP \(bu
Option arguments and command operands are presented in
.I italics
(underlined on some output devices, such as terminals and emulators),
to cue the user that they must be replaced with appropriate text.
.
.
.IP \(bu
Symbols that are neither to be typed literally nor simply replaced
appear in plain (roman) style;
brackets surround optional arguments,
and an ellipsis indicates that the previous syntactical element may be
repeated arbitrarily.
.
.
.IP
Some man pages use a brace-and-pipe notation such as
.RB \(lq{ \-\-diff | \-\-compare }\(rq
to indicate that one and only one of the \(lq|\(rq-separated items
within the braces must be input.
.
If this braced construct is furthermore surrounded by square brackets,
it means that at most one of the items is accepted.
.
.
.IP
Authors of man pages should note the use of the zero-width space
escape sequence \(lq\e&\(rq on both sides of the ellipsis;
this is a good practice to avoid surprises in the event the ellipsis
gets reflowed in your text editor.
.
See \(lqPortability\(rq, below.
.
The morbidly curious may consult
.BR groff (7)
regarding the narrow-space escape sequence \(lq\e|\(rq.
.
.
.\" ====================================================================
.SS "Hyperlink and email macros"
.\" ====================================================================
.
The following macros are not defined on legacy Unix systems
running classic troff.
.
To be certain your page will be portable to those systems, copy
their definitions from the
.I \%an\-ext.tmac
file of a
.B groff
installation.
.
.
.PP
Using these macros helps ensure that you get hyperlinks when your
manual page is rendered in a browser or other program that is
Web-enabled.
.
.
.TP
.BI .MT " address"
.TQ
.BI .ME " \fR[\fPpunctuation\fR]\fP"
Wrap an email address.
.
The argument of
.B .MT
is the address; text following, until
.BR .ME ,
is a name to be associated with the address.
.
Any argument to the
.B ME
macro is pasted to the end of the link text.
.
On a device that is not a browser,
.
.
.RS
.IP
.EX
contact
\&.MT fred.foonly@\e:fubar.net
Fred Foonly
\&.ME
for more information
.EE
.RE
.
.
.IP
usually displays like this: \[lq]contact Fred Foonly
<fred.foonly@\:fubar.net> for more information\[rq].
.
.
.IP
The use of
.B \e:
to insert hyphenless breakpoints is a groff extension and can
be omitted.
.
.
.TP
.BI .UR " URL"
.TQ
.BI .UE " \fR[\fPpunctuation\fR]\fP"
Wrap a World Wide Web hyperlink.
.
The argument to
.B .UR
is the URL; thereafter, lines until
.B .UE
are collected and used as the link text.
.
Any argument to the
.B UE
macro is pasted to the end of the text.
.
On a device that is not a browser,
.
.
.RS
.IP
.EX
this is a link to
\&.UR http://\e:randomsite.org/\e:fubar
some random site
\&.UE ,
given as an example
.EE
.RE
.
.
.IP
usually displays like this: \[lq]this is a link to some random
site \[la]http://\:randomsite.org/\:fubar\[ra], given as an
example\[rq].
.
.
.IP
The use of
.B \e:
to insert hyphenless breakpoints is a groff extension and can be
omitted.
.
.
.\" ====================================================================
.SS "Font face macros"
.\" ====================================================================
.
The default font size and family (for
.I troff
output devices)
is 10-point Times.
.
The default face is roman.
.
.
.TP
.BI .B " \fR[\fPtext\fR]\fP"
Causes
.I text
to appear in bold face.
.
If no text is present on the line where the macro is called the text
of the next input line appears in bold face.
.
.
.TP
.BI .I " \fR[\fPtext\fR]\fP"
Causes
.I text
to appear in italic.
.
If no text is present on the line where the macro is called the text
of the next input line appears in italic.
.
.
.TP
.BI .SM " \fR[\fPtext\fR]\fP"
Causes the text on the same line or the text on the next input line to
appear in a font that is one point size smaller than the default font.
.
.
.TP
.BI .SB " \fR[\fPtext\fR]\fP"
Causes the text on the same line or the text on the next input line to
appear in boldface font, one point size smaller than the default font.
.
.
.TP
.BI ".BI " text
Causes text on the same line to appear alternately in bold face and
italic.
.
The text must be on the same line as the macro call.
.
Thus
.
.
.RS
.IP
\&.BI this "word and" that
.
.
.PP
would cause \[oq]this\[cq] and \[oq]that\[cq] to appear in bold face,
while \[oq]word and\[cq] appears in italics.
.RE
.
.
.TP
.BI ".BR " text
Causes text on the same line to appear alternately in bold face and
roman.
.
The text must be on the same line as the macro call.
.
.
.TP
.BI ".IB " text
Causes text to appear alternately in italic and bold face.
.
The text must be on the same line as the macro call.
.
.
.TP
.BI ".IR " text
Causes text on the same line to appear alternately in italic and
roman.
.
The text must be on the same line as the macro call.
.
.
.TP
.BI ".RB " text
Causes text on the same line to appear alternately in roman and bold
face.
.
The text must be on the same line as the macro call.
.
.
.TP
.BI ".RI " text
Causes text on the same line to appear alternately in roman and
italic.
.
The text must be on the same line as the macro call.
.
.
.\" ====================================================================
.SS "Horizontal and vertical spacing"
.\" ====================================================================
.
The
.I indent
argument accepted by
.BR .RS ,
.BR .IP ,
.BR .TP ,
and the deprecated
.B .HP
is a number plus an optional scaling indicator.
.
If no scaling indicator is given,
the
.I man
package assumes \(oqn\(cq;
that is,
the width of a letter \(lqn\(rq in the font current when the macro is
called.
.
See section \(lqNUMERICAL EXPRESSIONS\(rq in
.IR groff (7)
for further details.
.
An indent specified in a call to
.BR .IP ,
.BR .TP ,
or the deprecated
.B .HP
persists until
(1) another of these macros is called with an explicit indent
argument,
or (2)
.BR .SH ,
.BR .SS ,
or
.B .PP
or its synonyms is made;
these clear the indent entirely.
.
.
.PP
Indents set by
.B .RS
move the left margin and persist until
.BR .RS ,
.BR .RE ,
.BR .SH ,
or
.B .SS
is called.
.
.
The default indentation,
exhibited by ordinary
.B .PP
paragraphs not within an
.BR .RS / .RE
relative indent,
is 7.2n in
.I troff
mode and 7n in
.I nroff
mode,
except for
.BR grohtml ,
which ignores indentation.
.
This same indentation is used again (additively) for the defaults of
.BR .IP ,
.BR .TP ,
.BR .RS ,
and the deprecated
.BR HP .
.
Section headings
.RB ( .SH )
are set flush with the left margin of the output device,
and subsection headings
.RB ( .SS )
are indented 3n.
.
.
.PP
Resist the temptation to mock up tabular or multi-column output with
ASCII tab characters or the indentation arguments to
.BR .IP ,
.BR .TP ,
.BR .RS ,
or the deprecated
.BR .HP ;
the result may not render comprehensibly on an output device you fail to
check,
or which is developed in the future.
.
The table preprocessor
.BR tbl (1)
can likely meet your needs.
.
.
.PP
The following macros cause a line break with the
insertion of vertical space:
.BR SH ,
.BR SS ,
.BR TP ,
.BR TQ ,
.B LP
.RB ( PP ,
.BR P ),
.BR IP ,
and the deprecated
.BR HP .
.
(The deprecated macro
.B .PD
can change this vertical spacing,
but its use is discouraged.)
.
The macros
.BR RS ,
.BR RE ,
.BR EX ,
and
.B EE
also cause a break but no insertion of vertical space.
.
.
.\" ====================================================================
.SS "String registers"
.\" ====================================================================
.
The following strings are defined:
.
.
.TP
.B \e*R
The \[oq]registered\[cq] sign.
.
.
.TP
.B \e*S
Switch back to the default font size.
.
.
.TP
.B \e*(lq
.TQ
.B \e*(rq
Left and right quote.
.
This is equal to \[oq]\e(lq\[cq] and \[oq]\e(rq\[cq], respectively.
.
.
.TP
.B \e*(HF
The typeface used to print headings and subheadings.
.
The default is \[oq]B\[cq].
.
.
.TP
.B \e*(Tm
The \[oq]trademark\[cq] sign.
.
.
.\" ====================================================================
.SS "Interaction with preprocessors"
.\" ====================================================================
.
When a preprocessor like
.I @g@tbl
or
.I @g@eqn
is needed,
a hint can be given to the man page formatter by making the first line
of a man page look like this:
.
.
.PP
.RS
.BI \(aq\e"\  word
.RE
.
.
.PP
Note that the line starts with an apostrophe (\(aq),
not a dot,
and that a single space character follows the double quote.
The
.I word
consists of one letter for each needed preprocessor:
\[oq]e\[cq] for
.BR @g@eqn ,
\[oq]r\[cq] for
.BR @g@refer ,
and
\[oq]t\[cq] for
.BR @g@tbl .
.
Modern implementations of the
.I man
program interpret this first line and automatically call the right
preprocessor(s).
.
.
.PP
The usual
.I tbl
and
.I eqn
macros for table and equation inclusion,
.BR .TS ,
.BR .T& ,
.BR .TE ,
.BR .EQ ,
and
.BR .EN ,
may be used freely.
.
Note that
.I nroff
output devices are extremely limited in presentation of mathematical
equations.
.
.
.\" ====================================================================
.SS Portability
.\" ====================================================================
.
Since the
.B man
macros consist of groups of
.I groff
requests, one can, in principle, supplement the functionality of the
.B man
macros with individual
.I groff
requests where necessary.
.
See the
.I groff
info pages for a complete reference of all requests.
.
.
.PP
Note, however, that using raw troff requests is likely to make your
page render poorly on the class of viewers that transform it to HTML.
.
Troff requests make implicit assumptions about things like character
and page sizes that may break in an HTML environment; also, many of
these viewers don't interpret the full troff vocabulary, a problem
that can lead to portions of your text being silently dropped.
.
.
.PP
For portability to modern viewers, it is best to write your page
entirely in the requests described on this page.
.
Further, it is best to completely avoid those we have described as
\[oq]presentation-level\[cq]
.RB ( .HP ,
.BR .PD ,
and
.BR .DT )
in \(lqDeprecated features\(rq, below.
.
.
.PP
The macros we have described as extensions
.RB ( .EX / .EE ,
.BR .SY / .OP / .YS ,
.BR .UR / .UE ,
and
.BR .MT / .ME )
should be used with caution, as they may not yet be built in to
some viewer that is important to your audience.
.
If in doubt, copy the implementation onto your page.
.
.
.PP
In a way similar to using
.I groff
requests, it is possible to use the facilities documented in the
ESCAPE SEQUENCES section of the
.BR groff (7)
manual page and in the
.BR groff_char (7)
manual page.
.
Regarding portability, similar caveats apply as with respect to
.I groff
requests.
.
Some escape sequences are however required for correct typesetting
even in manual pages and usually do not cause portability problems:
.
.TP
.RB \(dq \e\  \(dq
Unpaddable non-breaking space character.
.
(The double-quotes are to make the presence of the space character
clear in this document, and are not necessary in the input file.)
.
Useful for preventing breaking between a numerical quantity and its
corresponding unit(s), for instance:
.
.RS
.IP
.EX
There are 2.54\e\ cm in an inch, and 1,024\e\ bytes in 1\e\ kiB.
.EE
.RE
.
.TP
.B \e&
Zero-width space.
.
Append to an input line to prevent an end-of-sentence punctuation
sequence from being recognized as such, or insert at the beginning of an
input line to prevent a dot or apostrophe from being interpreted as the
beginning of a
.I roff
request.
.
.TP
.B \e(aq
ASCII apostrophe.
.
Useful for syntax elements of programming languages because some
output devices might replace unescaped apostrophes with right single
quotation marks.
.
.TP
.B \e(oq
Opening single quotation mark.
.
.TQ
.B \e(cq
Closing single quotation mark.
.
.IP
Use these for paired directional single quotes, \(oqlike this\(cq.
.
.TP
.B \e(dq
ASCII double-quote.
.
Sometimes needed on macro lines to prevent the interpretation of the
ASCII quotation mark character \(oq\(dq\(cq as the beginning or end
of a macro argument.
.
.TP
.B \e(lq
Left double quotation mark.
.
.TQ
.B \e(rq
Right double quotation mark.
.
.IP
Use these for paired directional double quotes, \(lqlike this\(rq.
.
.TP
.B \e(em
Em-dash.
.
Used as a punctuation mark for an interruption in a sentence\(emlike
in this one.
.
.TP
.B \e(en
En-dash.
.
Used to separate the two ends of a range, in particular between
numbers, for example: the digits 1\(en9.
.
.TP
.B \e(ga
ASCII grave accent.
.
Useful for syntax elements of programming languages, for example
shell command substitutions, because some output devices might
replace unescaped grave accents with left single quotation marks.
.
.TP
.B \e(ha
ASCII circumflex accent.
.
Useful for syntax elements of programming languages because some
output devices might replace unescaped circumflex accents with
non-ASCII glyphs like the Unicode U+02C6 modifier letter circumflex.
.
.TP
.B \e(ti
ASCII tilde.
.
Useful for syntax elements of programming languages because some
output devices might replace unescaped tildes with non-ASCII glyphs
like the Unicode U+02DC small tilde.
.
.TP
.B \e-
Minus sign.
.
Also use this to display syntax elements that require the ASCII
hyphen-minus character, for example command-line options and C
language operators.
.
The unescaped \(oq\-\(cq input character is not appropriate for
these cases because it may render as a hyphen on some output devices.
.
.TP
.B \ec
.
If this escape sequence occurs at the end of an input line, no white
space is inserted between the last glyph on it and the first glyph
resulting from the next input line.
.
This is occasionally useful when three different fonts are needed
in a single word, for example:
.
.RS
.IP
.EX
\&.BR "dd if" =\ec
\&.I file
.EE
.RE
.
.IP
Note that when using this trick with the
.B .BI
or
.B .RI
macros, you will need to manually add an italic correction escape
.B \e/
before the
.B \ec
due to way macros expand their arguments.
.
.
.RS
.IP
.EX
Files processed with
\&.B groff \e\-mom
(or
\&.BI "\e\-m " mom\e/\ec
) produce PostScript output by default.
.EE
.RE
.
.
.IP
Alternatively, and perhaps with better portability, the
.B \ef
font escape sequence can be used; see below.
.
Attempting to use
.B \ec
to include the output from more than one macro line into the next-line
argument of a
.B .TP
macro will misrender with
.I groff
1.22.3,
.I mandoc
1.14.1,
older versions of these programs,
and perhaps with some other formatters.
.
.TP
.B \ee
Widely used in manual pages to represent a backslash output glyph.
.
It works reliably as long as the
.B .ec
request is not used, which should never happen in manual pages, and
it is slightly more portable than the more exact
.B \e(rs
(\[lq]reverse solidus\[rq])
escape sequence.
.
.TP
.BR \efB ,\  \efI ,\  \efR ,\  \efP
Switch to bold, italic, roman, or back to the previous font,
respectively.
.
This is needed when three different fonts are required on a single
input line, for example:
.
.RS
.IP
.EX
\&.TP
\efBif\efP=\efIfile\efP
.EE
.RE
.
.IP
It can also be used if three different fonts are needed in a
single word.
It may be more portable than
.BR \ec .
.
It is up to you to account for italic corrections with
.B \e/
and
.BR \e, ,
which are themselves
.I groff
extensions,
if desired and if supported by your implementation.
.
.
.IP
As long as at most two fonts are needed in any one whitespace-delimited
word,
using font alternation macros like
.B .BR
usually results in more readable source code.
.
.
.PP
For maximum portability, escape sequences and special characters
not listed above are better avoided in manual pages.
.
.
.\" ====================================================================
.SS "Deprecated features"
.\" ====================================================================
.
Use of the following is discouraged.
.
.
.TP
.BI .AT " \fR[\fPsystem \fR[\fPrelease\fR]]\fP"
Alter the footer for use with AT&T man pages.
.
This macro exists only for compatibility; don't use it.
.
See the
.I groff
info manual for more.
.
.
.TP
.B .BT
Print the footer string.
.
Redefine this macro to get control of the footer.
.
.
.TP
.B .DT
Set tabs every 0.5\~inches.
.
Since this macro is always called during a
.B TH
macro, it makes sense to call it only if the tab positions have been
changed.
.
.
.IP
Use of this presentation-level macro is deprecated.
.
It translates poorly to HTML, under which exact whitespace control
and tabbing are not readily available.
.
Thus, information or distinctions that you use
.B .DT
to express are likely to be lost.
.
If you feel tempted to use it, you should probably be composing a
table using
.BR @g@tbl (@MAN1EXT@)
markup instead.
.
.
.TP
.BI .HP " \fR[\fPnnn\fR]\fP"
Set up a paragraph with hanging left indentation.
.
The indentation is set to
.I nnn
if that argument is supplied (the default unit is \[oq]n\[cq] if
omitted), otherwise it is set to the previous indentation value
specified with
.BR .TP ,
.BR .IP ,
or
.B .HP
(or to the default value if none of them have been used yet).
.
Font size and face are reset to its default values.
.
The following paragraph illustrates the effect of this macro with
hanging indentation set to\~4 (enclosed by
.B .RS
and
.B .RE
to set the left margin temporarily to the current indentation):
.
.
.RS
.HP 4
This is a paragraph following an invocation of the
.B HP
macro.
.
As you can see, it produces a paragraph where all lines but the first
are indented.
.RE
.
.
.IP
Use of this presentation-level macro is deprecated.
.
While it is universally portable to legacy Unix systems, a hanging
indentation cannot be expressed naturally under HTML, and many
HTML-based manual viewers simply interpret it as a starter for a
normal paragraph.
.
Thus, any information or distinction you tried to express with the
indentation may be lost.
.
.
.TP
.BI .PD " \fR[\fPnnn\fR]\fP"
Adjust the empty space before a new paragraph or section.
.
The optional argument gives the amount of space (default unit is
\[oq]v\[cq]); without parameter, the value is reset to its default
value (1\~line in nroff mode, 0.4v\~otherwise).
.
This affects the macros
.BR SH ,
.BR SS ,
.BR TP ,
.B LP
(resp.\&
.B PP
and
.BR P ),
.BR IP ,
and
.BR HP .
.
.
.IP
Use of this presentation-level macro is deprecated.
.
It translates poorly to HTML, under which exact control of
inter-paragraph spacing is not readily available.
.
Thus, information or distinctions that you use
.B .PD
to express are likely to be lost.
.
.
.TP
.B .PT
Print the header string.
.
Redefine this macro to get control of the header.
.
.
.TP
.BI .UC " \fR[\fPversion\fR]\fP"
Alter the footer for use with BSD man pages.
.
This macro exists only for compatibility; don't use it.
.
See the
.I groff
info manual for more.
.
.
.
.
.\" ====================================================================
.SH OPTIONS
.\" ====================================================================
.
The
.B man
macros understand the following command-line options (which define
various registers).
.
.
.TP
.B \-rcR=1
This option (the default if in nroff mode) creates a single, very
long page instead of multiple pages.
.
Say
.B \-rcR=0
to disable it.
.
.
.TP
.B \-rC1
If more than one manual page is given on the command line, number the
pages continuously, rather than starting each at\~1.
.
.
.TP
.B \-rD1
Double-sided printing.
.
Footers for even and odd pages are formatted differently.
.
.
.TP
.BI \-rFT= dist
Set distance of the footer relative to the bottom of the page if
negative or relative to the top if positive.
.
The default is \-0.5i.
.
.
.TP
.BI \-rHY= flags
Set hyphenation flags.
.
Possible values are 1\~to not hyphenate the first and last character
of a word, 2\~to not hyphenate the last word on a page, 4\~to not
hyphenate the last two characters of a word, 8\~to not hyphenate the
first two characters of a word, 16\~to enable hyphenation before the
last character of a word, and 32 to enable hyphenation after the
first character of a word.
.
These values are additive; the default is\~6.
.
Values 4 and\~16 can't be used together since they contradict each
other;
the same holds for values 8 and\~32.
.
.
.TP
.BI \-rIN= width
Set body text indentation to
.IR width .
.
The default is 7n for
.IR nroff ,
7.2n for
.IR troff .
.
For
.IR nroff ,
this value should always be an integer multiple of unit \[oq]n\[cq] to
get consistent indentation.
.
.
.TP
.BI \-rLL= line-length
Set line length.
.
If this option is not given, the line length is set to respect any
value set by a prior \[oq].ll\[cq] request (which
.I must
be in effect when the \[oq].TH\[cq] macro is invoked),
if this differs from the built\-in default for the formatter;
otherwise it defaults to 78n in
.I nroff
mode and 6.5i in
.I troff
mode.
.
.
.IP
Note that the use of a \[oq].ll\[cq] request to initialize the line
length is supported for backward compatibility with some versions of
the
.B man
program;
direct initialization of the \[oq]LL\[cq] register should
.I always
be preferred to the use of such a request.
.
In particular, note that a \[oq].ll\ 65n\[cq] request does
.I not
preserve the normal
.I nroff
default line length,
(the
.B man
default initialization to 78n prevails), whereas, the
\[oq]\-rLL=65n\[cq] option, or an equivalent \[oq].nr\ LL\ 65n\[cq]
request preceding the use of the \[oq]TH\[cq] macro,
.I does
set a line length of 65n.
.
.
.TP
.BI \-rLT= title-length
Set title length.
.
If this option is not given, the title length defaults to the line
length.
.
.
.TP
.BI \-rP nnn
Enumeration of pages start with
.I nnn
rather than with\~1.
.
.
.TP
.BI \-rS xx
Base document font size is
.I xx
points
.RI ( xx
can be 10, 11, or\~12) rather than 10\~points.
.
.
.TP
.BI \-rSN= width
Set sub-subheading indentation to
.IR width .
The default is 3n.
.
.
.TP
.BI \-rX nnn
After page\~\c
.IR nnn ,
number pages as
.IR nnn a,
.IR nnn b,
.IR nnn c,
etc.
.
For example, the option \[oq]\-rX2\[cq] produces the following page
numbers: 1, 2, 2a, 2b, 2c, etc.
.
.
.\" ====================================================================
.SH FILES
.\" ====================================================================
.
.TP
.I @MACRODIR@/\:man.tmac
.TQ
.I @MACRODIR@/\:an.tmac
These are wrapper files to call
.IR andoc.tmac .
.
.
.TP
.I @MACRODIR@/\:andoc.tmac
This brief
.I groff
program detects whether the
.I man
or
.I mdoc
macro package is being used by a document and loads the correct macro
definitions,
taking advantage of the fact that pages using them must call
.B .TH
or
.BR .Dd ,
respectively,
as their first macro.
.
Because the wrappers above load this file,
a
.I man
program or user typing,
for example,
\(lqgroff \-man page.1\(rq,
need not know which package the file
.I page.1
uses.
.
Multiple man pages, in either format, can be handled.
.
.
.TP
.I @MACRODIR@/\:an\-old.tmac
Most
.I man
macros are contained in this file.
.
It also loads the GNU extensions from
.I an\-ext.tmac
(see below).
.
.
.TP
.I @MACRODIR@/\:an\-ext.tmac
The extension macro definitions for
.BR .SY ,
.BR .OP ,
.BR .YS ,
.BR .TQ ,
.BR .EX / .EE ,
.BR .UR / .UE ,
and
.BR .MT / .ME
are contained in this file,
which is written in classic
.I troff
and permissively licensed\(emnot copylefted.
.
Man page authors concerned about portability to legacy Unix systems are
encouraged to copy these definitions into their pages,
and maintainers of
.I troff
implementations or work-alike systems that format man pages are
encouraged to re-use them.
.
.
.IP
Note that the definitions for these macros are read after the call of
.BR .TH ,
so they will replace any macros of the same names preceding it in your
file.
.
If you use your own implementations of these macros,
they must be defined after calling
.B .TH
to have any effect.
.
.
.TP
.I @LOCALMACRODIR@/\:man.local
Local changes and customizations should be put into this file.
.
.
.\" ====================================================================
.SH NOTES
.\" ====================================================================
.
Some tips on troubleshooting your man pages follow.
.
.
.TP
.RB \(bu " .RS" " doesn't indent relative to my indented paragraph"
The
.B .RS
macro sets the indentation relative to the amount of a
.I normal
paragraph
.RB ( .PP
and its synonyms).
.
The same default indentation amount is used for
.BR .RS ,
.BR .IP ,
.BR .TP ,
and the deprecated
.BR .HP .
.
If you need to start an indent relative to an indented paragraph,
give
.B .RS
an indentation argument that is at least as much as the paragraph's
indentation amount relative to an adjacent
.B .PP
paragraph.
.
See \(lqHorizontal and vertical spacing\(rq above for the values.
.
.
.TP
.RB \(bu " .RE" " doesn't reset the indent to the expected level"
.TQ
\(bu warning: scale indicator invalid in this context
.TQ
\(bu warning: number register \(aqan\-saved\-margin\c
.IR n "\(aq not defined"
.TQ
\(bu warning: number register 'an\-saved\-prevailing\-indent\c
.IR n "\(aq not defined"
The
.B .RS
macro takes an indentation
.I amount
as an argument;
the
.B .RE
macro's argument is a specific indentation
.IR level .
.B .RE\~1
goes to the level before any
.B .RS
macros were called,
.B .RE\~2
goes to the level of the first
.B RS
call you made,
and so forth.
.
If you desire symmetry in your macro calls,
simply issue one
.B .RE
without an argument
for each
.B .RS
that precedes it.
.
.
.IP
After calls to the
.B .SH
and
.B SS
sectioning macros,
all relative indents are cleared and calls to
.B .RE
have no effect.
.
.
.\" ====================================================================
.SH AUTHORS
.\" ====================================================================
The GNU version of the
.I man
macro package was written by James Clark and contributors.
.
The extension macros were written by
.MT wl@\:gnu.org
Werner Lemberg
.ME
and
.MT esr@\:thyrsus.com
Eric S.\& Raymond
.ME .
.
.
.PP
This document was originally written for the Debian GNU/Linux system by
.MT sgk@\:debian.org
Susan G.\& Kleinmann
.ME .
.
It was corrected and updated by Werner Lemberg.
.
The extension macros were documented by Eric S.\& Raymond;
he also originated the portability advice.
.
.
.\" ====================================================================
.SH "SEE ALSO"
.\" ====================================================================
.BR @g@tbl (@MAN1EXT@),
.BR @g@eqn (@MAN1EXT@),
.BR @g@refer (@MAN1EXT@),
.BR man (1),
.BR man (7),
.BR groff_mdoc (7)
.
.
.\" Restore compatibility mode (for, e.g., Solaris 10/11).
.cp \n[groff_man_C]
.
.
.\" ====================================================================
.\" ### Emacs settings:
.\" Local Variables:
.\" mode: nroff
.\" End:
.\" vim: set filetype=groff:
