.TH @G@LOOKBIB @MAN1EXT@ "@MDATE@" "groff @VERSION@"
.SH NAME
@g@lookbib \- search bibliographic databases
.
.
.\" ====================================================================
.\" Legal Terms
.\" ====================================================================
.\"
.\" Copyright (C) 1989-2018 Free Software Foundation, Inc.
.\"
.\" Permission is granted to make and distribute verbatim copies of this
.\" manual provided the copyright notice and this permission notice are
.\" preserved on all copies.
.\"
.\" Permission is granted to copy and distribute modified versions of
.\" this manual under the conditions for verbatim copying, provided that
.\" the entire resulting derived work is distributed under the terms of
.\" a permission notice identical to this one.
.\"
.\" Permission is granted to copy and distribute translations of this
.\" manual into another language, under the above conditions for
.\" modified versions, except that this permission notice may be
.\" included in translations approved by the Free Software Foundation
.\" instead of in the original English.
.
.
.\" ====================================================================
.SH SYNOPSIS
.\" ====================================================================
.
.SY @g@lookbib
.OP \-i string
.OP \-t n
.I filename
\&.\|.\|.\&
.YS
.
.SY @g@lookbib
.B \-\-help
.YS
.
.SY @g@lookbib
.B \-v
.SY @g@lookbib
.B \-\-version
.YS
.
.
.\" ====================================================================
.SH DESCRIPTION
.\" ====================================================================
.
.B @g@lookbib
prints a prompt on the standard error (unless the standard input is not
a terminal),
reads from the standard input a line containing a set of keywords,
searches the bibliographic databases
.IR filename \|.\|.\|.\&
for references containing those keywords,
prints any references found on the standard output,
and repeats this process until the end of input.
.
For each database
.I filename
to be searched,
if an index
.IB filename @INDEX_SUFFIX@
created by
.BR @g@indxbib (@MAN1EXT@)
exists, then it will be searched instead;
each index can cover multiple databases.
.
.
.\" ====================================================================
.SH OPTIONS
.\" ====================================================================
.
It is possible to have whitespace between a command-line option and its
parameter.
.
.TP
.B \-v
Print the version number.
.
.TP
.BI \-i string
When searching files for which no index exists,
ignore the contents of fields whose names are in
.IR string .
.
.TP
.BI \-t n
Only require the first
.I n
characters of keys to be given.
Initially
.I n
is\~6.
.
.
.\" ====================================================================
.SH FILES
.\" ====================================================================
.
.TP
.IB filename @INDEX_SUFFIX@
Index files.
.
.
.\" ====================================================================
.SH "SEE ALSO"
.\" ====================================================================
.BR @g@refer (@MAN1EXT@),
.BR lkbib (@MAN1EXT@),
.BR @g@indxbib (@MAN1EXT@)
.
.
.\" Local Variables:
.\" mode: nroff
.\" End:
.\" vim: set filetype=groff:
