.TH XTOTROFF @MAN1EXT@ "@MDATE@" "Groff Version @VERSION@"
.SH NAME
xtotroff \- convert X font metrics into GNU troff font metrics
.
.
.\" ====================================================================
.\" Legal Terms
.\" ====================================================================
.\"
.\" Copyright (C) 2004-2014 Free Software Foundation, Inc.
.\"
.\" Permission is granted to make and distribute verbatim copies of this
.\" manual provided the copyright notice and this permission notice are
.\" preserved on all copies.
.\"
.\" Permission is granted to copy and distribute modified versions of
.\" this manual under the conditions for verbatim copying, provided that
.\" the entire resulting derived work is distributed under the terms of
.\" a permission notice identical to this one.
.\"
.\" Permission is granted to copy and distribute translations of this
.\" manual into another language, under the above conditions for
.\" modified versions, except that this permission notice may be
.\" included in translations approved by the Free Software Foundation
.\" instead of in the original English.
.
.
.\" ====================================================================
.SH SYNOPSIS
.\" ====================================================================
.
.B xtotroff
[
.BI \-r \%resolution
]
[
.BI \-s \%point-size
]
[
.B \-v
]
.I FontMap
.
.
.\" ====================================================================
.SH DESCRIPTION
.\" ====================================================================
.
.B xtotroff
takes a
.IR FontMap ,
which maps
.B groff
fonts to X11 fonts,
creates GNU
.B troff
metric files for all fonts listed.
.
Each line in
.I FontMap
consists of GNU
.B troff
font name and an X font name (XLFD) pattern, separated by whitespace.
.
Example:
.
.PP
.in +2n
.nf
TB   -adobe-times-bold-r-normal--*-*-*-*-p-*-iso8859-1
.fi
.in
.
.
.PP
The wildcards in the patterns are filled with the arguments to the
.B \-r
and
.B \-s
switches.
.
If a font name is still ambiguous,
.B xtotroff
aborts.
.
.
.\" ====================================================================
.SH OPTIONS
.\" ====================================================================
.
It is possible to have whitespace between a command-line option and its
parameter.
.
.TP
.BI \-r resolution
Set the resolution for all font patterns in
.IR FontMap .
.
The value is used for both the horizontal and vertical resolution.
.
If not specified, a resolution of 75dpi is assumed.
.
.TP
.BI \-s point-size
Set the point size for all font patterns in
.IR FontMap .
.
If not specified, a size of 10pt is assumed.
.
.TP
.B \-v
Print the version number.
.
.
.\" ====================================================================
.SH BUGS
.\" ====================================================================
The only supported font encodings are \(oqiso8859-1\(cq and
\(cqadobe-fontspecific\(cq.
.
.
.\" ====================================================================
.SH "SEE ALSO"
.\" ====================================================================
.BR gxditview (@MAN1EXT@)
.
.
.\" Local Variables:
.\" mode: nroff
.\" End:
.\" vim: set filetype=groff:
