'\" e
.TH LJ4_FONT @MAN5EXT@ "@MDATE@" "Groff Version @VERSION@"
.SH NAME
lj4_font \- groff fonts for use with devlj4
.
.
.\" ====================================================================
.\" Legal Terms
.\" ====================================================================
.\"
.\" Copyright (C) 2004-2014 Free Software Foundation, Inc.
.\"
.\" Permission is granted to make and distribute verbatim copies of this
.\" manual provided the copyright notice and this permission notice are
.\" preserved on all copies.
.\"
.\" Permission is granted to copy and distribute modified versions of
.\" this manual under the conditions for verbatim copying, provided that
.\" the entire resulting derived work is distributed under the terms of
.\" a permission notice identical to this one.
.\"
.\" Permission is granted to copy and distribute translations of this
.\" manual into another language, under the above conditions for
.\" modified versions, except that this permission notice may be
.\" included in translations approved by the Free Software Foundation
.\" instead of in the original English.
.
.
.\" ====================================================================
.SH DESCRIPTION
.\" ====================================================================
.
Nominally,
all Hewlett-Packard LaserJet\~\%4-series and newer printers have the
same internal fonts:
45 scalable fonts and one bitmapped Lineprinter font.
.
The scalable fonts are available in sizes between 0.25 points and 999.75
points,
in 0.25-point increments;
the Lineprinter font is available only in 8.5-point size.
.
.
.LP
The LaserJet font files included with
.B groff
assume that all printers since the LaserJet\~4 are identical.
.
There are some differences between fonts in the earlier and more recent
printers,
however.
.
The LaserJet\~4 printer used Agfa Intellifont technology for 35 of the
internal scalable fonts;
the remaining 10 scalable fonts were TrueType.
.
Beginning with the LaserJet\~\%4000-series printers introduced in 1997,
all scalable internal fonts have been TrueType.
.
The number of printable glyphs differs slightly between Intellifont and
TrueType fonts
(generally,
the TrueType fonts include more glyphs),
and
there are some minor differences in glyph metrics.
.
Differences among printer models are described in the
.I "PCL\~5 Comparison Guide"
and the
.I "PCL\~5 Comparison Guide Addendum"
(for printers introduced since approximately 2001).
.
.
.LP
LaserJet printers reference a glyph by a combination of a 256-glyph
symbol set and an index within that symbol set.
.
Many glyphs appear in more than one symbol set;
all combinations of symbol set and index that reference the same glyph
are equivalent.
.
For each glyph,
.BR hpftodit (@MAN1EXT@)
searches a list of symbol sets,
and selects the first set that contains the glyph.
.
The printing code generated by
.BR hpftodit (@MAN1EXT@)
is an integer that encodes a numerical value for the symbol set in the
high byte(s),
and the index in the low byte.
.
See
.BR groff_font (@MAN5EXT@)
for a complete description of the font file format;
symbol sets are described in greater detail in the
.IR "PCL\~5 Printer Language Technical Reference Manual" .
.
.
.LP
Two of the scalable fonts,
Symbol and Wingdings,
are bound to 256-glyph symbol sets;
the remaining scalable fonts,
as well as the Lineprinter font,
support numerous symbol sets,
sufficient to enable printing of more than 600 glyphs.
.
.
.LP
The metrics generated by
.BR hpftodit (@MAN1EXT@)
assume that the DESC file contains values of 1200 for
.I res
and 6350 for
.IR unitwidth ,
or any combination
(e.g.,
2400 and 3175)
for which
.EQ
res\~\[mu]\~unitwidth = 7\|620\|000.
.EN
.
Although HP PCL\~5 LaserJet printers support an internal resolution of
7200 units per inch,
they use a 16-bit signed integer for cursor positioning;
if
.B devlj4
is to support U.S.\& ledger paper (11\~in\~\[mu]\~17\~in;
in = inch),
the maximum usable resolution is 32\|767\~\[di]\~17,
or 1927 units per inch,
which rounds down to 1200 units per inch.
.
If the largest required paper size is less
(e.g.,
8.5\~in\~\[mu]\~11\~in,
or A5),
a greater
.I res
(and lesser
.IR unitwidth )
can be specified.
.
.
.\" ====================================================================
.SH LIMITATIONS
.\" ====================================================================
.
Font metrics for Intellifont fonts were provided by Tagged Font Metric
(TFM) files originally developed by Agfa/Compugraphic.
.
The TFM files provided for these fonts supported 600+ glyphs and
contained extensive lists of kerning pairs.
.
.
.LP
To accommodate developers who had become accustomed to TFM files,
HP also provided TFM files for the 10 TrueType fonts included in the
LaserJet\~4.
.
The TFM files for TrueType fonts generally included less information
than the Intellifont TFMs,
supporting fewer glyphs,
and in most cases,
providing no kerning information.
.
By the time the LaserJet\~4000 printer was introduced,
most developers had migrated to other means of obtaining font metrics,
and support for new TFM files was very limited.
.
The TFM files provided for the TrueType fonts in the LaserJet\~4000
support only the Latin 2 (ISO 8859-2) symbol set,
and include no kerning information;
consequently,
they are of little value for any but the most rudimentary documents.
.
.
.LP
Because the Intellifont TFM files contain considerably more information,
they generally are preferable to the TrueType TFM files even for use
with the TrueType fonts in the newer printers.
.
The metrics for the TrueType fonts are very close,
though not identical,
to those for the earlier Intellifont fonts of the same names.
.
Although most output using the Intellifont metrics with the newer
printers is quite acceptable,
a few glyphs may fail to print as expected.
.
The differences in glyph metrics may be particularly noticeable with
composite parentheses,
brackets,
and braces used by
.BR eqn (@MAN1EXT@) .
.
A script,
located in
.IR @FONTDIR@/\:devlj4/\:generate ,
can be used to adjust the metrics for these glyphs in the special font
\[lq]S\[rq] for use with printers that have all TrueType fonts.
.
.
.LP
At the time HP last supported TFM files,
only version 1.0 of the Unicode standard was available.
.
Consequently,
many glyphs lacking assigned code points were assigned by HP to the
Private Use Area (PUA).
.
Later versions of the Unicode standard included code points outside the
PUA for many of these glyphs.
.
The HP-supplied TrueType TFM files use the PUA assignments;
TFM files generated from more recent TrueType font files require the
later Unicode values to access the same glyphs.
.
Consequently,
two different mapping files may be required:
one for the HP-supplied TFM files,
and one for more recent TFM files.
.
.
.\" ====================================================================
.SH FILES
.\" ====================================================================
.
.TP
.I @FONTDIR@/\:devlj4/\:DESC
device description file
.
.
.TP
.IR @FONTDIR@/\:devlj4/\: F
font description file for font
.I F
.
.
.TP
.I @FONTDIR@/\:devlj4/\:generate
corrects Intellifont-based height metrics for several glyphs in the
special font for TrueType CG Times (LaserJet\~4000 and later).
.
.
.\" ====================================================================
.SH "SEE ALSO"
.\" ====================================================================
.
.BR groff (@MAN1EXT@),
.BR hpftodit (@MAN1EXT@),
.BR grolj4 (@MAN1EXT@),
.BR groff_font (@MAN5EXT@)
.
.
.\" ====================================================================
.\" Editor settings
.\" ====================================================================
.
.\" Local Variables:
.\" mode: nroff
.\" fill-column: 72
.\" End:
.\" vim: set filetype=groff textwidth=72:
