.TH roff2@ROFF2MODE@ @MAN1EXT@ "@MDATE@" "Groff Version @VERSION@"
.SH NAME
roff2@ROFF2MODE@ \- transform roff code into @ROFF2MODE@ mode
.
.\" roff2@ROFF2MODE@.1 - man page for roff2@ROFF2MODE@ (section 1).
.
.\" Source file position: <groff_source_top>/contrib/groffer/roff2.man
.\" Installed position:   $prefix/share/man/man1/roff2@ROFF2MODE@.1
.
.
.\" ====================================================================
.\" Legalese
.\" ====================================================================
.\"
.\" Copyright (C) 2006-2014 Free Software Foundation, Inc.
.\"
.\" This file is part of groffer, which is part of GNU groff, a free
.\" software project.
.\"
.\" You can redistribute it and/or modify it under the terms of the GNU
.\" General Public License version 2 (GPL2) as published by the Free
.\" Software Foundation.
.\"
.\" The license text is available in the internet at
.\" <http://www.gnu.org/licenses/gpl-2.0.html>.
.
.
.\" ====================================================================
.\" Characters
.\" ====================================================================
.
.\" Ellipsis ...
.ie t .ds EL \fS\N'188'\fP\"
.el .ds EL \&.\|.\|.\&\"
.\" called with \*(EL
.
.
.\" ====================================================================
.SH "SYNOPSIS"
.\" ====================================================================
.
.SY roff2@ROFF2MODE@
.OP \& "\%groffer_option \*(EL"
.OP \-\-
.OP \& "\%filespec \*(EL"
.YS
.
.SY roff2@ROFF2MODE@
.BR \-h | \-\-help
.YS
.
.SY roff2@ROFF2MODE@
.BR \-v | \-\-version
.YS
.
.P
The options
.B \-v
and
.B \%\-\-version
print the version information of the program to standard output and exit.
.
The options
.B \-h
and
.B \-\-help
print a usage information of the program to standard output and stop
the program instantly.
.
.
.P
All other options are assumed to be
.B \%groffer
options.
.
They are internally passed to
.BR \%groffer .
They override the behavior of the program.
.
The options are optional, they can be omitted.
.
.
.P
The
.I \%filespec
arguments correspond to the
.I \%filespec
arguments of
.BR \%groffer .
So they are either the names of existing, readable files or
.B \-
for standard input, or the name of a man page or a
.BR \%groffer (@MAN1EXT@)
man page search pattern.
.
If no
.I \%filespec
is specified standard input is assumed automatically.
.
.
.\" ====================================================================
.SH DESCRIPTION
.
.B \%roff2@ROFF2MODE@
transforms
.I roff
code into
.ie '@ROFF2MODE@'x' \{\
.  I X
mode corresponding to the
.  I groff
devices
.  BR X *;
this mode is suitable for
.  BR \%gxditview (@MAN1EXT@).
.\}
.el \{\
.  I \%@ROFF2MODE@
mode.
.\}
.
Print the result to standard output.
.
.
.P
There are more of these programs for generating other formats of
.I \%roff
input.
.
.if !'@ROFF2MODE@'dvi' \{\
.  TP
.  BR \%roff2dvi (@MAN1EXT@)
is for
.  I dvi
mode.
.\}
.
.if !'@ROFF2MODE@'html' \{\
.  TP
.  BR \%roff2html (@MAN1EXT@)
generates
.  I HTML
output.
.\}
.
.if !'@ROFF2MODE@'pdf' \{\
.  TP
.  BR \%roff2pdf (@MAN1EXT@)
outputs
.  I pdf
mode.
.\}
.
.if !'@ROFF2MODE@'ps' \{\
.  TP
.  BR \%roff2ps (@MAN1EXT@)
prints
.  I \%PostScript
format to standard output.
.\}
.
.if !'@ROFF2MODE@'text' \{\
.  TP
.  BR \%roff2text (@MAN1EXT@)
generates text output in the
.  B groff
device
.  IR latin1 .
.\}
.
.if !'@ROFF2MODE@'x' \{\
.  TP
.  BR \%roff2x (@MAN1EXT@)
prints the output in the
.  B groff
device
.  B X
that is suitable for programs like
.  BR \%gxditview (@MAN1EXT@)
or
.  BR \%xditview (1).
.\}
.
.
.\" ====================================================================
.SH AUTHORS
.\" ====================================================================
.B roff2@ROFF2MODE@
was written by
.MT groff\-bernd.warken\-72@\:web.de
Bernd Warken
.ME .
.
.
.\" ====================================================================
.SH "SEE ALSO"
.\" ====================================================================
.
.BR \%groff (@MAN1EXT@),
.BR \%groffer (@MAN1EXT@),
.if !'@ROFF2MODE@'dvi' \
.  BR \%roff2dvi (@MAN1EXT@),
.if !'@ROFF2MODE@'html' \
.  BR \%roff2html (@MAN1EXT@),
.if !'@ROFF2MODE@'pdf' \
.  BR \%roff2pdf (@MAN1EXT@),
.if !'@ROFF2MODE@'ps' \
.  BR \%roff2ps (@MAN1EXT@),
.if !'@ROFF2MODE@'text' \
.  BR \%roff2text (@MAN1EXT@),
.if !'@ROFF2MODE@'x' \
.  BR \%roff2x (@MAN1EXT@),
.BR \%gxditview (@MAN1EXT@).
.
.
.\" ====================================================================
.\" Emacs settings
.\" ====================================================================
.
.\" Local Variables:
.\" mode: nroff
.\" End:
.\" vim: set filetype=groff:
