.TH PDFROFF @MAN1EXT@ "@MDATE@" "Groff Version @VERSION@"
.SH NAME
pdfroff \- create PDF documents using groff
.
.
.\" Save and disable compatibility mode (for, e.g., Solaris 10/11).
.do nr pdfroff_C \n[.C]
.cp 0
.
.
.\" pdfroff.1
.\" File position: <groff-source>/contrib/pdfmark/pdfroff.man
.
.\" ====================================================================
.\" Legal Matters
.\" ====================================================================
.\"
.\" Copyright (C) 2005-2014 Free Software Foundation, Inc.
.\"
.\" This file is part of groff, the free GNU roff type-setting system.
.\"
.\" Permission is granted to copy, distribute and/or modify this
.\" document under the terms of the GNU Free Documentation License
.\" (FDL), Version 1.3 or any later version published by the Free
.\" Software Foundation; with no Front-Cover Texts, no Back-Cover Texts,
.\" and the following Invariant Sections:--
.\"
.\"     a)  This "Legal Matters" section, extending from the definition
.\"         of .co to the end of the enclosing .au definition.
.\"
.\"     b) The entire sections bearing the heading "COPYING" and
.\"        "AUTHORS".
.\"
.\" A copy of the Free Documentation License is included as a file
.\" called FDL in the main directory of the groff source package, it is
.\" also available in the internet at the GNU copyleft site
.\" <http://www.gnu.org/copyleft/fdl.html>.
.
.
.\" ====================================================================
.\" Local macro definitions
.
.hw pdfmark
.
.
.\" ====================================================================
.
.
.
.\" ====================================================================
.SH SYNOPSIS
.\" ====================================================================
.
.SY pdfroff
.OP \-abcegilpstzCEGNRSUVXZ
.OP \-d cs
.OP \-f fam
.OP \-F dir
.OP \-I dir
.OP \-L arg
.OP \-m name
.OP \-M dir
.OP \-n num
.OP \-o list
.OP \-P arg
.OP \-r cn
.OP \-T dev
.OP \-w name
.OP \-W name
.OP \-\-emit\-ps
.OP \-\-no\-toc\-relocation
.OP \-\-no-kill\-null\-pages
.OP \-\-stylesheet=\fIname\fP
.OP \-\-no\-pdf\-output
.OP \-\-pdf\-output=\fIname\fP
.OP \-\-no\-reference\-dictionary
.OP \-\-reference\-dictionary=\fIname\fP
.OP \-\-report\-progress
.OP \-\-keep\-temporary\-files
.I file .\|.\|.
.
.SY pdfroff
.B \-h
|
.B \-\-help
.
.SY pdfroff
.B \-v
|
.B \-\-version
.RI [ option\ .\|.\|. ]
.YS
.
.
.\" ====================================================================
.SH DESCRIPTION
.\" ====================================================================
.
.B pdfroff
is a wrapper program for the GNU text processing system,
.BR  groff .
.
It transparently handles the mechanics of multiple pass
.B groff
processing, when applied to suitably marked up
.B groff
source files,
such that tables of contents and body text are formatted separately,
and are subsequently combined in the correct order, for final publication
as a single PDF document.
.
A further optional
\*(lqstyle sheet\*(rq
capability is provided;
this allows for the definition of content which is required to precede the
table of contents, in the published document.
.
.P
For each invocation of
.BR pdfroff ,
the ultimate
.B groff
output stream is post-processed by the GhostScript interpreter,
to produce a finished PDF document.
.
.P
.B pdfroff
makes no assumptions about, and imposes no restrictions on, the use of
any
.B groff
macro packages which the user may choose to employ,
in order to achieve a desired document format;
however, it
.I does
include specific built in support for the
.B pdfmark
macro package, should the user choose to employ it.
.
Specifically, if the
.I pdfhref
macro, defined in the
.B pdfmark.tmac
package, is used to define public reference marks, or dynamic links to
such reference marks, then
.B pdfroff
performs as many preformatting
.B groff
passes as required, up to a maximum limit of
.IR four ,
in order to compile a document reference dictionary, to resolve
references, and to expand the dynamically defined content of links.
.
.
.\" ====================================================================
.SH USAGE
.\" ====================================================================
.
The command line is parsed in accordance with normal GNU conventions,
but with one exception \(em when specifying any short form option
(i.e., a single character option introduced by a single hyphen),
and if that option expects an argument, then it
.I must
be specified independently (i.e., it may
.I not
be appended to any group of other single character short form options).
.
.
.P
Long form option names (i.e., those introduced by a double hyphen) may
be abbreviated to their minimum length unambiguous initial substring.
.
.
.P
Otherwise,
.B pdfroff
usage closely mirrors that of
.B groff
itself.
.
Indeed, with the exception of the
.BR \-h ,
.BR \-v ,
and
.BI \-T \ dev
short form options, and all long form options, which are parsed
internally by
.BR pdfroff ,
all options and file name arguments specified on the command line are
passed on to
.BR groff ,
to control the formatting of the PDF document.
.
Consequently,
.B pdfroff
accepts all options and arguments, as specified in
.BR groff (@MAN1EXT@),
which may also be considered as the definitive reference for all standard
.BR pdfroff
options and argument usage.
.
.
.\" ====================================================================
.SH OPTIONS
.\" ====================================================================
.
.B pdfroff
accepts all of the short form options (i.e., those introduced by a
single hyphen), which are available with
.B groff
itself.
.
In most cases, these are simply passed transparently to
.BR groff ;
the following, however, are handled specially by
.BR pdfroff .
.
.TP
.B \-h
Same as
.BR \-\-help ;
see below.
.
.TP
.B \-i
Process standard input, after all other specified input files.
.
This is passed transparently to
.BR groff ,
but, if grouped with other options, it
.I must
be the first in the group.
.
Hiding it within a group breaks standard input processing, in the
multiple pass
.B groff
processing context of
.BR pdfroff .
.
.TP
.BI \-T \ dev
Only
.B \-T\ ps
is supported by
.BR pdfroff .
.
Attempting to specify any other device causes
.B pdfroff
to abort.
.
.TP
.B \-v
Same as
.BR \-\-version ;
see below.
.
.
.P
See
.BR groff (@MAN1EXT@)
for a description of all other short form options, which are
transparently passed through
.BR pdfroff
to
.BR groff .
.
.
.P
All long form options (i.e., those introduced by a double hyphen) are
interpreted locally by
.BR pdfroff ;
they are
.B not
passed on to
.BR groff ,
unless otherwise stated below.
.
.TP
.B \-\-help
Causes
.B pdfroff
to display a summary of the its usage syntax, and supported options,
and then exit.
.
.TP
.B \-\-emit\-ps
Suppresses the final output conversion step, causing
.B pdfroff
to emit PostScript output instead of PDF.
.
This may be useful, to capture intermediate PostScript output, when
using a specialised postprocessor, such as
.I gpresent
for example,
in place of the default
.I GhostScript
PDF writer.
.
.TP
.B \-\-keep\-temporary\-files
Suppresses the deletion of temporary files, which normally occurs
after
.B pdfroff
has completed PDF document formatting; this may be useful, when
debugging formatting problems.
.
.IP
See section
.BR FILES ,
for a description of the temporary files used by
.BR pdfroff .
.
.TP
.B \-\-no\-pdf\-output
May be used with the
.BI \%\-\-reference\-dictionary= name
option (described below) to eliminate the overhead of PDF formatting,
when running
.B pdfroff
to create a reference dictionary, for use in a different document.
.
.TP
.B \-\-no\-reference\-dictionary
May be used to eliminate the overhead of creating a reference dictionary,
when it is known that the target PDF document contains no public
references, created by the
.I pdfhref
macro.
.
.TP
.B \-\-no\-toc\-relocation
May be used to eliminate the extra
.B groff
processing pass,
which is required to generate a table of contents,
and relocate it to the start of the PDF document,
when processing any document which lacks an automatically
generated table of contents.
.
.TP
.B \-\-no\-kill\-null\-pages
While preparing for simulation of the manual collation step,
which is traditionally required to relocate a
.I "table of contents"
to the start of a document,
.B pdfroff
accumulates a number of empty page descriptions
into the intermediate
.I PostScript
output stream.
During the final collation step,
these empty pages are normally discarded from the finished document;
this option forces
.B pdfroff
to leave them in place.
.
.TP
.BI \-\-pdf\-output= name
Specifies the name to be used for the resultant PDF document;
if unspecified, the PDF output is written to standard output.
A future version of
.B pdfroff
may use this option,
to encode the document name in a generated reference dictionary.
.
.TP
.BI \-\-reference\-dictionary= name
Specifies the name to be used for the generated reference dictionary file;
if unspecified, the reference dictionary is created in a temporary file,
which is deleted when
.B pdfroff
completes processing of the current document.
.
This option
.I must
be specified, if it is desired to save the reference dictionary,
for use in references placed in other PDF documents.
.
.TP
.B \-\-report\-progress
Causes
.B pdfroff
to display an informational message on standard error,
at the start of each
.B groff
processing pass.
.
.TP
.BI \-\-stylesheet= name
Specifies the name of an
.IR "input file" ,
to be used as a style sheet for formatting of content,
which is to be placed
.I before
the table of contents,
in the formatted PDF document.
.
.TP
.B \-\-version
Causes
.B pdfroff
to display a version identification message.
.
The entire command line is then passed transparently to
.BR groff ,
in a
.I one
pass operation
.IR only ,
in order to display the associated
.B groff
version information, before exiting.
.
.
.\" ====================================================================
.SH ENVIRONMENT
.\" ====================================================================
.
The following environment variables may be set, and exported,
to modify the behaviour of
.BR pdfroff .
.
.TP
.B PDFROFF_COLLATE
Specifies the program to be used
for collation of the finished PDF document.
.
.IP
This collation step may be required to move
.I tables of contents
to the start of the finished PDF document,
when formatting with traditional macro packages,
which print them at the end.
.
However, users should not normally need to specify
.BR \%PDFROFF_COLLATE ,
(and indeed, are not encouraged to do so).  If unspecified,
.B pdfroff
uses
.BR sed (@MAN1EXT@)
by default,
which normally suffices.
.
.IP
If
.B \%PDFROFF_COLLATE
.I is
specified,
then it must act as a filter,
accepting a list of file name arguments,
and write its output to the
.I stdout
stream,
whence it is piped to the
.BR \%PDFROFF_POSTPROCESSOR_COMMAND ,
to produce the finished PDF output.
.
.IP
When specifying
.BR \%PDFROFF_COLLATE ,
it is normally necessary to also specify
.BR \%PDFROFF_KILL_NULL_PAGES .
.
.IP
.B \%PDFROFF_COLLATE
is ignored,
if
.B pdfroff
is invoked with the
.I \%\-\-no\-kill\-null\-pages
option.
.
.TP
.B PDFROFF_KILL_NULL_PAGES
Specifies options to be passed to the
.B \%PDFROFF_COLLATE
program.
.
.IP
It should not normally be necessary to specify
.BR \%PDFROFF_KILL_NULL_PAGES .
.
The internal default is a
.BR sed (@MAN1EXT@)
script,
which is intended to remove completely blank pages
from the collated output stream,
and which should be appropriate in most applications of
.BR pdfroff .
.
However,
if any alternative to
.BR sed (@MAN1EXT@)
is specified for
.BR \%PDFROFF_COLLATE ,
then it is likely that a corresponding alternative specification for
.B \%PDFROFF_KILL_NULL_PAGES
is required.
.
.IP
As in the case of
.BR \%PDFROFF_COLLATE ,
.B \%PDFROFF_KILL_NULL_PAGES
is ignored, if
.B pdfroff
is invoked with the
.I \%\-\-no\-kill\-null\-pages
option.
.
.TP
.B PDFROFF_POSTPROCESSOR_COMMAND
Specifies the command to be used for the final document conversion
from PostScript intermediate output to PDF.
.
It must behave as a filter,
writing its output to the
.I stdout
stream,
and must accept an arbitrary number of
.I files .\|.\|.\&
arguments,
with the special case of
.I \-
representing the
.I stdin
stream.
.
.IP
If unspecified,
.B \%PDFROFF_POSTPROCESSOR_COMMAND
defaults to
.
.RS 12n
.EX
gs \-dBATCH \-dQUIET \-dNOPAUSE \-dSAFER \-sDEVICE=pdfwrite \e
	\-sOutputFile=\-
.EE
.RE
.
.TP
.B GROFF_TMPDIR
Identifies the directory in which
.B pdfroff
should create temporary files.
.
If
.B \%GROFF_TMPDIR
is
.I not
specified, then the variables
.BR TMPDIR ,
.B TMP
and
.B TEMP
are considered in turn, as possible temporary file repositories.
If none of these are set, then temporary files are created
in the current directory.
.
.TP
.B GROFF_GHOSTSCRIPT_INTERPRETER
Specifies the program to be invoked, when
.B pdfroff
converts
.B groff
PostScript output to PDF.
.
If
.B \%PDFROFF_POSTPROCESSOR_COMMAND
is specified,
then the command name it specifies is
.I implicitly
assigned to
.BR \%GROFF_GHOSTSCRIPT_INTERPRETER ,
overriding any explicit setting specified in the environment.
.
If
.B \%GROFF_GHOSTSCRIPT_INTERPRETER
is not specified, then
.B pdfroff
searches the process
.BR PATH ,
looking for a program with any of the well known names
for the GhostScript interpreter;
if no GhostScript interpreter can be found,
.B pdfroff
aborts.
.
.TP
.B GROFF_AWK_INTERPRETER
Specifies the program to be invoked, when
.B pdfroff
is extracting reference dictionary entries from a
.B groff
intermediate message stream.
.
If
.B \%GROFF_AWK_INTERPRETER
is not specified, then
.B pdfroff
searches the process
.BR PATH ,
looking for any of the preferred programs, \[oq]gawk\[cq],
\[oq]mawk\[cq], \[oq]nawk\[cq], and \[oq]awk\[cq], in this order; if
none of these are found,
.B pdfroff
issues a warning message, and continue processing;
however, in this case, no reference dictionary is created.
.
.TP
.B OSTYPE
Typically defined automatically by the operating system,
.B OSTYPE
is used on Microsoft Win32/MS-DOS platforms
.IR only ,
to infer the default
.B \%PATH_SEPARATOR
character,
which is used when parsing the process
.B PATH
to search for external helper programs.
.
.TP
.B PATH_SEPARATOR
If set,
.B \%PATH_SEPARATOR
overrides the default separator character,
(\[oq]:\[cq] on POSIX/UNIX systems,
inferred from
.B OSTYPE
on Microsoft Win32/MS-DOS),
which is used when parsing the process
.B PATH
to search for external helper programs.
.
.TP
.B SHOW_PROGRESS
If this is set to a non-empty value, then
.B pdfroff
always behaves as if the
.B \%\-\-report\-progress
option is specified, on the command line.
.
.
.\" ====================================================================
.SH FILES
.\" ====================================================================
.
Input and output files for
.B pdfroff
may be named according to any convention of the user's choice.
Typically, input files may be named according to the choice of the
principal formatting macro package, e.g.,
.IB file .ms
might be an input file for formatting using the
.B ms
macros
.RB ( s.tmac );
normally, the final output file should be named
.IB file .pdf\c
\&.
.
.
.P
Temporary files, created by
.BR pdfroff ,
are placed in the file system hierarchy,
in or below the directory specified by environment variables
(see section
.BR ENVIRONMENT ).
.
If
.BR mktemp (@MAN1EXT@)
is available,
it is invoked to create a private subdirectory of
the nominated temporary files directory,
(with subdirectory name derived from the template
.BR pdfroff-XXXXXXXXXX );
if this subdirectory is successfully created,
the temporary files will be placed within it,
otherwise they will be placed directly in the directory
nominated in the environment.
.P
All temporary files themselves
are named according to the convention
.BI pdf $$ .*\c
\&, where
.I $$
is the standard shell variable representing the process ID of the
.B pdfroff
process itself, and
.I *
represents any of the extensions used by
.B pdfroff
to identify the following temporary and intermediate files.
.
.TP
.BI pdf $$ .tmp
A scratch pad file,
used to capture reference data emitted by
.BR groff ,
during the
.I reference dictionary
compilation phase.
.
.TP
.BI pdf $$ .ref
The
.IR "reference dictionary" ,
as compiled in the last but one pass of the
.I reference dictionary
compilation phase;
(at the start of the first pass,
this file is created empty;
in successive passes,
it contains the
.I reference dictionary
entries,
as collected in the preceding pass).
.
.IP
If the
.BR \%\-\-reference\-dictionary =\c
.I name
option is specified,
this intermediate file becomes permanent,
and is named
.IR name ,
rather than
.BI pdf $$ .ref\c
\&.
.
.TP
.BI pdf $$ .cmp
Used to collect
.I reference dictionary
entries during the active pass of the
.I reference dictionary
compilation phase.
.
At the end of any pass,
when the content of
.BI pdf $$ .cmp
compares as identical to
.BI pdf $$ .ref\c
\&,
(or the corresponding file named by the
.BR \%\-\-reference\-dictionary =\c
.I name
option),
then
.I reference dictionary
compilation is terminated,
and the
.I document reference map
is appended to this intermediate file,
for inclusion in the final formatting passes.
.
.TP
.BI pdf $$ .tc
An intermediate
.I PostScript
file,
in which \[lq]Table of Contents\[rq] entries are collected,
to facilitate relocation before the body text,
on ultimate output to the
.I GhostScript
postprocessor.
.
.TP
.BI pdf $$ .ps
An intermediate
.I PostScript
file,
in which the body text is collected prior to ultimate output to the
.I GhostScript
postprocessor,
in the proper sequence,
.I after
.BI pdf $$ .tc\c
\&.
.
.
.\" ====================================================================
.SH AUTHORS
.\" ====================================================================
.B pdfroff
was written by
.MT keith.d.marshall@\:ntlworld.com
Keith Marshall
.ME .
.
.
.\" ====================================================================
.SH SEE ALSO
.\" ====================================================================
.
See
.BR groff (@MAN1EXT@)
for the definitive reference to document formatting with
.BR groff .
.
Since
.B pdfroff
provides a superset of all
.B groff
capabilities,
.BR groff (@MAN1EXT@)
may also be considered to be the definitive reference to all
.I standard
capabilities of
.BR pdfroff ,
with this document providing the reference to
.BR pdfroff 's
extended features.
.
.
.P
While
.B pdfroff
imposes neither any restriction on, nor any requirement for,
the use of any specific
.B groff
macro package, a number of supplied macro packages,
and in particular those associated with the package
.BR pdfmark.tmac ,
are best suited for use with
.BR pdfroff
as the preferred formatter.
.
Detailed documentation on the use of these packages may be found,
in PDF format, in the reference guide
.BR "\*(lqPortable Document Format Publishing with GNU Troff\*(rq" ,
included in the installed documentation set as
.BR \%@PDFDOCDIR@/pdfmark.pdf .
.
.
.\" Restore compatibility mode (for, e.g., Solaris 10/11).
.cp \n[pdfroff_C]
.
.
.\" ====================================================================
.\" Local Variables:
.\" mode: nroff
.\" End:
.\" vim: filetype=groff:
