/*
 This file is part of GNU Taler
 (C) 2022 Taler Systems S.A.

 GNU Taler is free software; you can redistribute it and/or modify it under the
 terms of the GNU General Public License as published by the Free Software
 Foundation; either version 3, or (at your option) any later version.

 GNU Taler is distributed in the hope that it will be useful, but WITHOUT ANY
 WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

 You should have received a copy of the GNU General Public License along with
 GNU Taler; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */

import { useTranslationContext } from "@gnu-taler/web-util/browser";
import { Fragment, h, VNode } from "preact";
import { Amount } from "../../components/Amount.js";
import { AmountField } from "../../components/AmountField.js";
import { Part, PartPayto } from "../../components/Part.js";
import { Button } from "../../mui/Button.js";
import { DepositDetails, getAmountWithFee } from "../../wallet/Transaction.js";
import { State } from "./index.js";

/**
 *
 * @author sebasjm
 */

export function ReadyView(state: State.Ready): VNode {
  const { i18n } = useTranslationContext();

  return (
    <Fragment>
      <section style={{ textAlign: "left" }}>
        <p>
          <AmountField
            label={i18n.str`Amount`}
            handler={state.amount}
            required
          />
        </p>
        <PartPayto kind="neutral" payto={state.account} />
        <Part
          title={i18n.str`Details`}
          text={
            <DepositDetails
              amount={getAmountWithFee(state.cost, state.effective, "debit")}
            />
          }
        />

      </section>
      <section>
        <Button
          variant="contained"
          color="success"
          onClick={state.confirm.onClick}
        >
          <i18n.Translate>
            Send &nbsp; {<Amount value={state.cost} />}
          </i18n.Translate>
        </Button>
      </section>
    </Fragment>
  );
}
