/*
   This file is part of TALER
   Copyright (C) 2025 Taler Systems SA

   TALER is free software; you can redistribute it and/or modify it under the
   terms of the GNU General Public License as published by the Free Software
   Foundation; either version 3, or (at your option) any later version.

   TALER is distributed in the hope that it will be useful, but WITHOUT ANY
   WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
   A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

   You should have received a copy of the GNU General Public License along with
   TALER; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */
/**
 * @file backenddb/pg_insert_unit.c
 * @brief Implementation of the insert_unit function for Postgres
 * @author Bohdan Potuzhnyi
 */
#include "platform.h"
#include <taler/taler_error_codes.h>
#include <taler/taler_dbevents.h>
#include <taler/taler_pq_lib.h>
#include "pg_insert_unit.h"
#include "pg_helper.h"


enum GNUNET_DB_QueryStatus
TMH_PG_insert_unit (void *cls,
                    const char *instance_id,
                    const struct TALER_MERCHANTDB_UnitDetails *ud,
                    bool *no_instance,
                    bool *conflict,
                    uint64_t *unit_serial)
{
  struct PostgresClosure *pg = cls;
  struct GNUNET_PQ_QueryParam params[] = {
    GNUNET_PQ_query_param_string (instance_id),
    GNUNET_PQ_query_param_string (ud->unit),
    GNUNET_PQ_query_param_string (ud->unit_name_long),
    GNUNET_PQ_query_param_string (ud->unit_name_short),
    TALER_PQ_query_param_json (ud->unit_name_long_i18n),
    TALER_PQ_query_param_json (ud->unit_name_short_i18n),
    GNUNET_PQ_query_param_bool (ud->unit_allow_fraction),
    GNUNET_PQ_query_param_uint32 (&ud->unit_precision_level),
    GNUNET_PQ_query_param_bool (ud->unit_active),
    GNUNET_PQ_query_param_end
  };
  bool unit_serial_present = true;
  struct GNUNET_PQ_ResultSpec rs[] = {
    GNUNET_PQ_result_spec_bool ("no_instance",
                                no_instance),
    GNUNET_PQ_result_spec_bool ("conflict",
                                conflict),
    GNUNET_PQ_result_spec_allow_null (
      GNUNET_PQ_result_spec_uint64 ("unit_serial",
                                    unit_serial),
      &unit_serial_present),
    GNUNET_PQ_result_spec_end
  };
  enum GNUNET_DB_QueryStatus qs;

  *no_instance = false;
  *conflict = false;

  check_connection (pg);
  PREPARE (pg,
           "insert_unit",
           "SELECT"
           " out_no_instance AS no_instance"
           " ,out_conflict AS conflict"
           " ,out_unit_serial AS unit_serial"
           " FROM merchant_do_insert_unit"
           " ($1,$2,$3,$4,$5,$6,$7,$8,$9);");
  qs = GNUNET_PQ_eval_prepared_singleton_select (pg->conn,
                                                 "insert_unit",
                                                 params,
                                                 rs);
  GNUNET_PQ_cleanup_query_params_closures (params);
  if (! unit_serial_present)
    *unit_serial = 0;
  return qs;
}
