// VQF 902.5 Customer Profile Template
// Pass JSON data as content dictionary

#let form(data) = {
  set page(
    paper: "a4",
    margin: (left: 2cm, right: 2cm, top: 2cm, bottom: 2.5cm),
    footer: context [
      #grid(
        columns: (1fr, 1fr),
        align: (left, right),
        text(size: 8pt)[
          VQF doc. Nr. 902.5#linebreak()
          Version of 1 December 2015
        ],
        text(size: 8pt)[
          Page #here().page() of #counter(page).final().first()
        ]
      )
    ]
  )

  set text(font: "Liberation Sans", size: 10pt)
  set par(justify: false, leading: 0.65em)

  // Helper function to get value or empty string
  let get(key, default: "") = {
    data.at(key, default: default)
  }

  // Helper function for checkbox
  let checkbox(checked) = {
    box(
      width: 3mm,
      height: 3mm,
      stroke: 0.5pt + black,
      inset: 0.3mm,
      if checked == true or checked == "true" {
        place(center + horizon, text(size: 8pt, sym.checkmark))
      }
    )
  }

  // Header
  align(center, text(size: 11pt, weight: "bold")[CONFIDENTIAL])

  v(0.5em)

  grid(
    columns: (50%, 50%),
    gutter: 1em,
    image("vss_vqf_verein.png", width: 80%),
    align(right)[
      #table(
        columns: (1fr, 1fr),
        stroke: 0.5pt + black,
        inset: 5pt,
        align: (left, left),
        [VQF member no.], [AMLA File No.],
        [#get("VQF_MEMBER_NUMBER")], [#get("FILE_NUMBER")]
      )
    ]
  )

  v(1em)

  align(left, text(size: 14pt, weight: "bold")[Customer Profile])

  v(0.3em)

  text(size: 9pt, style: "italic")[For permanent business relationship and regular customers]

  v(-1em)
  line(length:100%)

  grid(
    columns: (auto, 1fr),
    gutter: 0.5em,
    align: (left, left),
    image("pointing_finger.svg", height: 2em),
    text(size: 9pt)[
      The information below has to refer to the persons from whom the assets originate ultimately (e.g. beneficial owner of the assets, founder/creator of a trust or foundation). Is the customer an operational legal entity or partnership the information may refer to the entity itself (not to the controlling person), unless the entity holds the assets in trust for a third party.
    ]
  )

  v(1em)

  v(0.3em)

  table(
    columns: (20%,80%),
    stroke: 0.5pt + black,
    inset: 5pt,
    [Customer:#footnote[Pursuant Identification Form (VQF doc. No. 902.1) numeral 1.]],
    [#get("CUSTOMER_NAME")]
  )

  v(0.5em)

  text(weight: "bold")[This form was completed by:]

  v(0.3em)

  table(
    columns: (20%, 80%),
    stroke: 0.5pt + black,
    inset: 5pt,
    align: (left, left),
    [Full name], [#get("AML_STAFF_NAME")],
    [Date], [#get("FILING_DATE")],
  )

  v(1.5em)

  // Section 1: Business Activity
  text(size: 11pt, weight: "bold")[1. Business activity]

  v(0.5em)

  table(
    columns: (40%, 60%),
    stroke: 0.5pt + black,
    inset: 5pt,
    [Profession, business activities etc. (former, current, potentially planned)],
    [#get("BIZREL_PROFESSION")]
  )

  v(1.5em)

  // Section 2: Financial Circumstances
  text(size: 11pt, weight: "bold")[2. Financial circumstances]

  v(0.5em)

  table(
    columns: (40%, 60%),
    stroke: 0.5pt + black,
    inset: 5pt,
    [Income and assets, liabilities (estimated)],
    [#get("BIZREL_INCOME")]
  )

  v(1.5em)

  // Section 3: Origin of Deposited Assets
  text(size: 11pt, weight: "bold")[3. Origin of the deposited assets involved]

  v(0.5em)

  let origin_cat = get("BIZREL_ORIGIN_CATEGORY")

  block(breakable: false)[
    #table(
      columns: (40%, 60%),
      stroke: 0.5pt + black,
      inset: 5pt,
      [Nature, amount and currency of the involved assets],
      [#get("BIZREL_ORIGIN_NATURE")],
      [Category],
      [#grid(
        columns: (auto, 1fr),
        gutter: 0.5em,
        checkbox(origin_cat == "SAVINGS"), [Savings],
        checkbox(origin_cat == "OWN_BUSINESS"), [Own business operations],
        checkbox(origin_cat == "INHERITANCE"), [Inheritance],
        checkbox(origin_cat == "OTHER"), [Other, what? #get("BIZREL_ORIGIN_CATEGORY_OTHER")],
      )],
      [Detailed description of the origins/economical background of the assets involved in the business relationship],
      [#get("BIZREL_ORIGIN_DETAIL")]
    )
  ]

  v(1.5em)
  pagebreak()

  // Section 4: Nature and Purpose
  text(size: 11pt, weight: "bold")[4. Nature and purpose of the business relationship]

  v(0.5em)

  table(
    columns: (40%, 60%),
    stroke: 0.5pt + black,
    inset: 5pt,
    [Purpose of the business relationship],
    [#get("BIZREL_PURPOSE")],
    [Information on the planned development of the business relationship and the assets],
    [#get("BIZREL_DEVELOPMENT")],
    [Especially in the case of cash or money and asset transfer transactions with regular customers:
     \ - Details on usual business volume
     \ - Information on the beneficiaries
     \ (Full name, address, bank account)],
    [#get("BIZREL_FINANCIAL_VOLUME")]
  )

  v(1.5em)

  // Section 5: Relationship with Third Parties
  text(size: 11pt, weight: "bold")[5. Relationship with third parties]

  v(0.5em)

  table(
    columns: (40%, 60%),
    stroke: 0.5pt + black,
    inset: 5pt,
    [Relation of the customer to the beneficial owner, controlling persons, authorised signatories and other persons involved in the business relationship],
    [#get("BIZREL_THIRDPARTY_RELATIONSHIP")],
    [Relation to other AMLA-Files],
    [#get("BIZREL_THIRDPARTY_AMLA_FILES")],
    [Introducer / agents / references],
    [#get("BIZREL_THIRDPARTY_REFERENCES")]
  )

  v(1.5em)

  // Section 6: Further Information
  text(size: 11pt, weight: "bold")[6. Further information]

  v(0.5em)

  table(
    columns: (40%, 60%),
    stroke: 0.5pt + black,
    inset: 5pt,
    [Other relevant information],
    [#get("BIZREL_FURTHER_INFO")]
  )

  v(2em)

  text(size: 9pt, style: "italic")[⚠ *This form has to be updated when changes occur.*]
}

// Example usage:
#form((
  "VQF_MEMBER_NUMBER": "12345",
  "FILE_NUMBER": "42",
  "CUSTOMER_NAME": "John Doe",
  "FILED_BY_NAME": "Jane Smith",
  "FILING_DATE": "10.11.2025",
  "BIZREL_PROFESSION": "Software Engineer",
  "BIZREL_INCOME": "Annual income CHF 150,000",
  "BIZREL_ORIGIN_NATURE": "CHF 50,000 in cash",
  "BIZREL_ORIGIN_CATEGORY": "SAVINGS",
  "BIZREL_PURPOSE": "Payment services",
  "BIZREL_DEVELOPMENT": "Regular transactions expected",
))