/*
   This file is part of TALER
   Copyright (C) 2025 Taler Systems SA

   TALER is free software; you can redistribute it and/or modify it under the
   terms of the GNU General Public License as published by the Free Software
   Foundation; either version 3, or (at your option) any later version.

   TALER is distributed in the hope that it will be useful, but WITHOUT ANY
   WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
   A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

   You should have received a copy of the GNU General Public License along with
   TALER; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */
/**
 * @file donaudb/pg_update_charity.h
 * @brief Implementation of the update_charity function for Postgres
 * @author Bohdan Potuzhnyi
 */
#ifndef PG_UPDATE_CHARITY_H
#define PG_UPDATE_CHARITY_H

#include <taler/taler_util.h>
#include "donaudb_plugin.h"

/**
 * Update an existing charity entry.
 *
 * @param cls closure
 * @param charity_id identifier of the charity to update
 * @param charity_pub new public key for the charity
 * @param charity_name new name
 * @param charity_url new landing page URL
 * @param max_per_year yearly donation limit
 * @return transaction status code
 */
enum GNUNET_DB_QueryStatus
DH_PG_update_charity (
  void *cls,
  uint64_t charity_id,
  const struct DONAU_CharityPublicKeyP *charity_pub,
  const char *charity_name,
  const char *charity_url,
  const struct TALER_Amount *max_per_year);

#endif
