# vim: set fileencoding=utf8 :
# Solfege - free ear training software
# Copyright (C) 2009 Tom Cato Amundsen
# License is GPL, see file COPYING

import unittest
from src import statistics
statistics.db = statistics.DB()
from src import app
from src import lessonfile
from src import idbyname

class TestDB(unittest.TestCase):
    def test_en(self):
        s1 = "var = 1"
        s2 = "#comment\nvar = 1"
        s3 = "#comment\n\nvar = 1"
        self.assertEqual(statistics.hash_lessonfile_text(s1),
                         statistics.hash_lessonfile_text(s2))
        self.assertEqual(statistics.hash_lessonfile_text(s1),
                         statistics.hash_lessonfile_text(s3))
    def test_two(self):
        opt_parser = app.SolfegeOptionParser()
        options, args = opt_parser.parse_args()
        lessonfile.manager = lessonfile.LessonFileManager(options.debug)
        a = app.SolfegeApp(options, None, None)
        t = idbyname.Teacher('idbyname', a)
        t.set_lessonfile('lesson-files/chord-min-major')
        t.m_statistics.reset_session()
        t.m_statistics.add_wrong('minor', 'major')
        t.m_statistics.add_wrong('minor', 'major')
        t.m_statistics.add_wrong('minor', 'minor')
        t.m_statistics.add_correct('major')
        for seconds in (-1, 0, 10000):
            self.assertEquals(t.m_statistics.get_num_correct_for_key(seconds, 'minor'), 1)
            self.assertEquals(t.m_statistics.get_num_guess_for_key(seconds, 'minor'), 3)
                
suite = unittest.makeSuite(TestDB)
