#!/usr/bin/python
"""
Generate thumbnails of the screenshots from the front page
of www.solfege.org
"""

import shutil
import os
import subprocess

thumbs = 'web-thumbs'
if os.path.exists(thumbs):
    shutil.rmtree(thumbs)
os.mkdir(thumbs)

origs = ('id-interval-piano', 'singinterval', 'rhythm', 'singchord', )
for fn in origs:
    fn_ext = "%s.png" % fn
    shutil.copyfile(os.path.join('help/C/figures', fn_ext),
                    os.path.join(thumbs, fn_ext))
    subprocess.call(['convert', '-scale', '50%',
        os.path.join(thumbs, fn_ext),
        os.path.join(thumbs, fn+"_t.png")])
