# GNU Solfege - ear training for GNOME
# Copyright (C) 2000, 2001, 2002, 2003, 2004  Tom Cato Amundsen
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

__exercise_data__ = {
    'exercise_name': 'id-by-name',
    'menu_path': '%s/%s' % (_("_Misc exercises"), _("Id_entify by name")),
    'icon': 'graphics/idbyname24.png',
    'toolbar': 5,
}
import exercise_setup
exercise_setup.register_exercise(__exercise_data__)

if __name__ == 'idbyname':
    # pydoc ??
    import sys
    sys.path.append("src")
    import i18n
    i18n.setup_srcdir()

import gtk, gnome
import gu, widgets
import abstract, const, mpd, mpd.musicdisplayer
import utils
import statistics, statisticsviewer
import lessonfile
import string
import dataparser
import soundcard


class Teacher(abstract.LessonbasedTeacher):
    exercise_data = __exercise_data__
    OK = 0
    ERR_PICKY = 1
    ERR_NO_QUESTION = 2
    def __init__(self, exname,  app, lesson_collection, lesson_file, config):
        abstract.LessonbasedTeacher.__init__(self, exname, app,
                lesson_collection, lesson_file, config)
        self.lessonfileclass = lessonfile.IdByNameLessonfile
        try: # the lessonfile might contain errors.
            self.parse_lessonfile()
        except dataparser.DataparserException, e:
            self.m_app.m_ui.display_error_message(str(e))
        self.m_statistics = statistics.LessonStatistics(self)
    def give_up(self):
        self.q_status = const.QSTATUS_GIVE_UP
    def ok_compare_listen(self):
        return self.q_status in (const.QSTATUS_GIVE_UP, const.QSTATUS_WRONG,
                    const.QSTATUS_SOLVED)
    def new_question(self):
        """
        UI will never call this function unless we have a usable lessonfile.
        """
        if self.m_timeout_handle:
            gtk.timeout_remove(self.m_timeout_handle)
            self.m_timeout_handle = None

        if self.get_bool('config/picky_on_new_question') \
                 and self.q_status in [const.QSTATUS_NEW, const.QSTATUS_WRONG]:
             return Teacher.ERR_PICKY

        self.q_status = const.QSTATUS_NO

        assert self.m_P
        try:
            self.m_P.select_random_question()
            self.q_status = const.QSTATUS_NEW
            return self.OK
        except lessonfile.NoQuestionException:
            return self.ERR_NO_QUESTION
    def guess_answer(self, answer):
        """
        Return: 1 if correct, None if wrong
        """
        if answer == self.m_P.get_cname():
            if self.q_status == const.QSTATUS_NEW:
                self.m_statistics.add_correct(answer)
            self.maybe_auto_new_question()
            self.q_status = const.QSTATUS_SOLVED
            return 1
        else:
            if self.q_status == const.QSTATUS_NEW:
                self.m_statistics.add_wrong(self.m_P.get_cname(),
                                            answer)
                self.q_status = const.QSTATUS_WRONG

class Gui(abstract.LessonbasedGui):
    def __init__(self, teacher, window):
        abstract.LessonbasedGui.__init__(self, teacher, window)
        ################
        # practise_box #
        ################
        self.g_music_displayer = mpd.musicdisplayer.MusicDisplayer(utils.play_tone)
        self.practise_box.pack_start(self.g_music_displayer)
        self.g_bb = widgets.QuestionNameButtonTable(self.m_t.m_exname)
        self.practise_box.pack_start(self.g_bb, False)

        self.g_flashbar = gu.FlashBar()
        self.g_flashbar.show()
        self.practise_box.pack_start(self.g_flashbar, False)
        self.practise_box.set_spacing(gnome.ui.PAD)

        self.g_new = gu.bButton(self.action_area, _("_New"), self.new_question)
        self.g_repeat = gu.bButton(self.action_area, _("_Repeat"),
                                   self.repeat_question)
        self.g_repeat_arpeggio = gu.bButton(self.action_area,
              _("Repeat _arpeggio"), self.repeat_question_arpeggio)
        self.g_repeat_slowly = gu.bButton(self.action_area,
              _("Repeat _slowly"), self.repeat_question_slowly)
        self.g_give_up = gu.bButton(self.action_area, 
              _("_Give up"), self.give_up)
        self.g_give_up.set_sensitive(False)

        self.g_show = gu.bButton(self.action_area, _("_Show"), self.show_answer)
        self.g_show.set_sensitive(False)
        self.practise_box.show_all()
        ##############
        # config_box #
        ##############
        self.config_box.set_border_width(12)
        self.config_box.set_spacing(18)
        self.add_select_lessonfile_gui()
        self.add_random_transpose_gui()
        # -----------------------------------------
        self.g_select_questions_category_box, category_box= gu.hig_category_vbox(
            _("Select questions to ask"))
        self.config_box.pack_start(self.g_select_questions_category_box, True)
        self.g_select_questions = widgets.QuestionNameCheckButtonTable(self.m_t)
        self.g_select_questions.initialize(4, 0)
        category_box.pack_start(self.g_select_questions, False)
        self.g_select_questions.show()
        # ------------------------------------------
        self._add_auto_new_question_gui(self.config_box)
        # ----------------------------------------------
        ##############
        # statistics #
        ##############
        self.setup_statisticsviewer(statisticsviewer.StatisticsViewer,
                                   _("Identify by name"))

        self.update_gui_after_lessonfile_change()
    def show_answer(self, widget=None):
        """
        Show the answer in the g_music_displayer if we have one, if not
        use a new window.
        """
        if self.m_t.m_P.header.have_music_displayer:
            fontsize = self.get_int('config/feta_font_size=20')
            self.g_music_displayer.display(self.m_t.m_P.get_music(), fontsize)
        else:
            self.g_win.display_in_musicviewer(self.m_t.m_P.get_music())
    def update_answer_buttons(self):
        if self.m_t.m_P:
            self.g_bb.initialize(self.m_t.m_P.header.fillnum,
                                 self.m_t.m_P.header.filldir)
            for question in self.m_t.m_P.iterate_questions_with_unique_names():
                self.g_bb.add(question,
                      self.m_t.m_P.header.labelformat, self.on_click)
        else:
            self.g_bb.initialize(0, 0)
    def update_select_question_buttons(self):
        if self.m_t.m_P and self.m_t.m_P.header.questions_selectable:
            self.g_select_questions_category_box.show()
            self.g_select_questions.initialize(self.m_t.m_P.header.fillnum,
                                 self.m_t.m_P.header.filldir)
            for question in self.m_t.m_P.iterate_questions_with_unique_names():
                self.g_select_questions.add(question,
                      self.m_t.m_statistics.get_label_style())
        else:
            self.g_select_questions_category_box.hide()
            self.g_select_questions.initialize(0, 0)
    def update_gui_after_lessonfile_change(self):
        #FIXME simplify conditionals
        if self.m_t.m_P:
            self.g_random_transpose.set_text(str(self.m_t.m_P.header.random_transpose))
            if self.m_t.m_P.header.musicformat == 'chord':
                self.g_repeat_arpeggio.show()
            else:
                self.g_repeat_arpeggio.hide()
            if self.m_t.m_P.header.have_repeat_slowly_button:
                self.g_repeat_slowly.show()
            else:
                self.g_repeat_slowly.hide()
            if self.m_t.m_P.header.have_music_displayer:
                self.g_music_displayer.show()
                self.g_show.hide()
            else:
                self.g_music_displayer.hide()
                self.g_show.show()
        if self.m_t.m_P and self.m_t.m_P.header.questions_selectable:
            if not self.get_list('ask_for_names'):
                self.block_watch('ask_for_names')
                self.set_list('ask_for_names', range(0, len(self.m_t.m_P.get_unique_cnames())))
                self.unblock_watch('ask_for_names')
            for question in self.m_t.m_P.m_questions:
                question['active'] = 0
            for idx in self.get_list('ask_for_names'):
                if idx >= len(self.m_t.m_P.get_unique_cnames()):
                    # if we get,  .solfegerc has some bad data.
                    break
                cname = self.m_t.m_P.get_unique_cnames()[idx]
                for question in self.m_t.m_P.m_questions:
                    if question.get_cname() == cname:
                       question['active'] = 1
        if self.m_t.m_P:
            self.g_new.set_sensitive(True)
        else:
            self.g_new.set_sensitive(False)
        self.g_repeat.set_sensitive(False)
        self.g_repeat_slowly.set_sensitive(False)
        self.g_repeat_arpeggio.set_sensitive(False)
        self.g_show.set_sensitive(False)
        self.g_give_up.set_sensitive(False)
        self.update_answer_buttons()
        self.update_select_question_buttons()
        self.g_win.set_title("Solfege - " + self.get_pretty_name())
    def give_up(self, _o=None):
        if self.m_t.q_status == const.QSTATUS_WRONG:
            self.g_flashbar.push(_("The answer is: %s") % self.m_t.m_P.get_name())
            self.m_t.give_up()
            self.g_show.set_sensitive(True)
            self.g_new.set_sensitive(True)
            self.g_new.grab_focus()
            self.g_give_up.set_sensitive(False)
            if self.m_t.m_P.header.have_music_displayer:
                self.show_answer()
    def on_click(self, button, event=None):
        if not event:
            self.on_left_click(button)
        elif event.button == 3:
            self.on_right_click(button)
    def on_right_click(self, button):
        if self.m_t.q_status == const.QSTATUS_NO:
            self.g_flashbar.flash(_("Click 'New' to begin."))
            return
        if not self.m_t.ok_compare_listen():
            self.g_flashbar.flash(_("You should try to guess before right-clicking."))
            return
        if self.m_t.m_P.get_question().has_key('set'):
            for question in self.m_t.m_P.m_questions:
                if question['set'] == self.m_t.m_P.get_question()['set'] \
                    and question.get_cname() == button.get_data('cname'):
                    self.m_t.m_P.play_question(question)
                    return
        for question in self.m_t.m_P.m_questions:
            if question.get_cname() == button.get_data('cname'):
                self.m_t.m_P.play_question(question)
                return
    def on_left_click(self, button):
        if self.m_t.q_status == const.QSTATUS_NO:
            self.g_flashbar.flash(_("Click 'New' to begin."))
            return
        if self.m_t.q_status == const.QSTATUS_SOLVED:
            if self.m_t.guess_answer(button.get_data('cname')):
                self.g_flashbar.flash(_("Correct, but you have already solved this question"))
            else:
                self.g_flashbar.flash(_("Wrong, but you have already solved this question"))
        elif self.m_t.q_status in (const.QSTATUS_NEW, const.QSTATUS_WRONG):
            if self.m_t.guess_answer(button.get_data('cname')):
                self.g_flashbar.flash(_("Correct"))
                self.g_new.set_sensitive(True)
                self.g_new.grab_focus()
                self.g_show.set_sensitive(True)
                self.g_give_up.set_sensitive(False)
                if self.m_t.m_P.header.have_music_displayer:
                    self.show_answer()
            else:
                self.g_flashbar.flash(_("Wrong"))
                if self.get_bool("config/auto_repeat_question_if_wrong_answer"):
                    self.m_t.m_P.play_question()
                self.g_give_up.set_sensitive(True)
    def new_question(self, widget=None):
        # if we have no lessonfile, then we have to questions.
        if not self.m_t.m_P:
            return
        if self.m_t.m_P.header.have_music_displayer:
            self.g_music_displayer.clear()
        try:
            g = self.m_t.new_question()
        except lessonfile.LessonfileException, e:
            self.g_win.display_error_message("In the file %s: %s" % (self.m_t.m_P.m_filename, str(e)))
            return
        if g == self.m_t.OK:
            try:
                self.m_t.m_P.play_question()
            except mpd.MpdException, e:
                # since we could not play the new question, it is possible,
                # if the user are fast, that the last question is still playing.
                soundcard.synth.stop()
                self.g_win.display_question_music_error_message(
                    self.m_t.m_P._idx, self.get_string('lessonfile'), e)
                self.m_t.q_status = const.QSTATUS_NO
                self.g_repeat.set_sensitive(False)
                self.g_repeat_slowly.set_sensitive(False)
                self.g_repeat_arpeggio.set_sensitive(False)
                self.g_show.set_sensitive(False)
            else:
                self.g_repeat.set_sensitive(True)
                self.g_repeat_slowly.set_sensitive(True)
                self.g_repeat_arpeggio.set_sensitive(True)
                self.g_new.set_sensitive(
                    not self.get_bool('config/picky_on_new_question'))
                self.g_bb.grab_focus_first_button()
                self.g_give_up.set_sensitive(False)
                self.g_show.set_sensitive(False)
                self.g_flashbar.clear()
        elif g == self.m_t.ERR_NO_QUESTION:
            self.g_flashbar.clear()
            self.g_flashbar.flash(_("You have to select some questions to practise."))
    def repeat_question(self, *w):
        self.g_bb.grab_focus_first_button()
        self.m_t.m_P.play_question()
    def repeat_question_arpeggio(self, *w):
        self.g_bb.grab_focus_first_button()
        self.m_t.m_P.play_question_arpeggio()
    def repeat_question_slowly(self, *w):
        self.g_bb.grab_focus_first_button()
        self.m_t.m_P.play_question_slowly()
    def on_start_practise(self):
        self.g_new.grab_focus()
        self.m_t.m_statistics.reset_session()
        self.g_music_displayer.clear()
        gtk.timeout_add(const.SHORT_WAIT, lambda self=self:
            self.g_flashbar.flash(_("Click 'New' to begin.")))
    def on_end_practise(self):
        self.m_t.end_practise()
        self.g_repeat.set_sensitive(False)
        self.g_repeat_slowly.set_sensitive(False)
        self.g_repeat_arpeggio.set_sensitive(False)
        if self.m_t.m_P and self.m_t.m_P.header.have_music_displayer:
            self.g_music_displayer.clear()
        self.g_show.set_sensitive(False)
        self.g_new.set_sensitive(True)
        self.g_give_up.set_sensitive(False)
        self.g_flashbar.clear()
