/*
 * Decompiled with CFR 0.152.
 */
package gnu.inet.encoding;

import gnu.inet.encoding.IDNAException;
import gnu.inet.encoding.Punycode;
import gnu.inet.encoding.PunycodeException;
import gnu.inet.encoding.Stringprep;
import gnu.inet.encoding.StringprepException;

public class IDNA {
    public static final String ACE_PREFIX = "xn--";

    public static String toASCII(String string) throws IDNAException {
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '.' || c == '\u3002' || c == '\uff0e' || c == '\uff61') {
                stringBuffer.append(IDNA.toASCII(stringBuffer2.toString(), false, true));
                stringBuffer.append(c);
                stringBuffer2 = new StringBuffer();
                continue;
            }
            stringBuffer2.append(c);
        }
        stringBuffer.append(IDNA.toASCII(stringBuffer2.toString(), false, true));
        return stringBuffer.toString();
    }

    public static String toASCII(String string, boolean bl, boolean bl2) throws IDNAException {
        char c;
        int n;
        boolean bl3 = false;
        for (n = 0; n < string.length(); ++n) {
            c = string.charAt(n);
            if (c <= '\u007f') continue;
            bl3 = true;
            break;
        }
        if (bl3) {
            try {
                string = Stringprep.nameprep(string, bl);
            }
            catch (StringprepException stringprepException) {
                throw new IDNAException(stringprepException);
            }
        }
        if (bl2) {
            for (n = 0; n < string.length(); ++n) {
                c = string.charAt(n);
                if (!(c <= ',' || c >= '.' && c <= '/' || c >= ':' && c <= '@' || c >= '[' && c <= '`') && (c < '{' || c > '\u007f')) continue;
                throw new IDNAException(IDNAException.CONTAINS_NON_LDH);
            }
            if (string.startsWith("-") || string.endsWith("-")) {
                throw new IDNAException(IDNAException.CONTAINS_HYPHEN);
            }
        }
        bl3 = false;
        for (n = 0; n < string.length(); ++n) {
            c = string.charAt(n);
            if (c <= '\u007f') continue;
            bl3 = true;
            break;
        }
        String string2 = string;
        if (bl3) {
            if (string.startsWith(ACE_PREFIX)) {
                throw new IDNAException(IDNAException.CONTAINS_ACE_PREFIX);
            }
            try {
                string2 = Punycode.encode(string);
            }
            catch (PunycodeException punycodeException) {
                throw new IDNAException(punycodeException);
            }
            string2 = ACE_PREFIX + string2;
        }
        if (string2.length() < 1 || string2.length() > 63) {
            throw new IDNAException(IDNAException.TOO_LONG);
        }
        return string2;
    }

    public static String toUnicode(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '.' || c == '\u3002' || c == '\uff0e' || c == '\uff61') {
                stringBuffer.append(IDNA.toUnicode(stringBuffer2.toString(), false, true));
                stringBuffer.append(c);
                stringBuffer2 = new StringBuffer();
                continue;
            }
            stringBuffer2.append(c);
        }
        stringBuffer.append(IDNA.toUnicode(stringBuffer2.toString(), false, true));
        return stringBuffer.toString();
    }

    public static String toUnicode(String string, boolean bl, boolean bl2) {
        String string2;
        String string3;
        String string4 = string;
        boolean bl3 = false;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c <= '\u007f') continue;
            bl3 = true;
            break;
        }
        if (bl3) {
            try {
                string = Stringprep.nameprep(string, bl);
            }
            catch (StringprepException stringprepException) {
                return string4;
            }
        }
        if (!string.startsWith(ACE_PREFIX)) {
            return string4;
        }
        String string5 = string;
        string = string.substring(ACE_PREFIX.length());
        try {
            string3 = Punycode.decode(string);
        }
        catch (PunycodeException punycodeException) {
            return string4;
        }
        try {
            string2 = IDNA.toASCII(string3, bl, bl2);
        }
        catch (IDNAException iDNAException) {
            return string4;
        }
        if (!string2.equalsIgnoreCase(string5)) {
            return string4;
        }
        return string3;
    }
}

