/* 
 *    Programmed By: Mohammed Isam Mohammed [mohammed_isam1984@yahoo.com]
 *    Copyright 2014, 2015, 2016, 2017, 2018 (c)
 * 
 *    file: defs.h
 *    This file is part of mino.
 *
 *    mino is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 3 of the License, or
 *    (at your option) any later version.
 *
 *    mino is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with mino.  If not, see <http://www.gnu.org/licenses/>.
 */    
#ifndef __Mino_PRO_H
#define __Mino_PRO_H

#include <stdio.h>
#include <errno.h>

int SCREEN_W;
int SCREEN_H;

//Definitions for box-drawing characters//
#define ULC	0x6C//201	//Upper Left Corner of Double-box
#define LLC	0x6D//200	//Lower Left Corner of Double-box
#define URC	0x6B//187	//Upper Right Corner of Double-box
#define LRC	0x6A//188	//Lower Right Corner of Double-box
#define HB	0x71//205	//Horizontal bar of Double-box
#define VB	0x78//186	//Vertical bar of Double-box
#define RFT	0x74//204	//Right-facing T of Double-box
#define LFT	0x75//185	//Left-facing T of Double-box
#define DFT	0x77//203	//Down-facing T of Double-box
#define UFT	0x76//202	//Up-facing T of Double-box
#define MC	0x7E//206	//Middle-Cross of Double-box

//Definitions for colors//
#define BLACK      30      //set black foreground
#define RED        31      //set red foreground
#define GREEN      32      //set green foreground
#define BROWN      33      //set brown foreground
#define BLUE       34      //set blue foreground
#define MAGENTA    35      //set magenta foreground
#define CYAN       36      //set cyan foreground
#define WHITE      37      //set white foreground
#define BGBLACK    40      //set black background
#define BGRED      41      //set red background
#define BGGREEN    42      //set green background
#define BGBROWN    43      //set brown background
#define BGBLUE     44      //set blue background
#define BGMAGENTA  45      //set magenta background
#define BGCYAN     46      //set cyan background
#define BGWHITE    47      //set white background
#define BGDEFAULT  49      //set default background color

//buttons used in message boxes//
#define OK	1	//00000001
#define YES	2	//00000010
#define CANCEL	4	//00000100
#define NO	8	//00001000
//button combinations-->  00000101	OK/CANCEL = 5
			//00001010	YES/NO = 10
//types of message displayed in message boxes//
typedef enum msgT { INFO, ERROR, CONFIRM } msgType;

#define MAXDIRS		1024
#define	MAXFILES	1024
//int MAXDIRS;
//int MAXFILES;
int MAX_DIR_NAME_LEN;
//int MAX_FILE_NAME_LEN;
#define MAX_FILE_NAME_LEN   1024
int MAX_MSG_BOX_W;
int MAX_MSG_BOX_H;
#define MAX_INPUT_MSG_LEN 100

//Function prototypes//
//clearArea is a flag to indicate whether to clear the window with spaces
void drawBox(int x1, int y1, int x2, int y2, char* title, int clearArea, int isMainWindow);   
void drawMenuBar(int x, int y, int w);
void setScreenColors(int FG, int BG);
void setScreenColorsI(int colorIndex);
void getScreenSize();
void clearScreen();
void showCursor();
void hideCursor();
void init(char *open_file_name);
int  initNewDocument();
int __initNewDocument();
void resetLineCounters();
void init_built_in_defaults();
void init_error();
void exit_gracefully(int exit_code, char *open_file_name);
void parseLineArgs(int argc, char **argv);
int scanDir(char *dir, char ***dirs, char ***files, int *totalDirs, int *totalFiles);

int msgBox(char *msg, int Buttons, msgType tmsg);
char *inputBox(char *msg, char *title);
char *getUserInput(char *msg, char *title);
char input[(MAX_INPUT_MSG_LEN*4)+1];//input string returned by inputBox() function

void refreshDirView();
void refreshView();
void refreshViewLines(int start, int end, int startOutputAt);
void refreshSelectedLine();
void refreshSelectedLineInColor(int pos, int *incomment);
void refreshBottomView();

//openSave determines if the function is to open or save a file
//showDialog: if YES, show open dialogbox, if NO, don't
//The function returns 1 if successful, 0 if failed to open/save file
typedef enum opensaveE { OPEN, SAVE } OPEN_SAVE;
char *openSaveFile(OPEN_SAVE openSave, int showDialog, char *open_file_name);
//called by above function to actually do the work of opening file
int _openFile(char *open_file_name);
//called by above function to actually do the work of saving file
int _saveFile(char *open_file_name);
void checkFileExtension(char *open_file_name);
int NEW_FILE;	//boolean telling if the current file is a new or opened one

//Menu items//
char *menu[4];
#define totalMainMenus	4	//total items in main menu bar
#define fTotal		6	//total items in file menu
#define eTotal		10	//total items in mino menu
#define oTotal		4	//total items in options menu
#define hTotal		4	//total items in help menu
char *fileMenu[6];
char *editMenu[10];
char *optionsMenu[4];
char *helpMenu[4];
void showMenu(int index, char *open_file_name);

int x, y, w, h;

//values used in the activeWindow variable//
#define DIR_WIN		1
#define FILE_WIN	2
#define FILE_MENU	3
#define Mino_MENU	4
#define HELP_MENU	5

void catchSignals();

char *cwd;	//the current working directory
char *config_file_name;//string holding the name of the config file
FILE *config_file;
int  open_file_at_startup;

#define MAX_LINES	5000
struct linestruct
{
    char *text;
    int  byteCount;
    int  charCount;
    int  linkedToNext;
    int  bytesAlloced;
} linestruct;
extern struct linestruct *lines[MAX_LINES];

struct linestruct *allocLineStruct();
struct linestruct *allocLineStructB(int bytes);
void copyLineStruct(int pos1, int pos2);
void freeLineStruct(struct linestruct *line);

int MAX_CHARS_PER_LINE;
int maxLen;
int firstVisLine;
int totalVisLines;
int totalLines;
int selectedLine;
int selectedChar;
int selectedCharCarry;
int WRAP_LINES;//if TRUE (1), lines are wrapped, ie will not go on beyond screen limits
int TAB_CHARS;	//number of spaces in a TAB
char *documentTitle;//[MAX_FILE_NAME_LEN];	//document title is the file name
#define __DEFAULT_TITLE   "untitled"
char *DEFAULT_TITLE;
void insertChar(char *ch);
void insertTab();
void insertEnter();
void deletePrevChar();
void deleteNextChar();
void deletePrevWord();
void deleteNextWord();
void deleteLine();
int  charsToBytes(int pos, int selChar);
void postDeleteWord(int pos);
int appendToLine(int posTo, int posFrom, int count);
void checkLineBounds(int pos);
void copyInLine(int pos, int to, int from, int calcTotalChars);
int extendLineText(int pos, int newSize);

//enumeration determining the state of the open file
enum fstate { MODIFIED, NEW, SAVED, OPENED, IDLE } FILE_STATE;
//whether to show README file on startup
extern int  SHOW_README;
void showREADMEOnStartup();

void sighandler(int signo);

//print unicode char at line 'pos' with index of 'index'
//into the screen
void putuchar(int pos, int index, int *carry);
void putunichar(char *ch);
int GNU_DOS_LEVEL;
int makestr(char *newstr, char *str);
void move_lines_up(int first, int last);
void move_lines_upd(int first, int diff);
void move_lines_down(int first, int last);
void move_lines_downl(int first, int last, char *newLineText);
void calcCharCarry(int pos);
int  is_whitespace(char c);

extern char *strdup(const char *s);    /* string.h */
extern int fcloseall (void);    /* stdio.h */
extern char *strcasestr (const char *HAYSTACK, const char *NEEDLE);    /* string.h */
extern int strcasecmp (const char *S1, const char *S2);     /* string.h */
extern char *copyrightNotice;

void initDirView();

#define TABSPACES(index)        (TAB_CHARS-((TAB_CHARS+(index))%TAB_CHARS))

#endif
