;# $Id: cosmetic.pl,v 3.0.1.1 1993/11/10 17:39:10 ram Exp $
;#
;#  Copyright (c) 1991-1993, Raphael Manfredi
;#  
;#  You may redistribute only under the terms of the Artistic Licence,
;#  as specified in the README file that comes with the distribution.
;#  You may reuse parts of this distribution only within the terms of
;#  that same Artistic Licence; a copy of which may be found at the root
;#  of the source tree for dist 3.0.
;#
;# $Log: cosmetic.pl,v $
;# Revision 3.0.1.1  1993/11/10  17:39:10  ram
;# patch14: now also adds confmagic.h if not in MANIFEST.new already
;# patch14: new functions mani_add and mani_remove to factorize code
;#
;# Revision 3.0  1993/08/18  12:10:20  ram
;# Baseline for dist 3.0 netwide release.
;#
;# 
# Update the MANIFEST.new file if necessary
sub cosmetic_update {
	# Check for an "empty" config_h.SH (2 blank lines only). This test relies
	# on the actual text held in Config_h.U. If the unit is modified, then the
	# following might need adjustments.
	local($blank_lines) = 0;
	open(CONF_H, 'config_h.SH') || die "Can't open config_h.SH\n";
	while(<CONF_H>) {
		++$blank_lines if /^$/;
	}
	unlink 'config_h.SH' unless $blank_lines > 3;

	open(NEWMANI,$NEWMANI);
	$_ = <NEWMANI>;
	/(\S+\s+)\S+/ && ($spaces = length($1));	# Spaces wanted
	close NEWMANI;
	$spaces = 29 if ($spaces < 12);				# Default value
	open(NEWMANI,$NEWMANI);
	$/ = "\001";			# Swallow the whole file
	$_ = <NEWMANI>;
	$/ = "\n";
	close NEWMANI;

	$* = 1;					# Multi-line matching

	&mani_add('Configure', 'Portability tool', $spaces) unless /^Configure\b/;
	&mani_add('config_h.SH', 'Produces config.h', $spaces)
		unless /^config_h\.SH\b/ || !-f 'config_h.SH';
	&mani_add('confmagic.h', 'Magic symbol remapping', $spaces)
		if $opt_M && !/^confmagic\.h\b/;

	&mani_remove('config_h.SH') if /^config_h\.SH\b/ && !-f 'config_h.SH';
	&mani_remove('confmagic.h') if /^confmagic.h\b/ && !$opt_M;

	$* = 0;
}

# Add file to MANIFEST.new, with properly indented comment
sub mani_add {
	local($file, $comment, $spaces) = @_;
	print "Adding $file to your $NEWMANI file...\n" unless $opt_s;
	open(NEWMANI, ">>$NEWMANI") || warn "Can't add $file to $NEWMANI: $!\n";
	local($blank) = ' ' x ($spaces - length($file));
	print NEWMANI "${file}${blank}${comment}\n";
	close NEWMANI;
}

# Remove file from MANIFEST.new
sub mani_remove {
	local($file) = @_;
	print "Removing $file from $NEWMANI...\n" unless $opt_s;
	unless (open(NEWMANI, ">$NEWMANI.x")) {
		warn "Can't create backup $NEWMANI copy: $!\n";
		return;
	}
	unless (open(OLDMANI, $NEWMANI)) {
		warn "Can't open $NEWMANI: $!\n";
		return;
	}
	local($_);
	while (<OLDMANI>) {
		print NEWMANI unless /^$file\b/
	}
	close OLDMANI;
	close NEWMANI;
	rename("$NEWMANI.x", $NEWMANI) ||
		warn "Couldn't restore $NEWMANI from $NEWMANI.x\n";
}

