/*
** pidentd.h - Definitions needing global visibility
**
** Copyright (c) 1997 Peter Eriksson <pen@lysator.liu.se>
**
** This program is free software; you can redistribute it and/or
** modify it as you wish - as long as you don't claim that you wrote
** it.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
*/

#ifndef PIDENTD_H
#define PIDENTD_H

#include "config.h"

#include "s_pthread.h"

#include "buffer.h"
#include "avail.h"
#include "daemon.h"
#include "kernel.h"
#include "request.h"
#include "server.h"
#include "send.h"
#include "safeio.h"
#include "support.h"
#include "conf.h"
#include "str2.h"
#include "timeout.h"
#include "pdes.h"

#ifndef PATH_PIDFILE
#define PATH_PIDFILE "/etc/pidentd.pid"
#endif

#ifndef PATH_CFGFILE
#define PATH_CFGFILE "/etc/pidentd.conf"
#endif

extern int debug;
extern int server_uid;
extern int server_gid;


#ifdef HAVE_LIBDES

#ifndef PATH_KEYFILE
#define PATH_KEYFILE "/etc/pidentd.key"
#endif

int encrypt_flag;
extern char *encrypt_keyfile;

#endif

extern char *pidfile_path;

extern char server_version[];

extern pthread_attr_t cattr_detached;

#endif
