/*

  ssh-dummy-shell.c

  Author:
        Timo J. Rinne <tri@ssh.fi>

  Copyright (C) 2000 SSH Communications Security Oy, Espoo, Finland
  All rights reserved.

  This is a dummy shell replacement for environments that don't want to
  grant shell prompt for visitors but for example allow them to have
  file transfer capability.

*/

#include "ssh2includes.h"
#include "sshuserfiles.h"
#include "sshtty.h"
#include "sshgetopt.h"

/* Program name, without path. */
const char *av0;

char *allowed_cmd[] =
{
  "sftp-server",
  NULL
};

int main(int argc, char **argv)
{
  char buf[0x40];
  FILE *f;
  size_t l, i;

  /* Save program name. */
  if (strchr(argv[0], '/'))
    av0 = strrchr(argv[0], '/') + 1;
  else
    av0 = argv[0];

  for (i = 0; allowed_cmd[i]; i++)
    {
      if (((argc == 3) &&
           (strcmp(argv[1], "-c") == 0) &&
           (strcmp(argv[2], allowed_cmd[i]) == 0)) ||
          ((argc == 2) &&
           (strcmp(argv[1], allowed_cmd[i]) == 0)))
        {
          char *nargv[2];

          nargv[0] = allowed_cmd[i];
          nargv[1] = NULL;
          execvp(nargv[0], nargv);
          fprintf(stderr, "%s: Command not found.\n", av0);
          exit(-1);
        }
    }
  if (argc > 1)
    {
      fprintf(stderr, "%s: Illegal arguments.\n", av0);
      exit(-1);
    }
  /*
    No argument ->
       1) enter raw mode
       2) print the message
       3) wait for keypress. 
       4) leave raw mode
       5) exit with return value 0
  */
  ssh_enter_raw_mode(-1, FALSE);
  if ((f = fopen(SSH_SERVER_DIR "/ssh_dummy_shell.out", "r")) != NULL)
    {
      while ((l = fread(buf, 1, sizeof (buf), f)) > 0)
        {
          for (i = 0; i < l; i++)
            {
              if (buf[i] == '\n')
                fputc('\r', stdout);
              fputc(buf[i], stdout);
            }
        }
      fclose(f);
    }
  else
    {
      printf("Press any key to exit.\r\n");
    }
  fgetc(stdin);
  printf("\r\n");
  ssh_leave_raw_mode(-1);
  exit(0);
}

/* eof (ssh-dummy-shell.c) */
