/*

  sshgetcwd.c

  Author:
        Sami Lehtinen <sjl@ssh.fi>

  Copyright (C) 1999 SSH Communications Security Oy, Espoo, Finland
  All rights reserved.

  Get current working directory, and allocate the needed space for it.
*/

#include "sshincludes.h"

#define SSH_DEBUG_MODULE "SshGetCwd"

#define SSH_GETCWD_INITIAL_BUFFER_SIZE 512

char *ssh_getcwd(void)
{
  char *cwd, *buf;
  int allocated = SSH_GETCWD_INITIAL_BUFFER_SIZE;

  buf = ssh_xmalloc(allocated);
  
  while (1)
    {
      if (!(cwd = getcwd(buf, allocated)))
        {
          if (errno == ERANGE)
            {
              /* Buffer wasn't large enough. */
              allocated *= 2;
              SSH_DEBUG(4, ("Allocating more space (now %d bytes).",    \
                            allocated));
              buf = ssh_xrealloc(buf, allocated);
              continue;
            }
          else
            {
              /* Some other error. */
              ssh_xfree(buf);
              return NULL;
            }
        }
      else
        {
          return cwd;
        }
    }
}
