/*
 *
 * $Source: /filesv/usr/local/proj/sphinx/spx2/src/lib/auth/RCS/create_certif_aux.c,v $
 *
 *
 *  MODULE NAME:    create_certif_aux.c
 *
 *
 *  AUTHORS:
 *
 *	K. Alagappan
 *      J. Tardo
 *
 */


/*
 * COPYRIGHT (C) 1992 DIGITAL EQUIPMENT CORPORATION
 * ALL RIGHTS RESERVED
 *
 * "Digital Equipment Corporation authorizes the reproduction,
 * distribution and modification of this software subject to the following
 * restrictions:
 * 
 * 1.  Any partial or whole copy of this software, or any modification
 * thereof, must include this copyright notice in its entirety.
 *
 * 2.  This software is supplied "as is" with no warranty of any kind,
 * expressed or implied, for any purpose, including any warranty of fitness 
 * or merchantibility.  DIGITAL assumes no responsibility for the use or
 * reliability of this software, nor promises to provide any form of 
 * support for it on any basis.
 *
 * 3.  Distribution of this software is authorized only if no profit or
 * remuneration of any kind is received in exchange for such distribution. 
 * 
 * 4.  This software and all application programs are to be used only for
 * non-commercial purposes. However, media costs associated with the
 * distribution of the software or application programs may be recovered.
 *
 */


/*
 *
 *  Creates a certificate.  Subject and Issuer name are required, as well as
 *  certificate serial number and expiration in days.
 *
 */

#include <stdio.h>
#include <ctype.h>

#include "bigrsacode.h"
#include "bigsignverify.h"
#include "BigRSA.h"

#include "cdc.h"
#include "SPHINX-types.h"
#include "objid.h"

#define DAYS 60*60*24

#define MAX_INT_BYTES 255
#define MAX_SIZE 2*DigitLim*sizeof(BigNumDigit)

#ifdef DEBUG
#undef DEBUG
#endif

extern char *rindex();

int    encode_SPHINX_Certificate();
int    encode_SPHINX_CertifInfo();
struct type_SPHINX_Name *str_to_rdn();
struct type_SPHINX_Validity *exp2SPHINX_Validity();
struct type_SPHINX_AlgorithmIdentifier *create_alg_id();

int create_certif_aux(issuer, subject, vers, serial, expire, domain, taflag, xflag, password)
char *issuer, *subject;
int  vers, serial, expire;
char *domain;
int  taflag, xflag;
char *password;
{

    int i,c;
    int status, issudot, subjdot;
    int subject_keylen, subject_uid_len;
    int issuer_keylen, issuer_uid_len;
    time_t now, valid_again;
    unsigned char *encoded_subject_key;
    int encoded_subject_key_len;
    PE certpe;
    unsigned char *asn1_cert, hashkey[8];
    int asn1_cert_len;

    static RSAKeyStorage subject_publickey, issuer_privatekey;
    static unsigned char subject_key[MAX_SIZE];
    static char subject_ava[ANAME_SZ], issuer_ava[ANAME_SZ];
    static char issuer_name[FULLNAME_SZ];
    static char subject_name[FULLNAME_SZ];
    static char issuer_uid[UID_SZ+1];
    static char subject_uid[UID_SZ+1];

    struct type_SPHINX_Certificate           *cert;
    struct type_SPHINX_CertifInfo            *cinfo;
    struct type_SPHINX_SubjectPublicKeyInfo  *subjpubkey;

    if (domain == NULL) strcpy(issuer_name, get_domain_name(NULL));
    else strcpy(issuer_name, domain);

    subjdot = 0;
    i = strlen(issuer_name);
    if (strcmp(subject,".") == 0) {
      while (issuer_name[--i] != '=');
      strcpy(subject, &issuer_name[++i]);
      subjdot = 1;
    }

    if ( read_pubkey_verbose(subject,subject_ava,subject_uid+1,&subject_uid_len,
		 &subject_publickey) == 0) {
			printf("\nError decoding subject public key.\n");
			return(0);
    }
    if (xflag == 0) {
      if (taflag == 1) {
#ifdef sun
	if ((strncmp(subject_ava, "CN=", 3) == 0) || (strncmp(subject_ava, "cn=", 3) == 0)) {
#else
	if (strncasecmp(subject_ava, "CN=", 3) == 0) {
#endif
	  printf("illegal format - cannot create trusted authority certificate\n");
	  printf("( subject ava is of type CN, therefore it is not a TA )\n");
	  return(0);
	}
      }
    }

    subject_keylen = BnnNumDigits(subject_publickey.n,subject_publickey.nl);
    subject_keylen = (subject_keylen*(sizeof(int)*8))-
	BnnNumLeadingZeroBitsInDigit(BnnGetDigit(
			subject_publickey.n+subject_keylen-1));

    encoded_subject_key = EncodePublic(&subject_publickey);
    encoded_subject_key_len = (int) DecodeTotalLength(encoded_subject_key);
    *subject_key=0;
    memcpy(subject_key+1,encoded_subject_key,encoded_subject_key_len);
    FreePublic(encoded_subject_key);

#ifdef DEBUG
printf("\nEncoded subject public key length: %d", encoded_subject_key_len);
#endif

    issudot = 0;
    i = strlen(issuer_name);
    if (strcmp(issuer,".") == 0) {
      while (issuer_name[--i] != '=');
      strcpy(issuer, &issuer_name[++i]);
      issudot = 1;
    }

    if( read_privkey_verbose(issuer,issuer_ava,issuer_uid+1,&issuer_uid_len, 
            hashkey, &issuer_privatekey, password) == 0) {
		printf("\nError decoding issuer private key.\n");
		return(0);
    }

    if (subject_ava[0]=='{') {
        for(i=0;i<strlen(subject_ava)-2;i++) subject_ava[i]=subject_ava[i+1];
        subject_ava[i]='\0';
    }
    if (issuer_ava[0]=='{') {
        for(i=0;i<strlen(issuer_ava)-2;i++) issuer_ava[i]=issuer_ava[i+1];
        issuer_ava[i]='\0';
    }

    if (xflag == 0) {
      if (taflag == 1) {
	if (!subjdot) {
	  strcat(issuer_name, "/");
	  strcat(issuer_name, subject_ava);
	}
	strcpy(subject_name, issuer_name);
	strcat(issuer_name, "/");
	strcat(issuer_name, issuer_ava);
      }
      if (taflag == 0) {
#ifdef sun
	if ((strncmp(issuer_ava, "CN=", 3) == 0) || (strncmp(issuer_ava, "cn=", 3) == 0)) {
#else
	if (strncasecmp(issuer_ava, "CN=", 3) == 0) {
#endif
	  printf("illegal format - cannot create certificate for principal\n");
	  printf("( issuer ava is of type CN, therefore it is not a certifier )\n");
	  return(0);
	}
	if (!issudot) {
	  strcat(issuer_name, "/");
	  strcat(issuer_name, issuer_ava);
	}
	strcpy(subject_name, issuer_name);
	strcat(subject_name, "/");
	strcat(subject_name, subject_ava);
      }
      if (taflag == 2) {
	if (!issudot) {
	  strcat(issuer_name, "/");
	  strcat(issuer_name, issuer_ava);
	}
	strcpy(subject_name, issuer_name);
      }
    } else {
      printf("Making a cross certificate\n");
      if (domain == NULL) {
	printf("  what is the X.500 prefix for issuer_ava (from keyfile) %s\n", issuer_ava);
	printf("  issuer_prefix : ");

	for (i = c = 0 ; ((c=getchar())!=EOF) && (c != '\n') ; i++)
	  issuer_name[i] = c;
	issuer_name[i] = '\0';
	strcat(issuer_name, "/");
	strcat(issuer_name, issuer_ava);
	printf("issuer_fullname is %s\n", issuer_name);
	printf("  what is the X.500 prefix for subject_ava (from keyfile) %s\n", subject_ava);
	printf("  subject_prefix : ");

	for (i = c = 0 ; ((c=getchar())!=EOF) && (c != '\n') ; i++)
	  subject_name[i] = c;
	subject_name[i] = '\0';
	strcat(subject_name, "/");
	strcat(subject_name, subject_ava);
	printf("subject_fullname is %s\n", subject_name);
      } else {
	strcpy(issuer_name, domain);
	strcat(issuer_name, "/");
	strcat(issuer_name, issuer_ava);
	strcpy(subject_name, domain);
	strcat(subject_name, "/");
	strcat(subject_name, subject_ava);
      }
    }

    issuer_keylen = BnnNumDigits(issuer_privatekey.n,issuer_privatekey.nl);
    issuer_keylen = (issuer_keylen*(sizeof(int)*8))-
	BnnNumLeadingZeroBitsInDigit(BnnGetDigit(
			issuer_privatekey.n+issuer_keylen-1));

#ifdef DEBUG
printf("\nIssuer keylen(bits): %d", issuer_keylen);
printf("\nIssuer uid_len: %d\n", issuer_uid_len);
#endif

    cinfo = (struct type_SPHINX_CertifInfo *) malloc(sizeof(struct type_SPHINX_CertifInfo));
    if (vers == int_SPHINX_Version_v1988) {
      cinfo->version = NULL;
    } else {
      cinfo->version = (struct type_SPHINX_Version *) 
	malloc(sizeof (struct type_SPHINX_Version));
      cinfo->version->parm = vers;
    }
    cinfo->serialNumber = (struct type_SPHINX_CertificateSerialNumber *)
		malloc(sizeof (struct type_SPHINX_CertificateSerialNumber));
    cinfo->serialNumber->parm = serial;
    cinfo->signature = create_alg_id(OIW_MD2_WITH_RSA_OID,NULL);
    if ((cinfo->issuer=str_to_rdn(issuer_name))==NULL){
        printf("\nerror converting issuer_name - '%s'\n", issuer_name);
        return(0);
    }
    time(&now);
    cinfo->valid = exp2SPHINX_Validity (now + expire*DAYS);

    if ((cinfo->subject=str_to_rdn(subject_name))==NULL){
        printf("\nerror converting subject_name - '%s'\n", subject_name);
        return(0);
    }
    subjpubkey = (struct type_SPHINX_SubjectPublicKeyInfo *)
                      malloc(sizeof(struct type_SPHINX_SubjectPublicKeyInfo));
    cinfo->subjectPublicKey = subjpubkey;

    subjpubkey->algorithm = create_alg_id(RSA_OID,&subject_keylen);
    subjpubkey->subjectPublicKey = str2prim(subject_key, 
                    encoded_subject_key_len+1, PE_CLASS_UNIV, PE_PRIM_BITS );
    prim2bit(subjpubkey->subjectPublicKey);

    if (vers == int_SPHINX_Version_v1992) {
      cinfo->issuerUID = 
                str2prim(issuer_uid,  issuer_uid_len+1, PE_CLASS_UNIV, PE_PRIM_BITS);
      prim2bit(cinfo->issuerUID);
      cinfo->subjectUID = 
                str2prim(subject_uid, subject_uid_len+1, PE_CLASS_UNIV, PE_PRIM_BITS);
      prim2bit(cinfo->subjectUID);
    } else {
      cinfo->issuerUID = NULL;
      cinfo->subjectUID = NULL;
    }

#ifdef DEBUG
printf("\nSigning certificate...");
fflush(stdout);
#endif

    status = rsamd2_sign_aux (cinfo,encode_SPHINX_CertifInfo,&issuer_privatekey,&cert);
    if ((status==0)||(status==NOTOK)) {
#ifdef DEBUG
printf("\n%s: Signature Failed.\n", __FILE__);
#endif
        return(0);
    }
#ifdef DEBUG
printf("success\n");
fflush(stdout);
#endif

    status = encode_SPHINX_Certificate(&certpe,1,NULL,NULLCP,cert);
    if (status == NOTOK) {
	printf("\nEncode Certificate Failed.");
	return(0);
    }
    
    status = pe2ssdu(certpe,&asn1_cert,&asn1_cert_len);
    write_certif(asn1_cert,asn1_cert_len,subject,issuer);
    free_SPHINX_Certificate(cert);
    return(1);
}

int write_certif(cert,len,subject,issuer)
char *cert, *subject, *issuer ;
int len;
{
    char certfile[80], *cp;
    FILE *f;

    if ((cp = rindex(issuer,'/')) != 0)  { *cp++; strcpy(certfile, cp); }
    else strcpy(certfile,issuer);
    strcat(certfile,"_certif_");
    if ((cp = rindex(subject,'/')) != 0) { *cp++; strcat(certfile, cp); }
    else strcat(certfile,subject);
    printf("Writing ... ");
    if((f=fopen(certfile, "w"))==NULL){
	printf("\ncouldn't create %s\n",certfile);
	return(0);
    }

    fdumphex_auth (cert,len,f);
    printf("%s\n",certfile);
    return(1);
}

#define CHARS_PER_LINE 16

/*
 * write out half-ASCII hex characters to a file
 */

int fdumphex_auth (x,l,fp)
int l;
unsigned char * x;
FILE *fp ;
{
    int i;
    for(i=0;i<l;i++){
        if ((i%CHARS_PER_LINE)==0)fprintf(fp,"\n");
        fprintf(fp," %02x",*x++);
        }
    fprintf(fp,"\n");
}
