/*
 *
 * $Source: /filesv/usr/local/proj/sphinx/spx2/src/lib/api/RCS/sphinxuserok.c,v $
 *
 *
 *  MODULE NAME:    sphinxuserok.c
 *
 *
 *  AUTHORS:
 *
 *	K. Alagappan
 *
 */


/*
 * COPYRIGHT (C) 1992 DIGITAL EQUIPMENT CORPORATION
 * ALL RIGHTS RESERVED
 *
 * "Digital Equipment Corporation authorizes the reproduction,
 * distribution and modification of this software subject to the following
 * restrictions:
 * 
 * 1.  Any partial or whole copy of this software, or any modification
 * thereof, must include this copyright notice in its entirety.
 *
 * 2.  This software is supplied "as is" with no warranty of any kind,
 * expressed or implied, for any purpose, including any warranty of fitness 
 * or merchantibility.  DIGITAL assumes no responsibility for the use or
 * reliability of this software, nor promises to provide any form of 
 * support for it on any basis.
 *
 * 3.  Distribution of this software is authorized only if no profit or
 * remuneration of any kind is received in exchange for such distribution. 
 * 
 * 4.  This software and all application programs are to be used only for
 * non-commercial purposes. However, media costs associated with the
 * distribution of the software or application programs may be recovered.
 *
 */


#include <sys/param.h>
#include <sys/stat.h>
#include <sys/time.h>
#include <sys/resource.h>
#include <sys/file.h>
#include <ctype.h>
#include <sgtty.h>
#include <utmp.h>
#include <signal.h>
#include <pwd.h>
#include <stdio.h>
#include <lastlog.h>
#include <errno.h>
#include <syslog.h>

#include "cdc.h"
#include "BigNum.h"
#include "BigRSA.h"
#include "random.h"
#include "spxapi_defs.h"

#ifdef sun
#define strncasecmp	strncmp_support
#define strcasecmp	strcmp_support
#endif

/*
 * sphinxuserok - returns 1 upon success
 *	     	          0 upon failure
 */
sphinxuserok(user_fullname, acl_file)
char      *user_fullname, *acl_file;
{
  FILE *hostf;
  char domain[256];
  struct stat sbuf;
  struct passwd *pwd;

  if ((hostf = fopen(acl_file, "r")) == NULL) {
    goto bad;
  }
/*
  (void)fstat(fileno(hostf), &sbuf);
  if (sbuf.st_uid && sbuf.st_uid != pwd->pw_uid) {
    fclose(hostf);
    goto bad;
  }
*/
  if (hostf) {
    if ((parser_sphinx(hostf, user_fullname)) == 0) {
      (void) fclose(hostf);
      return(1);
    }
    (void) fclose(hostf);
  }
 bad:
  return (0);
}

/*
 * parser - reads in all entries from file descriptor, hostf
 *	and compares entries with the one to match
 */
parser_sphinx(hostf, user_fullname)
FILE *hostf;
char *user_fullname;
{
  FILE *tty;
  char *appl;
  char fullname[255], fn_buf[255];
  register char *p, *fn_p;
  char **cp;
  int  fn_len, wildcard_match, quoted_name = 0;

  while (fgets(fullname, sizeof(fullname), hostf)) {
    int fnmatch, applmatch;
    /*
     * Skip beginning white space
     */

    p = fullname;
    while (*p == ' ' || *p == '\t')
      p++;
    fn_p = p;
    if (*p == '"') quoted_name = 1;

    if (!quoted_name) {
      while (*p != '\n' && *p != ' ' && *p != '\t' && *p != '\0')
	p++;
    } else {
      p++;
      fn_p = p;
      while (*p != '\n' && *p != '"' && *p != '\0')
	p++;
    }

    if (*p == ' ' || *p == '\t' || ((*p == '"') && (quoted_name))) {
      *p++ = '\0';
      /*
       * Skip middle white space
       */
      while (*p == ' ' || *p == '\t')
	p++;
      appl = p;

      while (*p != '\n' && *p != ' ' && *p != '\t' && *p != '\0')
	p++;
      /*
       * Stop before trailing white space
       */
    } else
      appl = p;
    *p = '\0';

    wildcard_match = 0;

    if (strncasecmp(fn_p, "SPX:", 4) != 0) {
      strcpy(fn_buf, "SPX:");
      if (*fn_p != '/') {
	strcat(fn_buf, get_domain_name(NULL));
	strcat(fn_buf, "/");
	strcat(fn_buf, fn_p);
      } else {
	strcat(fn_buf, fn_p);
      }
    } else {
      if (fn_p[4] != '/') {
	strcpy(fn_buf, "SPX:");
	strcat(fn_buf, get_domain_name(NULL));
	strcat(fn_buf, "/");
	strcat(fn_buf, &fn_p[4]);
      } else {
	strcpy(fn_buf, fn_p);
      }
    }
    fn_len = strlen(fn_buf);
    if (fn_buf[fn_len-1] == '*') {
      wildcard_match = 1;
      fn_buf[fn_len-1] = '\0';
      fn_len--;
    }

    if ((!wildcard_match) && (fnmatch = !strcasecmp(user_fullname, fn_buf)) == 0) {
      continue;
    }

    if ((wildcard_match) && (fnmatch = !strncasecmp(user_fullname, fn_buf, fn_len)) == 0) {
      continue;
    }

    if (fnmatch)
      return (0);
  }
  return (-1);
}
