/*
   This file is part of TALER
 Copyright (C) 2025 Taler Systems SA

   TALER is free software; you can redistribute it and/or modify it under the
   terms of the GNU General Public License as published by the Free Software
   Foundation; either version 3, or (at your option) any later version.

   TALER is distributed in the hope that it will be useful, but WITHOUT ANY
   WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
   A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

   You should have received a copy of the GNU General Public License along with
   TALER; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */
/**
 * @file backenddb/pg_update_unit.h
 * @brief implementation of the update_unit function for Postgres
 * @author Bohdan Potuzhnyi
 */
#ifndef PG_UPDATE_UNIT_H
#define PG_UPDATE_UNIT_H

#include <taler/taler_util.h>
#include <taler/taler_json_lib.h>
#include "taler_merchantdb_plugin.h"

/**
 * Update an existing measurement unit definition.
 *
 * @param cls closure
 * @param instance_id instance owning the unit
 * @param unit_id symbolic unit identifier
 * @param unit_name_long optional new long name (NULL to keep existing)
 * @param unit_name_long_i18n optional new long-name translations
 * @param unit_name_short optional new short name
 * @param unit_name_short_i18n optional new short-name translations
 * @param unit_allow_fraction optional new fractional toggle
 * @param unit_precision_level optional new fractional precision
 * @param unit_active optional new visibility flag
 * @param[out] no_instance set if instance unknown
 * @param[out] no_unit set if unit unknown
 * @param[out] builtin_conflict set if immutable builtin fields touched
 * @return database result code
 */
enum GNUNET_DB_QueryStatus
TMH_PG_update_unit (void *cls,
                    const char *instance_id,
                    const char *unit_id,
                    const char *unit_name_long,
                    const json_t *unit_name_long_i18n,
                    const char *unit_name_short,
                    const json_t *unit_name_short_i18n,
                    const bool *unit_allow_fraction,
                    const uint32_t *unit_precision_level,
                    const bool *unit_active,
                    bool *no_instance,
                    bool *no_unit,
                    bool *builtin_conflict);

#endif
