/******************************************

  XException
  XStatus
  XOSErrorTexts


  (C) 1997 Jens von Pilgrim

  ******************************************/


#include "XBaseClasses.h"

//////////////////////////////////////////
// class XStatus


XStatus::~XStatus()
{}

const XString XStatus::GetStatusString() const
{
	return m_String;
}

const int XStatus::GetStatusCode() const
{
	return m_Code;
}

const bool XStatus::IsError() const
{ return m_Error;
}

const long XStatus::GetStatusUserdef() const
{
	return m_Userdef;
}

const XString XStatus::GetClassName() const
{
	return m_ClassName;
}

const int XStatus::GetLineNo() const
{
	return m_LineNo;
}

const XString XStatus::GetFileName() const
{
	return m_FileName;
}


XStatus::XStatus(const XString& inClassName, const XString& inFileName)
{
	m_ClassName = inClassName;
	m_FileName = inFileName;
	ResetStatus();
}

void XStatus::SetStatus ( int inCode, const XString& inString,  int inLineNo, const XString& inFileName, long inUserdef)
{
	m_Error = false;
	m_Code = inCode;
	m_String = inString;
	m_Userdef = inUserdef;
	m_LineNo = inLineNo;
	if (!inFileName.IsEmpty()) m_FileName = inFileName;
}

void XStatus::SetStatus ( const XStatus& inStatus)
{
	m_Error = inStatus.m_Error;
	m_Code = inStatus.m_Code;
	m_String = inStatus.m_String;
	m_Userdef = inStatus.m_Userdef;
	m_LineNo = inStatus.m_LineNo;
	m_FileName = inStatus.m_FileName;
}



void XStatus::SetError ( bool inFlag)
{
	m_Error = inFlag;
}

void XStatus::SetError ( int inCode, const XString& inString,  int inLineNo, const XString& inFileName, long inUserdef)
{
	m_Error = true;
	m_Code = inCode;
	m_String = inString;
	m_Userdef = inUserdef;
	m_LineNo = inLineNo;
	if (!inFileName.IsEmpty()) m_FileName = inFileName;
}



void XStatus::SetStatusCode (int inCode, bool inOSERROR)
{
	m_Code = inCode;
	if (inOSERROR) m_String = XOSErrorTexts::GetErrorText(inCode);
}

void XStatus::SetStatusString (const XString& inString)
{
	m_String = inString;
}

void XStatus::SetStatusUserdef ( long inUserdef)
{
	m_Userdef = inUserdef;
}


void XStatus::SetStatusLineNo ( int inLineNo)
{
	m_LineNo = inLineNo;
}

void XStatus::SetFileName ( const XString& inFileName)
{
	m_FileName = inFileName;
}

void XStatus::ResetStatus()
{
	m_Code = 0;
	m_String = "unknown";
	m_Userdef = 0;
	m_LineNo = -1;
	m_Error = false;
}


//////////////////////////////////////////
// class XException : public XStatus

XException::XException( int inCode, const XString& inString, int inLineNo, const XString& inFileName, long inUserdef)
          :XStatus("XException", inFileName)
{
	SetStatus( inCode, inString, inLineNo, inFileName, inUserdef);
	SetError(true);
}

XException::~XException()
{}

const XString XException::GetFString(bool inINTERNALS) const
{
	XString ret;
		
	if (inINTERNALS)
	{
		ret = GetFileName() + XString("(");
		if (GetLineNo()>=0)
			ret += XString(GetLineNo())+ XString(", ");
		ret += GetClassName() + XString(")");
	}
	
	ret += XString("Code ") + XString( GetStatusCode() ) +
	       XString(": ") + GetStatusString();
	return ret;
}
		
		   



//////////////////////////////////////////
// class XOSErrorTexts

XOSErrorTexts::XOSErrorTexts()
{}

XOSErrorTexts::~XOSErrorTexts()
{}

const XString XOSErrorTexts::GetErrorText( int inNo)
{
#define XOSErrorTexts_TEXTNO 35
	const char *Texts[XOSErrorTexts_TEXTNO] =
	{ "No error occurred",
	  "An unspecified error occurred",
	  "File not found",
	  "Path not found",
	  "Too many files opened",
	  "Access denied",
	  "Invalid file handle",
	  "Memory blocks destroyed",
	  "Out of memory",
	  "Invalid memory-adress",
	  "Invalid environment",
	  "Invalid format",
	  "Invalid access-code",
	  "Invalid datas",
	  "reserved"
	  "Invalid drive",
	  "Current working directory cannot be removed.",
	  "Different machine",
	  "There are no more directory entries.",
	  "Disk is write protected",
	  "Drive is defect",
	  "Drive not ready",
	  "Invalid diskcommand",
	  "CRC-Error",
	  "Invalid request-stucture-length",
	  "Search error",
	  "No DOS-disk",
	  "Sector not found",
	  "No paper",
	  "Write error",
	  "Read error",
	  "Common error",
	  "SHARE.EXE not loaded or shared region was locked",
	  "Region already locked",
	  "Wrong disk",
	  "FCB not accessable" }  ;

	if (inNo == 80) return "File exists";

	if ( inNo >= XOSErrorTexts_TEXTNO )
		return XString("Unknowm Errorcode (")+
		       XString(inNo)+XString(").");
	else
	  return Texts[inNo];
		
}
