/*
 *	Transparent Cryptographic File System (TCFS) for NetBSD 
 *	Author and mantainer: 	Luigi Catuogno [luicat@tcfs.unisa.it]
 *	
 *	references:		http://tcfs.dia.unisa.it
 *				tcfs-bsd@tcfs.unisa.it
 */

/*
 *	Base utility set v0.1
 *
 *	  $Source: /usr/src/tcfs-utils_0.1/include/RCS/tcfspwdb.h,v $
 *	   $State: Exp $
 *	$Revision: 1.1 $
 *	  $Author: luicat $
 *	    $Date: 2000/01/10 10:39:18 $
 *
 */

/* RCS_HEADER_ENDS_HERE */



#ifndef _TCFSPWDB_H_
#define _TCFSPWDB_H_

#include <unistd.h>
#include "tcfsdefines.h"

#define UserLen 	8
#define PassLen 	UUKEYSIZE
#define MaxLineLen 	100
#define MaxUserLen  	8
#define NumOfField   2

typedef struct tcfspwdb_r
{
	char user[UserLen];
	char upw[PassLen];
} tcfspwdb;

typedef struct tcfsgpwdb_r
{
	char user[UserLen];
	char gkey[PassLen];
	gid_t gid;
	int n;
	int soglia;
} tcfsgpwdb;

#define U_DEL	0
#define U_NEW	1
#define U_CHG	2
#define U_CKL	3

#define F_USR			0x80
#define F_PWD			0x40
#define F_GID			0x20
#define F_GKEY			0x10
#define F_MEMBERS		0x08
#define F_THRESHOLD	0x04

#define TCFSPWDBSIZ	1024

#define TCFSPWDB	"/usr/tcfs/etc/tcfspwdb"
#define TCFSPWDFILE	"/usr/tcfs/etc/tcfspwdb"
#define TCFSPWDOLD	"/usr/tcfs/etc/tcfspwdb.old"
#define TCFSPWDLOCK	"/usr/tcfs/etc/tcfspwdb.lock"
#define TCFSPWDTMP	"/usr/tcfs/etc/tcfstmp"

#define TCFSGPWDB	"/usr/tcfs/etc/tcfsgpwdb"

#endif /* _TCFSPWDB_H_ */
