/*
SKIP Source Code License Statement:
------------------------------------------------------------------
  Copyright
  Sun Microsystems, Inc.


  Copyright (C) 1994, 1995 Sun Microsystems, Inc.  All Rights
  Reserved.

  Permission is hereby granted, free of charge, to any person
  obtaining a copy of this software and associated documentation
  files (the "Software"), to deal in the Software without
  restriction, including without limitation the rights to use,
  copy, modify, merge, publish, distribute, sublicense, and/or sell
  copies of the Software or derivatives of the Software, and to 
  permit persons to whom the Software or its derivatives is furnished 
  to do so, subject to the following conditions:

  The above copyright notice and this permission notice shall be
  included in all copies or substantial portions of the Software.

  The Software must not be transferred to persons who are not US
  citizens or permanent residents of the US or exported outside
  the US (except Canada) in any form (including by electronic
  transmission) without prior written approval from the US
  Government. Non-compliance with these restrictions constitutes
  a violation of the U.S. Export Control Laws.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
  EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
  OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
  NONINFRINGEMENT.  IN NO EVENT SHALL SUN MICROSYSTEMS, INC., BE LIABLE
  FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
  OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
  CONNECTION WITH THE SOFTWARE OR DERIVATES OF THIS SOFTWARE OR 
  THE USE OR OTHER DEALINGS IN THE SOFTWARE.

  Except as contained in this notice, the name of Sun Microsystems, Inc.
  shall not be used in advertising or otherwise to promote
  the sale, use or other dealings in this Software or its derivatives 
  without prior written authorization from Sun Microsystems, Inc.
*/

#pragma ident "@(#)es_stats.c	1.2 95/11/20 Sun Microsystems"

#include <stdio.h>
#include <sys/param.h>
#include <sys/types.h>
#include <xview/xview.h>
#include <xview/panel.h>
#include <xview/textsw.h>
#include <xview/xv_xrect.h>
#include <xview/svrimage.h>
#include <xview/cms.h>
#include <xview/panel.h>

#ifdef SYSV
#include <sys/systeminfo.h>
#include <sys/resource.h>
#endif

#include "es_ras.h"
#include "es_stats.h"

/*
 * Simple graphical shell for skipstat
 */

int			poll_interval = ES_STAT_POLL_INTERVAL;
Server_image 		updated;
Panel_item		time_message;
Frame			frame;
Panel			panel;
char			*progname;
char			cmd[STRSZ];

/*
 * current stat info
 */
es_stats_t		current_stats[ES_STATS_MAX];
int			num_stats, es_display_depth;


static void
usage(char *prog)
{
	fprintf(stderr, "%s: <-d delay> <-t title> command...\n", prog);
	exit(1);
}

/* es_update_status()
 *
 * process interval timer
 */
static Notify_value
es_update_status()
{
	int		i, new_num, bigwin;
	char		old_value[STRSZ], *new_value;
	time_t		now;

	
	time(&now);
	xv_set(time_message,
		PANEL_LABEL_STRING, ctime(&now),
		NULL);
	es_get_stats(cmd, current_stats, &new_num, &bigwin);
	for (i = 0; i < new_num; i++) {
		strcpy(old_value, (char *)
				xv_get(current_stats[i].item, PANEL_VALUE));

		if (strcmp(old_value, current_stats[i].value) == 0) {
			xv_set(current_stats[i].updated,
				XV_SHOW, FALSE,
				NULL);
			continue;
		}

		xv_set(current_stats[i].item, 
			PANEL_VALUE, current_stats[i].value,
			NULL
		);
		xv_set(current_stats[i].updated,
				XV_SHOW, TRUE,
				NULL);
	}
	return (NOTIFY_DONE);
}

main(int argc, char ** argv)
{
	Xv_Screen		screen;
	Server_image 		skip;
	Display			*display;
	Icon			icon;
	int			bigwin, screen_no, x, y, w, h, d;
	extern char     	*optarg;
	extern int      	optind;
	Panel_item		logo, message;
	struct itimerval	timer;
	int			c, i;
	char			*title = "SKIP Statistical information";
	char			label[STRSZ], hostname[STRSZ];
#include "updated.xbm"
#include "skiptool_small.xbm"

	progname = argv[0];

	xv_init(XV_INIT_ARGC_PTR_ARGV, &argc, argv, NULL);

	while ((c = getopt(argc, argv, "d:t:")) != -1) {

	switch (c) {
		case 'd':
			poll_interval = atoi(optarg);
			if (poll_interval <= 0) {
				poll_interval = ES_STAT_POLL_INTERVAL;
			}
			break;

		case 't':
			title = optarg;
			break;

		default:
		usage(progname);
		}
	} 

	*cmd = '\0';
	for (i = optind; i < argc; i++) {
		strcat(cmd, argv[i]);
		strcat(cmd, " ");
	}

#ifdef SYSV
	sysinfo(SI_HOSTNAME, hostname, STRSZ);
#else
	gethostname(hostname, STRSZ);
#endif
	sprintf(label, "SKIP Statistics (%s)", hostname);

	frame = (Frame) xv_create(NULL, FRAME_CMD, 
		FRAME_SHOW_FOOTER, TRUE,
		FRAME_SHOW_RESIZE_CORNER, TRUE,
		FRAME_CMD_PUSHPIN_IN, TRUE,
		FRAME_LABEL, label,
		NULL);

	display = (Display *) xv_get(frame, XV_DISPLAY);
	screen = xv_get(frame, XV_SCREEN);
	screen_no = xv_get(screen, SCREEN_NUMBER);
	es_display_depth = DefaultDepth(display, screen_no);
	if ((updated = load_raster(SKIP_UPDATED_ICON, &w, &h, &d)) == NULL) {
		updated = xv_create(XV_NULL, SERVER_IMAGE,
			SERVER_IMAGE_DEPTH, 1,
			SERVER_IMAGE_X_BITS, updated_bits,
			XV_WIDTH, updated_width,
			XV_HEIGHT, updated_height,
			NULL);
	}
	if ((skip = load_raster(SKIP_SMALL_ICON, &w, &h, &d)) == NULL) {
		skip = xv_create(XV_NULL, SERVER_IMAGE,
			SERVER_IMAGE_DEPTH, 1,
			SERVER_IMAGE_X_BITS, skiptool_small_bits,
			XV_WIDTH, w = skiptool_small_width,
			XV_HEIGHT, h = skiptool_small_height,
			NULL);
	}

	icon = xv_create(frame, ICON, ICON_IMAGE, skip, ICON_WIDTH, w,
		ICON_HEIGHT, h, NULL);

	xv_set(frame, FRAME_ICON, icon, NULL);

	panel = (Panel) xv_create(frame, PANEL,
		XV_X, 0,
		XV_Y, 0,
		NULL);
			
	logo = xv_create(panel, PANEL_MESSAGE,
		XV_X, 24,
		XV_Y, 24,
		PANEL_LABEL_IMAGE, skip,
		NULL);

	message = xv_create(panel, PANEL_MESSAGE,
		PANEL_LABEL_STRING, title,
		PANEL_LABEL_BOLD, TRUE,
		XV_X, 100,
		XV_Y, 30,
		NULL);

	time_message = xv_create(panel, PANEL_MESSAGE,
		PANEL_LABEL_STRING, "",
		XV_X, 100,
		XV_Y, 50,
		PANEL_LABEL_BOLD, FALSE,
		NULL);

	window_fit(panel);
	xv_set(frame, XV_WIDTH, xv_get(panel, XV_WIDTH) + 20,
		XV_HEIGHT, xv_get(panel, XV_HEIGHT),
		NULL);

	memset((char *) current_stats, 0, sizeof(current_stats));
	es_get_stats(cmd, current_stats, &num_stats, &bigwin);
	es_create_stats_window(current_stats, num_stats, bigwin);
	memset((char *)&timer, 0, sizeof(timer));
	timer.it_value.tv_sec = poll_interval;
	timer.it_interval.tv_sec = poll_interval;
	notify_set_itimer_func(frame, es_update_status,
			ITIMER_REAL, &timer, NULL);
	xv_main_loop(frame);
}



void
resize_frame_to_panel(Frame frame, Panel panel)
{
	window_fit(panel);
	xv_set(frame, XV_WIDTH, xv_get(panel, XV_WIDTH),
		XV_HEIGHT, xv_get(panel, XV_HEIGHT),
		NULL);
}

es_create_stats_window(es_stats_t stats[], int num_stats, int bigwin)
{
	int j, gap = 20;
	int x = 30, y = 100;

	for (j = 0; j < num_stats; j++) {
		stats[j].updated = xv_create(panel, PANEL_MESSAGE,
					XV_X, x - 6,
					XV_Y, y,
					XV_SHOW, FALSE,
					PANEL_LABEL_IMAGE, updated,
					NULL);

		stats[j].item =  xv_create(panel, PANEL_TEXT,
			PANEL_VALUE_DISPLAY_LENGTH, 10,
			PANEL_VALUE, stats[j].value,
			PANEL_READ_ONLY, TRUE,
			PANEL_LABEL_STRING, stats[j].name,
			PANEL_LABEL_WIDTH, 220,
			PANEL_LAYOUT, PANEL_HORIZONTAL,
			PANEL_READ_ONLY, TRUE,
			PANEL_VALUE_UNDERLINED, FALSE,
			XV_X, bigwin ? x + 36 : x,
			XV_Y, y,
		NULL);
		y += gap;
	}
	resize_frame_to_panel(frame, panel);
}


es_get_stats(char *cmd, es_stats_t stats[], int *num_stats, int *bigwin)
{
	FILE	*pp;
	char	*s, line[STRSZ];

	(*num_stats) = 0;
	(*bigwin) = 0;

	pp = popen(cmd, "r");
	if (!pp) {
		return;
	}
	do {
		if (fgets(line, STRSZ, pp) == NULL) {
			break;
		}

		/*
		 * extract stat name
		 */
		s = strtok(line, "\t:\n");
		if (s == NULL) {
			continue;
		}
		strcpy(stats[*num_stats].name, s);
		strcat(stats[*num_stats].name, ":");

		/*
		 * extract value
		 */
		s = strtok(NULL, "\t \n");
		if (s == NULL) {
			continue;
		}
		strcpy(stats[*num_stats].value, s);

		if ((int) strlen(stats[*num_stats].name) > 27) {
			*bigwin = 1;
		}

		
		(*num_stats)++;

	} while (!feof(pp));
	pclose(pp);
}
